/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.atom;

import com.liferay.portal.atom.AtomPager;
import com.liferay.portal.atom.AtomUtil;
import com.liferay.portal.kernel.atom.AtomEntryContent;
import com.liferay.portal.kernel.atom.AtomException;
import com.liferay.portal.kernel.atom.AtomRequestContext;
import com.liferay.portal.kernel.atom.BaseMediaAtomCollectionAdapter;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.bookmarks.util.comparator.EntryNameComparator;
import com.liferay.portlet.documentlibrary.service.DLAppServiceUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class FileEntryAtomCollectionAdapter
extends BaseMediaAtomCollectionAdapter<FileEntry> {
    protected static final String COLLECTION_NAME = "files";

    public String getCollectionName() {
        return COLLECTION_NAME;
    }

    public List<String> getEntryAuthors(FileEntry fileEntry) {
        ArrayList<String> authors = new ArrayList<String>();
        authors.add(fileEntry.getUserName());
        return authors;
    }

    public AtomEntryContent getEntryContent(FileEntry fileEntry, AtomRequestContext atomRequestContext) {
        AtomEntryContent atomEntryContent = new AtomEntryContent(AtomEntryContent.Type.MEDIA);
        atomEntryContent.setMimeType(fileEntry.getMimeType());
        String srcLink = AtomUtil.createEntryLink(atomRequestContext, COLLECTION_NAME, String.valueOf(fileEntry.getFileEntryId()) + ":media");
        atomEntryContent.setSrcLink(srcLink);
        return atomEntryContent;
    }

    public String getEntryId(FileEntry fileEntry) {
        return String.valueOf(fileEntry.getPrimaryKey());
    }

    public String getEntrySummary(FileEntry fileEntry) {
        return fileEntry.getDescription();
    }

    public String getEntryTitle(FileEntry fileEntry) {
        return fileEntry.getTitle();
    }

    public Date getEntryUpdated(FileEntry fileEntry) {
        return fileEntry.getModifiedDate();
    }

    public String getFeedTitle(AtomRequestContext atomRequestContext) {
        return String.valueOf(AtomUtil.createFeedTitleFromPortletName(atomRequestContext, "20")) + " files";
    }

    public String getMediaContentType(FileEntry fileEntry) {
        return fileEntry.getMimeType();
    }

    public String getMediaName(FileEntry fileEntry) {
        return fileEntry.getTitle();
    }

    public InputStream getMediaStream(FileEntry fileEntry) throws AtomException {
        try {
            return fileEntry.getContentStream();
        }
        catch (Exception ex) {
            throw new AtomException(500, (Throwable)ex);
        }
    }

    protected void doDeleteEntry(String resourceName, AtomRequestContext atomRequestContext) throws Exception {
        long fileEntryId = GetterUtil.getLong((String)resourceName);
        DLAppServiceUtil.deleteFileEntry((long)fileEntryId);
    }

    protected FileEntry doGetEntry(String resourceName, AtomRequestContext atomRequestContext) throws Exception {
        long fileEntryId = GetterUtil.getLong((String)resourceName);
        return DLAppServiceUtil.getFileEntry((long)fileEntryId);
    }

    protected Iterable<FileEntry> doGetFeedEntries(AtomRequestContext atomRequestContext) throws Exception {
        long folderId = atomRequestContext.getLongParameter("folderId");
        long repositoryId = 0L;
        if (folderId != 0L) {
            Folder folder = DLAppServiceUtil.getFolder((long)folderId);
            repositoryId = folder.getRepositoryId();
        } else {
            repositoryId = atomRequestContext.getLongParameter("repositoryId");
        }
        int count = DLAppServiceUtil.getFileEntriesCount((long)repositoryId, (long)folderId);
        AtomPager atomPager = new AtomPager(atomRequestContext, count);
        AtomUtil.saveAtomPagerInRequest(atomRequestContext, atomPager);
        return DLAppServiceUtil.getFileEntries((long)repositoryId, (long)folderId, (int)atomPager.getStart(), (int)(atomPager.getEnd() + 1), (OrderByComparator)new EntryNameComparator());
    }

    protected FileEntry doPostEntry(String title, String summary, String content, Date date, AtomRequestContext atomRequestContext) throws Exception {
        long folderId = atomRequestContext.getLongParameter("folderId");
        long repositoryId = 0L;
        if (folderId != 0L) {
            Folder folder = DLAppServiceUtil.getFolder((long)folderId);
            repositoryId = folder.getRepositoryId();
        } else {
            repositoryId = atomRequestContext.getLongParameter("repositoryId");
        }
        String mimeType = atomRequestContext.getHeader("Media-Content-Type");
        if (mimeType == null) {
            mimeType = MimeTypesUtil.getContentType((String)title);
        }
        byte[] contentDecoded = Base64.decode((String)content);
        ByteArrayInputStream contentInputStream = new ByteArrayInputStream(contentDecoded);
        ServiceContext serviceContext = new ServiceContext();
        FileEntry fileEntry = DLAppServiceUtil.addFileEntry((long)repositoryId, (long)folderId, (String)title, (String)mimeType, (String)title, (String)summary, null, (InputStream)contentInputStream, (long)contentDecoded.length, (ServiceContext)serviceContext);
        return fileEntry;
    }

    protected FileEntry doPostMedia(String mimeType, String slug, InputStream inputStream, AtomRequestContext atomRequestContext) throws Exception {
        long folderId = atomRequestContext.getLongParameter("folderId");
        long repositoryId = 0L;
        if (folderId != 0L) {
            Folder folder = DLAppServiceUtil.getFolder((long)folderId);
            repositoryId = folder.getRepositoryId();
        } else {
            repositoryId = atomRequestContext.getLongParameter("repositoryId");
        }
        String title = atomRequestContext.getHeader("Title");
        String description = atomRequestContext.getHeader("Summary");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamUtil.transfer((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
        byte[] content = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream contentInputStream = new ByteArrayInputStream(content);
        ServiceContext serviceContext = new ServiceContext();
        FileEntry fileEntry = DLAppServiceUtil.addFileEntry((long)repositoryId, (long)folderId, (String)title, (String)mimeType, (String)title, (String)description, null, (InputStream)contentInputStream, (long)content.length, (ServiceContext)serviceContext);
        return fileEntry;
    }

    protected void doPutEntry(FileEntry fileEntry, String title, String summary, String content, Date date, AtomRequestContext atomRequestContext) throws Exception {
        String mimeType = atomRequestContext.getHeader("Media-Content-Type");
        if (mimeType == null) {
            mimeType = MimeTypesUtil.getContentType((String)title);
        }
        byte[] contentDecoded = Base64.decode((String)content);
        ByteArrayInputStream contentInputStream = new ByteArrayInputStream(contentDecoded);
        ServiceContext serviceContext = new ServiceContext();
        DLAppServiceUtil.updateFileEntry((long)fileEntry.getFileEntryId(), (String)title, (String)mimeType, (String)title, (String)summary, null, (boolean)true, (InputStream)contentInputStream, (long)contentDecoded.length, (ServiceContext)serviceContext);
    }

    protected void doPutMedia(FileEntry fileEntry, String mimeType, String slug, InputStream inputStream, AtomRequestContext atomRequestContext) throws Exception {
        String title = atomRequestContext.getHeader("Title");
        String description = atomRequestContext.getHeader("Summary");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamUtil.transfer((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
        byte[] content = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream contentInputStream = new ByteArrayInputStream(content);
        ServiceContext serviceContext = new ServiceContext();
        DLAppServiceUtil.updateFileEntry((long)fileEntry.getFileEntryId(), (String)slug, (String)mimeType, (String)title, (String)description, null, (boolean)true, (InputStream)contentInputStream, (long)content.length, (ServiceContext)serviceContext);
    }
}

