/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.asset;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.PortletURLFactoryUtil;
import com.liferay.portlet.asset.model.AssetRenderer;
import com.liferay.portlet.asset.model.BaseAssetRendererFactory;
import com.liferay.portlet.assetpublisher.util.AssetPublisherUtil;
import com.liferay.portlet.documentlibrary.asset.DLFileEntryAssetRenderer;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileEntryType;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryTypeLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryTypeServiceUtil;
import com.liferay.portlet.documentlibrary.service.permission.DLFileEntryPermission;
import com.liferay.portlet.documentlibrary.service.permission.DLFileEntryTypePermission;
import com.liferay.portlet.documentlibrary.service.permission.DLPermission;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;

public class DLFileEntryAssetRendererFactory
extends BaseAssetRendererFactory {
    public static final String TYPE = "document";
    private static final boolean _LINKABLE = true;

    public AssetRenderer getAssetRenderer(long classPK, int type) throws PortalException, SystemException {
        FileEntry fileEntry = null;
        FileVersion fileVersion = null;
        if (type == 0) {
            fileVersion = DLAppLocalServiceUtil.getFileVersion((long)classPK);
            fileEntry = fileVersion.getFileEntry();
        } else {
            fileEntry = DLAppLocalServiceUtil.getFileEntry((long)classPK);
            fileVersion = fileEntry.getFileVersion();
        }
        DLFileEntryAssetRenderer dlFileEntryAssetRenderer = new DLFileEntryAssetRenderer(fileEntry, fileVersion);
        dlFileEntryAssetRenderer.setAssetRendererType(type);
        return dlFileEntryAssetRenderer;
    }

    public String getClassName() {
        return DLFileEntry.class.getName();
    }

    public List<Tuple> getClassTypeFieldNames(long classTypeId, Locale locale, int start, int end) throws Exception {
        ArrayList classTypeFieldNames = new ArrayList();
        DLFileEntryType dlFileEntryType = DLFileEntryTypeLocalServiceUtil.getDLFileEntryType((long)classTypeId);
        List ddmStructures = dlFileEntryType.getDDMStructures();
        for (DDMStructure ddmStructure : ddmStructures) {
            classTypeFieldNames.addAll(this.getDDMStructureFieldNames(ddmStructure, locale));
        }
        return ListUtil.subList(classTypeFieldNames, (int)start, (int)end);
    }

    public int getClassTypeFieldNamesCount(long classTypeId, Locale locale) throws Exception {
        ArrayList classTypeFieldNames = new ArrayList();
        DLFileEntryType dlFileEntryType = DLFileEntryTypeLocalServiceUtil.getDLFileEntryType((long)classTypeId);
        List ddmStructures = dlFileEntryType.getDDMStructures();
        for (DDMStructure ddmStructure : ddmStructures) {
            classTypeFieldNames.addAll(this.getDDMStructureFieldNames(ddmStructure, locale));
        }
        return classTypeFieldNames.size();
    }

    public Map<Long, String> getClassTypes(long[] groupIds, Locale locale) throws Exception {
        HashMap<Long, String> classTypes = new HashMap<Long, String>();
        List dlFileEntryTypes = DLFileEntryTypeServiceUtil.getFileEntryTypes((long[])groupIds);
        for (DLFileEntryType dlFileEntryType : dlFileEntryTypes) {
            classTypes.put(dlFileEntryType.getFileEntryTypeId(), dlFileEntryType.getName(locale));
        }
        return classTypes;
    }

    public String getType() {
        return TYPE;
    }

    public String getTypeName(Locale locale, boolean hasSubtypes) {
        if (hasSubtypes) {
            return LanguageUtil.get((Locale)locale, (String)"basic-document");
        }
        return super.getTypeName(locale, hasSubtypes);
    }

    public PortletURL getURLAdd(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws PortalException, SystemException {
        ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (!DLPermission.contains(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), "ADD_DOCUMENT")) {
            return null;
        }
        long classTypeId = GetterUtil.getLong((Object)liferayPortletRequest.getAttribute("ASSET_RENDERER_FACTORY_CLASS_TYPE_ID"));
        if (classTypeId > 0L && !DLFileEntryTypePermission.contains(themeDisplay.getPermissionChecker(), classTypeId, "VIEW")) {
            return null;
        }
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)liferayPortletRequest, (String)"20", (long)this.getControlPanelPlid(themeDisplay), (String)"RENDER_PHASE");
        portletURL.setParameter("struts_action", "/document_library/edit_file_entry");
        portletURL.setParameter("folderId", String.valueOf(AssetPublisherUtil.getRecentFolderId((PortletRequest)liferayPortletRequest, (String)this.getClassName())));
        return portletURL;
    }

    public PortletURL getURLView(LiferayPortletResponse liferayPortletResponse, WindowState windowState) {
        LiferayPortletURL liferayPortletURL = liferayPortletResponse.createLiferayPortletURL("110", "RENDER_PHASE");
        try {
            liferayPortletURL.setWindowState(windowState);
        }
        catch (WindowStateException windowStateException) {}
        return liferayPortletURL;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws Exception {
        return DLFileEntryPermission.contains(permissionChecker, classPK, actionId);
    }

    public boolean isLinkable() {
        return true;
    }

    protected String getIconPath(ThemeDisplay themeDisplay) {
        return String.valueOf(themeDisplay.getPathThemeImages()) + "/common/clip.png";
    }
}

