/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.action;

import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.assetpublisher.util.AssetPublisherUtil;
import com.liferay.portlet.documentlibrary.DuplicateFileException;
import com.liferay.portlet.documentlibrary.DuplicateFolderNameException;
import com.liferay.portlet.documentlibrary.FolderNameException;
import com.liferay.portlet.documentlibrary.NoSuchFolderException;
import com.liferay.portlet.documentlibrary.action.ActionUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.DLAppServiceUtil;
import com.liferay.portlet.trash.util.TrashUtil;
import java.util.HashMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditFolderAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateFolder(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteFolders(actionRequest, false);
            } else if (cmd.equals("move")) {
                this.moveFolders(actionRequest, false);
            } else if (cmd.equals("move_from_trash")) {
                this.moveFolders(actionRequest, true);
            } else if (cmd.equals("move_to_trash")) {
                this.deleteFolders(actionRequest, true);
            } else if (cmd.equals("subscribe")) {
                this.subscribeFolder(actionRequest);
            } else if (cmd.equals("unsubscribe")) {
                this.unsubscribeFolder(actionRequest);
            } else if (cmd.equals("updateWorkflowDefinitions")) {
                this.updateWorkflowDefinitions(actionRequest);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchFolderException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.document_library.error");
            }
            if (e2 instanceof DuplicateFileException || e2 instanceof DuplicateFolderNameException || e2 instanceof FolderNameException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
            }
            throw e2;
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getFolder((PortletRequest)renderRequest);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchFolderException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e2.getClass());
                return actionMapping.findForward("portlet.document_library.error");
            }
            throw e2;
        }
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.document_library.edit_folder"));
    }

    protected void deleteFolders(ActionRequest actionRequest, boolean moveToTrash) throws Exception {
        String deleteEntryTitle = null;
        long[] deleteFolderIds = null;
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        deleteFolderIds = folderId > 0L ? new long[]{folderId} : StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"folderIds"), (long)0L);
        int i2 = 0;
        while (i2 < deleteFolderIds.length) {
            long deleteFolderId = deleteFolderIds[i2];
            if (moveToTrash) {
                Folder folder = DLAppServiceUtil.moveFolderToTrash((long)deleteFolderId);
                if (i2 == 0) {
                    deleteEntryTitle = TrashUtil.getOriginalTitle((String)folder.getName());
                }
            } else {
                DLAppServiceUtil.deleteFolder((long)deleteFolderId);
            }
            AssetPublisherUtil.removeRecentFolderId((PortletRequest)actionRequest, (String)DLFileEntry.class.getName(), (long)deleteFolderId);
            ++i2;
        }
        if (moveToTrash && deleteFolderIds.length > 0) {
            HashMap<String, String[]> data = new HashMap<String, String[]>();
            data.put("deleteEntryClassName", new String[]{DLFolder.class.getName()});
            if (Validator.isNotNull((String)deleteEntryTitle)) {
                data.put("deleteEntryTitle", new String[]{deleteEntryTitle});
            }
            data.put("restoreFolderIds", ArrayUtil.toStringArray((long[])deleteFolderIds));
            SessionMessages.add((PortletRequest)actionRequest, (String)(String.valueOf(PortalUtil.getPortletId((PortletRequest)actionRequest)) + ".deleteSuccessData"), data);
            this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        }
    }

    protected void moveFolders(ActionRequest actionRequest, boolean moveFromTrash) throws Exception {
        long[] folderIds = null;
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        folderIds = folderId > 0L ? new long[]{folderId} : StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"folderIds"), (long)0L);
        long parentFolderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"parentFolderId");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DLFileEntry.class.getName(), (PortletRequest)actionRequest);
        long[] lArray = folderIds;
        int n = folderIds.length;
        int n2 = 0;
        while (n2 < n) {
            long moveFolderId = lArray[n2];
            if (moveFromTrash) {
                DLAppServiceUtil.moveFolderFromTrash((long)moveFolderId, (long)parentFolderId, (ServiceContext)serviceContext);
            } else {
                DLAppServiceUtil.moveFolder((long)moveFolderId, (long)parentFolderId, (ServiceContext)serviceContext);
            }
            ++n2;
        }
    }

    protected void subscribeFolder(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        DLAppServiceUtil.subscribeFolder((long)themeDisplay.getScopeGroupId(), (long)folderId);
    }

    protected void unsubscribeFolder(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        DLAppServiceUtil.unsubscribeFolder((long)themeDisplay.getScopeGroupId(), (long)folderId);
    }

    protected void updateFolder(ActionRequest actionRequest) throws Exception {
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        long repositoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"repositoryId");
        long parentFolderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"parentFolderId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DLFolder.class.getName(), (PortletRequest)actionRequest);
        if (folderId <= 0L) {
            DLAppServiceUtil.addFolder((long)repositoryId, (long)parentFolderId, (String)name, (String)description, (ServiceContext)serviceContext);
        } else {
            DLAppServiceUtil.updateFolder((long)folderId, (String)name, (String)description, (ServiceContext)serviceContext);
        }
    }

    protected void updateWorkflowDefinitions(ActionRequest actionRequest) throws Exception {
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DLFileEntry.class.getName(), (PortletRequest)actionRequest);
        DLAppServiceUtil.updateFolder((long)0L, null, null, (ServiceContext)serviceContext);
    }
}

