/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.documentlibrary.DuplicateFileEntryTypeException;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryTypeException;
import com.liferay.portlet.documentlibrary.NoSuchMetadataSetException;
import com.liferay.portlet.documentlibrary.model.DLFileEntryMetadata;
import com.liferay.portlet.documentlibrary.model.DLFileEntryType;
import com.liferay.portlet.documentlibrary.service.DLAppServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryTypeServiceUtil;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.dynamicdatamapping.NoSuchStructureException;
import com.liferay.portlet.dynamicdatamapping.RequiredStructureException;
import com.liferay.portlet.dynamicdatamapping.StructureDuplicateElementException;
import com.liferay.portlet.dynamicdatamapping.StructureNameException;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditFileEntryTypeAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateFileEntryType(actionRequest, actionResponse);
            } else if (cmd.equals("delete")) {
                this.deleteFileEntryType(actionRequest, actionResponse);
            } else if (cmd.equals("subscribe")) {
                this.subscribeFileEntryType(actionRequest);
            } else if (cmd.equals("unsubscribe")) {
                this.unsubscribeFileEntryType(actionRequest);
            }
            if (SessionErrors.isEmpty((PortletRequest)actionRequest)) {
                SessionMessages.add((PortletRequest)actionRequest, (String)(String.valueOf(PortalUtil.getPortletId((PortletRequest)actionRequest)) + ".refreshPortlet"), (Object)"20");
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e2) {
            if (e2 instanceof DuplicateFileEntryTypeException || e2 instanceof NoSuchMetadataSetException || e2 instanceof StructureDuplicateElementException || e2 instanceof StructureNameException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
            }
            if (e2 instanceof NoSuchFileEntryTypeException || e2 instanceof NoSuchStructureException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.document_library.error");
            }
            if (e2 instanceof RequiredStructureException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                this.sendRedirect(actionRequest, actionResponse);
            }
            throw e2;
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        DLFileEntryType dlFileEntryType = null;
        try {
            long fileEntryTypeId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"fileEntryTypeId");
            if (fileEntryTypeId > 0L) {
                dlFileEntryType = DLFileEntryTypeServiceUtil.getFileEntryType((long)fileEntryTypeId);
                renderRequest.setAttribute("DOCUMENT_LIBRARY_FILE_ENTRY_TYPE", (Object)dlFileEntryType);
                DDMStructure ddmStructure = DDMStructureLocalServiceUtil.fetchStructure((long)dlFileEntryType.getGroupId(), (long)PortalUtil.getClassNameId(DLFileEntryMetadata.class), (String)DLUtil.getDDMStructureKey((DLFileEntryType)dlFileEntryType));
                if (ddmStructure == null) {
                    ddmStructure = DDMStructureLocalServiceUtil.fetchStructure((long)dlFileEntryType.getGroupId(), (long)PortalUtil.getClassNameId(DLFileEntryMetadata.class), (String)DLUtil.getDeprecatedDDMStructureKey((DLFileEntryType)dlFileEntryType));
                }
                renderRequest.setAttribute("DYNAMIC_DATA_MAPPING_STRUCTURE", (Object)ddmStructure);
            }
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchFileEntryTypeException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e2.getClass());
                return actionMapping.findForward("portlet.document_library.error");
            }
            throw e2;
        }
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.document_library.edit_file_entry_type"));
    }

    protected void deleteFileEntryType(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long fileEntryTypeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"fileEntryTypeId");
        DLFileEntryTypeServiceUtil.deleteFileEntryType((long)fileEntryTypeId);
    }

    protected long[] getLongArray(PortletRequest portletRequest, String name) {
        String value = portletRequest.getParameter(name);
        if (value == null) {
            return null;
        }
        return StringUtil.split((String)GetterUtil.getString((String)value), (long)0L);
    }

    protected void subscribeFileEntryType(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long fileEntryTypeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"fileEntryTypeId");
        DLAppServiceUtil.subscribeFileEntryType((long)themeDisplay.getScopeGroupId(), (long)fileEntryTypeId);
    }

    protected void unsubscribeFileEntryType(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long fileEntryTypeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"fileEntryTypeId");
        DLAppServiceUtil.unsubscribeFileEntryType((long)themeDisplay.getScopeGroupId(), (long)fileEntryTypeId);
    }

    protected void updateFileEntryType(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long fileEntryTypeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"fileEntryTypeId");
        Map nameMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"name");
        Map descriptionMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"description");
        long[] ddmStructureIds = this.getLongArray((PortletRequest)actionRequest, "ddmStructuresSearchContainerPrimaryKeys");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DLFileEntryType.class.getName(), (PortletRequest)actionRequest);
        if (fileEntryTypeId <= 0L) {
            long groupId = themeDisplay.getScopeGroupId();
            Group scopeGroup = GroupLocalServiceUtil.getGroup((long)groupId);
            if (scopeGroup.isLayout()) {
                groupId = scopeGroup.getParentGroupId();
            }
            DLFileEntryTypeServiceUtil.addFileEntryType((long)groupId, null, (Map)nameMap, (Map)descriptionMap, (long[])ddmStructureIds, (ServiceContext)serviceContext);
        } else {
            DLFileEntryTypeServiceUtil.updateFileEntryType((long)fileEntryTypeId, (Map)nameMap, (Map)descriptionMap, (long[])ddmStructureIds, (ServiceContext)serviceContext);
        }
    }
}

