/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.calendar.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portlet.calendar.model.CalEvent;
import com.liferay.portlet.calendar.service.CalEventLocalServiceUtil;

public class CalEventPermission {
    public static void check(PermissionChecker permissionChecker, CalEvent event, String actionId) throws PortalException {
        if (!CalEventPermission.contains(permissionChecker, event, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long eventId, String actionId) throws PortalException, SystemException {
        if (!CalEventPermission.contains(permissionChecker, eventId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, CalEvent event, String actionId) {
        if (permissionChecker.hasOwnerPermission(event.getCompanyId(), CalEvent.class.getName(), event.getEventId(), event.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(event.getGroupId(), CalEvent.class.getName(), event.getEventId(), actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long eventId, String actionId) throws PortalException, SystemException {
        CalEvent event = CalEventLocalServiceUtil.getEvent((long)eventId);
        return CalEventPermission.contains(permissionChecker, event, actionId);
    }
}

