/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.service.persistence;

import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.CalendarUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.model.impl.BlogsEntryImpl;
import com.liferay.portlet.blogs.service.persistence.BlogsEntryFinder;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class BlogsEntryFinderImpl
extends BasePersistenceImpl<BlogsEntry>
implements BlogsEntryFinder {
    public static final String COUNT_BY_ORGANIZATION_IDS = String.valueOf(BlogsEntryFinder.class.getName()) + ".countByOrganizationIds";
    public static final String FIND_BY_GROUP_IDS = String.valueOf(BlogsEntryFinder.class.getName()) + ".findByGroupIds";
    public static final String FIND_BY_ORGANIZATION_IDS = String.valueOf(BlogsEntryFinder.class.getName()) + ".findByOrganizationIds";
    public static final String FIND_BY_NO_ASSETS = String.valueOf(BlogsEntryFinder.class.getName()) + ".findByNoAssets";

    public int countByOrganizationId(long organizationId, Date displayDate, QueryDefinition queryDefinition) throws SystemException {
        ArrayList<Long> organizationIds = new ArrayList<Long>();
        organizationIds.add(organizationId);
        return this.countByOrganizationIds(organizationIds, displayDate, queryDefinition);
    }

    public int countByOrganizationIds(List<Long> organizationIds, Date displayDate, QueryDefinition queryDefinition) throws SystemException {
        Timestamp displayDate_TS = CalendarUtil.getTimestamp((Date)displayDate);
        Session session = null;
        try {
            Long count;
            Iterator itr;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_BY_ORGANIZATION_IDS);
            if (queryDefinition.getStatus() != -1) {
                sql = queryDefinition.isExcludeStatus() ? CustomSQLUtil.appendCriteria((String)sql, (String)"AND (BlogsEntry.status != ?)") : CustomSQLUtil.appendCriteria((String)sql, (String)"AND (BlogsEntry.status = ?)");
            }
            sql = StringUtil.replace((String)sql, (String)"[$ORGANIZATION_ID$]", (String)this.getOrganizationIds(organizationIds));
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            int i2 = 0;
            while (i2 < organizationIds.size()) {
                Long organizationId = organizationIds.get(i2);
                qPos.add(organizationId);
                ++i2;
            }
            qPos.add(displayDate_TS);
            if (queryDefinition.getStatus() != -1) {
                qPos.add(queryDefinition.getStatus());
            }
            if ((itr = q.iterate()).hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            return 0;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<BlogsEntry> findByGroupIds(long companyId, long groupId, Date displayDate, QueryDefinition queryDefinition) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_GROUP_IDS);
            if (queryDefinition.getStatus() != -1) {
                sql = queryDefinition.isExcludeStatus() ? CustomSQLUtil.appendCriteria((String)sql, (String)"AND (BlogsEntry.status != ?)") : CustomSQLUtil.appendCriteria((String)sql, (String)"AND (BlogsEntry.status = ?)");
            }
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("BlogsEntry", BlogsEntryImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(companyId);
            qPos.add(groupId);
            qPos.add(groupId);
            qPos.add(groupId);
            qPos.add(displayDate);
            if (queryDefinition.getStatus() != -1) {
                qPos.add(queryDefinition.getStatus());
            }
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)queryDefinition.getStart(), (int)queryDefinition.getEnd());
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<BlogsEntry> findByOrganizationId(long organizationId, Date displayDate, QueryDefinition queryDefinition) throws SystemException {
        ArrayList<Long> organizationIds = new ArrayList<Long>();
        organizationIds.add(organizationId);
        return this.findByOrganizationIds(organizationIds, displayDate, queryDefinition);
    }

    public List<BlogsEntry> findByOrganizationIds(List<Long> organizationIds, Date displayDate, QueryDefinition queryDefinition) throws SystemException {
        Timestamp displayDate_TS = CalendarUtil.getTimestamp((Date)displayDate);
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_ORGANIZATION_IDS);
            if (queryDefinition.getStatus() != -1) {
                sql = queryDefinition.isExcludeStatus() ? CustomSQLUtil.appendCriteria((String)sql, (String)"AND (BlogsEntry.status != ?)") : CustomSQLUtil.appendCriteria((String)sql, (String)"AND (BlogsEntry.status = ?)");
            }
            sql = StringUtil.replace((String)sql, (String)"[$ORGANIZATION_ID$]", (String)this.getOrganizationIds(organizationIds));
            sql = CustomSQLUtil.replaceOrderBy((String)sql, (OrderByComparator)queryDefinition.getOrderByComparator());
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("BlogsEntry", BlogsEntryImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            int i2 = 0;
            while (i2 < organizationIds.size()) {
                Long organizationId = organizationIds.get(i2);
                qPos.add(organizationId);
                ++i2;
            }
            qPos.add(displayDate_TS);
            if (queryDefinition.getStatus() != -1) {
                qPos.add(queryDefinition.getStatus());
            }
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)queryDefinition.getStart(), (int)queryDefinition.getEnd());
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<BlogsEntry> findByNoAssets() throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_NO_ASSETS);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("BlogsEntry", BlogsEntryImpl.class);
            List list = q.list(true);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String getOrganizationIds(List<Long> organizationIds) {
        if (organizationIds.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(organizationIds.size() * 2 - 1);
        int i2 = 0;
        while (i2 < organizationIds.size()) {
            sb.append("Users_Orgs.organizationId = ? ");
            if (i2 + 1 != organizationIds.size()) {
                sb.append("OR ");
            }
            ++i2;
        }
        return sb.toString();
    }
}

