/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.service.impl;

import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.service.base.BlogsEntryServiceBaseImpl;
import com.liferay.portlet.blogs.service.permission.BlogsEntryPermission;
import com.liferay.portlet.blogs.service.permission.BlogsPermission;
import com.liferay.portlet.blogs.util.comparator.EntryDisplayDateComparator;
import com.liferay.util.RSSUtil;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.feed.synd.SyndLinkImpl;
import com.sun.syndication.io.FeedException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class BlogsEntryServiceImpl
extends BlogsEntryServiceBaseImpl {
    public BlogsEntry addEntry(String title, String description, String content, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, boolean allowPingbacks, boolean allowTrackbacks, String[] trackbacks, boolean smallImage, String smallImageURL, String smallImageFileName, InputStream smallImageInputStream, ServiceContext serviceContext) throws PortalException, SystemException {
        BlogsPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "ADD_ENTRY");
        return this.blogsEntryLocalService.addEntry(this.getUserId(), title, description, content, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, allowPingbacks, allowTrackbacks, trackbacks, smallImage, smallImageURL, smallImageFileName, smallImageInputStream, serviceContext);
    }

    public void deleteEntry(long entryId) throws PortalException, SystemException {
        BlogsEntryPermission.check(this.getPermissionChecker(), entryId, "DELETE");
        this.blogsEntryLocalService.deleteEntry(entryId);
    }

    public List<BlogsEntry> getCompanyEntries(long companyId, Date displayDate, int status, int max) throws PortalException, SystemException {
        ArrayList<BlogsEntry> entries = new ArrayList<BlogsEntry>();
        boolean listNotExhausted = true;
        QueryDefinition queryDefinition = new QueryDefinition(status, false, 0, 0, (OrderByComparator)new EntryDisplayDateComparator());
        if (status == -1) {
            queryDefinition.setStatus(8, true);
        }
        block0: while (entries.size() < max && listNotExhausted) {
            queryDefinition.setEnd(queryDefinition.getStart() + max);
            List entryList = this.blogsEntryLocalService.getCompanyEntries(companyId, displayDate, queryDefinition);
            queryDefinition.setStart(queryDefinition.getStart() + max);
            listNotExhausted = entryList.size() == max;
            for (BlogsEntry entry : entryList) {
                if (entries.size() >= max) continue block0;
                if (!BlogsEntryPermission.contains(this.getPermissionChecker(), entry, "VIEW")) continue;
                entries.add(entry);
            }
        }
        return entries;
    }

    public String getCompanyEntriesRSS(long companyId, Date displayDate, int status, int max, String type, double version, String displayStyle, String feedURL, String entryURL, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        String name = company.getName();
        List<BlogsEntry> blogsEntries = this.getCompanyEntries(companyId, displayDate, status, max);
        return this.exportToRSS(name, name, type, version, displayStyle, feedURL, entryURL, blogsEntries, themeDisplay);
    }

    public BlogsEntry getEntry(long entryId) throws PortalException, SystemException {
        BlogsEntryPermission.check(this.getPermissionChecker(), entryId, "VIEW");
        return this.blogsEntryLocalService.getEntry(entryId);
    }

    public BlogsEntry getEntry(long groupId, String urlTitle) throws PortalException, SystemException {
        BlogsEntry entry = this.blogsEntryLocalService.getEntry(groupId, urlTitle);
        BlogsEntryPermission.check(this.getPermissionChecker(), entry.getEntryId(), "VIEW");
        return entry;
    }

    public List<BlogsEntry> getGroupEntries(long groupId, Date displayDate, int status, int max) throws SystemException {
        return this.getGroupEntries(groupId, displayDate, status, 0, max);
    }

    public List<BlogsEntry> getGroupEntries(long groupId, Date displayDate, int status, int start, int end) throws SystemException {
        if (status == -1) {
            return this.blogsEntryPersistence.filterFindByG_LtD_NotS(groupId, displayDate, 8, start, end);
        }
        return this.blogsEntryPersistence.filterFindByG_LtD_S(groupId, displayDate, status, start, end);
    }

    public List<BlogsEntry> getGroupEntries(long groupId, int status, int max) throws SystemException {
        return this.getGroupEntries(groupId, status, 0, max);
    }

    public List<BlogsEntry> getGroupEntries(long groupId, int status, int start, int end) throws SystemException {
        if (status == -1) {
            return this.blogsEntryPersistence.filterFindByG_NotS(groupId, 8, start, end);
        }
        return this.blogsEntryPersistence.filterFindByG_S(groupId, status, start, end);
    }

    public int getGroupEntriesCount(long groupId, Date displayDate, int status) throws SystemException {
        if (status == -1) {
            return this.blogsEntryPersistence.filterCountByG_LtD_NotS(groupId, displayDate, 8);
        }
        return this.blogsEntryPersistence.filterCountByG_LtD_S(groupId, displayDate, status);
    }

    public int getGroupEntriesCount(long groupId, int status) throws SystemException {
        if (status == -1) {
            return this.blogsEntryPersistence.filterCountByG_NotS(groupId, 8);
        }
        return this.blogsEntryPersistence.filterCountByG_S(groupId, status);
    }

    public String getGroupEntriesRSS(long groupId, Date displayDate, int status, int max, String type, double version, String displayStyle, String feedURL, String entryURL, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        String name = group.getDescriptiveName();
        List<BlogsEntry> blogsEntries = this.getGroupEntries(groupId, displayDate, status, max);
        return this.exportToRSS(name, name, type, version, displayStyle, feedURL, entryURL, blogsEntries, themeDisplay);
    }

    public List<BlogsEntry> getGroupsEntries(long companyId, long groupId, Date displayDate, int status, int max) throws PortalException, SystemException {
        ArrayList<BlogsEntry> entries = new ArrayList<BlogsEntry>();
        boolean listNotExhausted = true;
        QueryDefinition queryDefinition = new QueryDefinition(status, false, 0, 0, (OrderByComparator)new EntryDisplayDateComparator());
        if (status == -1) {
            queryDefinition.setStatus(8, true);
        }
        block0: while (entries.size() < max && listNotExhausted) {
            queryDefinition.setEnd(queryDefinition.getStart() + max);
            List entryList = this.blogsEntryLocalService.getGroupsEntries(companyId, groupId, displayDate, queryDefinition);
            queryDefinition.setStart(queryDefinition.getStart() + max);
            listNotExhausted = entryList.size() == max;
            for (BlogsEntry entry : entryList) {
                if (entries.size() >= max) continue block0;
                if (!BlogsEntryPermission.contains(this.getPermissionChecker(), entry, "VIEW")) continue;
                entries.add(entry);
            }
        }
        return entries;
    }

    public List<BlogsEntry> getOrganizationEntries(long organizationId, Date displayDate, int status, int max) throws PortalException, SystemException {
        ArrayList<BlogsEntry> entries = new ArrayList<BlogsEntry>();
        boolean listNotExhausted = true;
        QueryDefinition queryDefinition = new QueryDefinition(status, false, 0, 0, (OrderByComparator)new EntryDisplayDateComparator());
        if (status == -1) {
            queryDefinition.setStatus(8, true);
        }
        block0: while (entries.size() < max && listNotExhausted) {
            queryDefinition.setEnd(queryDefinition.getStart() + max);
            List entryList = this.blogsEntryFinder.findByOrganizationId(organizationId, displayDate, queryDefinition);
            queryDefinition.setStart(queryDefinition.getStart() + max);
            listNotExhausted = entryList.size() == max;
            for (BlogsEntry entry : entryList) {
                if (entries.size() >= max) continue block0;
                if (!BlogsEntryPermission.contains(this.getPermissionChecker(), entry, "VIEW")) continue;
                entries.add(entry);
            }
        }
        return entries;
    }

    public String getOrganizationEntriesRSS(long organizationId, Date displayDate, int status, int max, String type, double version, String displayStyle, String feedURL, String entryURL, ThemeDisplay themeDisplay) throws PortalException, SystemException {
        Organization organization = this.organizationPersistence.findByPrimaryKey(organizationId);
        String name = organization.getName();
        List<BlogsEntry> blogsEntries = this.getOrganizationEntries(organizationId, displayDate, status, max);
        return this.exportToRSS(name, name, type, version, displayStyle, feedURL, entryURL, blogsEntries, themeDisplay);
    }

    public BlogsEntry moveEntryToTrash(long entryId) throws PortalException, SystemException {
        BlogsEntryPermission.check(this.getPermissionChecker(), entryId, "DELETE");
        return this.blogsEntryLocalService.moveEntryToTrash(this.getUserId(), entryId);
    }

    public void restoreEntryFromTrash(long entryId) throws PortalException, SystemException {
        BlogsEntryPermission.check(this.getPermissionChecker(), entryId, "DELETE");
        this.blogsEntryLocalService.restoreEntryFromTrash(this.getUserId(), entryId);
    }

    public void subscribe(long groupId) throws PortalException, SystemException {
        BlogsPermission.check(this.getPermissionChecker(), groupId, "SUBSCRIBE");
        this.blogsEntryLocalService.subscribe(this.getUserId(), groupId);
    }

    public void unsubscribe(long groupId) throws PortalException, SystemException {
        BlogsPermission.check(this.getPermissionChecker(), groupId, "SUBSCRIBE");
        this.blogsEntryLocalService.unsubscribe(this.getUserId(), groupId);
    }

    public BlogsEntry updateEntry(long entryId, String title, String description, String content, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, boolean allowPingbacks, boolean allowTrackbacks, String[] trackbacks, boolean smallImage, String smallImageURL, String smallImageFileName, InputStream smallImageInputStream, ServiceContext serviceContext) throws PortalException, SystemException {
        BlogsEntryPermission.check(this.getPermissionChecker(), entryId, "UPDATE");
        return this.blogsEntryLocalService.updateEntry(this.getUserId(), entryId, title, description, content, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, allowPingbacks, allowTrackbacks, trackbacks, smallImage, smallImageURL, smallImageFileName, smallImageInputStream, serviceContext);
    }

    protected String exportToRSS(String name, String description, String type, double version, String displayStyle, String feedURL, String entryURL, List<BlogsEntry> blogsEntries, ThemeDisplay themeDisplay) throws SystemException {
        SyndFeedImpl syndFeed = new SyndFeedImpl();
        syndFeed.setDescription(description);
        ArrayList<SyndEntryImpl> syndEntries = new ArrayList<SyndEntryImpl>();
        syndFeed.setEntries(syndEntries);
        for (BlogsEntry entry : blogsEntries) {
            SyndEntryImpl syndEntry = new SyndEntryImpl();
            String author = PortalUtil.getUserName((BaseModel)entry);
            syndEntry.setAuthor(author);
            SyndContentImpl syndContent = new SyndContentImpl();
            syndContent.setType("html");
            String value = null;
            if (displayStyle.equals("abstract")) {
                String summary = entry.getDescription();
                if (Validator.isNull((String)summary)) {
                    summary = entry.getContent();
                }
                value = StringUtil.shorten((String)HtmlUtil.extractText((String)summary), (int)PropsValues.BLOGS_RSS_ABSTRACT_LENGTH, (String)"");
            } else {
                value = displayStyle.equals("title") ? "" : StringUtil.replace((String)entry.getContent(), (String[])new String[]{"href=\"/", "src=\"/"}, (String[])new String[]{"href=\"" + themeDisplay.getURLPortal() + "/", "src=\"" + themeDisplay.getURLPortal() + "/"});
            }
            syndContent.setValue(value);
            syndEntry.setDescription((SyndContent)syndContent);
            StringBundler sb = new StringBundler(4);
            if (entryURL.endsWith("/blogs/rss")) {
                sb.append(entryURL.substring(0, entryURL.length() - 3));
                sb.append(entry.getUrlTitle());
            } else {
                sb.append(entryURL);
                if (!entryURL.endsWith("?")) {
                    sb.append("&");
                }
                sb.append("entryId=");
                sb.append(entry.getEntryId());
            }
            String link = sb.toString();
            syndEntry.setLink(link);
            syndEntry.setPublishedDate(entry.getDisplayDate());
            syndEntry.setTitle(entry.getTitle());
            syndEntry.setUpdatedDate(entry.getModifiedDate());
            syndEntry.setUri(link);
            syndEntries.add(syndEntry);
        }
        syndFeed.setFeedType(RSSUtil.getFeedType((String)type, (double)version));
        ArrayList<SyndLinkImpl> syndLinks = new ArrayList<SyndLinkImpl>();
        syndFeed.setLinks(syndLinks);
        SyndLinkImpl selfSyndLink = new SyndLinkImpl();
        syndLinks.add(selfSyndLink);
        selfSyndLink.setHref(feedURL);
        selfSyndLink.setRel("self");
        if (feedURL.endsWith("/-/blogs/rss")) {
            SyndLinkImpl alternateSyndLink = new SyndLinkImpl();
            syndLinks.add(alternateSyndLink);
            alternateSyndLink.setHref(feedURL.substring(0, feedURL.length() - 12));
            alternateSyndLink.setRel("alternate");
        }
        syndFeed.setPublishedDate(new Date());
        syndFeed.setTitle(name);
        syndFeed.setUri(feedURL);
        try {
            return RSSUtil.export((SyndFeed)syndFeed);
        }
        catch (FeedException fe) {
            throw new SystemException((Throwable)fe);
        }
    }
}

