/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.assetcategoryadmin.action;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.service.AssetCategoryServiceUtil;
import com.liferay.portlet.assetcategoryadmin.action.ActionUtil;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditCategoryAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                jsonObject = this.updateCategory(actionRequest);
            } else if (cmd.equals("move")) {
                jsonObject = this.moveCategory(actionRequest);
            }
        }
        catch (Exception e2) {
            jsonObject.putException(e2);
        }
        this.writeJSON((PortletRequest)actionRequest, actionResponse, (Object)jsonObject);
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        ActionUtil.getCategory((PortletRequest)renderRequest);
        ActionUtil.getVocabularies((PortletRequest)renderRequest);
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.asset_category_admin.edit_category"));
    }

    protected String[] getCategoryProperties(ActionRequest actionRequest) {
        int[] categoryPropertiesIndexes = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"categoryPropertiesIndexes"), (int)0);
        String[] categoryProperties = new String[categoryPropertiesIndexes.length];
        int i2 = 0;
        while (i2 < categoryPropertiesIndexes.length) {
            int categoryPropertiesIndex = categoryPropertiesIndexes[i2];
            String key = ParamUtil.getString((PortletRequest)actionRequest, (String)("key" + categoryPropertiesIndex));
            if (!Validator.isNull((String)key)) {
                String value = ParamUtil.getString((PortletRequest)actionRequest, (String)("value" + categoryPropertiesIndex));
                categoryProperties[i2] = String.valueOf(key) + ":" + value;
            }
            ++i2;
        }
        return categoryProperties;
    }

    protected JSONObject moveCategory(ActionRequest actionRequest) throws Exception {
        long categoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"categoryId");
        long parentCategoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"parentCategoryId");
        long vocabularyId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"vocabularyId");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)AssetCategory.class.getName(), (PortletRequest)actionRequest);
        AssetCategory category = AssetCategoryServiceUtil.moveCategory((long)categoryId, (long)parentCategoryId, (long)vocabularyId, (ServiceContext)serviceContext);
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        jsonObject.put("categoryId", category.getCategoryId());
        return jsonObject;
    }

    protected JSONObject updateCategory(ActionRequest actionRequest) throws Exception {
        long categoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"categoryId");
        long parentCategoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"parentCategoryId");
        Map titleMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"title");
        Map descriptionMap = LocalizationUtil.getLocalizationMap((PortletRequest)actionRequest, (String)"description");
        long vocabularyId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"vocabularyId");
        String[] categoryProperties = this.getCategoryProperties(actionRequest);
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)AssetCategory.class.getName(), (PortletRequest)actionRequest);
        AssetCategory category = null;
        category = categoryId <= 0L ? AssetCategoryServiceUtil.addCategory((long)parentCategoryId, (Map)titleMap, (Map)descriptionMap, (long)vocabularyId, (String[])categoryProperties, (ServiceContext)serviceContext) : AssetCategoryServiceUtil.updateCategory((long)categoryId, (long)parentCategoryId, (Map)titleMap, (Map)descriptionMap, (long)vocabularyId, (String[])categoryProperties, (ServiceContext)serviceContext);
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        jsonObject.put("categoryId", category.getCategoryId());
        jsonObject.put("parentCategoryId", category.getParentCategoryId());
        return jsonObject;
    }
}

