/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.service.AssetCategoryLocalServiceUtil;
import com.liferay.portlet.asset.service.permission.AssetPermission;

public class AssetCategoryPermission {
    public static void check(PermissionChecker permissionChecker, AssetCategory category, String actionId) throws PortalException {
        if (!AssetCategoryPermission.contains(permissionChecker, category, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long groupId, long categoryId, String actionId) throws PortalException, SystemException {
        if (!AssetCategoryPermission.contains(permissionChecker, groupId, categoryId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long categoryId, String actionId) throws PortalException, SystemException {
        if (!AssetCategoryPermission.contains(permissionChecker, categoryId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, AssetCategory category, String actionId) {
        if (permissionChecker.hasOwnerPermission(category.getCompanyId(), AssetCategory.class.getName(), category.getCategoryId(), category.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(category.getGroupId(), AssetCategory.class.getName(), category.getCategoryId(), actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, long categoryId, String actionId) throws PortalException, SystemException {
        if (categoryId == 0L) {
            return AssetPermission.contains(permissionChecker, groupId, actionId);
        }
        return AssetCategoryPermission.contains(permissionChecker, categoryId, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long categoryId, String actionId) throws PortalException, SystemException {
        AssetCategory category = AssetCategoryLocalServiceUtil.getCategory((long)categoryId);
        return AssetCategoryPermission.contains(permissionChecker, category, actionId);
    }
}

