/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portlet.asset.TagPropertyKeyException;
import com.liferay.portlet.asset.TagPropertyValueException;
import com.liferay.portlet.asset.model.AssetTagProperty;
import com.liferay.portlet.asset.service.base.AssetTagPropertyLocalServiceBaseImpl;
import com.liferay.portlet.asset.util.AssetUtil;
import java.util.Date;
import java.util.List;

public class AssetTagPropertyLocalServiceImpl
extends AssetTagPropertyLocalServiceBaseImpl {
    public AssetTagProperty addTagProperty(long userId, long tagId, String key, String value) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date now = new Date();
        this.validate(key, value);
        long tagPropertyId = this.counterLocalService.increment();
        AssetTagProperty tagProperty = this.assetTagPropertyPersistence.create(tagPropertyId);
        tagProperty.setCompanyId(user.getCompanyId());
        tagProperty.setUserId(user.getUserId());
        tagProperty.setUserName(user.getFullName());
        tagProperty.setCreateDate(now);
        tagProperty.setModifiedDate(now);
        tagProperty.setTagId(tagId);
        tagProperty.setKey(key);
        tagProperty.setValue(value);
        this.assetTagPropertyPersistence.update((BaseModel)tagProperty);
        return tagProperty;
    }

    public void deleteTagProperties(long tagId) throws SystemException {
        List tagProperties = this.assetTagPropertyPersistence.findByTagId(tagId);
        for (AssetTagProperty tagProperty : tagProperties) {
            this.deleteTagProperty(tagProperty);
        }
    }

    public void deleteTagProperty(AssetTagProperty tagProperty) throws SystemException {
        this.assetTagPropertyPersistence.remove((BaseModel)tagProperty);
    }

    public void deleteTagProperty(long tagPropertyId) throws PortalException, SystemException {
        AssetTagProperty tagProperty = this.assetTagPropertyPersistence.findByPrimaryKey(tagPropertyId);
        this.deleteTagProperty(tagProperty);
    }

    public List<AssetTagProperty> getTagProperties() throws SystemException {
        return this.assetTagPropertyPersistence.findAll();
    }

    public List<AssetTagProperty> getTagProperties(long tagId) throws SystemException {
        return this.assetTagPropertyPersistence.findByTagId(tagId);
    }

    public AssetTagProperty getTagProperty(long tagPropertyId) throws PortalException, SystemException {
        return this.assetTagPropertyPersistence.findByPrimaryKey(tagPropertyId);
    }

    public AssetTagProperty getTagProperty(long tagId, String key) throws PortalException, SystemException {
        return this.assetTagPropertyPersistence.findByT_K(tagId, key);
    }

    public String[] getTagPropertyKeys(long groupId) throws SystemException {
        return this.assetTagPropertyKeyFinder.findByGroupId(groupId);
    }

    public List<AssetTagProperty> getTagPropertyValues(long groupId, String key) throws SystemException {
        return this.assetTagPropertyFinder.findByG_K(groupId, key);
    }

    public AssetTagProperty updateTagProperty(long tagPropertyId, String key, String value) throws PortalException, SystemException {
        this.validate(key, value);
        AssetTagProperty tagProperty = this.assetTagPropertyPersistence.findByPrimaryKey(tagPropertyId);
        tagProperty.setModifiedDate(new Date());
        tagProperty.setKey(key);
        tagProperty.setValue(value);
        this.assetTagPropertyPersistence.update((BaseModel)tagProperty);
        return tagProperty;
    }

    protected void validate(String key, String value) throws PortalException {
        if (!AssetUtil.isValidWord(key)) {
            throw new TagPropertyKeyException();
        }
        if (!AssetUtil.isValidWord(value)) {
            throw new TagPropertyValueException();
        }
    }
}

