/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.impl;

import com.liferay.portal.kernel.cache.ThreadLocalCachable;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.AssetTagException;
import com.liferay.portlet.asset.DuplicateTagException;
import com.liferay.portlet.asset.NoSuchTagException;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.model.AssetTag;
import com.liferay.portlet.asset.model.AssetTagProperty;
import com.liferay.portlet.asset.service.base.AssetTagLocalServiceBaseImpl;
import com.liferay.portlet.asset.util.AssetUtil;
import com.liferay.portlet.social.util.SocialCounterPeriodUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class AssetTagLocalServiceImpl
extends AssetTagLocalServiceBaseImpl {
    public AssetTag addTag(long userId, String name, String[] tagProperties, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long groupId = serviceContext.getScopeGroupId();
        if (tagProperties == null) {
            tagProperties = new String[]{};
        }
        Date now = new Date();
        long tagId = this.counterLocalService.increment();
        AssetTag tag = this.assetTagPersistence.create(tagId);
        tag.setGroupId(groupId);
        tag.setCompanyId(user.getCompanyId());
        tag.setUserId(user.getUserId());
        tag.setUserName(user.getFullName());
        tag.setCreateDate(now);
        tag.setModifiedDate(now);
        name = name.trim();
        name = StringUtil.toLowerCase((String)name);
        if (this.hasTag(groupId, name)) {
            throw new DuplicateTagException("A tag with the name " + name + " already exists");
        }
        this.validate(name);
        tag.setName(name);
        this.assetTagPersistence.update((BaseModel)tag);
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addTagResources(tag, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addTagResources(tag, serviceContext.getGroupPermissions(), serviceContext.getGuestPermissions());
        }
        int i2 = 0;
        while (i2 < tagProperties.length) {
            String[] tagProperty = StringUtil.split((String)tagProperties[i2], (char)':');
            String key = "";
            if (tagProperty.length > 0) {
                key = GetterUtil.getString((String)tagProperty[0]);
            }
            String value = "";
            if (tagProperty.length > 1) {
                value = GetterUtil.getString((String)tagProperty[1]);
            }
            if (Validator.isNotNull((String)key)) {
                this.assetTagPropertyLocalService.addTagProperty(userId, tagId, key, value);
            }
            ++i2;
        }
        return tag;
    }

    public void addTagResources(AssetTag tag, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(tag.getCompanyId(), tag.getGroupId(), tag.getUserId(), AssetTag.class.getName(), tag.getTagId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addTagResources(AssetTag tag, String[] groupPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(tag.getCompanyId(), tag.getGroupId(), tag.getUserId(), AssetTag.class.getName(), tag.getTagId(), groupPermissions, guestPermissions);
    }

    public List<AssetTag> checkTags(long userId, Group group, String[] names) throws PortalException, SystemException {
        ArrayList<AssetTag> tags = new ArrayList<AssetTag>();
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            AssetTag tag = null;
            try {
                tag = this.getTag(group.getGroupId(), name);
            }
            catch (NoSuchTagException noSuchTagException) {
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setAddGroupPermissions(true);
                serviceContext.setAddGuestPermissions(true);
                serviceContext.setScopeGroupId(group.getGroupId());
                tag = this.addTag(userId, name, PropsValues.ASSET_TAG_PROPERTIES_DEFAULT, serviceContext);
                Group companyGroup = this.groupLocalService.getCompanyGroup(group.getCompanyId());
                try {
                    AssetTag companyGroupTag = this.getTag(companyGroup.getGroupId(), name);
                    List tagProperties = this.assetTagPropertyLocalService.getTagProperties(companyGroupTag.getTagId());
                    for (AssetTagProperty tagProperty : tagProperties) {
                        this.assetTagPropertyLocalService.addTagProperty(userId, tag.getTagId(), tagProperty.getKey(), tagProperty.getValue());
                    }
                }
                catch (NoSuchTagException noSuchTagException2) {}
            }
            if (tag != null) {
                tags.add(tag);
            }
            ++n2;
        }
        return tags;
    }

    public void checkTags(long userId, long groupId, String[] names) throws PortalException, SystemException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        this.checkTags(userId, group, names);
    }

    public AssetTag decrementAssetCount(long tagId, long classNameId) throws PortalException, SystemException {
        AssetTag tag = this.assetTagPersistence.findByPrimaryKey(tagId);
        tag.setAssetCount(Math.max(0, tag.getAssetCount() - 1));
        this.assetTagPersistence.update((BaseModel)tag);
        this.assetTagStatsLocalService.updateTagStats(tagId, classNameId);
        return tag;
    }

    public void deleteGroupTags(long groupId) throws PortalException, SystemException {
        List<AssetTag> tags = this.getGroupTags(groupId);
        for (AssetTag tag : tags) {
            this.deleteTag(tag);
        }
    }

    public void deleteTag(AssetTag tag) throws PortalException, SystemException {
        List entries = this.assetTagPersistence.getAssetEntries(tag.getTagId());
        this.assetTagPersistence.remove((BaseModel)tag);
        this.resourceLocalService.deleteResource(tag.getCompanyId(), AssetTag.class.getName(), 4, tag.getTagId());
        this.assetTagPropertyLocalService.deleteTagProperties(tag.getTagId());
        this.assetEntryLocalService.reindex(entries);
    }

    public void deleteTag(long tagId) throws PortalException, SystemException {
        AssetTag tag = this.assetTagPersistence.findByPrimaryKey(tagId);
        this.deleteTag(tag);
    }

    public List<AssetTag> getEntryTags(long entryId) throws SystemException {
        return this.assetEntryPersistence.getAssetTags(entryId);
    }

    public List<AssetTag> getGroupsTags(long[] groupIds) throws SystemException {
        ArrayList<AssetTag> groupsTags = new ArrayList<AssetTag>();
        long[] lArray = groupIds;
        int n = groupIds.length;
        int n2 = 0;
        while (n2 < n) {
            long groupId = lArray[n2];
            List<AssetTag> groupTags = this.getGroupTags(groupId);
            groupsTags.addAll(groupTags);
            ++n2;
        }
        return groupsTags;
    }

    public List<AssetTag> getGroupTags(long groupId) throws SystemException {
        return this.assetTagPersistence.findByGroupId(groupId);
    }

    public List<AssetTag> getGroupTags(long groupId, int start, int end) throws SystemException {
        return this.assetTagPersistence.findByGroupId(groupId, start, end);
    }

    public int getGroupTagsCount(long groupId) throws SystemException {
        return this.assetTagPersistence.countByGroupId(groupId);
    }

    public List<AssetTag> getSocialActivityCounterOffsetTags(long groupId, String socialActivityCounterName, int startOffset, int endOffset) throws SystemException {
        int startPeriod = SocialCounterPeriodUtil.getStartPeriod((int)startOffset);
        int endPeriod = SocialCounterPeriodUtil.getEndPeriod((int)endOffset);
        return this.getSocialActivityCounterPeriodTags(groupId, socialActivityCounterName, startPeriod, endPeriod);
    }

    public List<AssetTag> getSocialActivityCounterPeriodTags(long groupId, String socialActivityCounterName, int startPeriod, int endPeriod) throws SystemException {
        int offset = SocialCounterPeriodUtil.getOffset((int)endPeriod);
        int periodLength = SocialCounterPeriodUtil.getPeriodLength((int)offset);
        return this.assetTagFinder.findByG_N_S_E(groupId, socialActivityCounterName, startPeriod, endPeriod, periodLength);
    }

    public AssetTag getTag(long tagId) throws PortalException, SystemException {
        return this.assetTagPersistence.findByPrimaryKey(tagId);
    }

    public AssetTag getTag(long groupId, String name) throws PortalException, SystemException {
        return this.assetTagFinder.findByG_N(groupId, name);
    }

    public long[] getTagIds(long groupId, String[] names) throws PortalException, SystemException {
        ArrayList<Long> tagIds = new ArrayList<Long>(names.length);
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            try {
                AssetTag tag = this.getTag(groupId, name);
                tagIds.add(tag.getTagId());
            }
            catch (NoSuchTagException noSuchTagException) {}
            ++n2;
        }
        return ArrayUtil.toArray((Long[])tagIds.toArray(new Long[tagIds.size()]));
    }

    public long[] getTagIds(long[] groupIds, String name) throws PortalException, SystemException {
        ArrayList<Long> tagIds = new ArrayList<Long>(groupIds.length);
        long[] lArray = groupIds;
        int n = groupIds.length;
        int n2 = 0;
        while (n2 < n) {
            long groupId = lArray[n2];
            try {
                AssetTag tag = this.getTag(groupId, name);
                tagIds.add(tag.getTagId());
            }
            catch (NoSuchTagException noSuchTagException) {}
            ++n2;
        }
        return ArrayUtil.toArray((Long[])tagIds.toArray(new Long[tagIds.size()]));
    }

    public long[] getTagIds(long[] groupIds, String[] names) throws PortalException, SystemException {
        long[] tagsIds = new long[]{};
        long[] lArray = groupIds;
        int n = groupIds.length;
        int n2 = 0;
        while (n2 < n) {
            long groupId = lArray[n2];
            tagsIds = ArrayUtil.append((long[][])new long[][]{tagsIds, this.getTagIds(groupId, names)});
            ++n2;
        }
        return tagsIds;
    }

    public String[] getTagNames() throws SystemException {
        return this.getTagNames(this.getTags());
    }

    public String[] getTagNames(long classNameId, long classPK) throws SystemException {
        return this.getTagNames(this.getTags(classNameId, classPK));
    }

    public String[] getTagNames(String className, long classPK) throws SystemException {
        return this.getTagNames(this.getTags(className, classPK));
    }

    public List<AssetTag> getTags() throws SystemException {
        return this.assetTagPersistence.findAll();
    }

    public List<AssetTag> getTags(long classNameId, long classPK) throws SystemException {
        AssetEntry entry = this.assetEntryPersistence.fetchByC_C(classNameId, classPK);
        if (entry == null) {
            return Collections.emptyList();
        }
        return this.assetEntryPersistence.getAssetTags(entry.getEntryId());
    }

    public List<AssetTag> getTags(long groupId, long classNameId, String name) throws SystemException {
        return this.assetTagFinder.findByG_C_N(groupId, classNameId, name, -1, -1, null);
    }

    public List<AssetTag> getTags(long groupId, long classNameId, String name, int start, int end) throws SystemException {
        return this.assetTagFinder.findByG_C_N(groupId, classNameId, name, start, end, null);
    }

    @ThreadLocalCachable
    public List<AssetTag> getTags(String className, long classPK) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.getTags(classNameId, classPK);
    }

    public int getTagsSize(long groupId, long classNameId, String name) throws SystemException {
        return this.assetTagFinder.countByG_C_N(groupId, classNameId, name);
    }

    public boolean hasTag(long groupId, String name) throws PortalException, SystemException {
        try {
            this.getTag(groupId, name);
            return true;
        }
        catch (NoSuchTagException noSuchTagException) {
            return false;
        }
    }

    public AssetTag incrementAssetCount(long tagId, long classNameId) throws PortalException, SystemException {
        AssetTag tag = this.assetTagPersistence.findByPrimaryKey(tagId);
        tag.setAssetCount(tag.getAssetCount() + 1);
        this.assetTagPersistence.update((BaseModel)tag);
        this.assetTagStatsLocalService.updateTagStats(tagId, classNameId);
        return tag;
    }

    public void mergeTags(long fromTagId, long toTagId, boolean overrideProperties) throws PortalException, SystemException {
        List entries = this.assetTagPersistence.getAssetEntries(fromTagId);
        this.assetTagPersistence.addAssetEntries(toTagId, entries);
        List tagProperties = this.assetTagPropertyPersistence.findByTagId(fromTagId);
        for (AssetTagProperty fromTagProperty : tagProperties) {
            AssetTagProperty toTagProperty = this.assetTagPropertyPersistence.fetchByT_K(toTagId, fromTagProperty.getKey());
            if (overrideProperties && toTagProperty != null) {
                toTagProperty.setValue(fromTagProperty.getValue());
                this.assetTagPropertyPersistence.update((BaseModel)toTagProperty);
                continue;
            }
            if (toTagProperty != null) continue;
            fromTagProperty.setTagId(toTagId);
            this.assetTagPropertyPersistence.update((BaseModel)fromTagProperty);
        }
        this.deleteTag(fromTagId);
    }

    public List<AssetTag> search(long groupId, String name, String[] tagProperties, int start, int end) throws SystemException {
        return this.search(new long[]{groupId}, name, tagProperties, start, end);
    }

    public List<AssetTag> search(long[] groupIds, String name, String[] tagProperties, int start, int end) throws SystemException {
        return this.assetTagFinder.findByG_N_P(groupIds, name, tagProperties, start, end, null);
    }

    public AssetTag updateTag(long userId, long tagId, String name, String[] tagProperties, ServiceContext serviceContext) throws PortalException, SystemException {
        AssetTag tag = this.assetTagPersistence.findByPrimaryKey(tagId);
        String oldName = tag.getName();
        tag.setModifiedDate(new Date());
        name = name.trim();
        name = StringUtil.toLowerCase((String)name);
        if (tagProperties == null) {
            tagProperties = new String[]{};
        }
        if (!name.equals(tag.getName()) && this.hasTag(tag.getGroupId(), name)) {
            throw new DuplicateTagException("A tag with the name " + name + " already exists");
        }
        if (!tag.getName().equals(name)) {
            try {
                AssetTag existingAssetTag = this.getTag(tag.getGroupId(), name);
                if (existingAssetTag.getTagId() != tagId) {
                    throw new DuplicateTagException("A tag with the name " + name + " already exists");
                }
            }
            catch (NoSuchTagException noSuchTagException) {}
        }
        this.validate(name);
        tag.setName(name);
        this.assetTagPersistence.update((BaseModel)tag);
        List oldTagProperties = this.assetTagPropertyPersistence.findByTagId(tagId);
        for (AssetTagProperty tagProperty : oldTagProperties) {
            this.assetTagPropertyLocalService.deleteTagProperty(tagProperty);
        }
        int i2 = 0;
        while (i2 < tagProperties.length) {
            String[] tagProperty = StringUtil.split((String)tagProperties[i2], (char)':');
            String key = "";
            if (tagProperty.length > 0) {
                key = GetterUtil.getString((String)tagProperty[0]);
            }
            String value = "";
            if (tagProperty.length > 1) {
                value = GetterUtil.getString((String)tagProperty[1]);
            }
            if (Validator.isNotNull((String)key)) {
                this.assetTagPropertyLocalService.addTagProperty(userId, tagId, key, value);
            }
            ++i2;
        }
        if (!oldName.equals(name)) {
            List entries = this.assetTagPersistence.getAssetEntries(tag.getTagId());
            this.assetEntryLocalService.reindex(entries);
        }
        return tag;
    }

    protected String[] getTagNames(List<AssetTag> tags) {
        return StringUtil.split((String)ListUtil.toString(tags, (Accessor)AssetTag.NAME_ACCESSOR));
    }

    protected void validate(String name) throws PortalException {
        if (!AssetUtil.isValidWord(name)) {
            throw new AssetTagException(StringUtil.merge((char[])AssetUtil.INVALID_CHARACTERS, (String)" "), 2);
        }
    }
}

