/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.announcements.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.announcements.EntryContentException;
import com.liferay.portlet.announcements.EntryDisplayDateException;
import com.liferay.portlet.announcements.EntryExpirationDateException;
import com.liferay.portlet.announcements.EntryTitleException;
import com.liferay.portlet.announcements.EntryURLException;
import com.liferay.portlet.announcements.NoSuchEntryException;
import com.liferay.portlet.announcements.action.ActionUtil;
import com.liferay.portlet.announcements.service.AnnouncementsEntryServiceUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditEntryAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateEntry(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteEntry(actionRequest);
            }
            String redirect = PortalUtil.escapeRedirect((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect"));
            if (Validator.isNotNull((String)redirect)) {
                actionResponse.sendRedirect(redirect);
            }
        }
        catch (Exception e2) {
            if (e2 instanceof EntryContentException || e2 instanceof EntryDisplayDateException || e2 instanceof EntryExpirationDateException || e2 instanceof EntryTitleException || e2 instanceof EntryURLException || e2 instanceof NoSuchEntryException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
            }
            throw e2;
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getEntry((PortletRequest)renderRequest);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchEntryException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e2.getClass());
                return actionMapping.findForward("portlet.announcements.error");
            }
            throw e2;
        }
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.announcements.edit_entry"));
    }

    protected void deleteEntry(ActionRequest actionRequest) throws Exception {
        long entryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"entryId");
        AnnouncementsEntryServiceUtil.deleteEntry((long)entryId);
    }

    protected void updateEntry(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long entryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"entryId");
        String[] distributionScopeParts = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"distributionScope"));
        long classNameId = 0L;
        long classPK = 0L;
        if (distributionScopeParts.length == 2 && (classNameId = GetterUtil.getLong((String)distributionScopeParts[0])) > 0L) {
            classPK = GetterUtil.getLong((String)distributionScopeParts[1]);
        }
        String title = ParamUtil.getString((PortletRequest)actionRequest, (String)"title");
        String content = ParamUtil.getString((PortletRequest)actionRequest, (String)"content");
        String url = ParamUtil.getString((PortletRequest)actionRequest, (String)"url");
        String type = ParamUtil.getString((PortletRequest)actionRequest, (String)"type");
        int displayDateMonth = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"displayDateMonth");
        int displayDateDay = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"displayDateDay");
        int displayDateYear = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"displayDateYear");
        int displayDateHour = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"displayDateHour");
        int displayDateMinute = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"displayDateMinute");
        int displayDateAmPm = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"displayDateAmPm");
        if (displayDateAmPm == 1) {
            displayDateHour += 12;
        }
        boolean displayImmediately = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"displayImmediately");
        int expirationDateMonth = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"expirationDateMonth");
        int expirationDateDay = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"expirationDateDay");
        int expirationDateYear = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"expirationDateYear");
        int expirationDateHour = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"expirationDateHour");
        int expirationDateMinute = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"expirationDateMinute");
        int expirationDateAmPm = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"expirationDateAmPm");
        if (expirationDateAmPm == 1) {
            expirationDateHour += 12;
        }
        int priority = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"priority");
        boolean alert = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"alert");
        if (entryId <= 0L) {
            AnnouncementsEntryServiceUtil.addEntry((long)themeDisplay.getPlid(), (long)classNameId, (long)classPK, (String)title, (String)content, (String)url, (String)type, (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (boolean)displayImmediately, (int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (int)priority, (boolean)alert);
        } else {
            AnnouncementsEntryServiceUtil.updateEntry((long)entryId, (String)title, (String)content, (String)url, (String)type, (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (int)expirationDateMonth, (int)expirationDateDay, (int)expirationDateYear, (int)expirationDateHour, (int)expirationDateMinute, (int)priority);
        }
    }
}

