/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portlet.NullSafeResourceBundle;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import org.apache.struts.util.RequestUtils;

public class PortletResourceBundles {
    private static Log _log = LogFactoryUtil.getLog(PortletResourceBundles.class);
    private static PortletResourceBundles _instance = new PortletResourceBundles();
    private Map<String, Map<String, ResourceBundle>> _resourceBundles = new ConcurrentHashMap<String, Map<String, ResourceBundle>>(new LinkedHashMap());

    public static String getString(Locale locale, String key) {
        return _instance._getString(locale, key);
    }

    public static String getString(PageContext pageContext, String key) {
        return _instance._getString(pageContext, key);
    }

    public static String getString(String languageId, String key) {
        return _instance._getString(languageId, key);
    }

    public static String getString(String servletContextName, String languageId, String key) {
        return _instance._getString(servletContextName, languageId, key);
    }

    public static void put(String servletContextName, String languageId, ResourceBundle resourceBundle) {
        _instance._put(servletContextName, languageId, resourceBundle);
    }

    public static void remove(String servletContextName) {
        _instance._remove(servletContextName);
    }

    private PortletResourceBundles() {
    }

    private ResourceBundle _getResourceBundle(Map<String, ResourceBundle> resourceBundles, String languageId) {
        ResourceBundle resourceBundle = resourceBundles.get(languageId);
        if (resourceBundle == null) {
            try {
                resourceBundle = new NullSafeResourceBundle(new PropertyResourceBundle((InputStream)new UnsyncByteArrayInputStream(new byte[0])));
                resourceBundles.put(languageId, resourceBundle);
            }
            catch (IOException ioe) {
                _log.error((Throwable)ioe);
            }
        }
        return resourceBundle;
    }

    private ResourceBundle _getResourceBundle(String servletContextName, String languageId) {
        Map<String, ResourceBundle> resourceBundles = this._getResourceBundles(servletContextName);
        return this._getResourceBundle(resourceBundles, languageId);
    }

    private Map<String, ResourceBundle> _getResourceBundles(String servletContextName) {
        Map<String, ResourceBundle> resourceBundles = this._resourceBundles.get(servletContextName);
        if (resourceBundles == null) {
            resourceBundles = new HashMap<String, ResourceBundle>();
            this._resourceBundles.put(servletContextName, resourceBundles);
        }
        return resourceBundles;
    }

    private String _getString(Locale locale, String key) {
        return this._getString(LocaleUtil.toLanguageId((Locale)locale), key);
    }

    private String _getString(PageContext pageContext, String key) {
        Locale locale = RequestUtils.getUserLocale((HttpServletRequest)((HttpServletRequest)pageContext.getRequest()), null);
        return this._getString(locale, key);
    }

    private String _getString(String languageId, String key) {
        return this._getString(null, languageId, key);
    }

    private String _getString(String servletContextName, String languageId, String key) {
        if (servletContextName != null) {
            ResourceBundle resourceBundle = this._getResourceBundle(servletContextName, languageId);
            return resourceBundle.getString(key);
        }
        Iterator<Map.Entry<String, Map<String, ResourceBundle>>> iterator = this._resourceBundles.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<String, Map<String, ResourceBundle>> entry = iterator.next();
            Map<String, ResourceBundle> resourceBundles = entry.getValue();
            ResourceBundle resourceBundle = this._getResourceBundle(resourceBundles, languageId);
            return ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)key);
        }
        return null;
    }

    private void _put(String servletContextName, String languageId, ResourceBundle resourceBundle) {
        Map<String, ResourceBundle> resourceBundles = this._getResourceBundles(servletContextName);
        resourceBundle = new NullSafeResourceBundle(resourceBundle);
        resourceBundles.put(languageId, resourceBundle);
    }

    private void _remove(String servletContextName) {
        this._resourceBundles.remove(servletContextName);
    }
}

