/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.xmlrpc;

import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.xmlrpc.Fault;
import com.liferay.portal.kernel.xmlrpc.Response;
import com.liferay.portal.kernel.xmlrpc.Success;
import com.liferay.portal.kernel.xmlrpc.XmlRpcException;
import com.liferay.portal.kernel.xmlrpc.XmlRpcUtil;
import com.liferay.portal.xml.StAXReaderUtil;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

public class XmlRpcParser {
    public static String buildMethod(String methodName, Object[] arguments) throws XmlRpcException {
        StringBundler sb = new StringBundler(arguments.length * 3 + 8);
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<methodCall>");
        sb.append("<methodName>");
        sb.append(methodName);
        sb.append("</methodName>");
        sb.append("<params>");
        Object[] objectArray = arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            Object argument = objectArray[n2];
            sb.append("<param>");
            sb.append(XmlRpcParser.wrapValue(argument));
            sb.append("</param>");
            ++n2;
        }
        sb.append("</params>");
        sb.append("</methodCall>");
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Tuple parseMethod(String xml) throws IOException {
        Tuple tuple;
        XMLStreamReader xmlStreamReader = null;
        try {
            XMLInputFactory xmlInputFactory = StAXReaderUtil.getXMLInputFactory();
            xmlStreamReader = xmlInputFactory.createXMLStreamReader((Reader)new UnsyncStringReader(xml));
            xmlStreamReader.nextTag();
            xmlStreamReader.nextTag();
            xmlStreamReader.next();
            String methodName = xmlStreamReader.getText();
            ArrayList<Object> arguments = new ArrayList<Object>();
            xmlStreamReader.nextTag();
            String name = xmlStreamReader.getLocalName();
            while (true) {
                String text;
                if (name.equals("methodCall")) {
                    tuple = new Tuple(new Object[]{methodName, arguments.toArray()});
                    if (xmlStreamReader == null) return tuple;
                    break;
                }
                xmlStreamReader.nextTag();
                name = xmlStreamReader.getLocalName();
                if (!name.equals("param")) continue;
                xmlStreamReader.nextTag();
                name = xmlStreamReader.getLocalName();
                int event = xmlStreamReader.next();
                if (event == 1) {
                    name = xmlStreamReader.getLocalName();
                    xmlStreamReader.next();
                    text = xmlStreamReader.getText();
                    if (name.equals("string")) {
                        arguments.add(text);
                    } else if (name.equals("int") || name.equals("i4")) {
                        arguments.add(GetterUtil.getInteger((String)text));
                    } else if (name.equals("double")) {
                        arguments.add(GetterUtil.getDouble((String)text));
                    } else {
                        if (!name.equals("boolean")) throw new IOException("XML-RPC not implemented for " + name);
                        arguments.add(GetterUtil.getBoolean((String)text));
                    }
                    xmlStreamReader.nextTag();
                    xmlStreamReader.nextTag();
                    xmlStreamReader.nextTag();
                } else {
                    text = xmlStreamReader.getText();
                    arguments.add(text);
                    xmlStreamReader.nextTag();
                    xmlStreamReader.nextTag();
                }
                name = xmlStreamReader.getLocalName();
            }
        }
        catch (Exception e2) {
            try {
                throw new IOException(e2.getMessage());
            }
            catch (Throwable throwable) {
                if (xmlStreamReader == null) throw throwable;
                try {
                    xmlStreamReader.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
        }
        try {
            xmlStreamReader.close();
            return tuple;
        }
        catch (Exception exception) {}
        return tuple;
    }

    /*
     * Loose catch block
     */
    public static Response parseResponse(String xml) throws XmlRpcException {
        XMLStreamReader xmlStreamReader;
        block26: {
            Fault fault;
            block27: {
                String name;
                block24: {
                    Success success;
                    block25: {
                        xmlStreamReader = null;
                        XMLInputFactory xmlInputFactory = StAXReaderUtil.getXMLInputFactory();
                        xmlStreamReader = xmlInputFactory.createXMLStreamReader((Reader)new UnsyncStringReader(xml));
                        xmlStreamReader.nextTag();
                        xmlStreamReader.nextTag();
                        name = xmlStreamReader.getLocalName();
                        if (!name.equals("params")) break block24;
                        String description = null;
                        xmlStreamReader.nextTag();
                        xmlStreamReader.nextTag();
                        int event = xmlStreamReader.next();
                        if (event == 1) {
                            xmlStreamReader.next();
                            description = xmlStreamReader.getText();
                        } else {
                            description = xmlStreamReader.getText();
                        }
                        success = XmlRpcUtil.createSuccess((String)description);
                        if (xmlStreamReader == null) break block25;
                        try {
                            xmlStreamReader.close();
                        }
                        catch (Exception exception) {}
                    }
                    return success;
                }
                if (!name.equals("fault")) break block26;
                int code = 0;
                String description = null;
                xmlStreamReader.nextTag();
                xmlStreamReader.nextTag();
                int i2 = 0;
                while (i2 < 2) {
                    xmlStreamReader.nextTag();
                    xmlStreamReader.nextTag();
                    xmlStreamReader.next();
                    String valueName = xmlStreamReader.getText();
                    if (valueName.equals("faultCode")) {
                        xmlStreamReader.nextTag();
                        xmlStreamReader.nextTag();
                        xmlStreamReader.nextTag();
                        name = xmlStreamReader.getLocalName();
                        if (name.equals("int") || name.equals("i4")) {
                            xmlStreamReader.next();
                            code = GetterUtil.getInteger((String)xmlStreamReader.getText());
                        }
                        xmlStreamReader.nextTag();
                        xmlStreamReader.nextTag();
                        xmlStreamReader.nextTag();
                    } else if (valueName.equals("faultString")) {
                        xmlStreamReader.nextTag();
                        xmlStreamReader.nextTag();
                        int event = xmlStreamReader.next();
                        if (event == 1) {
                            xmlStreamReader.next();
                            description = xmlStreamReader.getText();
                            xmlStreamReader.nextTag();
                        } else {
                            description = xmlStreamReader.getText();
                        }
                        xmlStreamReader.nextTag();
                        xmlStreamReader.nextTag();
                    }
                    ++i2;
                }
                fault = XmlRpcUtil.createFault((int)code, description);
                if (xmlStreamReader == null) break block27;
                try {
                    xmlStreamReader.close();
                }
                catch (Exception exception) {}
            }
            return fault;
        }
        if (xmlStreamReader != null) {
            try {
                xmlStreamReader.close();
            }
            catch (Exception exception) {}
        }
        return null;
        catch (Exception e2) {
            try {
                throw new XmlRpcException(xml, (Throwable)e2);
            }
            catch (Throwable throwable) {
                if (xmlStreamReader != null) {
                    try {
                        xmlStreamReader.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
        }
    }

    public static String wrapValue(Object value) throws XmlRpcException {
        if (value == null) {
            return "";
        }
        StringBundler sb = new StringBundler(5);
        sb.append("<value>");
        if (value instanceof String) {
            sb.append("<string>");
            sb.append(value.toString());
            sb.append("</string>");
        } else if (value instanceof Integer || value instanceof Short) {
            sb.append("<i4>");
            sb.append(value.toString());
            sb.append("</i4>");
        } else if (value instanceof Double || value instanceof Float) {
            sb.append("<double>");
            sb.append(value.toString());
            sb.append("</double>");
        } else if (value instanceof Boolean) {
            sb.append("<boolean>");
            if (((Boolean)value).booleanValue()) {
                sb.append('1');
            } else {
                sb.append('0');
            }
            sb.append("</boolean>");
        } else {
            throw new XmlRpcException("Unsupported type " + value.getClass());
        }
        sb.append("</value>");
        return sb.toString();
    }
}

