/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.words;

import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.SecureRandomUtil;
import com.liferay.portal.kernel.util.UnmodifiableList;
import com.liferay.util.ContentUtil;
import com.liferay.util.jazzy.BasicSpellCheckListener;
import com.liferay.util.jazzy.InvalidWord;
import com.swabunga.spell.engine.SpellDictionary;
import com.swabunga.spell.engine.SpellDictionaryHashMap;
import com.swabunga.spell.event.DefaultWordFinder;
import com.swabunga.spell.event.SpellCheckListener;
import com.swabunga.spell.event.SpellChecker;
import com.swabunga.spell.event.StringWordTokenizer;
import com.swabunga.spell.event.WordFinder;
import com.swabunga.spell.event.WordTokenizer;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class WordsUtil {
    private static Log _log = LogFactoryUtil.getLog(WordsUtil.class);
    private static WordsUtil _instance = new WordsUtil();
    private List<String> _dictionaryList = new UnmodifiableList(this._dictionaryList);
    private Set<String> _dictionarySet = new HashSet<String>(this._dictionaryList.size());
    private SpellDictionaryHashMap _spellDictionaryHashMap;

    public static List<InvalidWord> checkSpelling(String text) {
        return _instance._checkSpelling(text);
    }

    public static List<String> getDictionaryList() {
        return _instance._getDictionaryList();
    }

    public static Set<String> getDictionarySet() {
        return _instance._getDictionarySet();
    }

    public static String getRandomWord() {
        return _instance._getRandomWord();
    }

    public static boolean isDictionaryWord(String word) {
        return _instance._isDictionaryWord(word);
    }

    private WordsUtil() {
        this._dictionarySet.addAll(this._dictionaryList);
        this._dictionarySet = Collections.unmodifiableSet(this._dictionarySet);
        try {
            this._spellDictionaryHashMap = new SpellDictionaryHashMap();
            String[] dics = new String[]{"center.dic", "centre.dic", "color.dic", "colour.dic", "eng_com.dic", "english.0", "english.1", "ise.dic", "ize.dic", "labeled.dic", "labelled.dic", "yse.dic", "yze.dic"};
            int i2 = 0;
            while (i2 < dics.length) {
                this._spellDictionaryHashMap.addDictionary((Reader)new UnsyncStringReader(ContentUtil.get((String)("com/liferay/portal/words/dependencies/" + dics[i2]))));
                ++i2;
            }
        }
        catch (IOException ioe) {
            _log.error((Throwable)ioe);
        }
    }

    private List<InvalidWord> _checkSpelling(String text) {
        SpellChecker spellChecker = new SpellChecker((SpellDictionary)this._spellDictionaryHashMap);
        BasicSpellCheckListener basicSpellCheckListener = new BasicSpellCheckListener(text);
        spellChecker.addSpellCheckListener((SpellCheckListener)basicSpellCheckListener);
        spellChecker.checkSpelling((WordTokenizer)new StringWordTokenizer((WordFinder)new DefaultWordFinder(text)));
        return basicSpellCheckListener.getInvalidWords();
    }

    private List<String> _getDictionaryList() {
        return this._dictionaryList;
    }

    private Set<String> _getDictionarySet() {
        return this._dictionarySet;
    }

    private String _getRandomWord() {
        Random random = new Random(SecureRandomUtil.nextInt());
        int pos = random.nextInt(this._dictionaryList.size());
        return this._dictionaryList.get(pos);
    }

    private boolean _isDictionaryWord(String word) {
        return this._dictionarySet.contains(word);
    }
}

