/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.verify.VerifyProcess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class VerifySQLServer
extends VerifyProcess {
    private static final String _FILTER_EXCLUDED_TABLES = "(sysobjects.name not like 'Counter') and (sysobjects.name not like 'Cyrus%') and (sysobjects.name not like 'QUARTZ%')";
    private static final String _FILTER_NONUNICODE_DATA_TYPES = "((systypes.name = 'varchar') OR (systypes.name = 'text'))";
    private static Log _log = LogFactoryUtil.getLog(VerifySQLServer.class);
    private List<String> _addPrimaryKeySQLs = new ArrayList<String>();

    protected void convertColumnsToUnicode() {
        block8: {
            this.dropNonunicodeTableIndexes();
            Connection con = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    con = DataAccess.getUpgradeOptimizedConnection();
                    StringBundler sb = new StringBundler(12);
                    sb.append("select sysobjects.name as table_name, syscolumns.name ");
                    sb.append("AS column_name, systypes.name as data_type, ");
                    sb.append("syscolumns.length, syscolumns.isnullable as ");
                    sb.append("is_nullable FROM sysobjects inner join syscolumns on ");
                    sb.append("sysobjects.id = syscolumns.id inner join systypes on ");
                    sb.append("syscolumns.xtype = systypes.xtype where ");
                    sb.append("(sysobjects.xtype = 'U') and (sysobjects.category != ");
                    sb.append("2) and ");
                    sb.append(_FILTER_NONUNICODE_DATA_TYPES);
                    sb.append(" and ");
                    sb.append(_FILTER_EXCLUDED_TABLES);
                    sb.append(" order by sysobjects.name, syscolumns.colid");
                    String sql = sb.toString();
                    ps = con.prepareStatement(sql);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        String tableName = rs.getString("table_name");
                        if (!this.isPortalTableName(tableName)) continue;
                        String columnName = rs.getString("column_name");
                        String dataType = rs.getString("data_type");
                        int length = rs.getInt("length");
                        boolean nullable = rs.getBoolean("is_nullable");
                        if (dataType.equals("varchar")) {
                            this.convertVarcharColumn(tableName, columnName, length, nullable);
                            continue;
                        }
                        if (!dataType.equals("ntext") && !dataType.equals("text")) continue;
                        this.convertTextColumn(tableName, columnName, nullable);
                    }
                    for (String addPrimaryKeySQL : this._addPrimaryKeySQLs) {
                        this.runSQL(addPrimaryKeySQL);
                    }
                }
                catch (Exception e2) {
                    _log.error((Object)e2, (Throwable)e2);
                    DataAccess.cleanUp((Connection)con, ps, rs);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        }
    }

    protected void convertTextColumn(String tableName, String columnName, boolean nullable) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Updating " + tableName + "." + columnName + " to use " + "nvarchar(max)"));
        }
        StringBundler sb = new StringBundler(4);
        sb.append("alter table ");
        sb.append(tableName);
        sb.append(" add temp nvarchar(max)");
        if (!nullable) {
            sb.append(" not null");
        }
        this.runSQL(sb.toString());
        this.runSQL("update " + tableName + " set temp = " + columnName);
        this.runSQL("alter table " + tableName + " drop column " + columnName);
        this.runSQL("exec sp_rename '" + tableName + ".temp', '" + columnName + "', 'column'");
    }

    protected void convertVarcharColumn(String tableName, String columnName, int length, boolean nullable) throws Exception {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Updating " + tableName + "." + columnName + " to use nvarchar"));
        }
        StringBundler sb = new StringBundler(8);
        sb.append("alter table ");
        sb.append(tableName);
        sb.append(" alter column ");
        sb.append(columnName);
        sb.append(" nvarchar(");
        if (length == -1) {
            sb.append("max");
        } else {
            sb.append(length);
        }
        sb.append(")");
        if (!nullable) {
            sb.append(" not null");
        }
        this.runSQL(sb.toString());
    }

    @Override
    protected void doVerify() throws Exception {
        DB db = DBFactoryUtil.getDB();
        String dbType = db.getType();
        if (!dbType.equals("sqlserver")) {
            return;
        }
        this.convertColumnsToUnicode();
    }

    protected void dropNonunicodeTableIndexes() {
        block8: {
            Connection con = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    con = DataAccess.getUpgradeOptimizedConnection();
                    StringBundler sb = new StringBundler(15);
                    sb.append("select distinct sysobjects.name as table_name, ");
                    sb.append("sysindexes.name as index_name FROM sysobjects inner ");
                    sb.append("join sysindexes on sysobjects.id = sysindexes.id ");
                    sb.append("inner join syscolumns on sysobjects.id = ");
                    sb.append("syscolumns.id inner join sysindexkeys on ");
                    sb.append("((sysobjects.id = sysindexkeys.id) and ");
                    sb.append("(syscolumns.colid = sysindexkeys.colid) and ");
                    sb.append("(sysindexes.indid = sysindexkeys.indid)) inner join ");
                    sb.append("systypes on syscolumns.xtype = systypes.xtype where ");
                    sb.append("(sysobjects.type = 'U') and (sysobjects.category != ");
                    sb.append("2) and ");
                    sb.append(_FILTER_NONUNICODE_DATA_TYPES);
                    sb.append(" and ");
                    sb.append(_FILTER_EXCLUDED_TABLES);
                    sb.append(" order by sysobjects.name, sysindexes.name");
                    String sql = sb.toString();
                    ps = con.prepareStatement(sql);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        String indexNameUpperCase;
                        String tableName = rs.getString("table_name");
                        if (!this.isPortalTableName(tableName)) continue;
                        String indexName = rs.getString("index_name");
                        if (_log.isInfoEnabled()) {
                            _log.info((Object)("Dropping index " + tableName + "." + indexName));
                        }
                        if ((indexNameUpperCase = StringUtil.toUpperCase((String)indexName)).startsWith("PK")) {
                            String primaryKeyColumnNames = StringUtil.merge(this.getPrimaryKeyColumnNames(indexName));
                            this.runSQL("alter table " + tableName + " drop constraint " + indexName);
                            this._addPrimaryKeySQLs.add("alter table " + tableName + " add primary key (" + primaryKeyColumnNames + ")");
                            continue;
                        }
                        this.runSQL("drop index " + indexName + " on " + tableName);
                    }
                }
                catch (Exception e2) {
                    _log.error((Object)e2, (Throwable)e2);
                    DataAccess.cleanUp((Connection)con, ps, rs);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        }
    }

    protected List<String> getPrimaryKeyColumnNames(String indexName) {
        ArrayList<String> columnNames;
        block6: {
            columnNames = new ArrayList<String>();
            Connection con = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    con = DataAccess.getUpgradeOptimizedConnection();
                    StringBundler sb = new StringBundler(10);
                    sb.append("select distinct syscolumns.name as column_name from ");
                    sb.append("sysobjects inner join syscolumns on sysobjects.id = ");
                    sb.append("syscolumns.id inner join sysindexes on ");
                    sb.append("sysobjects.id = sysindexes.id inner join sysindexkeys ");
                    sb.append("on ((sysobjects.id = sysindexkeys.id) and ");
                    sb.append("(syscolumns.colid = sysindexkeys.colid) and ");
                    sb.append("(sysindexes.indid = sysindexkeys.indid)) where ");
                    sb.append("sysindexes.name = '");
                    sb.append(indexName);
                    sb.append("'");
                    String sql = sb.toString();
                    ps = con.prepareStatement(sql);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        String columnName = rs.getString("column_name");
                        columnNames.add(columnName);
                    }
                }
                catch (Exception e2) {
                    _log.error((Object)e2, (Throwable)e2);
                    DataAccess.cleanUp((Connection)con, ps, rs);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        }
        return columnNames;
    }
}

