/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.security.auth.FullNameGenerator;
import com.liferay.portal.security.auth.FullNameGeneratorFactory;
import com.liferay.portal.verify.VerifyException;
import com.liferay.portal.verify.VerifyProcess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;

public class VerifyAuditedModel
extends VerifyProcess {
    private static final String[][] _MODELS;
    private static Log _log;

    static {
        String[][] stringArrayArray = new String[12][];
        String[] stringArray = new String[6];
        stringArray[0] = "Layout";
        stringArray[1] = "plid";
        stringArray[5] = "false";
        stringArrayArray[0] = stringArray;
        String[] stringArray2 = new String[6];
        stringArray2[0] = "LayoutPrototype";
        stringArray2[1] = "layoutPrototypeId";
        stringArray2[5] = "true";
        stringArrayArray[1] = stringArray2;
        String[] stringArray3 = new String[6];
        stringArray3[0] = "LayoutSetPrototype";
        stringArray3[1] = "layoutSetPrototypeId";
        stringArray3[5] = "false";
        stringArrayArray[2] = stringArray3;
        stringArrayArray[3] = new String[]{"MBDiscussion", "discussionId", "threadId", "MBThread", "threadId", "true"};
        stringArrayArray[4] = new String[]{"MBThread", "threadId", "rootMessageId", "MBMessage", "messageId", "true"};
        stringArrayArray[5] = new String[]{"MBThreadFlag", "threadFlagId", "userId", "User_", "userId", "true"};
        String[] stringArray4 = new String[6];
        stringArray4[0] = "Organization_";
        stringArray4[1] = "organizationId";
        stringArray4[5] = "true";
        stringArrayArray[6] = stringArray4;
        stringArrayArray[7] = new String[]{"PollsChoice", "choiceId", "questionId", "PollsQuestion", "questionId", "true"};
        stringArrayArray[8] = new String[]{"PollsVote", "voteId", "questionId", "PollsQuestion", "questionId", "true"};
        stringArrayArray[9] = new String[]{"RepositoryEntry", "repositoryEntryId", "repositoryId", "Repository", "repositoryId", "true"};
        String[] stringArray5 = new String[6];
        stringArray5[0] = "Role_";
        stringArray5[1] = "roleId";
        stringArray5[5] = "true";
        stringArrayArray[10] = stringArray5;
        String[] stringArray6 = new String[6];
        stringArray6[0] = "UserGroup";
        stringArray6[1] = "userGroupId";
        stringArray6[5] = "true";
        stringArrayArray[11] = stringArray6;
        _MODELS = stringArrayArray;
        _log = LogFactoryUtil.getLog(VerifyAuditedModel.class);
    }

    @Override
    protected void doVerify() throws Exception {
        ArrayList<String> pendingModels = new ArrayList<String>();
        String[][] stringArray = _MODELS;
        int n = _MODELS.length;
        int n2 = 0;
        while (n2 < n) {
            String[] model = stringArray[n2];
            pendingModels.add(model[0]);
            ++n2;
        }
        while (!pendingModels.isEmpty()) {
            int count = pendingModels.size();
            String[][] stringArray2 = _MODELS;
            int n3 = _MODELS.length;
            n = 0;
            while (n < n3) {
                String[] model = stringArray2[n];
                if (!pendingModels.contains(model[3]) && pendingModels.contains(model[0])) {
                    this.verifyModel(model[0], model[1], model[2], model[3], model[4], GetterUtil.getBoolean((String)model[5]));
                    pendingModels.remove(model[0]);
                }
                ++n;
            }
            if (pendingModels.size() != count) continue;
            throw new VerifyException("Circular dependency detected " + pendingModels);
        }
    }

    protected Object[] getDefaultUserArray(Connection con, long companyId) throws Exception {
        ResultSet rs;
        PreparedStatement ps;
        block2: {
            Object[] objectArray;
            ps = null;
            rs = null;
            try {
                ps = con.prepareStatement("select userId, firstName, middleName, lastName from User_ where companyId = ? and defaultUser = ?");
                ps.setLong(1, companyId);
                ps.setBoolean(2, true);
                rs = ps.executeQuery();
                if (!rs.next()) break block2;
                long userId = rs.getLong("userId");
                String firstName = rs.getString("firstName");
                String middleName = rs.getString("middleName");
                String lastName = rs.getString("lastName");
                FullNameGenerator fullNameGenerator = FullNameGeneratorFactory.getInstance();
                String userName = fullNameGenerator.getFullName(firstName, middleName, lastName);
                Timestamp createDate = new Timestamp(System.currentTimeMillis());
                objectArray = new Object[]{companyId, userId, userName, createDate, createDate};
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp(null, (Statement)ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp(null, (Statement)ps, (ResultSet)rs);
            return objectArray;
        }
        DataAccess.cleanUp(null, (Statement)ps, (ResultSet)rs);
        return null;
    }

    protected Object[] getModelArray(String modelName, String pkColumnName, long primKey) throws Exception {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block4: {
            block3: {
                Object[] objectArray;
                con = null;
                ps = null;
                rs = null;
                try {
                    con = DataAccess.getUpgradeOptimizedConnection();
                    ps = con.prepareStatement("select companyId, userId, createDate, modifiedDate from " + modelName + " where " + pkColumnName + " = ?");
                    ps.setLong(1, primKey);
                    rs = ps.executeQuery();
                    if (!rs.next()) break block3;
                    long companyId = rs.getLong("companyId");
                    long userId = rs.getLong("userId");
                    Timestamp createDate = rs.getTimestamp("createDate");
                    Timestamp modifiedDate = rs.getTimestamp("modifiedDate");
                    objectArray = new Object[]{companyId, userId, this.getUserName(userId), createDate, modifiedDate};
                }
                catch (Throwable throwable) {
                    DataAccess.cleanUp((Connection)con, ps, rs);
                    throw throwable;
                }
                DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
                return objectArray;
            }
            if (!_log.isDebugEnabled()) break block4;
            _log.debug((Object)("Unable to find " + modelName + " " + primKey));
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return null;
    }

    protected String getUserName(long userId) throws Exception {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block2: {
            String string;
            con = null;
            ps = null;
            rs = null;
            try {
                con = DataAccess.getUpgradeOptimizedConnection();
                ps = con.prepareStatement("select firstName, middleName, lastName from User_ where userId = ?");
                ps.setLong(1, userId);
                rs = ps.executeQuery();
                if (!rs.next()) break block2;
                String firstName = rs.getString("firstName");
                String middleName = rs.getString("middleName");
                String lastName = rs.getString("lastName");
                FullNameGenerator fullNameGenerator = FullNameGeneratorFactory.getInstance();
                string = fullNameGenerator.getFullName(firstName, middleName, lastName);
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
            return string;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return "";
    }

    protected void verifyModel(String modelName, String pkColumnName, long primKey, Object[] modelArray, boolean updateDates) throws Exception {
        long companyId;
        PreparedStatement ps;
        Connection con;
        block9: {
            con = null;
            ps = null;
            con = DataAccess.getUpgradeOptimizedConnection();
            companyId = (Long)modelArray[0];
            if (modelArray[2] != null || (modelArray = this.getDefaultUserArray(con, companyId)) != null) break block9;
            DataAccess.cleanUp((Connection)con, ps);
            return;
        }
        try {
            try {
                long userId = (Long)modelArray[1];
                String userName = (String)modelArray[2];
                Timestamp createDate = (Timestamp)modelArray[3];
                Timestamp modifiedDate = (Timestamp)modelArray[4];
                StringBundler sb = new StringBundler(7);
                sb.append("update ");
                sb.append(modelName);
                sb.append(" set companyId = ?, userId = ?, userName = ?");
                if (updateDates) {
                    sb.append(", createDate = ?, modifiedDate = ?");
                }
                sb.append(" where ");
                sb.append(pkColumnName);
                sb.append(" = ?");
                ps = con.prepareStatement(sb.toString());
                ps.setLong(1, companyId);
                ps.setLong(2, userId);
                ps.setString(3, userName);
                if (updateDates) {
                    ps.setTimestamp(4, createDate);
                    ps.setTimestamp(5, modifiedDate);
                    ps.setLong(6, primKey);
                } else {
                    ps.setLong(4, primKey);
                }
                ps.executeUpdate();
            }
            catch (Exception e2) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Unable to verify model " + modelName), (Throwable)e2);
                }
                DataAccess.cleanUp((Connection)con, ps);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps);
    }

    protected void verifyModel(String modelName, String pkColumnName, String joinByColumnName, String relatedModelName, String relatedPKColumnName, boolean updateDates) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            StringBundler sb = new StringBundler(8);
            sb.append("select ");
            sb.append(pkColumnName);
            sb.append(", companyId");
            if (joinByColumnName != null) {
                sb.append(", ");
                sb.append(joinByColumnName);
            }
            sb.append(" from ");
            sb.append(modelName);
            sb.append(" where userName is null order by companyId");
            ps = con.prepareStatement(sb.toString());
            rs = ps.executeQuery();
            Object[] modelArray = null;
            long previousCompanyId = 0L;
            while (rs.next()) {
                long companyId = rs.getLong("companyId");
                long primKey = rs.getLong(pkColumnName);
                if (joinByColumnName != null) {
                    long relatedPrimKey = rs.getLong(joinByColumnName);
                    modelArray = this.getModelArray(relatedModelName, relatedPKColumnName, relatedPrimKey);
                } else if (previousCompanyId != companyId) {
                    modelArray = this.getDefaultUserArray(con, companyId);
                    previousCompanyId = companyId;
                }
                if (modelArray == null) continue;
                this.verifyModel(modelName, pkColumnName, primKey, modelArray, updateDates);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }
}

