/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.velocity;

import com.liferay.portal.kernel.io.ReaderInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.TemplateResourceLoaderUtil;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;

public class LiferayResourceLoader
extends ResourceLoader {
    private static Log _log = LogFactoryUtil.getLog(LiferayResourceLoader.class);

    public long getLastModified(Resource resource) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Get last modified for " + resource.getName()));
        }
        return 0L;
    }

    public InputStream getResourceStream(String source) throws ResourceNotFoundException {
        InputStream is = this.doGetResourceStream(source);
        if (is == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to find " + source));
            }
            throw new ResourceNotFoundException(source);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Successfully found " + source));
        }
        return is;
    }

    public void init(ExtendedProperties props) {
        this.setModificationCheckInterval(PropsValues.VELOCITY_ENGINE_RESOURCE_MODIFICATION_CHECK_INTERVAL);
    }

    public boolean isSourceModified(Resource resource) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Check modified status for " + resource.getName()));
        }
        return false;
    }

    public boolean resourceExists(String resourceName) {
        InputStream is = null;
        try {
            is = this.doGetResourceStream(resourceName);
            if (is != null) {
                is.close();
            }
        }
        catch (IOException iOException) {
        }
        catch (ResourceNotFoundException resourceNotFoundException) {}
        return is != null;
    }

    protected InputStream doGetResourceStream(String source) throws ResourceNotFoundException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Get resource for " + source));
        }
        try {
            TemplateResource templateResource = TemplateResourceLoaderUtil.getTemplateResource((String)"vm", (String)source);
            return new ReaderInputStream(templateResource.getReader());
        }
        catch (Exception exception) {
            return null;
        }
    }
}

