/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.cache.CacheRegistryImpl;
import com.liferay.portal.configuration.ConfigurationFactoryImpl;
import com.liferay.portal.dao.db.DBFactoryImpl;
import com.liferay.portal.dao.jdbc.DataSourceFactoryImpl;
import com.liferay.portal.kernel.cache.CacheRegistry;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.configuration.ConfigurationFactory;
import com.liferay.portal.kernel.configuration.ConfigurationFactoryUtil;
import com.liferay.portal.kernel.dao.db.DBFactory;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.dao.jdbc.DataSourceFactory;
import com.liferay.portal.kernel.dao.jdbc.DataSourceFactoryUtil;
import com.liferay.portal.kernel.log.LogFactory;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.log.SanitizerLogWrapper;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.JavaDetector;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.TimeZoneUtil;
import com.liferay.portal.log.Log4jLogFactoryImpl;
import com.liferay.portal.security.lang.DoPrivilegedUtil;
import com.liferay.portal.security.lang.SecurityManagerUtil;
import com.liferay.portal.spring.util.SpringUtil;
import com.liferay.portal.util.ClassLoaderUtil;
import com.liferay.portal.util.PropsImpl;
import com.liferay.portal.util.PropsUtil;
import com.liferay.util.log4j.Log4JUtil;
import com.sun.syndication.io.XmlReader;
import java.util.List;

public class InitUtil {
    private static final boolean _PRINT_TIME = false;
    private static boolean _initialized;
    private static boolean _neverInitialized;

    static {
        _neverInitialized = true;
    }

    public static synchronized void init() {
        if (_initialized) {
            return;
        }
        Object stopWatch = null;
        String userLanguage = SystemProperties.get((String)"user.language");
        String userCountry = SystemProperties.get((String)"user.country");
        String userVariant = SystemProperties.get((String)"user.variant");
        LocaleUtil.setDefault((String)userLanguage, (String)userCountry, (String)userVariant);
        String userTimeZone = SystemProperties.get((String)"user.timezone");
        TimeZoneUtil.setDefault((String)userTimeZone);
        try {
            PortalClassLoaderUtil.setClassLoader((ClassLoader)ClassLoaderUtil.getContextClassLoader());
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        com.liferay.portal.kernel.util.PropsUtil.setProps((Props)new PropsImpl());
        if (GetterUtil.getBoolean((String)SystemProperties.get((String)"log4j.configure.on.startup"), (boolean)true)) {
            ClassLoader classLoader = InitUtil.class.getClassLoader();
            Log4JUtil.configureLog4J((ClassLoader)classLoader);
        }
        try {
            LogFactoryUtil.setLogFactory((LogFactory)new Log4jLogFactoryImpl());
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
        SanitizerLogWrapper.init();
        SecurityManagerUtil.init();
        if (SecurityManagerUtil.ENABLED) {
            com.liferay.portal.kernel.util.PropsUtil.setProps((Props)DoPrivilegedUtil.wrap(com.liferay.portal.kernel.util.PropsUtil.getProps()));
            LogFactoryUtil.setLogFactory((LogFactory)DoPrivilegedUtil.wrap(LogFactoryUtil.getLogFactory()));
        }
        CacheRegistryUtil.setCacheRegistry((CacheRegistry)DoPrivilegedUtil.wrap(new CacheRegistryImpl()));
        ConfigurationFactoryUtil.setConfigurationFactory((ConfigurationFactory)DoPrivilegedUtil.wrap(new ConfigurationFactoryImpl()));
        DataSourceFactoryUtil.setDataSourceFactory((DataSourceFactory)DoPrivilegedUtil.wrap(new DataSourceFactoryImpl()));
        DBFactoryUtil.setDBFactory((DBFactory)DoPrivilegedUtil.wrap(new DBFactoryImpl()));
        JavaDetector.isJDK5();
        XmlReader.setDefaultEncoding((String)"UTF-8");
        _initialized = true;
    }

    public static synchronized void initWithSpring() {
        InitUtil.initWithSpring(false, null);
    }

    public static synchronized void initWithSpring(boolean force) {
        InitUtil.initWithSpring(force, null);
    }

    public static synchronized void initWithSpring(boolean force, List<String> extraConfigLocations) {
        if (force) {
            _initialized = false;
        }
        if (_initialized) {
            return;
        }
        if (!_neverInitialized) {
            PropsUtil.reload();
        } else {
            _neverInitialized = false;
        }
        InitUtil.init();
        SpringUtil.loadContext(extraConfigLocations);
        _initialized = true;
    }

    public static synchronized void initWithSpring(List<String> extraConfigLocations) {
        InitUtil.initWithSpring(false, extraConfigLocations);
    }
}

