/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FriendlyURLNormalizer;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.util.Normalizer;
import java.util.Arrays;
import java.util.regex.Pattern;

@DoPrivileged
public class FriendlyURLNormalizerImpl
implements FriendlyURLNormalizer {
    private static final char[] _REPLACE_CHARS;
    private static Pattern _friendlyURLHyphenPattern;
    private static Pattern _friendlyURLPattern;

    static {
        char[] replaceChars = new char[]{' ', ',', '\\', '\'', '\"', '(', ')', '[', ']', '{', '}', '?', '#', '@', '+', '~', ';', '$', '%', '!', '=', ':', '&', '\u00a3', '\u2013', '\u2014', '\u2018', '\u2019', '\u201c', '\u201d'};
        Arrays.sort(replaceChars);
        _REPLACE_CHARS = replaceChars;
        _friendlyURLHyphenPattern = Pattern.compile("(-)\\1+");
        _friendlyURLPattern = Pattern.compile("[^a-z0-9./_-]");
    }

    public String normalize(String friendlyURL) {
        return this.normalize(friendlyURL, _friendlyURLPattern);
    }

    public String normalize(String friendlyURL, char[] replaceChars) {
        if (Validator.isNull((String)friendlyURL)) {
            return friendlyURL;
        }
        friendlyURL = GetterUtil.getString((String)friendlyURL);
        friendlyURL = StringUtil.toLowerCase((String)friendlyURL);
        friendlyURL = Normalizer.normalizeToAscii((String)friendlyURL);
        StringBuilder sb = null;
        int index = 0;
        int i2 = 0;
        while (i2 < friendlyURL.length()) {
            char c2 = friendlyURL.charAt(i2);
            if (Arrays.binarySearch(_REPLACE_CHARS, c2) >= 0 || replaceChars != null && ArrayUtil.contains((char[])replaceChars, (char)c2)) {
                if (sb == null) {
                    sb = new StringBuilder();
                }
                if (i2 > index) {
                    sb.append(friendlyURL.substring(index, i2));
                }
                sb.append('-');
                index = i2 + 1;
            }
            ++i2;
        }
        if (sb != null) {
            if (index < friendlyURL.length()) {
                sb.append(friendlyURL.substring(index));
            }
            friendlyURL = sb.toString();
        }
        while (friendlyURL.contains("--")) {
            friendlyURL = StringUtil.replace((String)friendlyURL, (String)"--", (String)"-");
        }
        return friendlyURL;
    }

    public String normalize(String friendlyURL, Pattern friendlyURLPattern) {
        if (Validator.isNull((String)friendlyURL)) {
            return friendlyURL;
        }
        friendlyURL = StringUtil.toLowerCase((String)friendlyURL);
        friendlyURL = Normalizer.normalizeToAscii((String)friendlyURL);
        friendlyURL = friendlyURL.replaceAll(friendlyURLPattern.pattern(), "-");
        friendlyURL = friendlyURL.replaceAll(_friendlyURLHyphenPattern.pattern(), "-");
        return friendlyURL;
    }
}

