/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upload;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.ByteArrayFileInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upload.FileItem;
import com.liferay.portal.kernel.upload.UploadException;
import com.liferay.portal.kernel.upload.UploadServletRequest;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.upload.LiferayFileItem;
import com.liferay.portal.upload.LiferayFileItemFactory;
import com.liferay.portal.upload.LiferayFileUpload;
import com.liferay.portal.upload.LiferayServletRequest;
import com.liferay.portal.util.PrefsPropsUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;

public class UploadServletRequestImpl
extends HttpServletRequestWrapper
implements UploadServletRequest {
    private static Log _log = LogFactoryUtil.getLog(UploadServletRequestImpl.class);
    private static File _tempDir;
    private Map<String, FileItem[]> _fileParameters;
    private LiferayServletRequest _liferayServletRequest;
    private Map<String, List<String>> _regularParameters;

    public static File getTempDir() throws SystemException {
        if (_tempDir == null) {
            _tempDir = new File(PrefsPropsUtil.getString("com.liferay.portal.upload.UploadServletRequestImpl.temp.dir", SystemProperties.get((String)"java.io.tmpdir")));
        }
        return _tempDir;
    }

    public static void setTempDir(File tempDir) {
        _tempDir = tempDir;
    }

    public UploadServletRequestImpl(HttpServletRequest request) {
        block8: {
            super(request);
            this._fileParameters = new LinkedHashMap<String, FileItem[]>();
            this._regularParameters = new LinkedHashMap<String, List<String>>();
            try {
                LiferayFileUpload servletFileUpload = new LiferayFileUpload((FileItemFactory)new LiferayFileItemFactory(UploadServletRequestImpl.getTempDir()), request);
                servletFileUpload.setSizeMax(PrefsPropsUtil.getLong("com.liferay.portal.upload.UploadServletRequestImpl.max.size"));
                this._liferayServletRequest = new LiferayServletRequest(request);
                List liferayFileItemsList = servletFileUpload.parseRequest((HttpServletRequest)this._liferayServletRequest);
                for (LiferayFileItem liferayFileItem : liferayFileItemsList) {
                    if (liferayFileItem.isFormField()) {
                        liferayFileItem.setString(request.getCharacterEncoding());
                        String fieldName = liferayFileItem.getFieldName();
                        if (!this._regularParameters.containsKey(fieldName)) {
                            this._regularParameters.put(fieldName, new ArrayList());
                        }
                        List<String> values = this._regularParameters.get(fieldName);
                        values.add(liferayFileItem.getString());
                        continue;
                    }
                    FileItem[] liferayFileItems = this._fileParameters.get(liferayFileItem.getFieldName());
                    if (liferayFileItems == null) {
                        liferayFileItems = new LiferayFileItem[]{liferayFileItem};
                    } else {
                        LiferayFileItem[] newLiferayFileItems = new LiferayFileItem[liferayFileItems.length + 1];
                        System.arraycopy(liferayFileItems, 0, newLiferayFileItems, 0, liferayFileItems.length);
                        newLiferayFileItems[newLiferayFileItems.length - 1] = liferayFileItem;
                        liferayFileItems = newLiferayFileItems;
                    }
                    this._fileParameters.put(liferayFileItem.getFieldName(), liferayFileItems);
                }
            }
            catch (Exception e2) {
                UploadException uploadException = new UploadException((Throwable)e2);
                if (e2 instanceof FileUploadBase.FileSizeLimitExceededException || e2 instanceof FileUploadBase.SizeLimitExceededException) {
                    uploadException.setExceededSizeLimit(true);
                }
                request.setAttribute("UPLOAD_EXCEPTION", (Object)uploadException);
                if (!_log.isDebugEnabled()) break block8;
                _log.debug((Object)e2, (Throwable)e2);
            }
        }
    }

    public UploadServletRequestImpl(HttpServletRequest request, Map<String, FileItem[]> fileParams, Map<String, List<String>> regularParams) {
        super(request);
        this._fileParameters = new LinkedHashMap<String, FileItem[]>();
        this._regularParameters = new LinkedHashMap<String, List<String>>();
        if (fileParams != null) {
            this._fileParameters.putAll(fileParams);
        }
        if (regularParams != null) {
            this._regularParameters.putAll(regularParams);
        }
    }

    public void cleanUp() {
        if (this._fileParameters != null && !this._fileParameters.isEmpty()) {
            Iterator<FileItem[]> iterator = this._fileParameters.values().iterator();
            while (iterator.hasNext()) {
                FileItem[] liferayFileItems;
                FileItem[] fileItemArray = liferayFileItems = iterator.next();
                int n = liferayFileItems.length;
                int n2 = 0;
                while (n2 < n) {
                    FileItem liferayFileItem = fileItemArray[n2];
                    liferayFileItem.delete();
                    ++n2;
                }
            }
        }
    }

    public String getContentType(String name) {
        Object[] liferayFileItems = this._fileParameters.get(name);
        if (ArrayUtil.isNotEmpty((Object[])liferayFileItems)) {
            Object liferayFileItem = liferayFileItems[0];
            return liferayFileItem.getContentType();
        }
        return null;
    }

    public File getFile(String name) {
        return this.getFile(name, false);
    }

    public File getFile(String name, boolean forceCreate) {
        File file;
        block6: {
            if (this.getFileName(name) == null) {
                return null;
            }
            Object[] liferayFileItems = this._fileParameters.get(name);
            if (ArrayUtil.isEmpty((Object[])liferayFileItems)) {
                return null;
            }
            Object liferayFileItem = liferayFileItems[0];
            long size = liferayFileItem.getSize();
            if (size > 0L && size <= (long)liferayFileItem.getSizeThreshold()) {
                forceCreate = true;
            }
            file = liferayFileItem.getStoreLocation();
            if (liferayFileItem.isInMemory() && forceCreate) {
                try {
                    FileUtil.write((File)file, (InputStream)liferayFileItem.getInputStream());
                }
                catch (IOException ioe) {
                    if (!_log.isWarnEnabled()) break block6;
                    _log.warn((Object)("Unable to write temporary file " + file.getAbsolutePath()), (Throwable)ioe);
                }
            }
        }
        return file;
    }

    public InputStream getFileAsStream(String name) throws IOException {
        return this.getFileAsStream(name, true);
    }

    public InputStream getFileAsStream(String name, boolean deleteOnClose) throws IOException {
        if (this.getFileName(name) == null) {
            return null;
        }
        InputStream inputStream = null;
        Object[] liferayFileItems = this._fileParameters.get(name);
        if (ArrayUtil.isNotEmpty((Object[])liferayFileItems)) {
            Object liferayFileItem = liferayFileItems[0];
            inputStream = this.getInputStream((FileItem)liferayFileItem, deleteOnClose);
        }
        return inputStream;
    }

    public String getFileName(String name) {
        Object[] liferayFileItems = this._fileParameters.get(name);
        if (ArrayUtil.isNotEmpty((Object[])liferayFileItems)) {
            Object liferayFileItem = liferayFileItems[0];
            return liferayFileItem.getFileName();
        }
        return null;
    }

    public String[] getFileNames(String name) {
        Object[] liferayFileItems = this._fileParameters.get(name);
        if (ArrayUtil.isNotEmpty((Object[])liferayFileItems)) {
            String[] fileNames = new String[liferayFileItems.length];
            int i2 = 0;
            while (i2 < liferayFileItems.length) {
                Object liferayFileItem = liferayFileItems[i2];
                fileNames[i2] = liferayFileItem.getFileName();
                ++i2;
            }
            return fileNames;
        }
        return null;
    }

    public File[] getFiles(String name) {
        String[] fileNames = this.getFileNames(name);
        if (fileNames == null) {
            return null;
        }
        Object[] liferayFileItems = this._fileParameters.get(name);
        if (ArrayUtil.isNotEmpty((Object[])liferayFileItems)) {
            File[] files = new File[liferayFileItems.length];
            int i2 = 0;
            while (i2 < liferayFileItems.length) {
                Object liferayFileItem = liferayFileItems[i2];
                if (Validator.isNotNull((String)liferayFileItem.getFileName())) {
                    files[i2] = liferayFileItem.getStoreLocation();
                }
                ++i2;
            }
            return files;
        }
        return null;
    }

    public InputStream[] getFilesAsStream(String name) throws IOException {
        return this.getFilesAsStream(name, true);
    }

    public InputStream[] getFilesAsStream(String name, boolean deleteOnClose) throws IOException {
        String[] fileNames = this.getFileNames(name);
        if (fileNames == null) {
            return null;
        }
        InputStream[] inputStreams = null;
        Object[] liferayFileItems = this._fileParameters.get(name);
        if (ArrayUtil.isNotEmpty((Object[])liferayFileItems)) {
            inputStreams = new InputStream[liferayFileItems.length];
            int i2 = 0;
            while (i2 < liferayFileItems.length) {
                Object liferayFileItem = liferayFileItems[i2];
                if (Validator.isNotNull((String)liferayFileItem.getFileName())) {
                    inputStreams[i2] = this.getInputStream((FileItem)liferayFileItem, deleteOnClose);
                }
                ++i2;
            }
        }
        return inputStreams;
    }

    public String getFullFileName(String name) {
        Object[] liferayFileItems = this._fileParameters.get(name);
        if (ArrayUtil.isNotEmpty((Object[])liferayFileItems)) {
            Object liferayFileItem = liferayFileItems[0];
            return liferayFileItem.getFullFileName();
        }
        return null;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this._liferayServletRequest != null) {
            return this._liferayServletRequest.getInputStream();
        }
        return super.getInputStream();
    }

    public Map<String, FileItem[]> getMultipartParameterMap() {
        return this._fileParameters;
    }

    public String getParameter(String name) {
        List<String> values = this._regularParameters.get(name);
        if (values != null && !values.isEmpty()) {
            return values.get(0);
        }
        return super.getParameter(name);
    }

    public Map<String, String[]> getParameterMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        Enumeration<String> enu = this.getParameterNames();
        while (enu.hasMoreElements()) {
            String name = enu.nextElement();
            map.put(name, this.getParameterValues(name));
        }
        return map;
    }

    public Enumeration<String> getParameterNames() {
        LinkedHashSet<String> parameterNames = new LinkedHashSet<String>();
        Enumeration enu = super.getParameterNames();
        while (enu.hasMoreElements()) {
            parameterNames.add((String)enu.nextElement());
        }
        parameterNames.addAll(this._regularParameters.keySet());
        parameterNames.addAll(this._fileParameters.keySet());
        return Collections.enumeration(parameterNames);
    }

    public String[] getParameterValues(String name) {
        Object[] parameterValues = null;
        List<String> values = this._regularParameters.get(name);
        if (values != null) {
            parameterValues = values.toArray(new String[values.size()]);
        }
        Object[] parentParameterValues = super.getParameterValues(name);
        if (parameterValues == null) {
            return parentParameterValues;
        }
        if (parentParameterValues == null) {
            return parameterValues;
        }
        return (String[])ArrayUtil.append((Object[])parameterValues, (Object[])parentParameterValues);
    }

    public Map<String, List<String>> getRegularParameterMap() {
        return this._regularParameters;
    }

    public Long getSize(String name) {
        Object[] liferayFileItems = this._fileParameters.get(name);
        if (ArrayUtil.isNotEmpty((Object[])liferayFileItems)) {
            Object liferayFileItem = liferayFileItems[0];
            return new Long(liferayFileItem.getSize());
        }
        return null;
    }

    public Boolean isFormField(String name) {
        Object[] liferayFileItems = this._fileParameters.get(name);
        if (ArrayUtil.isNotEmpty((Object[])liferayFileItems)) {
            Object liferayFileItem = liferayFileItems[0];
            return new Boolean(liferayFileItem.isFormField());
        }
        return null;
    }

    protected InputStream getInputStream(FileItem liferayFileItem, boolean deleteOnClose) throws IOException {
        InputStream inputStream = null;
        if (liferayFileItem.isInMemory() && liferayFileItem.getSize() > 0L) {
            inputStream = liferayFileItem.getInputStream();
        } else if (!liferayFileItem.isInMemory()) {
            inputStream = new ByteArrayFileInputStream(liferayFileItem.getStoreLocation(), liferayFileItem.getSizeThreshold(), deleteOnClose);
        }
        return inputStream;
    }
}

