/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_2_0;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.wiki.model.WikiPage;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;

public class UpgradeSocial
extends UpgradeProcess {
    private static Log _log = LogFactoryUtil.getLog(UpgradeSocial.class);

    protected void addActivity(long activityId, long groupId, long companyId, long userId, Timestamp createDate, long mirrorActivityId, long classNameId, long classPK, int type, String extraData, long receiverUserId) throws Exception {
        block6: {
            Connection con = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    con = DataAccess.getUpgradeOptimizedConnection();
                    StringBundler sb = new StringBundler(5);
                    sb.append("insert into SocialActivity (activityId, groupId, ");
                    sb.append("companyId, userId, createDate, mirrorActivityId, ");
                    sb.append("classNameId, classPK, type_, extraData, ");
                    sb.append("receiverUserId) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ");
                    sb.append("?)");
                    ps = con.prepareStatement(sb.toString());
                    ps.setLong(1, activityId);
                    ps.setLong(2, groupId);
                    ps.setLong(3, companyId);
                    ps.setLong(4, userId);
                    ps.setLong(5, createDate.getTime());
                    ps.setLong(6, mirrorActivityId);
                    ps.setLong(7, classNameId);
                    ps.setLong(8, classPK);
                    ps.setInt(9, type);
                    ps.setString(10, extraData);
                    ps.setLong(11, receiverUserId);
                    ps.executeUpdate();
                }
                catch (Exception e2) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("Unable to add activity " + activityId), (Throwable)e2);
                    }
                    DataAccess.cleanUp((Connection)con, ps, rs);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
        }
    }

    protected void addActivitySet(long activitySetId, long groupId, long companyId, long userId, long createDate, long classNameId, long classPK, int type_) throws Exception {
        block6: {
            Connection con = null;
            PreparedStatement ps = null;
            try {
                try {
                    con = DataAccess.getUpgradeOptimizedConnection();
                    StringBundler sb = new StringBundler(4);
                    sb.append("insert into SocialActivitySet (activitySetId, ");
                    sb.append("groupId, companyId, userId, createDate, modifiedDate, ");
                    sb.append("classNameId, classPK, type_, activityCount) values ");
                    sb.append("(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                    ps = con.prepareStatement(sb.toString());
                    ps.setLong(1, activitySetId);
                    ps.setLong(2, groupId);
                    ps.setLong(3, companyId);
                    ps.setLong(4, userId);
                    ps.setLong(5, createDate);
                    ps.setLong(6, createDate);
                    ps.setLong(7, classNameId);
                    ps.setLong(8, classPK);
                    ps.setInt(9, type_);
                    ps.setInt(10, 1);
                    ps.executeUpdate();
                }
                catch (Exception e2) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("Unable to add activity set " + activitySetId), (Throwable)e2);
                    }
                    DataAccess.cleanUp((Connection)con, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, ps);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps);
        }
    }

    protected void doUpgrade() throws Exception {
        this.updateJournalActivities();
        this.updateSOSocialActivities();
        this.updateWikiPageActivities();
        this.migrateActivities();
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean hasActivitySets() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select count(*) from SocialActivitySet");
            rs = ps.executeQuery();
            boolean bl = true;
            while (true) {
                int count;
                if (bl && !(bl = false)) {
                    if (true) break block5;
                }
                if ((count = rs.getInt(1)) <= 0) break block5;
                break;
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        {
            block5: {
                DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
                return true;
            }
            if (rs.next()) continue;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return false;
    }

    protected void migrateActivities() throws Exception {
        if (this.hasActivitySets()) {
            return;
        }
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select groupId, companyId, userId, createDate, classNameId, classPK, type_ from SocialActivity");
            rs = ps.executeQuery();
            while (rs.next()) {
                long groupId = rs.getLong("groupId");
                long companyId = rs.getLong("companyId");
                long userId = rs.getLong("userId");
                long createDate = rs.getLong("createDate");
                long classNameId = rs.getLong("classNameId");
                long classPK = rs.getLong("classPK");
                int type_ = rs.getInt("type_");
                this.addActivitySet(this.increment(), groupId, companyId, userId, createDate, classNameId, classPK, type_);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void updateJournalActivities() throws Exception {
        String[] tableNames;
        long classNameId = PortalUtil.getClassNameId(JournalArticle.class);
        String[] stringArray = tableNames = new String[]{"SocialActivity", "SocialActivityCounter"};
        int n = tableNames.length;
        int n2 = 0;
        while (n2 < n) {
            String tableName = stringArray[n2];
            StringBundler sb = new StringBundler(7);
            sb.append("update ");
            sb.append(tableName);
            sb.append(" set classPK = (select resourcePrimKey ");
            sb.append("from JournalArticle where id_ = ");
            sb.append(tableName);
            sb.append(".classPK) where classNameId = ");
            sb.append(classNameId);
            this.runSQL(sb.toString());
            ++n2;
        }
    }

    protected void updateSOSocialActivities() throws Exception {
        if (!this.hasTable("SO_SocialActivity")) {
            return;
        }
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select activityId, activitySetId from SO_SocialActivity");
            rs = ps.executeQuery();
            while (rs.next()) {
                long activityId = rs.getLong("activityId");
                long activitySetId = rs.getLong("activitySetId");
                StringBundler sb = new StringBundler(4);
                sb.append("update SocialActivity set activitySetId = ");
                sb.append(activitySetId);
                sb.append(" where activityId = ");
                sb.append(activityId);
                this.runSQL(sb.toString());
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        this.runSQL("drop table SO_SocialActivity");
    }

    protected void updateWikiPageActivities() throws Exception {
        long classNameId = PortalUtil.getClassNameId(WikiPage.class);
        this.runSQL("delete from SocialActivity where classNameId = " + classNameId);
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select groupId, companyId, userId, modifiedDate, resourcePrimKey, version from WikiPage");
            rs = ps.executeQuery();
            while (rs.next()) {
                long groupId = rs.getLong("groupId");
                long companyId = rs.getLong("companyId");
                long userId = rs.getLong("userId");
                Timestamp modifiedDate = rs.getTimestamp("modifiedDate");
                long resourcePrimKey = rs.getLong("resourcePrimKey");
                double version = rs.getDouble("version");
                int type = 1;
                if (version > 1.0) {
                    type = 2;
                }
                JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
                extraDataJSONObject.put("version", version);
                this.addActivity(this.increment(), groupId, companyId, userId, modifiedDate, 0L, classNameId, resourcePrimKey, type, extraDataJSONObject.toString(), 0L);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }
}

