/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_2_0;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.CustomizedPages;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.PortletPreferences;
import com.liferay.portal.model.impl.PortletPreferencesImpl;
import com.liferay.portlet.PortalPreferencesImpl;
import com.liferay.portlet.PortalPreferencesWrapper;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;

public class UpgradeCustomizablePortlets
extends UpgradeProcess {
    private static final String _PREFIX = "<name>com.liferay.portal.model.CustomizedPages";
    private static final String _SUFFIX = "</name>";

    protected void doUpgrade() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("select ownerId, ownerType, preferences from PortalPreferences where preferences like '%com.liferay.portal.model.CustomizedPages%'");
            rs = ps.executeQuery();
            while (rs.next()) {
                long ownerId = rs.getLong("ownerId");
                int ownerType = rs.getInt("ownerType");
                String preferences = rs.getString("preferences");
                PortalPreferencesWrapper portalPreferencesWrapper = this.getPortalPreferencesInstance(ownerId, ownerType, preferences);
                this.upgradeCustomizablePreferences(portalPreferencesWrapper, ownerId, ownerType, preferences);
                portalPreferencesWrapper.store();
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected PortalPreferencesWrapper getPortalPreferencesInstance(long ownerId, int ownerType, String xml) throws SystemException {
        PortalPreferencesImpl portalPreferencesImpl = (PortalPreferencesImpl)PortletPreferencesFactoryUtil.fromXML((long)ownerId, (int)ownerType, (String)xml);
        return new PortalPreferencesWrapper(portalPreferencesImpl);
    }

    protected PortletPreferences getPortletPreferences(long ownerId, int ownerType, long plid, String portletId) throws Exception {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block3: {
            con = null;
            ps = null;
            rs = null;
            try {
                con = DataAccess.getUpgradeOptimizedConnection();
                ps = con.prepareStatement("select portletPreferencesId, ownerId, ownerType, plid, portletId, preferences from PortletPreferences where ownerId = ?, ownerType = ?, plid = ?, portletId = ?");
                ps.setLong(1, ownerId);
                ps.setInt(2, ownerType);
                ps.setLong(3, plid);
                ps.setString(4, portletId);
                rs = ps.executeQuery();
                if (rs.next()) break block3;
            }
            catch (Throwable throwable) {
                DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
                throw throwable;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
            return null;
        }
        PortletPreferencesImpl portletPreferences = new PortletPreferencesImpl();
        portletPreferences.setPortletPreferencesId(rs.getLong("portletPreferencesId"));
        portletPreferences.setOwnerId(rs.getLong("ownerId"));
        portletPreferences.setOwnerType(rs.getInt("ownerType"));
        portletPreferences.setPlid(rs.getLong("plid"));
        portletPreferences.setPortletId(rs.getString("portletId"));
        portletPreferences.setPreferences(rs.getString("preferences"));
        PortletPreferencesImpl portletPreferencesImpl = portletPreferences;
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        return portletPreferencesImpl;
    }

    protected String migratePortletPreferencesToUserPreferences(long userId, long plid, String portletId) throws Exception {
        if (!PortletConstants.hasInstanceId((String)portletId)) {
            return portletId;
        }
        String instanceId = PortletConstants.getInstanceId((String)portletId);
        String newPortletId = PortletConstants.assemblePortletId((String)portletId, (long)userId, (String)instanceId);
        this.updatePortletPreferences(userId, plid, portletId, newPortletId);
        return newPortletId;
    }

    protected void updatePortletPreferences(long userId, long plid, String portletId, String newPortletId) throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            ps = con.prepareStatement("update PortletPreferences set ownerId = ?, ownerType = ?, plid = ?, portletId = ? where ownerId = ? and ownerType = ? and portletId = ?");
            ps.setLong(1, userId);
            ps.setInt(2, 4);
            ps.setLong(3, plid);
            ps.setString(4, newPortletId);
            ps.setLong(5, 0L);
            ps.setInt(6, 3);
            ps.setString(7, portletId);
            ps.executeUpdate();
        }
        finally {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void upgradeCustomizablePreferences(PortalPreferencesWrapper portalPreferencesWrapper, long ownerId, int ownerType, String preferences) throws Exception {
        PortalPreferencesImpl portalPreferencesImpl = portalPreferencesWrapper.getPortalPreferencesImpl();
        int x = preferences.indexOf(_PREFIX);
        int y = -1;
        if (x == -1) return;
        y = preferences.indexOf(_SUFFIX, x += _PREFIX.length());
        while (x != -1) {
            String[] parts = StringUtil.split((String)preferences.substring(x, y), (String)"#");
            long plid = GetterUtil.getLong((String)parts[0]);
            String key = GetterUtil.getString((String)parts[1]);
            if (key.startsWith("column-")) {
                String value = portalPreferencesImpl.getValue(CustomizedPages.namespacePlid((long)plid), key);
                ArrayList<String> newPortletIds = new ArrayList<String>();
                String[] stringArray = StringUtil.split((String)value);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String customPortletId = stringArray[n2];
                    String newPortletId = this.migratePortletPreferencesToUserPreferences(ownerId, plid, customPortletId);
                    newPortletIds.add(newPortletId);
                    ++n2;
                }
                value = StringUtil.merge(newPortletIds);
                portalPreferencesImpl.setValue(CustomizedPages.namespacePlid((long)plid), key, value);
            }
            x = preferences.indexOf(_PREFIX, y);
            y = -1;
            if (x == -1) continue;
            y = preferences.indexOf(_SUFFIX, x += _PREFIX.length());
        }
    }
}

