/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.sourceformatter;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UniqueList;
import com.liferay.portal.tools.sourceformatter.CSSSourceProcessor;
import com.liferay.portal.tools.sourceformatter.FTLSourceProcessor;
import com.liferay.portal.tools.sourceformatter.JSPSourceProcessor;
import com.liferay.portal.tools.sourceformatter.JSSourceProcessor;
import com.liferay.portal.tools.sourceformatter.JavaSourceProcessor;
import com.liferay.portal.tools.sourceformatter.PropertiesSourceProcessor;
import com.liferay.portal.tools.sourceformatter.SHSourceProcessor;
import com.liferay.portal.tools.sourceformatter.SQLSourceProcessor;
import com.liferay.portal.tools.sourceformatter.SourceFormatterUtil;
import com.liferay.portal.tools.sourceformatter.SourceProcessor;
import com.liferay.portal.tools.sourceformatter.TLDSourceProcessor;
import com.liferay.portal.tools.sourceformatter.XMLSourceProcessor;
import java.util.ArrayList;
import java.util.List;

public class SourceFormatter {
    private static boolean _autoFix;
    private static List<String> _errorMessages;
    private static boolean _printErrors;
    private static boolean _throwException;
    private static boolean _useProperties;

    static {
        _errorMessages = new UniqueList();
    }

    public static void main(String[] args) {
        try {
            SourceFormatter sourceFormatter = SourceFormatterUtil.create(false, false, true, true);
            sourceFormatter.format();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public SourceFormatter(boolean useProperties, boolean throwException, boolean printErrors, boolean autoFix) throws Exception {
        _useProperties = useProperties;
        _throwException = throwException;
        _printErrors = printErrors;
        _autoFix = autoFix;
    }

    public void format() throws Exception {
        Thread thread1 = new Thread(){

            @Override
            public void run() {
                try {
                    ArrayList<SourceProcessor> sourceProcessors = new ArrayList<SourceProcessor>();
                    sourceProcessors.add((SourceProcessor)CSSSourceProcessor.class.newInstance());
                    sourceProcessors.add((SourceProcessor)FTLSourceProcessor.class.newInstance());
                    sourceProcessors.add((SourceProcessor)JavaSourceProcessor.class.newInstance());
                    sourceProcessors.add((SourceProcessor)JSSourceProcessor.class.newInstance());
                    sourceProcessors.add((SourceProcessor)PropertiesSourceProcessor.class.newInstance());
                    sourceProcessors.add((SourceProcessor)SHSourceProcessor.class.newInstance());
                    sourceProcessors.add((SourceProcessor)SQLSourceProcessor.class.newInstance());
                    sourceProcessors.add((SourceProcessor)TLDSourceProcessor.class.newInstance());
                    sourceProcessors.add((SourceProcessor)XMLSourceProcessor.class.newInstance());
                    for (SourceProcessor sourceProcessor : sourceProcessors) {
                        sourceProcessor.format(_useProperties, _printErrors, _autoFix);
                        _errorMessages.addAll(sourceProcessor.getErrorMessages());
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        };
        Thread thread2 = new Thread(){

            @Override
            public void run() {
                try {
                    SourceProcessor sourceProcessor = (SourceProcessor)JSPSourceProcessor.class.newInstance();
                    sourceProcessor.format(_useProperties, _printErrors, _autoFix);
                    _errorMessages.addAll(sourceProcessor.getErrorMessages());
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        };
        thread1.start();
        thread2.start();
        thread1.join();
        thread2.join();
        if (_throwException && !_errorMessages.isEmpty()) {
            throw new Exception(StringUtil.merge(_errorMessages, (String)"\n"));
        }
    }

    public String[] format(String fileName) throws Exception {
        SourceProcessor sourceProcessor = null;
        if (fileName.endsWith(".testjava")) {
            sourceProcessor = (SourceProcessor)JavaSourceProcessor.class.newInstance();
        }
        if (sourceProcessor == null) {
            return null;
        }
        String newContent = sourceProcessor.format(fileName, _useProperties, _printErrors, _autoFix);
        List<String> errorMessages = sourceProcessor.getErrorMessages();
        if (errorMessages.isEmpty()) {
            String[] stringArray = new String[2];
            stringArray[0] = newContent;
            return stringArray;
        }
        return new String[]{newContent, errorMessages.get(0)};
    }
}

