/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.sourceformatter;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.sourceformatter.BaseSourceProcessor;
import com.liferay.portal.tools.sourceformatter.JavaTerm;
import com.liferay.portal.tools.sourceformatter.JavaTermComparator;
import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaSource;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaSourceProcessor
extends BaseSourceProcessor {
    public static final int TYPE_CLASS_PRIVATE = 24;
    public static final int TYPE_CLASS_PRIVATE_STATIC = 23;
    public static final int TYPE_CLASS_PROTECTED = 16;
    public static final int TYPE_CLASS_PROTECTED_STATIC = 15;
    public static final int TYPE_CLASS_PUBLIC = 8;
    public static final int TYPE_CLASS_PUBLIC_STATIC = 7;
    public static final int[] TYPE_CONSTRUCTOR = new int[]{18, 10, 4};
    public static final int TYPE_CONSTRUCTOR_PRIVATE = 18;
    public static final int TYPE_CONSTRUCTOR_PROTECTED = 10;
    public static final int TYPE_CONSTRUCTOR_PUBLIC = 4;
    public static final int[] TYPE_METHOD = new int[]{19, 17, 11, 9, 5, 3};
    public static final int TYPE_METHOD_PRIVATE = 19;
    public static final int TYPE_METHOD_PRIVATE_STATIC = 17;
    public static final int TYPE_METHOD_PROTECTED = 11;
    public static final int TYPE_METHOD_PROTECTED_STATIC = 9;
    public static final int TYPE_METHOD_PUBLIC = 5;
    public static final int TYPE_METHOD_PUBLIC_STATIC = 3;
    public static final int[] TYPE_VARIABLE = new int[]{22, 21, 20, 14, 13, 12, 6, 2, 1};
    public static final int TYPE_VARIABLE_PRIVATE = 22;
    public static final int TYPE_VARIABLE_PRIVATE_STATIC = 21;
    public static final int TYPE_VARIABLE_PRIVATE_STATIC_FINAL = 20;
    public static final int TYPE_VARIABLE_PROTECTED = 14;
    public static final int TYPE_VARIABLE_PROTECTED_STATIC = 13;
    public static final int TYPE_VARIABLE_PROTECTED_STATIC_FINAL = 12;
    public static final int TYPE_VARIABLE_PUBLIC = 6;
    public static final int TYPE_VARIABLE_PUBLIC_STATIC = 2;
    public static final int TYPE_VARIABLE_PUBLIC_STATIC_FINAL = 1;
    private static Pattern _importsPattern = Pattern.compile("(^[ \t]*import\\s+.*;\n+)+", 8);
    private Pattern _catchExceptionPattern = Pattern.compile("\n(\t+)catch \\((.+Exception) (.+)\\) \\{\n");
    private boolean _checkUnprocessedExceptions;
    private Pattern _incorrectCloseCurlyBracePattern = Pattern.compile("\n\n(\t+)}\n");
    private Pattern _incorrectLineBreakPattern = Pattern.compile("\t(catch |else |finally |for |if |try |while ).*\\{\n\n\t+\\w");
    private Properties _javaTermSortExclusions;
    private Properties _lineLengthExclusions;
    private Pattern _logPattern = Pattern.compile("Log _log = LogFactoryUtil.getLog\\(\n*\t*(.+)\\.class\\)");
    private Properties _staticLogVariableExclusions;
    private Properties _upgradeServiceUtilExclusions;

    public static String stripJavaImports(String content, String packageDir, String className) throws IOException {
        Matcher matcher = _importsPattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        String imports = matcher.group();
        Set classes = ClassUtil.getClasses((Reader)new UnsyncStringReader(content), (String)className);
        StringBundler sb = new StringBundler();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(imports));
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            String importClass;
            int importY;
            int importX;
            String importPackage;
            if (!line.contains("import ") || (importPackage = line.substring((importX = line.indexOf(" ")) + 1, importY = line.lastIndexOf("."))).equals(packageDir) || importPackage.equals("java.lang") || !(importClass = line.substring(importY + 1, line.length() - 1)).equals("*") && !classes.contains(importClass)) continue;
            sb.append(line);
            sb.append("\n");
        }
        imports = JavaSourceProcessor.formatImports(sb.toString(), 7);
        content = String.valueOf(content.substring(0, matcher.start())) + imports + content.substring(matcher.end());
        content = content.replaceFirst("(?m)^[ \t]*(package .*;)\\s*^[ \t]*import", "$1\n\nimport");
        content = content.replaceFirst("(?m)^[ \t]*((?:package|import) .*;)\\s*^[ \t]*/\\*\\*", "$1\n\n/**");
        return content;
    }

    protected static boolean isInJavaTermTypeGroup(int javaTermType, int[] javaTermTypeGroup) {
        int[] nArray = javaTermTypeGroup;
        int n = javaTermTypeGroup.length;
        int n2 = 0;
        while (n2 < n) {
            int type = nArray[n2];
            if (javaTermType == type) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected List<String> addParameterTypes(String line, List<String> parameterTypes) {
        int x = line.indexOf("(");
        if (x != -1 && (Validator.isNull((String)(line = line.substring(x + 1))) || line.startsWith(")"))) {
            return parameterTypes;
        }
        x = 0;
        while ((x = line.indexOf(" ")) != -1) {
            String parameterType = line.substring(0, x);
            if (parameterType.equals("throws")) {
                return parameterTypes;
            }
            parameterTypes.add(parameterType);
            int y = line.indexOf(",");
            int z = line.indexOf(")");
            if (y == -1 || z != -1 && z < y) {
                return parameterTypes;
            }
            line = line.substring(y + 1);
            line = line.trim();
        }
        return parameterTypes;
    }

    protected void checkAnnotationForMethod(JavaTerm javaTerm, String annotation, String requiredMethodNameRegex, int requiredMethodType, String fileName) {
        String methodContent = javaTerm.getContent();
        String methodName = javaTerm.getName();
        Pattern pattern = Pattern.compile(requiredMethodNameRegex);
        Matcher matcher = pattern.matcher(methodName);
        if (methodContent.contains("\t@" + annotation + "\n") || methodContent.contains("\t@" + annotation + "(")) {
            if (!matcher.find()) {
                this.processErrorMessage(fileName, "LPS-36303: Incorrect method name: " + methodName + " " + fileName);
            } else if (javaTerm.getType() != requiredMethodType) {
                this.processErrorMessage(fileName, "LPS-36303: Incorrect method type for " + methodName + " " + fileName);
            }
        } else if (matcher.find() && !methodContent.contains("\t@Override")) {
            this.processErrorMessage(fileName, "Annotation @" + annotation + " required for " + methodName + " " + fileName);
        }
    }

    protected String checkIfClause(String ifClause, String fileName, int lineCount) throws IOException {
        String ifClauseSingleLine = StringUtil.replace((String)ifClause, (String[])new String[]{"\t ", "\t", "(\n", "\n"}, (String[])new String[]{"\t", "", "(", " "});
        this.checkIfClauseParentheses(ifClauseSingleLine, fileName, lineCount);
        return this.checkIfClauseTabsAndSpaces(ifClause);
    }

    protected String checkIfClauseTabsAndSpaces(String ifClause) throws IOException {
        if (ifClause.contains("!(") || ifClause.contains("\t//")) {
            return ifClause;
        }
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(ifClause));
        String line = null;
        String previousLine = null;
        int previousLineLeadingWhiteSpace = 0;
        int lastCriteriumLineLeadingWhiteSpace = 0;
        int closeParenthesesCount = 0;
        int openParenthesesCount = 0;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            int expectedLeadingWhiteSpace;
            String originalLine = line;
            line = StringUtil.replace((String)line, (String)"\t", (String)"    ");
            int leadingWhiteSpace = line.length() - StringUtil.trimLeading((String)line).length();
            if (Validator.isNull(previousLine)) {
                lastCriteriumLineLeadingWhiteSpace = line.indexOf("(");
            } else if (previousLine.endsWith("|") || previousLine.endsWith("&") || previousLine.endsWith("^")) {
                expectedLeadingWhiteSpace = lastCriteriumLineLeadingWhiteSpace + openParenthesesCount - closeParenthesesCount;
                if (leadingWhiteSpace != expectedLeadingWhiteSpace) {
                    return this.fixIfClause(ifClause, originalLine, leadingWhiteSpace - expectedLeadingWhiteSpace);
                }
                lastCriteriumLineLeadingWhiteSpace = leadingWhiteSpace;
                closeParenthesesCount = 0;
                openParenthesesCount = 0;
            } else {
                expectedLeadingWhiteSpace = 0;
                if (previousLine.contains("\tif (")) {
                    expectedLeadingWhiteSpace = previousLineLeadingWhiteSpace + 8;
                } else if (previousLine.contains("\telse if (") || previousLine.contains("\twhile (")) {
                    expectedLeadingWhiteSpace = previousLineLeadingWhiteSpace + 12;
                }
                if (expectedLeadingWhiteSpace != 0 && leadingWhiteSpace != expectedLeadingWhiteSpace) {
                    return this.fixIfClause(ifClause, originalLine, leadingWhiteSpace - expectedLeadingWhiteSpace);
                }
            }
            if (line.endsWith(") {")) {
                return ifClause;
            }
            line = this.stripQuotes(line, '\"');
            line = this.stripQuotes(line, '\'');
            closeParenthesesCount += StringUtil.count((String)line, (String)")");
            openParenthesesCount += StringUtil.count((String)line, (String)"(");
            previousLine = originalLine;
            previousLineLeadingWhiteSpace = leadingWhiteSpace;
        }
        return ifClause;
    }

    protected void checkTestAnnotations(JavaTerm javaTerm, String fileName) {
        int methodType = javaTerm.getType();
        if (methodType != 5 && methodType != 3) {
            return;
        }
        this.checkAnnotationForMethod(javaTerm, "After", "^.*tearDown\\z", 5, fileName);
        this.checkAnnotationForMethod(javaTerm, "AfterClass", "^.*tearDownClass\\z", 3, fileName);
        this.checkAnnotationForMethod(javaTerm, "Before", "^.*setUp\\z", 5, fileName);
        this.checkAnnotationForMethod(javaTerm, "BeforeClass", "^.*setUpClass\\z", 3, fileName);
        this.checkAnnotationForMethod(javaTerm, "Test", "^.*test", 5, fileName);
    }

    /*
     * WARNING - void declaration
     */
    protected void checkUnprocessedExceptions(String content, File file, String packagePath, String fileName) throws IOException {
        List<String> importedExceptionClassNames = null;
        JavaDocBuilder javaDocBuilder = null;
        int lineCount = 1;
        Matcher catchExceptionMatcher;
        while ((catchExceptionMatcher = this._catchExceptionPattern.matcher(content)).find()) {
            void var18_18;
            String packageName;
            String beforeCatchCode = content.substring(0, catchExceptionMatcher.start());
            lineCount = lineCount + StringUtil.count((String)beforeCatchCode, (String)"\n") + 1;
            String exceptionClassName = catchExceptionMatcher.group(2);
            String exceptionVariableName = catchExceptionMatcher.group(3);
            String tabs = catchExceptionMatcher.group(1);
            int pos = content.indexOf("\n" + tabs + "}", catchExceptionMatcher.end() - 1);
            String insideCatchCode = content.substring(catchExceptionMatcher.end(), pos + 1);
            Pattern exceptionVariablePattern = Pattern.compile("\\W" + exceptionVariableName + "\\W");
            Matcher exceptionVariableMatcher = exceptionVariablePattern.matcher(insideCatchCode);
            if (exceptionVariableMatcher.find()) {
                content = content.substring(catchExceptionMatcher.start() + 1);
                continue;
            }
            if (javaDocBuilder == null) {
                javaDocBuilder = new JavaDocBuilder();
                javaDocBuilder.addSource(file);
            }
            if (importedExceptionClassNames == null) {
                importedExceptionClassNames = this.getImportedExceptionClassNames(javaDocBuilder);
            }
            String originalExceptionClassName = exceptionClassName;
            if (!exceptionClassName.contains(".")) {
                for (String string : importedExceptionClassNames) {
                    if (!string.endsWith("." + exceptionClassName)) continue;
                    exceptionClassName = string;
                    break;
                }
            }
            if (!exceptionClassName.contains(".")) {
                exceptionClassName = String.valueOf(packagePath) + "." + exceptionClassName;
            }
            JavaClass javaClass = javaDocBuilder.getClassByName(exceptionClassName);
            while ((packageName = var18_18.getPackageName()).contains("com.liferay")) {
                exceptionClassName = var18_18.getName();
                if (exceptionClassName.equals("PortalException") || exceptionClassName.equals("SystemException")) {
                    this.processErrorMessage(fileName, "Unprocessed " + originalExceptionClassName + ": " + fileName + " " + lineCount);
                    break;
                }
                JavaClass exceptionSuperClass = var18_18.getSuperJavaClass();
                if (exceptionSuperClass == null) break;
                JavaClass javaClass2 = exceptionSuperClass;
            }
            content = content.substring(catchExceptionMatcher.start() + 1);
        }
        return;
    }

    protected String fixDataAccessConnection(String className, String content) {
        int x = content.indexOf("package ");
        int y = content.indexOf(59, x);
        if (x == -1 || y == -1) {
            return content;
        }
        String packageName = content.substring(x + 8, y);
        if (!(packageName.startsWith("com.liferay.portal.kernel.upgrade") || packageName.startsWith("com.liferay.portal.kernel.verify") || packageName.startsWith("com.liferay.portal.upgrade") || packageName.startsWith("com.liferay.portal.verify"))) {
            return content;
        }
        content = StringUtil.replace((String)content, (String)"DataAccess.getConnection", (String)"DataAccess.getUpgradeOptimizedConnection");
        return content;
    }

    protected String fixIfClause(String ifClause, String line, int delta) {
        String newLine = line;
        String whiteSpace = "";
        int whiteSpaceLength = Math.abs(delta);
        while (whiteSpaceLength > 0) {
            if (whiteSpaceLength >= 4) {
                whiteSpace = String.valueOf(whiteSpace) + "\t";
                whiteSpaceLength -= 4;
                continue;
            }
            whiteSpace = String.valueOf(whiteSpace) + " ";
            --whiteSpaceLength;
        }
        if (delta > 0) {
            if (!line.contains("\t" + whiteSpace)) {
                newLine = StringUtil.replaceLast((String)newLine, (String)"\t", (String)"    ");
            }
            newLine = StringUtil.replaceLast((String)newLine, (String)("\t" + whiteSpace), (String)"\t");
        } else {
            newLine = StringUtil.replaceLast((String)newLine, (String)"\t", (String)("\t" + whiteSpace));
        }
        return StringUtil.replace((String)ifClause, (String)line, (String)newLine);
    }

    protected String fixIncorrectEmptyLineBeforeCloseCurlyBrace(String content, String fileName) {
        if (fileName.endsWith("AnnotationLocatorTest.java")) {
            return content;
        }
        Matcher matcher = this._incorrectCloseCurlyBracePattern.matcher(content);
        while (matcher.find()) {
            String tabs = matcher.group(1);
            int tabCount = tabs.length();
            int pos = matcher.start();
            while (content.charAt((pos = content.lastIndexOf("\n" + tabs, pos - 1)) + tabCount + 1) == '\t') {
            }
            String codeBlock = content.substring(pos + tabCount + 1);
            String firstLine = codeBlock.substring(0, codeBlock.indexOf("\n"));
            if (firstLine.contains(" class ") || firstLine.contains(" enum ") || firstLine.contains(" interface ") || firstLine.startsWith("new ") || firstLine.contains(" new ")) continue;
            return StringUtil.replaceFirst((String)content, (String)("\n\n" + tabs + "}\n"), (String)("\n" + tabs + "}\n"), (int)pos);
        }
        return content;
    }

    protected String fixJavaTermsDividers(String fileName, String content, Set<JavaTerm> javaTerms) {
        JavaTerm previousJavaTerm = null;
        for (JavaTerm javaTerm : javaTerms) {
            if (previousJavaTerm == null) {
                previousJavaTerm = javaTerm;
                continue;
            }
            String javaTermContent = javaTerm.getContent();
            if (javaTermContent.startsWith("\t//") || javaTermContent.contains("\tstatic {")) {
                previousJavaTerm = javaTerm;
                continue;
            }
            String previousJavaTermContent = previousJavaTerm.getContent();
            if (previousJavaTermContent.startsWith("\t//") || previousJavaTermContent.contains("\tstatic {")) {
                previousJavaTerm = javaTerm;
                continue;
            }
            String javaTermName = javaTerm.getName();
            String excluded = null;
            if (this._javaTermSortExclusions != null) {
                excluded = this._javaTermSortExclusions.getProperty(String.valueOf(fileName) + "@" + javaTerm.getLineCount());
                if (excluded == null) {
                    excluded = this._javaTermSortExclusions.getProperty(String.valueOf(fileName) + "@" + javaTermName);
                }
                if (excluded == null) {
                    excluded = this._javaTermSortExclusions.getProperty(fileName);
                }
            }
            if (excluded != null) {
                previousJavaTerm = javaTerm;
                continue;
            }
            String previousJavaTermName = previousJavaTerm.getName();
            boolean requiresEmptyLine = false;
            if (previousJavaTerm.getType() != javaTerm.getType()) {
                requiresEmptyLine = true;
            } else if (!JavaSourceProcessor.isInJavaTermTypeGroup(javaTerm.getType(), TYPE_VARIABLE)) {
                requiresEmptyLine = true;
            } else if (StringUtil.isUpperCase((String)javaTermName) && !StringUtil.isLowerCase((String)javaTermName) || StringUtil.isUpperCase((String)previousJavaTermName) && !StringUtil.isLowerCase((String)previousJavaTermName)) {
                requiresEmptyLine = true;
            } else if (this.hasAnnotationCommentOrJavadoc(javaTermContent) || this.hasAnnotationCommentOrJavadoc(previousJavaTermContent)) {
                requiresEmptyLine = true;
            } else if (previousJavaTerm.getType() == 21 && (previousJavaTermName.equals("_log") || previousJavaTermName.equals("_instance"))) {
                requiresEmptyLine = true;
            } else if (previousJavaTermContent.contains("\n\n\t") || javaTermContent.contains("\n\n\t")) {
                requiresEmptyLine = true;
            }
            if (requiresEmptyLine) {
                if (!content.contains("\n\n" + javaTermContent)) {
                    return StringUtil.replace((String)content, (String)("\n" + javaTermContent), (String)("\n\n" + javaTermContent));
                }
            } else if (content.contains("\n\n" + javaTermContent)) {
                return StringUtil.replace((String)content, (String)("\n\n" + javaTermContent), (String)("\n" + javaTermContent));
            }
            previousJavaTerm = javaTerm;
        }
        return content;
    }

    @Override
    protected void format() throws Exception {
        Collection<String> fileNames = null;
        if (portalSource) {
            fileNames = this.getPortalJavaFiles();
            this._checkUnprocessedExceptions = GetterUtil.getBoolean((String)System.getProperty("source.formatter.check.unprocessed.exceptions"));
        } else {
            fileNames = this.getPluginJavaFiles();
        }
        this._javaTermSortExclusions = this.getExclusionsProperties("source_formatter_javaterm_sort_exclusions.properties");
        this._lineLengthExclusions = this.getExclusionsProperties("source_formatter_line_length_exclusions.properties");
        this._staticLogVariableExclusions = this.getExclusionsProperties("source_formatter_static_log_exclusions.properties");
        this._upgradeServiceUtilExclusions = this.getExclusionsProperties("source_formatter_upgrade_service_util_exclusions.properties");
        for (String fileName : fileNames) {
            this.format(fileName);
        }
    }

    @Override
    protected String format(String fileName) throws Exception {
        String logClassName;
        Matcher matcher;
        int packagePathY;
        if (fileName.endsWith("SourceProcessor.java")) {
            return null;
        }
        File file = new File("./" + fileName);
        fileName = StringUtil.replace((String)fileName, (String)"\\", (String)"/");
        String content = fileUtil.read(file);
        if (this.isGenerated(content) && !fileName.endsWith("JavadocFormatter.java")) {
            return null;
        }
        String className = file.getName();
        className = className.substring(0, className.length() - 5);
        String packagePath = fileName;
        int packagePathX = packagePath.indexOf("/src/");
        packagePath = packagePathX + 5 >= (packagePathY = packagePath.lastIndexOf("/")) ? "" : packagePath.substring(packagePathX + 5, packagePathY);
        if ((packagePath = StringUtil.replace((String)packagePath, (String)"/", (String)".")).endsWith(".model") && content.contains("extends " + className + "Model")) {
            return null;
        }
        String newContent = content;
        if (newContent.contains("$\n */")) {
            this.processErrorMessage(fileName, "*: " + fileName);
            newContent = StringUtil.replace((String)newContent, (String)"$\n */", (String)"$\n *\n */");
        }
        if ((newContent = this.fixCopyright(newContent, this.getCopyright(), this.getOldCopyright(), file, fileName)).contains(String.valueOf(className) + ".java.html")) {
            this.processErrorMessage(fileName, "Java2HTML: " + fileName);
        }
        if (newContent.contains(" * @author Raymond Aug") && !newContent.contains(" * @author Raymond Aug\u00e9")) {
            newContent = newContent.replaceFirst("Raymond Aug.++", "Raymond Aug\u00e9");
            this.processErrorMessage(fileName, "UTF-8: " + fileName);
        }
        newContent = this.fixDataAccessConnection(className, newContent);
        newContent = this.fixSessionKey(fileName, newContent, sessionKeyPattern);
        newContent = StringUtil.replace((String)newContent, (String[])new String[]{"com.liferay.portal.PortalException", "com.liferay.portal.SystemException", "com.liferay.util.LocalizationUtil", "private static final Log _log"}, (String[])new String[]{"com.liferay.portal.kernel.exception.PortalException", "com.liferay.portal.kernel.exception.SystemException", "com.liferay.portal.kernel.util.LocalizationUtil", "private static Log _log"});
        newContent = this.fixCompatClassImports(file, newContent);
        newContent = JavaSourceProcessor.stripJavaImports(newContent, packagePath, className);
        newContent = StringUtil.replace((String)newContent, (String[])new String[]{";\n/**", "\t/*\n\t *", "catch(", "else{", "if(", "for(", "while(", "List <", "){\n", "]{\n"}, (String[])new String[]{";\n\n/**", "\t/**\n\t *", "catch (", "else {", "if (", "for (", "while (", "List<", ") {\n", "] {\n"});
        while ((matcher = this._incorrectLineBreakPattern.matcher(newContent)).find()) {
            newContent = StringUtil.replaceFirst((String)newContent, (String)"\n", (String)"", (int)matcher.start());
        }
        matcher = this._logPattern.matcher(newContent);
        if (matcher.find() && !(logClassName = matcher.group(1)).equals(className)) {
            newContent = StringUtil.replaceLast((String)newContent, (String)(String.valueOf(logClassName) + ".class)"), (String)(String.valueOf(className) + ".class)"));
        }
        String excluded = null;
        if (this._staticLogVariableExclusions != null) {
            excluded = this._staticLogVariableExclusions.getProperty(fileName);
        }
        if (excluded == null) {
            newContent = StringUtil.replace((String)newContent, (String)"private Log _log", (String)"private static Log _log");
        }
        if (newContent.contains("*/\npackage ")) {
            this.processErrorMessage(fileName, "package: " + fileName);
        }
        if (!newContent.endsWith("\n\n}") && !newContent.endsWith("{\n}")) {
            this.processErrorMessage(fileName, "}: " + fileName);
        }
        if (portalSource && !className.equals("BaseServiceImpl") && className.endsWith("ServiceImpl") && newContent.contains("ServiceUtil.")) {
            this.processErrorMessage(fileName, "ServiceUtil: " + fileName);
        }
        excluded = null;
        if (this._upgradeServiceUtilExclusions != null) {
            excluded = this._upgradeServiceUtilExclusions.getProperty(fileName);
        }
        if (excluded == null && portalSource && fileName.contains("/portal/upgrade/") && !fileName.contains("/test/") && newContent.contains("ServiceUtil.")) {
            this.processErrorMessage(fileName, "ServiceUtil: " + fileName);
        }
        if (!className.equals("DeepNamedValueScanner") && !className.equals("ProxyUtil") && newContent.contains("import java.lang.reflect.Proxy;")) {
            this.processErrorMessage(fileName, "Proxy: " + fileName);
        }
        if (newContent.contains("import edu.emory.mathcs.backport.java")) {
            this.processErrorMessage(fileName, "edu.emory.mathcs.backport.java: " + fileName);
        }
        if (newContent.contains("import jodd.util.StringPool")) {
            this.processErrorMessage(fileName, "jodd.util.StringPool: " + fileName);
        }
        int pos1 = -1;
        while ((pos1 = newContent.indexOf("\ttry {", pos1 + 1)) != -1) {
            int pos2 = newContent.indexOf("\ttry {", pos1 + 1);
            int pos3 = newContent.indexOf("\"select count(", pos1);
            if (pos2 != -1 && pos3 != -1 && pos2 < pos3) continue;
            int pos4 = newContent.indexOf("rs.getLong(1)", pos1);
            int pos5 = newContent.indexOf("\tfinally {", pos1);
            if (pos3 == -1 || pos4 == -1 || pos5 == -1) break;
            if (pos3 >= pos4 || pos4 >= pos5) continue;
            this.processErrorMessage(fileName, "Use getInt(1) for count: " + fileName);
        }
        if (content.contains("implements ProcessCallable") && !content.contains("private static final long serialVersionUID")) {
            this.processErrorMessage(fileName, "Assign ProcessCallable implementation a serialVersionUID: " + fileName);
        }
        this.checkLanguageKeys(fileName, newContent, languageKeyPattern);
        newContent = StringUtil.replace((String)newContent, (String)"\tfor (;;) {", (String)"\twhile (true) {");
        if (this._checkUnprocessedExceptions && !fileName.contains("/test/")) {
            this.checkUnprocessedExceptions(newContent, file, packagePath, fileName);
        }
        if (!fileName.contains("SecureRandomUtil") && content.contains("java.security.SecureRandom") && !content.contains("javax.crypto.KeyGenerator")) {
            this.processErrorMessage(fileName, "Use SecureRandomUtil instead of java.security.SecureRandom: " + fileName);
        }
        String oldContent = newContent;
        while (true) {
            newContent = this.fixIncorrectEmptyLineBeforeCloseCurlyBrace(oldContent, fileName);
            newContent = this.formatJava(fileName, newContent);
            if (oldContent.equals(newContent = StringUtil.replace((String)newContent, (String)"\n\n\n", (String)"\n\n"))) break;
            oldContent = newContent;
        }
        if (this.isAutoFix() && newContent != null && !content.equals(newContent)) {
            fileUtil.write(file, newContent);
            sourceFormatterHelper.printError(fileName, file);
        }
        return newContent;
    }

    protected String formatAnnotations(String fileName, String content, Set<JavaTerm> javaTerms) throws IOException {
        block0: for (JavaTerm javaTerm : javaTerms) {
            if (fileName.contains("/test/") && !fileName.endsWith("TestBean.java") && !fileName.endsWith("TestCase.java")) {
                this.checkTestAnnotations(javaTerm, fileName);
            }
            while (true) {
                String javaTermContent = javaTerm.getContent();
                javaTerm.sortAnnotations();
                String newJavaTermContent = javaTerm.getContent();
                if (javaTermContent.equals(newJavaTermContent)) continue block0;
                content = content.replace(javaTermContent, newJavaTermContent);
            }
        }
        return content;
    }

    protected String formatJava(String fileName, String content) throws IOException {
        StringBundler sb = new StringBundler();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(content));
        int index = 0;
        int lineCount = 0;
        String line = null;
        String previousLine = "";
        int lineToSkipIfEmpty = 0;
        TreeSet<JavaTerm> javaTerms = new TreeSet<JavaTerm>(new JavaTermComparator());
        JavaTerm javaTerm = null;
        String javaTermName = null;
        int javaTermLineCount = -1;
        int javaTermStartPosition = -1;
        int javaTermType = -1;
        boolean readParameterTypes = false;
        List<String> parameterTypes = new ArrayList<String>();
        int lastCommentOrAnnotationPos = -1;
        String ifClause = "";
        String packageName = "";
        while ((line = unsyncBufferedReader.readLine()) != null) {
            String linePart;
            ++lineCount;
            if ((line = this.trimLine(line, false)).startsWith("package ")) {
                packageName = line.substring(8, line.length() - 1);
            }
            if (line.startsWith("import ")) {
                String importPackageName;
                int pos;
                if (line.endsWith(".*;")) {
                    this.processErrorMessage(fileName, "import: " + fileName + " " + lineCount);
                }
                if ((pos = line.lastIndexOf(".")) != -1 && (importPackageName = line.substring(7, pos)).equals(packageName)) continue;
            }
            if (line.contains("\tfor (") && line.contains(":") && !line.contains(" :")) {
                line = StringUtil.replace((String)line, (String)":", (String)" :");
            }
            line = this.replacePrimitiveWrapperInstantiation(fileName, line, lineCount);
            String trimmedLine = StringUtil.trimLeading((String)line);
            this.checkStringBundler(trimmedLine, fileName, lineCount);
            if (trimmedLine.startsWith("* @deprecated") && mainReleaseVersion.equals("6.2.0")) {
                if (!trimmedLine.startsWith("* @deprecated As of ")) {
                    line = StringUtil.replace((String)line, (String)"* @deprecated", (String)"* @deprecated As of 6.2.0");
                } else {
                    String version = trimmedLine.substring(20);
                    version = StringUtil.split((String)version, (String)" ")[0];
                    if (StringUtil.count((String)(version = StringUtil.replace((String)version, (String)",", (String)"")), (String)".") == 1) {
                        line = StringUtil.replaceFirst((String)line, (String)version, (String)(String.valueOf(version) + ".0"));
                    }
                }
            }
            this.checkInefficientStringMethods(line, fileName, lineCount);
            if (trimmedLine.startsWith("=")) {
                this.processErrorMessage(fileName, "equal: " + fileName + " " + lineCount);
            }
            if (line.contains("ActionForm form")) {
                this.processErrorMessage(fileName, "Rename form to actionForm: " + fileName + " " + lineCount);
            }
            if (line.contains("ActionMapping mapping")) {
                this.processErrorMessage(fileName, "Rename mapping to ActionMapping: " + fileName + " " + lineCount);
            }
            if (fileName.contains("/upgrade/") && line.contains("rs.getDate(")) {
                this.processErrorMessage(fileName, "Use rs.getTimeStamp: " + fileName + " " + lineCount);
            }
            if (!trimmedLine.equals("{") && line.endsWith("{") && !line.endsWith(" {")) {
                line = StringUtil.replaceLast((String)line, (String)"{", (String)" {");
            }
            line = this.sortExceptions(line);
            if (trimmedLine.startsWith("if (") || trimmedLine.startsWith("else if (") || trimmedLine.startsWith("while (") || Validator.isNotNull((String)ifClause)) {
                ifClause = String.valueOf(ifClause) + line + "\n";
                if (line.endsWith(") {")) {
                    String newIfClause = this.checkIfClause(ifClause, fileName, lineCount);
                    if (!ifClause.equals(newIfClause)) {
                        return StringUtil.replace((String)content, (String)ifClause, (String)newIfClause);
                    }
                    ifClause = "";
                } else if (line.endsWith(";")) {
                    ifClause = "";
                }
            }
            String excluded = null;
            if (line.startsWith("\tprivate ") || line.equals("\tprivate") || line.startsWith("\tprotected ") || line.equals("\tprotected") || line.startsWith("\tpublic ") || line.equals("\tpublic")) {
                Tuple tuple = this.getJavaTermTuple(line, content, index, 1, 3);
                if (tuple != null) {
                    int javaTermEndPosition = 0;
                    javaTermEndPosition = lastCommentOrAnnotationPos == -1 ? index : lastCommentOrAnnotationPos;
                    if (javaTermStartPosition != -1 && javaTermEndPosition < content.length()) {
                        String javaTermContent = content.substring(javaTermStartPosition, javaTermEndPosition);
                        if (Validator.isNotNull((String)javaTermName)) {
                            javaTerm = new JavaTerm(javaTermName, javaTermType, parameterTypes, javaTermContent, javaTermLineCount);
                            javaTerms.add(javaTerm);
                        }
                    }
                    javaTermLineCount = lineCount;
                    javaTermName = (String)tuple.getObject(0);
                    javaTermStartPosition = javaTermEndPosition;
                    javaTermType = (Integer)tuple.getObject(1);
                    if (Validator.isNotNull((String)javaTermName) && (JavaSourceProcessor.isInJavaTermTypeGroup(javaTermType, TYPE_CONSTRUCTOR) || JavaSourceProcessor.isInJavaTermTypeGroup(javaTermType, TYPE_METHOD))) {
                        readParameterTypes = true;
                        parameterTypes = new ArrayList();
                    }
                }
                lastCommentOrAnnotationPos = -1;
            } else if (this.hasAnnotationCommentOrJavadoc(line) && lastCommentOrAnnotationPos == -1) {
                lastCommentOrAnnotationPos = index;
            }
            if (readParameterTypes) {
                parameterTypes = this.addParameterTypes(trimmedLine, parameterTypes);
                if (trimmedLine.contains(")")) {
                    readParameterTypes = false;
                }
            }
            if (!trimmedLine.contains("//") && !trimmedLine.startsWith("*")) {
                int y;
                String strippedQuotesLine = this.stripQuotes(trimmedLine, '\"');
                int x = -1;
                while ((x = strippedQuotesLine.indexOf("=", x + 1)) != -1) {
                    char c2 = strippedQuotesLine.charAt(x - 1);
                    if (Character.isLetterOrDigit(c2)) {
                        line = StringUtil.replace((String)line, (String)(String.valueOf(c2) + "="), (String)(String.valueOf(c2) + " ="));
                        break;
                    }
                    if (x == strippedQuotesLine.length() - 1) break;
                    c2 = strippedQuotesLine.charAt(x + 1);
                    if (!Character.isLetterOrDigit(c2)) continue;
                    line = StringUtil.replace((String)line, (String)("=" + c2), (String)("= " + c2));
                    break;
                }
                while (trimmedLine.contains("\t")) {
                    line = StringUtil.replaceLast((String)line, (String)"\t", (String)" ");
                    trimmedLine = StringUtil.replaceLast((String)trimmedLine, (String)"\t", (String)" ");
                }
                if (!(!line.contains("\t ") || previousLine.endsWith("&&") || previousLine.endsWith("||") || previousLine.contains("\t((") || previousLine.contains("\t<") || previousLine.contains("\t ") || previousLine.contains("\timplements ") || previousLine.contains("\tthrows "))) {
                    line = StringUtil.replace((String)line, (String)"\t ", (String)"\t");
                }
                while (trimmedLine.contains("  ") && !trimmedLine.contains("\"  ") && !fileName.contains("Test")) {
                    line = StringUtil.replaceLast((String)line, (String)"  ", (String)" ");
                    trimmedLine = StringUtil.replaceLast((String)trimmedLine, (String)"  ", (String)" ");
                }
                if (!line.contains("\"")) {
                    int pos = line.indexOf(") ");
                    if (pos != -1 && Character.isLetter((linePart = line.substring(pos + 2)).charAt(0)) && !linePart.startsWith("default") && !linePart.startsWith("instanceof") && !linePart.startsWith("throws")) {
                        line = StringUtil.replaceLast((String)line, (String)(" " + linePart), (String)linePart);
                    }
                    if ((trimmedLine.startsWith("private ") || trimmedLine.startsWith("protected ") || trimmedLine.startsWith("public ")) && !line.contains("=") && line.contains(" (")) {
                        line = StringUtil.replace((String)line, (String)" (", (String)"(");
                    }
                    if (line.contains(" [")) {
                        line = StringUtil.replace((String)line, (String)" [", (String)"[");
                    }
                    int x2 = -1;
                    while (true) {
                        char previousChar;
                        char nextChar;
                        int posComma = line.indexOf(",", x2 + 1);
                        int posSemicolon = line.indexOf(";", x2 + 1);
                        if (posComma == -1 && posSemicolon == -1) break;
                        x2 = Math.min(posComma, posSemicolon);
                        if (x2 == -1) {
                            x2 = Math.max(posComma, posSemicolon);
                        }
                        if (line.length() > x2 + 1 && (nextChar = line.charAt(x2 + 1)) != '\'' && nextChar != ')' && nextChar != ' ' && nextChar != '*') {
                            line = StringUtil.insert((String)line, (String)" ", (int)(x2 + 1));
                        }
                        if (x2 <= 0 || (previousChar = line.charAt(x2 - 1)) != ' ') continue;
                        line = line.substring(0, x2 - 1).concat(line.substring(x2));
                    }
                }
                if ((line.contains(" && ") || line.contains(" || ")) && line.endsWith("(")) {
                    this.processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                }
                if (trimmedLine.endsWith("+") && !trimmedLine.startsWith("(")) {
                    int closeParenthesisCount = StringUtil.count((String)strippedQuotesLine, (String)")");
                    int openParenthesisCount = StringUtil.count((String)strippedQuotesLine, (String)"(");
                    if (openParenthesisCount > closeParenthesisCount) {
                        this.processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                    }
                }
                if (line.contains(",") && !line.contains(")") && !line.contains(">") && !line.contains("\"") && line.endsWith("(")) {
                    this.processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                }
                if ((line.endsWith(" +") || line.endsWith(" -") || line.endsWith(" *") || line.endsWith(" /")) && (x = line.indexOf(" = ")) != -1 && ((y = line.indexOf("\"")) == -1 || x < y)) {
                    this.processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                }
                if (line.endsWith(" throws") || previousLine.endsWith("(") && line.contains(" throws ") && line.endsWith("{")) {
                    this.processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                }
                if (trimmedLine.startsWith(".") || line.endsWith(".") && line.contains("=")) {
                    this.processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                }
                if (trimmedLine.startsWith("}") && line.endsWith("{")) {
                    this.processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                }
            }
            if (line.contains("    ") && !line.matches("\\s*\\*.*") && !fileName.endsWith("StringPool.java")) {
                this.processErrorMessage(fileName, "tab: " + fileName + " " + lineCount);
            }
            if (line.contains("  {") && !line.matches("\\s*\\*.*")) {
                this.processErrorMessage(fileName, "{:" + fileName + " " + lineCount);
            }
            excluded = null;
            if (this._lineLengthExclusions != null && (excluded = this._lineLengthExclusions.getProperty(String.valueOf(fileName) + "@" + lineCount)) == null) {
                excluded = this._lineLengthExclusions.getProperty(fileName);
            }
            Tuple combinedLines = null;
            int lineLength = this.getLineLength(line);
            if (!(excluded != null || line.startsWith("import ") || line.startsWith("package ") || line.matches("\\s*\\*.*") || fileName.endsWith("Table.java") && line.contains("String TABLE_SQL_CREATE = ") || fileName.endsWith("Table.java") && line.contains("String TABLE_SQL_DROP = ") || fileName.endsWith("Table.java") && line.contains(" index IX_"))) {
                if (lineLength > 80) {
                    this.processErrorMessage(fileName, "> 80: " + fileName + " " + lineCount);
                } else {
                    int lineLeadingTabCount = this.getLeadingTabCount(line);
                    int previousLineLeadingTabCount = this.getLeadingTabCount(previousLine);
                    if (!trimmedLine.startsWith("//")) {
                        int diff;
                        int x;
                        if (previousLine.endsWith(",") && previousLine.contains("(") && !previousLine.contains("for (") && lineLeadingTabCount > previousLineLeadingTabCount) {
                            this.processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                        }
                        if (Validator.isNotNull((String)trimmedLine)) {
                            if ((previousLine.endsWith(":") && previousLine.contains("\tfor ") || previousLine.endsWith("(") && previousLine.contains("\tif ")) && previousLineLeadingTabCount + 2 != lineLeadingTabCount) {
                                this.processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                            }
                            if (previousLine.endsWith("{") && !trimmedLine.startsWith("}") && previousLineLeadingTabCount + 1 != lineLeadingTabCount) {
                                this.processErrorMessage(fileName, "tab: " + fileName + " " + lineCount);
                            }
                        }
                        if (previousLine.endsWith(".") && (x = trimmedLine.indexOf("(")) != -1 && this.getLineLength(previousLine) + x < 80 && (trimmedLine.endsWith("(") || trimmedLine.charAt(x + 1) != ')')) {
                            this.processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                        }
                        if (trimmedLine.startsWith("throws ") && ((diff = lineLeadingTabCount - previousLineLeadingTabCount) == 0 || diff > 1)) {
                            this.processErrorMessage(fileName, "tab: " + fileName + " " + lineCount);
                        }
                        if ((previousLine.contains(" class ") || previousLine.contains(" enum ")) && previousLine.endsWith("{") && Validator.isNotNull((String)line) && !trimmedLine.startsWith("}")) {
                            this.processErrorMessage(fileName, "new line: " + fileName + " " + lineCount);
                        }
                    }
                    combinedLines = this.getCombinedLines(trimmedLine, previousLine, lineLeadingTabCount, previousLineLeadingTabCount);
                }
            }
            if (combinedLines != null) {
                previousLine = (String)combinedLines.getObject(0);
                if (combinedLines.getSize() > 1) {
                    linePart = (String)combinedLines.getObject(1);
                    boolean addToPreviousLine = (Boolean)combinedLines.getObject(2);
                    if (addToPreviousLine) {
                        previousLine = String.valueOf(previousLine) + linePart;
                        line = StringUtil.replaceFirst((String)line, (String)linePart, (String)"");
                    } else if (linePart.length() + lineLength <= 80 && (line.endsWith("{") || line.endsWith(";"))) {
                        previousLine = StringUtil.replaceLast((String)previousLine, (String)StringUtil.trim((String)linePart), (String)"");
                        line = StringUtil.replaceLast((String)line, (String)"\t", (String)("\t" + linePart));
                    } else {
                        this.processErrorMessage(fileName, "line break: " + fileName + " " + lineCount);
                    }
                    sb.append(previousLine);
                    sb.append("\n");
                    previousLine = line;
                } else if (line.endsWith("{") && !previousLine.contains(" class ")) {
                    lineToSkipIfEmpty = lineCount + 1;
                }
            } else {
                if (lineCount > 1 && (Validator.isNotNull((String)previousLine) || lineToSkipIfEmpty != lineCount - 1)) {
                    sb.append(previousLine);
                    if (Validator.isNotNull((String)previousLine) && Validator.isNotNull((String)trimmedLine) && !previousLine.contains("/*") && !previousLine.endsWith("*/")) {
                        String trimmedPreviousLine = StringUtil.trimLeading((String)previousLine);
                        if (trimmedPreviousLine.startsWith("// ") && !trimmedLine.startsWith("// ") || !trimmedPreviousLine.startsWith("// ") && trimmedLine.startsWith("// ")) {
                            sb.append("\n");
                        } else if (!trimmedPreviousLine.endsWith("{") && !trimmedPreviousLine.endsWith(":") && (trimmedLine.startsWith("for (") || trimmedLine.startsWith("if ("))) {
                            sb.append("\n");
                        } else if (!(!previousLine.endsWith("\t}") || trimmedLine.startsWith("}") || trimmedLine.startsWith(")") || trimmedLine.startsWith("//") || trimmedLine.startsWith("catch ") || trimmedLine.startsWith("else ") || trimmedLine.startsWith("finally ") || trimmedLine.startsWith("while "))) {
                            sb.append("\n");
                        }
                    }
                    sb.append("\n");
                }
                previousLine = line;
            }
            index = index + line.length() + 1;
        }
        sb.append(previousLine);
        unsyncBufferedReader.close();
        String newContent = sb.toString();
        if (newContent.endsWith("\n")) {
            newContent = newContent.substring(0, newContent.length() - 1);
        }
        if (content.equals(newContent)) {
            if (javaTermStartPosition != -1) {
                int javaTermEndPosition = content.length() - 2;
                String javaTermContent = content.substring(javaTermStartPosition, javaTermEndPosition);
                javaTerm = new JavaTerm(javaTermName, javaTermType, parameterTypes, javaTermContent, javaTermLineCount);
                javaTerms.add(javaTerm);
            }
            newContent = this.sortJavaTerms(fileName, content, javaTerms);
        }
        if (content.equals(newContent)) {
            newContent = this.fixJavaTermsDividers(fileName, content, javaTerms);
        }
        if (content.equals(newContent)) {
            newContent = this.formatAnnotations(fileName, content, javaTerms);
        }
        return newContent;
    }

    protected String getClassName(String line) {
        int pos = line.indexOf(" implements ");
        if (pos == -1) {
            pos = line.indexOf(" extends ");
        }
        if (pos == -1) {
            pos = line.indexOf("{");
        }
        if (pos != -1) {
            line = line.substring(0, pos);
        }
        line = line.trim();
        pos = line.lastIndexOf(" ");
        return line.substring(pos + 1);
    }

    protected Tuple getCombinedLines(String line, String previousLine, int lineTabCount, int previousLineTabCount) {
        String filePart;
        int pos;
        if (Validator.isNull((String)line) || Validator.isNull((String)previousLine)) {
            return null;
        }
        String trimmedPreviousLine = StringUtil.trimLeading((String)previousLine);
        int previousLineLength = this.getLineLength(previousLine);
        if (line.startsWith("// ") && trimmedPreviousLine.startsWith("// ")) {
            String linePart = line.substring(3);
            if (!linePart.startsWith("PLACEHOLDER") && !linePart.startsWith("[")) {
                int pos2 = linePart.indexOf(" ");
                if (pos2 == -1) {
                    pos2 = linePart.length();
                }
                if (previousLineLength + pos2 < 80) {
                    if (linePart.contains(" ")) {
                        return new Tuple(new Object[]{String.valueOf(previousLine) + " ", linePart.substring(0, pos2 + 1), true});
                    }
                    return new Tuple(new Object[]{String.valueOf(previousLine) + " " + linePart});
                }
            }
            return null;
        }
        if (line.startsWith("// ") || trimmedPreviousLine.startsWith("// ")) {
            return null;
        }
        if (previousLine.endsWith(" extends")) {
            return new Tuple(new Object[]{previousLine, "extends ", false});
        }
        if (previousLine.endsWith(" implements")) {
            return new Tuple(new Object[]{previousLine, "implements ", false});
        }
        if (line.startsWith("+ ") || line.startsWith("- ") || line.startsWith("|| ") || line.startsWith("&& ")) {
            int pos3 = line.indexOf(" ");
            String linePart = line.substring(0, pos3);
            return new Tuple(new Object[]{String.valueOf(previousLine) + " ", linePart, true});
        }
        if (line.length() + previousLineLength < 80) {
            if (trimmedPreviousLine.startsWith("for ") && previousLine.endsWith(":") && line.endsWith("{")) {
                return new Tuple(new Object[]{String.valueOf(previousLine) + " " + line});
            }
            if ((previousLine.endsWith("=") || previousLine.endsWith(".") || trimmedPreviousLine.equals("return")) && line.endsWith(";")) {
                return new Tuple(new Object[]{String.valueOf(previousLine) + " " + line});
            }
            if ((trimmedPreviousLine.startsWith("if ") || trimmedPreviousLine.startsWith("else ")) && (previousLine.endsWith("||") || previousLine.endsWith("&&")) && line.endsWith("{")) {
                return new Tuple(new Object[]{String.valueOf(previousLine) + " " + line});
            }
            if ((line.startsWith("extends ") || line.startsWith("implements ") || line.startsWith("throws")) && line.endsWith("{") && lineTabCount == previousLineTabCount + 1) {
                return new Tuple(new Object[]{String.valueOf(previousLine) + " " + line});
            }
        }
        if (previousLine.endsWith("=") && line.endsWith(";")) {
            String tempLine = line;
            int pos4 = 0;
            while (true) {
                int closeParenthesisCount;
                if ((pos4 = tempLine.indexOf("-")) == -1) {
                    pos4 = tempLine.indexOf("+");
                }
                if (pos4 == -1) {
                    pos4 = tempLine.indexOf("/");
                }
                if (pos4 == -1) {
                    pos4 = tempLine.indexOf("*");
                }
                if (pos4 == -1) {
                    pos4 = tempLine.indexOf("||");
                }
                if (pos4 == -1) {
                    pos4 = tempLine.indexOf("&&");
                }
                if (pos4 == -1) break;
                String linePart = tempLine.substring(0, pos4);
                int openParenthesisCount = StringUtil.count((String)linePart, (String)"(");
                if (openParenthesisCount == (closeParenthesisCount = StringUtil.count((String)linePart, (String)")"))) {
                    return null;
                }
                tempLine = String.valueOf(tempLine.substring(0, pos4)) + tempLine.substring(pos4 + 1);
            }
            int x = line.indexOf("(");
            if (x == 0) {
                x = line.indexOf("(", 1);
            }
            if (x != -1) {
                char previousChar;
                int y = line.indexOf(")", x);
                int z = line.indexOf("\"");
                if (x + 1 != y && (z == -1 || z > x) && (previousChar = line.charAt(x - 1)) != ')' && previousChar != '(' && previousChar != ' ' && previousLineLength + 1 + x < 80) {
                    String linePart = line.substring(0, x + 1);
                    if (linePart.startsWith("(") && !linePart.contains(")")) {
                        return null;
                    }
                    return new Tuple(new Object[]{String.valueOf(previousLine) + " ", linePart, true});
                }
            }
        }
        if (previousLine.endsWith(",") && previousLineTabCount == lineTabCount && !previousLine.contains("}")) {
            int x = line.indexOf(",");
            if (x != -1) {
                while (previousLineLength + 1 + x < 80) {
                    String linePart = line.substring(0, x + 1);
                    if (this.isValidJavaParameter(linePart)) {
                        if (line.equals(linePart)) {
                            return new Tuple(new Object[]{String.valueOf(previousLine) + " " + linePart});
                        }
                        return new Tuple(new Object[]{String.valueOf(previousLine) + " ", String.valueOf(linePart) + " ", true});
                    }
                    String partAfterComma = line.substring(x + 1);
                    int pos5 = partAfterComma.indexOf(",");
                    if (pos5 != -1) {
                        x = x + pos5 + 1;
                        continue;
                    }
                    break;
                }
            } else if (!(line.endsWith("(") || line.endsWith("+") || line.endsWith(".") || line.startsWith("new ") && line.endsWith("{") || line.length() + previousLineLength >= 80)) {
                return new Tuple(new Object[]{String.valueOf(previousLine) + " " + line});
            }
        }
        if (!previousLine.endsWith("(")) {
            return null;
        }
        if (StringUtil.count((String)previousLine, (String)"(") > 1 && (pos = trimmedPreviousLine.lastIndexOf("(", trimmedPreviousLine.length() - 2)) > 0 && Character.isLetterOrDigit(trimmedPreviousLine.charAt(pos - 1)) && !(filePart = trimmedPreviousLine.substring(pos + 1)).contains(")") && !filePart.contains("\"")) {
            return new Tuple(new Object[]{previousLine, filePart, false});
        }
        if (line.length() + previousLineLength > 80) {
            return null;
        }
        if (line.endsWith(";")) {
            return new Tuple(new Object[]{String.valueOf(previousLine) + line});
        }
        if ((line.endsWith("{") && !line.startsWith("new ") || line.endsWith(")")) && (trimmedPreviousLine.startsWith("else ") || trimmedPreviousLine.startsWith("if ") || trimmedPreviousLine.startsWith("private ") || trimmedPreviousLine.startsWith("protected ") || trimmedPreviousLine.startsWith("public "))) {
            return new Tuple(new Object[]{String.valueOf(previousLine) + line});
        }
        return null;
    }

    protected String getConstructorOrMethodName(String line, int pos) {
        line = line.substring(0, pos);
        int x = line.lastIndexOf(" ");
        return line.substring(x + 1);
    }

    protected List<String> getImportedExceptionClassNames(JavaDocBuilder javaDocBuilder) {
        ArrayList<String> exceptionClassNames = new ArrayList<String>();
        JavaSource javaSource = javaDocBuilder.getSources()[0];
        String[] stringArray = javaSource.getImports();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String importClassName = stringArray[n2];
            if (importClassName.endsWith("Exception") && !exceptionClassNames.contains(importClassName)) {
                exceptionClassNames.add(importClassName);
            }
            ++n2;
        }
        return exceptionClassNames;
    }

    protected Tuple getJavaTermTuple(String line, String content, int index, int numLines, int maxLines) {
        int spaceCount;
        int pos = line.indexOf("(");
        if (line.startsWith("\tpublic static final ") && (line.contains("=") || line.endsWith(";") && pos == -1)) {
            return new Tuple(new Object[]{this.getVariableName(line), 1});
        }
        if (line.startsWith("\tpublic static ")) {
            if (line.startsWith("\tpublic static class ") || line.startsWith("\tpublic static enum") || line.startsWith("\tpublic static interface")) {
                return new Tuple(new Object[]{this.getClassName(line), 7});
            }
            if (line.contains("=") || line.endsWith(";") && pos == -1) {
                return new Tuple(new Object[]{this.getVariableName(line), 2});
            }
            if (pos != -1) {
                return new Tuple(new Object[]{this.getConstructorOrMethodName(line, pos), 3});
            }
        } else if (line.startsWith("\tpublic ")) {
            if (line.startsWith("\tpublic abstract class ") || line.startsWith("\tpublic class ") || line.startsWith("\tpublic enum ") || line.startsWith("\tpublic interface ")) {
                return new Tuple(new Object[]{this.getClassName(line), 8});
            }
            if (line.contains("=") || line.endsWith(";") && pos == -1) {
                return new Tuple(new Object[]{this.getVariableName(line), 6});
            }
            if (pos != -1) {
                spaceCount = StringUtil.count((String)line.substring(0, pos), (String)" ");
                if (spaceCount == 1) {
                    return new Tuple(new Object[]{this.getConstructorOrMethodName(line, pos), 4});
                }
                if (spaceCount > 1) {
                    return new Tuple(new Object[]{this.getConstructorOrMethodName(line, pos), 5});
                }
            }
        } else if (line.startsWith("\tprotected static final ")) {
            if (line.contains("=") || line.endsWith(";") && pos == -1) {
                return new Tuple(new Object[]{this.getVariableName(line), 12});
            }
        } else if (line.startsWith("\tprotected static ")) {
            if (line.startsWith("\tprotected static class ") || line.startsWith("\tprotected static enum ") || line.startsWith("\tprotected static interface ")) {
                return new Tuple(new Object[]{this.getClassName(line), 15});
            }
            if (line.contains("=") || line.endsWith(";") && pos == -1) {
                return new Tuple(new Object[]{this.getVariableName(line), 13});
            }
            if (pos != -1) {
                return new Tuple(new Object[]{this.getConstructorOrMethodName(line, pos), 9});
            }
        } else {
            if (line.startsWith("\tprotected ")) {
                if (line.startsWith("\tprotected abstract class ") || line.startsWith("\tprotected class ") || line.startsWith("\tprotected enum ") || line.startsWith("\tprotected interface ")) {
                    return new Tuple(new Object[]{this.getClassName(line), 16});
                }
                if (pos != -1 && !line.contains("=")) {
                    int spaceCount2 = StringUtil.count((String)line.substring(0, pos), (String)" ");
                    if (spaceCount2 == 1) {
                        return new Tuple(new Object[]{this.getConstructorOrMethodName(line, pos), 10});
                    }
                    if (spaceCount2 > 1) {
                        return new Tuple(new Object[]{this.getConstructorOrMethodName(line, pos), 11});
                    }
                }
                return new Tuple(new Object[]{this.getVariableName(line), 14});
            }
            if (line.startsWith("\tprivate static final ")) {
                if (line.contains("=") || line.endsWith(";") && pos == -1) {
                    return new Tuple(new Object[]{this.getVariableName(line), 20});
                }
            } else if (line.startsWith("\tprivate static ")) {
                if (line.startsWith("\tprivate static class ") || line.startsWith("\tprivate static enum ") || line.startsWith("\tprivate static interface ")) {
                    return new Tuple(new Object[]{this.getClassName(line), 23});
                }
                if (line.contains("=") || line.endsWith(";") && pos == -1) {
                    return new Tuple(new Object[]{this.getVariableName(line), 21});
                }
                if (pos != -1) {
                    return new Tuple(new Object[]{this.getConstructorOrMethodName(line, pos), 17});
                }
            } else if (line.startsWith("\tprivate ")) {
                if (line.startsWith("\tprivate abstract class ") || line.startsWith("\tprivate class ") || line.startsWith("\tprivate enum ") || line.startsWith("\tprivate interface ")) {
                    return new Tuple(new Object[]{this.getClassName(line), 24});
                }
                if (line.contains("=") || line.endsWith(";") && pos == -1) {
                    return new Tuple(new Object[]{this.getVariableName(line), 22});
                }
                if (pos != -1) {
                    spaceCount = StringUtil.count((String)line.substring(0, pos), (String)" ");
                    if (spaceCount == 1) {
                        return new Tuple(new Object[]{this.getConstructorOrMethodName(line, pos), 18});
                    }
                    if (spaceCount > 1) {
                        return new Tuple(new Object[]{this.getConstructorOrMethodName(line, pos), 19});
                    }
                }
            }
        }
        if (numLines < maxLines) {
            int posEndNextline;
            int posStartNextLine = content.indexOf("\n", index) + 1;
            String nextLine = content.substring(posStartNextLine, posEndNextline = content.indexOf("\n", posStartNextLine));
            if (Validator.isNull((String)nextLine)) {
                return null;
            }
            nextLine = StringUtil.trimLeading((String)nextLine);
            return this.getJavaTermTuple(String.valueOf(line) + " " + nextLine, content, posStartNextLine, numLines + 1, maxLines);
        }
        return null;
    }

    protected int getLeadingTabCount(String line) {
        int leadingTabCount = 0;
        while (line.startsWith("\t")) {
            line = line.substring(1);
            ++leadingTabCount;
        }
        return leadingTabCount;
    }

    protected int getLineLength(String line) {
        int lineLength = 0;
        int tabLength = 4;
        char[] cArray = line.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c2 = cArray[n2];
            if (c2 == '\t') {
                int i2 = 0;
                while (i2 < tabLength) {
                    ++lineLength;
                    ++i2;
                }
                tabLength = 4;
            } else {
                ++lineLength;
                if (--tabLength <= 0) {
                    tabLength = 4;
                }
            }
            ++n2;
        }
        return lineLength;
    }

    protected Collection<String> getPluginJavaFiles() {
        TreeSet<String> fileNames = new TreeSet<String>();
        String[] excludes = new String[]{"**\\bin\\**", "**\\model\\*Clp.java", "**\\model\\impl\\*BaseImpl.java", "**\\model\\impl\\*Model.java", "**\\model\\impl\\*ModelImpl.java", "**\\service\\**\\service\\*Service.java", "**\\service\\**\\service\\*ServiceClp.java", "**\\service\\**\\service\\*ServiceFactory.java", "**\\service\\**\\service\\*ServiceUtil.java", "**\\service\\**\\service\\*ServiceWrapper.java", "**\\service\\**\\service\\ClpSerializer.java", "**\\service\\**\\service\\messaging\\*ClpMessageListener.java", "**\\service\\**\\service\\persistence\\*Finder.java", "**\\service\\**\\service\\persistence\\*Util.java", "**\\service\\base\\*ServiceBaseImpl.java", "**\\service\\base\\*ServiceClpInvoker.java", "**\\service\\http\\*JSONSerializer.java", "**\\service\\http\\*ServiceHttp.java", "**\\service\\http\\*ServiceJSON.java", "**\\service\\http\\*ServiceSoap.java", "**\\tmp\\**"};
        String[] includes = new String[]{"**\\*.java"};
        fileNames.addAll(this.getFileNames(excludes, includes));
        return fileNames;
    }

    protected Collection<String> getPortalJavaFiles() {
        TreeSet<String> fileNames = new TreeSet<String>();
        String[] excludes = new String[]{"**\\*_IW.java", "**\\PropsValues.java", "**\\bin\\**", "**\\classes\\*", "**\\counter\\service\\**", "**\\jsp\\*", "**\\model\\impl\\*BaseImpl.java", "**\\model\\impl\\*Model.java", "**\\model\\impl\\*ModelImpl.java", "**\\portal\\service\\**", "**\\portal-client\\**", "**\\portal-web\\classes\\**\\*.java", "**\\portal-web\\test\\**\\*Test.java", "**\\portal-web\\test\\**\\*Tests.java", "**\\portlet\\**\\service\\**", "**\\test\\*-generated\\**", "**\\tmp\\**", "**\\tools\\tck\\**"};
        String[] includes = new String[]{"**\\*.java"};
        fileNames.addAll(this.getFileNames(excludes, includes));
        excludes = new String[]{"**\\bin\\**", "**\\portal-client\\**", "**\\tools\\ext_tmpl\\**", "**\\*_IW.java", "**\\test\\**\\*PersistenceTest.java"};
        includes = new String[]{"**\\com\\liferay\\portal\\service\\ServiceContext*.java", "**\\model\\BaseModel.java", "**\\model\\impl\\BaseModelImpl.java", "**\\service\\Base*.java", "**\\service\\PersistedModelLocalService*.java", "**\\service\\base\\PrincipalBean.java", "**\\service\\http\\*HttpTest.java", "**\\service\\http\\*SoapTest.java", "**\\service\\http\\TunnelUtil.java", "**\\service\\impl\\*.java", "**\\service\\jms\\*.java", "**\\service\\permission\\*.java", "**\\service\\persistence\\BasePersistence.java", "**\\service\\persistence\\BatchSession*.java", "**\\service\\persistence\\*FinderImpl.java", "**\\service\\persistence\\*Query.java", "**\\service\\persistence\\impl\\*.java", "**\\portal-impl\\test\\**\\*.java", "**\\portal-service\\**\\liferay\\documentlibrary\\**.java", "**\\portal-service\\**\\liferay\\lock\\**.java", "**\\portal-service\\**\\liferay\\mail\\**.java", "**\\util-bridges\\**\\*.java"};
        fileNames.addAll(this.getFileNames(excludes, includes));
        return fileNames;
    }

    protected String getVariableName(String line) {
        int x = line.indexOf("=");
        int y = line.lastIndexOf(" ");
        if (x != -1) {
            line = line.substring(0, x);
            line = StringUtil.trim((String)line);
            y = line.lastIndexOf(" ");
            return line.substring(y + 1);
        }
        if (line.endsWith(";")) {
            return line.substring(y + 1, line.length() - 1);
        }
        return "";
    }

    protected boolean hasAnnotationCommentOrJavadoc(String s) {
        return s.startsWith("\t@") || s.startsWith("\t/**") || s.startsWith("\t//");
    }

    protected boolean isGenerated(String content) {
        return content.contains("* @generated") || content.contains("$ANTLR");
    }

    protected boolean isValidJavaParameter(String javaParameter) {
        int quoteCount = StringUtil.count((String)javaParameter, (String)"\"");
        if (quoteCount % 2 == 1) {
            return false;
        }
        javaParameter = this.stripQuotes(javaParameter, '\"');
        int openParenthesisCount = StringUtil.count((String)javaParameter, (String)"(");
        int closeParenthesisCount = StringUtil.count((String)javaParameter, (String)")");
        int lessThanCount = StringUtil.count((String)javaParameter, (String)"<");
        int greaterThanCount = StringUtil.count((String)javaParameter, (String)">");
        int openCurlyBraceCount = StringUtil.count((String)javaParameter, (String)"{");
        int closeCurlyBraceCount = StringUtil.count((String)javaParameter, (String)"}");
        return openParenthesisCount == closeParenthesisCount && lessThanCount == greaterThanCount && openCurlyBraceCount == closeCurlyBraceCount;
    }

    protected String sortExceptions(String line) {
        if (!line.endsWith("{") && !line.endsWith(";")) {
            return line;
        }
        int x = line.indexOf("throws ");
        if (x == -1) {
            return line;
        }
        String previousException = "";
        String[] exceptions = StringUtil.split((String)line.substring(x), (char)' ');
        int i2 = 1;
        while (i2 < exceptions.length) {
            String exception = exceptions[i2];
            if (exception.equals("{")) break;
            if (exception.endsWith(",") || exception.endsWith(";")) {
                exception = exception.substring(0, exception.length() - 1);
            }
            if (Validator.isNotNull((String)previousException) && previousException.compareToIgnoreCase(exception) > 0) {
                return StringUtil.replace((String)line, (String)(String.valueOf(previousException) + ", " + exception), (String)(String.valueOf(exception) + ", " + previousException));
            }
            previousException = exception;
            ++i2;
        }
        return line;
    }

    protected String sortJavaTerms(String fileName, String content, Set<JavaTerm> javaTerms) {
        JavaTerm previousJavaTerm = null;
        for (JavaTerm javaTerm : javaTerms) {
            if (previousJavaTerm == null) {
                previousJavaTerm = javaTerm;
                continue;
            }
            int javaTermLineCount = javaTerm.getLineCount();
            String javaTermName = javaTerm.getName();
            String excluded = null;
            if (this._javaTermSortExclusions != null) {
                excluded = this._javaTermSortExclusions.getProperty(String.valueOf(fileName) + "@" + javaTermLineCount);
                if (excluded == null) {
                    excluded = this._javaTermSortExclusions.getProperty(String.valueOf(fileName) + "@" + javaTermName);
                }
                if (excluded == null) {
                    excluded = this._javaTermSortExclusions.getProperty(fileName);
                }
            }
            if (excluded != null) {
                previousJavaTerm = javaTerm;
                continue;
            }
            String javaTermContent = javaTerm.getContent();
            String previousJavaTermContent = previousJavaTerm.getContent();
            if (previousJavaTerm.getLineCount() > javaTermLineCount) {
                String previousJavaTermName = previousJavaTerm.getName();
                String javaTermNameLowerCase = javaTermName.toLowerCase();
                String previousJavaTermNameLowerCase = previousJavaTermName.toLowerCase();
                if (!(fileName.contains("persistence") && (previousJavaTermName.startsWith("doCount") && javaTermName.startsWith("doCount") || previousJavaTermName.startsWith("doFind") && javaTermName.startsWith("doFind") || previousJavaTermNameLowerCase.startsWith("count") && javaTermNameLowerCase.startsWith("count") || previousJavaTermNameLowerCase.startsWith("filter") && javaTermNameLowerCase.startsWith("filter") || previousJavaTermNameLowerCase.startsWith("find") && javaTermNameLowerCase.startsWith("find") || previousJavaTermNameLowerCase.startsWith("join") && javaTermNameLowerCase.startsWith("join")))) {
                    content = StringUtil.replaceFirst((String)content, (String)("\n" + javaTermContent), (String)("\n" + previousJavaTermContent));
                    content = StringUtil.replaceLast((String)content, (String)("\n" + previousJavaTermContent), (String)("\n" + javaTermContent));
                    return content;
                }
            }
            previousJavaTerm = javaTerm;
        }
        return content;
    }
}

