/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.sourceformatter;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.sourceformatter.ImportPackage;
import com.liferay.portal.tools.sourceformatter.ImportPackageFactoryUtil;
import com.liferay.portal.tools.sourceformatter.SourceFormatterHelper;
import com.liferay.portal.tools.sourceformatter.SourceProcessor;
import com.liferay.portal.util.FileImpl;
import com.liferay.portal.xml.SAXReaderImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.DirectoryScanner;

public abstract class BaseSourceProcessor
implements SourceProcessor {
    protected static final String BASEDIR = "./";
    protected static final String MAIN_RELEASE_VERSION_6_1_0 = "6.1.0";
    protected static final String MAIN_RELEASE_VERSION_6_2_0 = "6.2.0";
    protected static FileImpl fileUtil = FileImpl.getInstance();
    protected static Pattern languageKeyPattern = Pattern.compile("LanguageUtil.(?:get|format)\\([^;%]+|Liferay.Language.get\\('([^']+)");
    protected static String mainReleaseVersion;
    protected static boolean portalSource;
    protected static SAXReaderImpl saxReaderUtil;
    protected static Pattern sessionKeyPattern;
    protected static SourceFormatterHelper sourceFormatterHelper;
    protected static Pattern taglibSessionKeyPattern;
    private static boolean _autoFix;
    private static Map<String, String> _compatClassNamesMap;
    private static String _copyright;
    private static List<String> _errorMessages;
    private static String[] _excludes;
    private static boolean _initialized;
    private static String _oldCopyright;
    private static Properties _portalLanguageKeysProperties;
    private static boolean _printErrors;

    static {
        saxReaderUtil = SAXReaderImpl.getInstance();
        sessionKeyPattern = Pattern.compile("SessionErrors.(?:add|contains|get)\\([^;%&|!]+|".concat("SessionMessages.(?:add|contains|get)\\([^;%&|!]+"), 8);
        taglibSessionKeyPattern = Pattern.compile("<liferay-ui:error [^>]+>|<liferay-ui:success [^>]+>", 8);
        _errorMessages = new ArrayList<String>();
    }

    @Override
    public void format(boolean useProperties, boolean printErrors, boolean autoFix) throws Exception {
        this._init(useProperties, printErrors, autoFix);
        this.format();
        sourceFormatterHelper.close();
    }

    @Override
    public String format(String fileName, boolean useProperties, boolean printErrors, boolean autoFix) throws Exception {
        try {
            this._init(useProperties, printErrors, autoFix);
            String string = this.format(fileName);
            return string;
        }
        finally {
            sourceFormatterHelper.close();
        }
    }

    @Override
    public List<String> getErrorMessages() {
        return _errorMessages;
    }

    protected static String formatImports(String imports, int classStartPos) throws IOException {
        if (imports.contains("/*") || imports.contains("*/") || imports.contains("//")) {
            return String.valueOf(imports) + "\n";
        }
        List<ImportPackage> importPackages = new ArrayList();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(imports));
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            ImportPackage importPackage = ImportPackageFactoryUtil.create(line);
            if (importPackage == null || importPackages.contains(importPackage)) continue;
            importPackages.add(importPackage);
        }
        importPackages = ListUtil.sort(importPackages);
        StringBundler sb = new StringBundler();
        String temp = null;
        int i2 = 0;
        while (i2 < importPackages.size()) {
            ImportPackage importPackage = (ImportPackage)importPackages.get(i2);
            String s = importPackage.getLine();
            int pos = s.indexOf(".");
            if ((pos = s.indexOf(".", pos + 1)) == -1) {
                pos = s.indexOf(".");
            }
            String packageLevel = s.substring(classStartPos, pos);
            if (i2 != 0 && !packageLevel.equals(temp)) {
                sb.append("\n");
            }
            temp = packageLevel;
            sb.append(s);
            sb.append("\n");
            ++i2;
        }
        return sb.toString();
    }

    protected void checkIfClauseParentheses(String ifClause, String fileName, int lineCount) {
        int quoteCount = StringUtil.count((String)ifClause, (String)"\"");
        if (quoteCount % 2 == 1) {
            return;
        }
        ifClause = this.stripQuotes(ifClause, '\"');
        if ((ifClause = this.stripQuotes(ifClause, '\'')).contains("//") || ifClause.contains("/*") || ifClause.contains("*/")) {
            return;
        }
        ifClause = this.stripRedundantParentheses(ifClause);
        int level = 0;
        int max = StringUtil.count((String)ifClause, (String)"(");
        int previousParenthesisPos = -1;
        int[] levels = new int[max];
        int i2 = 0;
        while (i2 < ifClause.length()) {
            char c2 = ifClause.charAt(i2);
            if (c2 == '(' || c2 == ')') {
                String s;
                if (previousParenthesisPos != -1 && this.hasMissingParentheses(s = ifClause.substring(previousParenthesisPos + 1, i2))) {
                    this.processErrorMessage(fileName, "missing parentheses: " + fileName + " " + lineCount);
                }
                previousParenthesisPos = i2;
                if (c2 == '(') {
                    levels[level] = i2;
                    ++level;
                } else {
                    int posOpenParenthesis = levels[level - 1];
                    if (level > 1) {
                        String s2;
                        char nextChar = ifClause.charAt(i2 + 1);
                        char previousChar = ifClause.charAt(posOpenParenthesis - 1);
                        if (!Character.isLetterOrDigit(nextChar) && nextChar != '.' && !Character.isLetterOrDigit(previousChar) && this.hasRedundantParentheses(s2 = ifClause.substring(posOpenParenthesis + 1, i2))) {
                            this.processErrorMessage(fileName, "redundant parentheses: " + fileName + " " + lineCount);
                        }
                        if (previousChar == '(' && nextChar == ')') {
                            this.processErrorMessage(fileName, "redundant parentheses: " + fileName + " " + lineCount);
                        }
                    }
                    --level;
                }
            }
            ++i2;
        }
    }

    protected void checkInefficientStringMethods(String line, String fileName, int lineCount) {
        if (mainReleaseVersion.equals(MAIN_RELEASE_VERSION_6_1_0)) {
            return;
        }
        String methodName = "toLowerCase";
        int pos = line.indexOf(".toLowerCase()");
        if (pos == -1) {
            methodName = "toUpperCase";
            pos = line.indexOf(".toUpperCase()");
        }
        if (pos == -1 && !line.contains("StringUtil.equalsIgnoreCase(")) {
            methodName = "equalsIgnoreCase";
            pos = line.indexOf(".equalsIgnoreCase(");
        }
        if (pos != -1) {
            this.processErrorMessage(fileName, "Use StringUtil." + methodName + ": " + fileName + " " + lineCount);
        }
    }

    protected void checkLanguageKeys(String fileName, String content, Pattern pattern) throws IOException {
        String fileExtension = fileUtil.getExtension(fileName);
        if (!portalSource || fileExtension.equals("vm")) {
            return;
        }
        if (_portalLanguageKeysProperties == null) {
            _portalLanguageKeysProperties = new Properties();
            ClassLoader classLoader = BaseSourceProcessor.class.getClassLoader();
            InputStream inputStream = classLoader.getResourceAsStream("content/Language.properties");
            _portalLanguageKeysProperties.load(inputStream);
        }
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            String[] languageKeys;
            String[] stringArray = languageKeys = this.getLanguageKeys(matcher);
            int n = languageKeys.length;
            int n2 = 0;
            while (n2 < n) {
                String languageKey = stringArray[n2];
                if (!(Validator.isNumber((String)languageKey) || languageKey.endsWith("-") || languageKey.endsWith("[") || languageKey.endsWith(".") || languageKey.endsWith("_") || languageKey.startsWith("-") || languageKey.startsWith("[") || languageKey.startsWith("{") || languageKey.startsWith(".") || languageKey.startsWith("_") || _portalLanguageKeysProperties.containsKey(languageKey))) {
                    this.processErrorMessage(fileName, "missing language key: " + languageKey + " " + fileName);
                }
                ++n2;
            }
        }
    }

    protected void checkStringBundler(String line, String fileName, int lineCount) {
        String[] lineParts;
        if (!line.startsWith("sb.append(") && !line.contains("SB.append(") || !line.endsWith(");")) {
            return;
        }
        int pos = line.indexOf(".append(");
        line = line.substring(pos + 8, line.length() - 2);
        if (!(line = this.stripQuotes(line, '\"')).contains(" + ")) {
            return;
        }
        String[] stringArray = lineParts = StringUtil.split((String)line, (String)" + ");
        int n = lineParts.length;
        int n2 = 0;
        while (n2 < n) {
            int openParenthesesCount;
            String linePart = stringArray[n2];
            int closeParenthesesCount = StringUtil.count((String)linePart, (String)")");
            if (closeParenthesesCount != (openParenthesesCount = StringUtil.count((String)linePart, (String)"("))) {
                return;
            }
            if (Validator.isNumber((String)linePart)) {
                return;
            }
            ++n2;
        }
        this.processErrorMessage(fileName, "plus: " + fileName + " " + lineCount);
    }

    protected String fixCompatClassImports(File file, String content) throws IOException {
        String absolutePath = fileUtil.getAbsolutePath(file);
        if (portalSource || !mainReleaseVersion.equals(MAIN_RELEASE_VERSION_6_1_0) || absolutePath.contains("/ext-") || absolutePath.contains("/portal-compat-shared/")) {
            return content;
        }
        Map<String, String> compatClassNamesMap = this.getCompatClassNamesMap();
        String newContent = content;
        for (Map.Entry<String, String> entry : compatClassNamesMap.entrySet()) {
            Matcher matcher;
            String compatClassName = entry.getKey();
            String extendedClassName = entry.getValue();
            Pattern pattern = Pattern.compile(String.valueOf(extendedClassName) + "\\W");
            while ((matcher = pattern.matcher(newContent)).find()) {
                newContent = String.valueOf(newContent.substring(0, matcher.start())) + compatClassName + newContent.substring(matcher.end() - 1);
            }
        }
        return newContent;
    }

    protected String fixCopyright(String content, String copyright, String oldCopyright, File file, String fileName) throws IOException {
        int x;
        if (fileName.endsWith(".vm")) {
            return content;
        }
        if (oldCopyright != null && content.contains(oldCopyright)) {
            content = StringUtil.replace((String)content, (String)oldCopyright, (String)copyright);
            this.processErrorMessage(fileName, "old (c): " + fileName);
        }
        if (!content.contains(copyright)) {
            String customCopyright = this.getCustomCopyright(file);
            if (Validator.isNotNull((String)customCopyright)) {
                copyright = customCopyright;
            }
            if (!content.contains(copyright)) {
                this.processErrorMessage(fileName, "(c): " + fileName);
            }
        }
        if (fileName.endsWith(".jsp") || fileName.endsWith(".jspf")) {
            content = StringUtil.replace((String)content, (String)("<%\n" + copyright + "\n%>"), (String)("<%--\n" + copyright + "\n--%>"));
        }
        if ((x = content.indexOf("* Copyright (c) 2000-20")) == -1) {
            return content;
        }
        int y = copyright.indexOf("* Copyright (c) 2000-20");
        if (y == -1) {
            return content;
        }
        String contentCopyrightYear = content.substring(x, x + 25);
        String copyrightYear = copyright.substring(y, y + 25);
        return StringUtil.replace((String)content, (String)contentCopyrightYear, (String)copyrightYear);
    }

    protected String fixSessionKey(String fileName, String content, Pattern pattern) {
        if (mainReleaseVersion.equals(MAIN_RELEASE_VERSION_6_1_0)) {
            return content;
        }
        Matcher matcher = pattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        String newContent = content;
        do {
            String match = matcher.group();
            String s = null;
            if (pattern.equals(sessionKeyPattern)) {
                s = ",";
            } else if (pattern.equals(taglibSessionKeyPattern)) {
                s = "key=";
            }
            int x = match.indexOf(s);
            if (x == -1) continue;
            String substring = match.substring(x += s.length()).trim();
            String quote = "";
            if (substring.startsWith("'")) {
                quote = "'";
            } else {
                if (!substring.startsWith("\"")) continue;
                quote = "\"";
            }
            int y = match.indexOf(quote, x);
            int z = match.indexOf(quote, y + 1);
            if (y == -1 || z == -1) continue;
            String prefix = match.substring(0, y + 1);
            String suffix = match.substring(z);
            String oldKey = match.substring(y + 1, z);
            boolean alphaNumericKey = true;
            char[] cArray = oldKey.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c2 = cArray[n2];
                if (!Validator.isChar((char)c2) && !Validator.isDigit((char)c2) && c2 != '-' && c2 != '_') {
                    alphaNumericKey = false;
                }
                ++n2;
            }
            if (!alphaNumericKey) continue;
            String newKey = TextFormatter.format((String)oldKey, (int)14);
            if ((newKey = TextFormatter.format((String)newKey, (int)12)).equals(oldKey)) continue;
            String oldSub = prefix.concat(oldKey).concat(suffix);
            String newSub = prefix.concat(newKey).concat(suffix);
            newContent = StringUtil.replaceFirst((String)newContent, (String)oldSub, (String)newSub);
        } while (matcher.find());
        return newContent;
    }

    protected abstract void format() throws Exception;

    protected String format(String fileName) throws Exception {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected Map<String, String> getCompatClassNamesMap() throws IOException {
        void var5_6;
        if (_compatClassNamesMap != null) {
            return _compatClassNamesMap;
        }
        HashMap<String, String> compatClassNamesMap = new HashMap<String, String>();
        String[] includes = new String[]{"**\\portal-compat-shared\\src\\com\\liferay\\compat\\**\\*.java"};
        String basedir = BASEDIR;
        List<Object> fileNames = new ArrayList();
        boolean bl = false;
        while (var5_6 < 3) {
            fileNames = this.getFileNames(basedir, new String[0], includes);
            if (!fileNames.isEmpty()) break;
            basedir = "../" + basedir;
            ++var5_6;
        }
        for (String string : fileNames) {
            File file = new File(String.valueOf(basedir) + string);
            String content = fileUtil.read(file);
            String string3 = StringUtil.replace((String)string, (String)"\\", (String)"/");
            string3 = StringUtil.replace((String)string3, (String)"/", (String)".");
            int pos = string3.indexOf("com.");
            String compatClassName = string3.substring(pos);
            String extendedClassName = StringUtil.replace((String)(compatClassName = compatClassName.substring(0, compatClassName.length() - 5)), (String)"compat.", (String)"");
            if (!content.contains("extends " + extendedClassName)) continue;
            compatClassNamesMap.put(compatClassName, extendedClassName);
        }
        _compatClassNamesMap = compatClassNamesMap;
        return _compatClassNamesMap;
    }

    protected String getCopyright() throws IOException {
        if (Validator.isNotNull((String)_copyright)) {
            return _copyright;
        }
        _copyright = fileUtil.read("copyright.txt");
        if (Validator.isNull((String)_copyright)) {
            _copyright = fileUtil.read("../copyright.txt");
        }
        if (Validator.isNull((String)_copyright)) {
            _copyright = fileUtil.read("../../copyright.txt");
        }
        return _copyright;
    }

    protected String getCustomCopyright(File file) throws IOException {
        String absolutePath = fileUtil.getAbsolutePath(file);
        int x = absolutePath.length();
        while ((x = absolutePath.lastIndexOf("/", x)) != -1) {
            String copyright = fileUtil.read(String.valueOf(absolutePath.substring(0, x + 1)) + "copyright.txt");
            if (Validator.isNotNull((String)copyright)) {
                return copyright;
            }
            --x;
        }
        return null;
    }

    protected Properties getExclusionsProperties(String fileName) throws IOException {
        InputStream inputStream = null;
        int level = 0;
        if (portalSource) {
            String sourceFormatterExclusions;
            ClassLoader classLoader = BaseSourceProcessor.class.getClassLoader();
            URL url = classLoader.getResource(sourceFormatterExclusions = System.getProperty("source-formatter-exclusions", "com/liferay/portal/tools/dependencies/" + fileName));
            if (url == null) {
                return null;
            }
            inputStream = url.openStream();
        } else {
            try {
                inputStream = new FileInputStream(fileName);
            }
            catch (FileNotFoundException fileNotFoundException) {}
            if (inputStream == null) {
                try {
                    inputStream = new FileInputStream("../" + fileName);
                    level = 1;
                }
                catch (FileNotFoundException fileNotFoundException) {}
            }
            if (inputStream == null) {
                try {
                    inputStream = new FileInputStream("../../" + fileName);
                    level = 2;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return null;
                }
            }
        }
        Properties properties = new Properties();
        properties.load(inputStream);
        ((InputStream)inputStream).close();
        if (level > 0) {
            properties = this.stripTopLevelDirectories(properties, level);
        }
        return properties;
    }

    protected List<String> getFileNames(String basedir, String[] excludes, String[] includes) {
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(basedir);
        excludes = (String[])ArrayUtil.append((Object[][])new String[][]{excludes, _excludes, {"**\\.git\\**", "**\\tmp\\**"}});
        if (portalSource) {
            excludes = (String[])ArrayUtil.append((Object[])excludes, (Object[])new String[]{"**\\webapps\\**"});
        }
        directoryScanner.setExcludes(excludes);
        directoryScanner.setIncludes(includes);
        return sourceFormatterHelper.scanForFiles(directoryScanner);
    }

    protected List<String> getFileNames(String[] excludes, String[] includes) {
        return this.getFileNames(BASEDIR, excludes, includes);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected String[] getLanguageKeys(Matcher matcher) {
        String languageKey;
        if (matcher.groupCount() > 0 && Validator.isNotNull((String)(languageKey = matcher.group(1)))) {
            return new String[]{languageKey};
        }
        StringBundler sb = new StringBundler();
        String match = matcher.group();
        int count = 0;
        int i2 = 0;
        while (i2 < match.length()) {
            char c2 = match.charAt(i2);
            switch (c2) {
                case ')': {
                    if (count <= 1) {
                        return new String[0];
                    }
                    --count;
                    break;
                }
                case '(': {
                    ++count;
                    break;
                }
                case '\"': {
                    if (count > 1) break;
                    while (i2 < match.length()) {
                        if (match.charAt(++i2) == '\"') {
                            String languageKey2 = sb.toString();
                            if (match.startsWith("names")) {
                                return StringUtil.split((String)languageKey2);
                            }
                            return new String[]{languageKey2};
                        }
                        sb.append(match.charAt(i2));
                    }
                    break;
                }
            }
            ++i2;
        }
        return new String[0];
    }

    protected String getOldCopyright() throws IOException {
        if (Validator.isNotNull((String)_oldCopyright)) {
            return _oldCopyright;
        }
        _oldCopyright = fileUtil.read("old-copyright.txt");
        if (Validator.isNull((String)_oldCopyright)) {
            _oldCopyright = fileUtil.read("../old-copyright.txt");
        }
        if (Validator.isNull((String)_oldCopyright)) {
            _oldCopyright = fileUtil.read("../../old-copyright.txt");
        }
        return _oldCopyright;
    }

    protected boolean hasMissingParentheses(String s) {
        boolean containsMathOperator;
        if (Validator.isNull((String)s)) {
            return false;
        }
        boolean containsAndOrOperator = s.contains("&&") || s.contains("||");
        boolean containsCompareOperator = s.contains(" == ") || s.contains(" != ") || s.contains(" < ") || s.contains(" > ") || s.contains(" =< ") || s.contains(" => ") || s.contains(" <= ") || s.contains(" >= ");
        boolean bl = containsMathOperator = s.contains(" = ") || s.contains(" - ") || s.contains(" + ") || s.contains(" & ") || s.contains(" % ") || s.contains(" * ") || s.contains(" / ");
        return containsCompareOperator && (containsAndOrOperator || containsMathOperator && !s.contains("["));
    }

    protected boolean hasRedundantParentheses(String s) {
        if (!s.contains("&&") && !s.contains("||")) {
            int y;
            int x = 0;
            while ((x = s.indexOf(")")) != -1 && (y = s.substring(0, x).lastIndexOf("(")) != -1) {
                s = String.valueOf(s.substring(0, y)) + s.substring(x + 1);
            }
        }
        return Validator.isNotNull((String)s) && !s.contains(" ");
    }

    protected boolean isAutoFix() {
        return _autoFix;
    }

    protected void processErrorMessage(String fileName, String message) {
        _errorMessages.add(message);
        if (_printErrors) {
            sourceFormatterHelper.printError(fileName, message);
        }
    }

    protected String replacePrimitiveWrapperInstantiation(String fileName, String line, int lineCount) {
        return line;
    }

    protected String stripQuotes(String s, char delimeter) {
        boolean insideQuotes = false;
        StringBundler sb = new StringBundler();
        int i2 = 0;
        while (i2 < s.length()) {
            char c2 = s.charAt(i2);
            if (insideQuotes) {
                if (c2 == delimeter && (c2 <= '\u0001' || s.charAt(i2 - 1) != '\\' || s.charAt(i2 - 2) == '\\')) {
                    insideQuotes = false;
                }
            } else if (c2 == delimeter) {
                insideQuotes = true;
            } else {
                sb.append(c2);
            }
            ++i2;
        }
        return sb.toString();
    }

    protected String stripRedundantParentheses(String s) {
        int x = 0;
        while (true) {
            x = s.indexOf("(", x + 1);
            int y = s.indexOf(")", x);
            if (x == -1 || y == -1) {
                return s;
            }
            String linePart = s.substring(x + 1, y);
            if (!Validator.isAlphanumericName((String)(linePart = StringUtil.replace((String)linePart, (String)",", (String)""))) && !Validator.isNull((String)linePart)) continue;
            s = String.valueOf(s.substring(0, x)) + s.substring(y + 1);
        }
    }

    protected Properties stripTopLevelDirectories(Properties properties, int level) throws IOException {
        File dir = new File(".");
        String dirName = dir.getCanonicalPath();
        dirName = StringUtil.replace((String)dirName, (String)"\\", (String)"/");
        int pos = dirName.length();
        int i2 = 0;
        while (i2 < level) {
            pos = dirName.lastIndexOf("/", pos - 1);
            ++i2;
        }
        String topLevelDirNames = String.valueOf(dirName.substring(pos + 1)) + "/";
        Properties newProperties = new Properties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(topLevelDirNames)) continue;
            key = StringUtil.replaceFirst((String)key, (String)topLevelDirNames, (String)"");
            String value = (String)entry.getValue();
            newProperties.setProperty(key, value);
        }
        return newProperties;
    }

    protected String trimContent(String content, boolean allowLeadingSpaces) throws IOException {
        StringBundler sb = new StringBundler();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(content));
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            sb.append(this.trimLine(line, allowLeadingSpaces));
            sb.append("\n");
        }
        unsyncBufferedReader.close();
        content = sb.toString();
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        return content;
    }

    protected String trimLine(String line, boolean allowLeadingSpaces) {
        if (line.trim().length() == 0) {
            return "";
        }
        line = StringUtil.trimTrailing((String)line);
        if (allowLeadingSpaces || !line.startsWith(" ") || line.startsWith(" *")) {
            return line;
        }
        if (!line.startsWith("    ")) {
            while (line.startsWith(" ")) {
                line = StringUtil.replaceFirst((String)line, (String)" ", (String)"");
            }
        } else {
            int pos = 0;
            String temp = line;
            while (temp.startsWith("    ")) {
                line = StringUtil.replaceFirst((String)line, (String)"    ", (String)"\t");
                temp = line.substring(++pos);
            }
        }
        return line;
    }

    private void _init(boolean useProperties, boolean printErrors, boolean autoFix) throws Exception {
        _errorMessages = new ArrayList<String>();
        sourceFormatterHelper = new SourceFormatterHelper(useProperties);
        sourceFormatterHelper.init();
        if (_initialized) {
            return;
        }
        _autoFix = autoFix;
        this._setVersion();
        _excludes = StringUtil.split((String)GetterUtil.getString((String)System.getProperty("source.formatter.excludes")));
        portalSource = this._isPortalSource();
        _printErrors = printErrors;
        _initialized = true;
    }

    private boolean _isPortalSource() {
        return fileUtil.exists("./portal-impl");
    }

    private void _setVersion() throws Exception {
        String releaseInfoVersion = ReleaseInfo.getVersion();
        if (releaseInfoVersion.startsWith("6.1")) {
            mainReleaseVersion = MAIN_RELEASE_VERSION_6_1_0;
        } else if (releaseInfoVersion.startsWith("6.2")) {
            mainReleaseVersion = MAIN_RELEASE_VERSION_6_2_0;
        } else {
            throw new Exception("Invalid release information: " + ReleaseInfo.getVersion());
        }
    }
}

