/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.samplesqlbuilder;

import com.liferay.counter.model.Counter;
import com.liferay.counter.model.CounterModel;
import com.liferay.counter.model.impl.CounterModelImpl;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.IntegerWrapper;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.AccountModel;
import com.liferay.portal.model.ClassNameModel;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.CompanyModel;
import com.liferay.portal.model.ContactModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.GroupModel;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutFriendlyURLModel;
import com.liferay.portal.model.LayoutModel;
import com.liferay.portal.model.LayoutSetModel;
import com.liferay.portal.model.ModelHintsUtil;
import com.liferay.portal.model.PortletPreferencesModel;
import com.liferay.portal.model.ResourcePermission;
import com.liferay.portal.model.ResourcePermissionModel;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.RoleModel;
import com.liferay.portal.model.SubscriptionModel;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserModel;
import com.liferay.portal.model.VirtualHostModel;
import com.liferay.portal.model.impl.AccountModelImpl;
import com.liferay.portal.model.impl.ClassNameModelImpl;
import com.liferay.portal.model.impl.CompanyModelImpl;
import com.liferay.portal.model.impl.ContactModelImpl;
import com.liferay.portal.model.impl.GroupModelImpl;
import com.liferay.portal.model.impl.LayoutFriendlyURLModelImpl;
import com.liferay.portal.model.impl.LayoutModelImpl;
import com.liferay.portal.model.impl.LayoutSetModelImpl;
import com.liferay.portal.model.impl.PortletPreferencesModelImpl;
import com.liferay.portal.model.impl.ResourcePermissionModelImpl;
import com.liferay.portal.model.impl.RoleModelImpl;
import com.liferay.portal.model.impl.SubscriptionModelImpl;
import com.liferay.portal.model.impl.UserModelImpl;
import com.liferay.portal.model.impl.VirtualHostModelImpl;
import com.liferay.portal.security.auth.FullNameGenerator;
import com.liferay.portal.security.auth.FullNameGeneratorFactory;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.tools.samplesqlbuilder.SequentialUUID;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.PortletPreferencesFactory;
import com.liferay.portlet.PortletPreferencesFactoryImpl;
import com.liferay.portlet.PortletPreferencesImpl;
import com.liferay.portlet.asset.model.AssetCategory;
import com.liferay.portlet.asset.model.AssetCategoryModel;
import com.liferay.portlet.asset.model.AssetEntryModel;
import com.liferay.portlet.asset.model.AssetTag;
import com.liferay.portlet.asset.model.AssetTagModel;
import com.liferay.portlet.asset.model.AssetTagStatsModel;
import com.liferay.portlet.asset.model.AssetVocabulary;
import com.liferay.portlet.asset.model.AssetVocabularyModel;
import com.liferay.portlet.asset.model.impl.AssetCategoryModelImpl;
import com.liferay.portlet.asset.model.impl.AssetEntryModelImpl;
import com.liferay.portlet.asset.model.impl.AssetTagModelImpl;
import com.liferay.portlet.asset.model.impl.AssetTagStatsModelImpl;
import com.liferay.portlet.asset.model.impl.AssetVocabularyModelImpl;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.model.BlogsEntryModel;
import com.liferay.portlet.blogs.model.BlogsStatsUserModel;
import com.liferay.portlet.blogs.model.impl.BlogsEntryModelImpl;
import com.liferay.portlet.blogs.model.impl.BlogsStatsUserModelImpl;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFileEntryMetadata;
import com.liferay.portlet.documentlibrary.model.DLFileEntryMetadataModel;
import com.liferay.portlet.documentlibrary.model.DLFileEntryModel;
import com.liferay.portlet.documentlibrary.model.DLFileEntryTypeModel;
import com.liferay.portlet.documentlibrary.model.DLFileVersionModel;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.model.DLFolderModel;
import com.liferay.portlet.documentlibrary.model.impl.DLFileEntryMetadataModelImpl;
import com.liferay.portlet.documentlibrary.model.impl.DLFileEntryModelImpl;
import com.liferay.portlet.documentlibrary.model.impl.DLFileEntryTypeModelImpl;
import com.liferay.portlet.documentlibrary.model.impl.DLFileVersionModelImpl;
import com.liferay.portlet.documentlibrary.model.impl.DLFolderModelImpl;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordModel;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordSet;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordSetModel;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordVersionModel;
import com.liferay.portlet.dynamicdatalists.model.impl.DDLRecordModelImpl;
import com.liferay.portlet.dynamicdatalists.model.impl.DDLRecordSetModelImpl;
import com.liferay.portlet.dynamicdatalists.model.impl.DDLRecordVersionModelImpl;
import com.liferay.portlet.dynamicdatamapping.model.DDMContent;
import com.liferay.portlet.dynamicdatamapping.model.DDMContentModel;
import com.liferay.portlet.dynamicdatamapping.model.DDMStorageLink;
import com.liferay.portlet.dynamicdatamapping.model.DDMStorageLinkModel;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructureLinkModel;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructureModel;
import com.liferay.portlet.dynamicdatamapping.model.impl.DDMContentModelImpl;
import com.liferay.portlet.dynamicdatamapping.model.impl.DDMStorageLinkModelImpl;
import com.liferay.portlet.dynamicdatamapping.model.impl.DDMStructureLinkModelImpl;
import com.liferay.portlet.dynamicdatamapping.model.impl.DDMStructureModelImpl;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalArticleModel;
import com.liferay.portlet.journal.model.JournalArticleResourceModel;
import com.liferay.portlet.journal.model.JournalContentSearchModel;
import com.liferay.portlet.journal.model.impl.JournalArticleModelImpl;
import com.liferay.portlet.journal.model.impl.JournalArticleResourceModelImpl;
import com.liferay.portlet.journal.model.impl.JournalContentSearchModelImpl;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBCategoryConstants;
import com.liferay.portlet.messageboards.model.MBCategoryModel;
import com.liferay.portlet.messageboards.model.MBDiscussion;
import com.liferay.portlet.messageboards.model.MBDiscussionModel;
import com.liferay.portlet.messageboards.model.MBMailingListModel;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.model.MBMessageConstants;
import com.liferay.portlet.messageboards.model.MBMessageModel;
import com.liferay.portlet.messageboards.model.MBStatsUserModel;
import com.liferay.portlet.messageboards.model.MBThread;
import com.liferay.portlet.messageboards.model.MBThreadFlagModel;
import com.liferay.portlet.messageboards.model.MBThreadModel;
import com.liferay.portlet.messageboards.model.impl.MBCategoryModelImpl;
import com.liferay.portlet.messageboards.model.impl.MBDiscussionModelImpl;
import com.liferay.portlet.messageboards.model.impl.MBMailingListModelImpl;
import com.liferay.portlet.messageboards.model.impl.MBMessageModelImpl;
import com.liferay.portlet.messageboards.model.impl.MBStatsUserModelImpl;
import com.liferay.portlet.messageboards.model.impl.MBThreadFlagModelImpl;
import com.liferay.portlet.messageboards.model.impl.MBThreadModelImpl;
import com.liferay.portlet.social.model.SocialActivity;
import com.liferay.portlet.social.model.SocialActivityModel;
import com.liferay.portlet.social.model.impl.SocialActivityModelImpl;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiNodeModel;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.model.WikiPageConstants;
import com.liferay.portlet.wiki.model.WikiPageModel;
import com.liferay.portlet.wiki.model.WikiPageResourceModel;
import com.liferay.portlet.wiki.model.impl.WikiNodeModelImpl;
import com.liferay.portlet.wiki.model.impl.WikiPageModelImpl;
import com.liferay.portlet.wiki.model.impl.WikiPageResourceModelImpl;
import com.liferay.util.SimpleCounter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.portlet.PortletPreferences;

public class DataFactory {
    private static final long _CURRENT_TIME = System.currentTimeMillis();
    private static final String _DEPENDENCIES_DIR = "com/liferay/portal/tools/samplesqlbuilder/dependencies/";
    private static final long _FUTURE_TIME = System.currentTimeMillis() + 31536000000L;
    private static final String _SAMPLE_USER_NAME = "Sample";
    private static PortletPreferencesFactory _portletPreferencesFactory = new PortletPreferencesFactoryImpl();
    private long _accountId;
    private AccountModel _accountModel;
    private RoleModel _administratorRoleModel;
    private Map<Long, SimpleCounter> _assetCategoryCounters = new HashMap<Long, SimpleCounter>();
    private List<AssetCategoryModel>[] _assetCategoryModelsArray;
    private Map<Long, SimpleCounter> _assetPublisherQueryCounter = new HashMap<Long, SimpleCounter>();
    private String _assetPublisherQueryName;
    private Map<Long, SimpleCounter> _assetTagCounters = new HashMap<Long, SimpleCounter>();
    private List<AssetTagModel>[] _assetTagModelsArray;
    private List<AssetTagStatsModel>[] _assetTagStatsModelsArray;
    private List<AssetVocabularyModel>[] _assetVocabularyModelsArray;
    private List<ClassNameModel> _classNameModels;
    private Map<String, Long> _classNameModelsMap = new HashMap<String, Long>();
    private long _companyId;
    private CompanyModel _companyModel;
    private SimpleCounter _counter;
    private AssetVocabularyModel _defaultAssetVocabularyModel;
    private DDMStructureModel _defaultDLDDMStructureModel;
    private DLFileEntryTypeModel _defaultDLFileEntryTypeModel;
    private long _defaultUserId;
    private UserModel _defaultUserModel;
    private String _dlDDMStructureContent;
    private List<String> _firstNames;
    private SimpleCounter _futureDateCounter;
    private long _globalGroupId;
    private GroupModel _globalGroupModel;
    private List<GroupModel> _groupModels;
    private long _guestGroupId;
    private GroupModel _guestGroupModel;
    private RoleModel _guestRoleModel;
    private UserModel _guestUserModel;
    private String _journalArticleContent;
    private List<String> _lastNames;
    private Map<Long, SimpleCounter> _layoutCounters = new HashMap<Long, SimpleCounter>();
    private int _maxAssetCategoryCount;
    private int _maxAssetEntryToAssetCategoryCount;
    private int _maxAssetEntryToAssetTagCount;
    private int _maxAssetPublisherPageCount;
    private int _maxAssetTagCount;
    private int _maxAssetVocabularyCount;
    private int _maxBlogsEntryCommentCount;
    private int _maxBlogsEntryCount;
    private int _maxDDLCustomFieldCount;
    private int _maxDDLRecordCount;
    private int _maxDDLRecordSetCount;
    private int _maxDLFileEntryCount;
    private int _maxDLFileEntrySize;
    private int _maxDLFolderCount;
    private int _maxDLFolderDepth;
    private int _maxGroupsCount;
    private int _maxJournalArticleCount;
    private int _maxJournalArticlePageCount;
    private int _maxJournalArticleVersionCount;
    private int _maxMBCategoryCount;
    private int _maxMBMessageCount;
    private int _maxMBThreadCount;
    private int _maxUserCount;
    private int _maxUserToGroupCount;
    private int _maxWikiNodeCount;
    private int _maxWikiPageCommentCount;
    private int _maxWikiPageCount;
    private RoleModel _ownerRoleModel;
    private RoleModel _powerUserRoleModel;
    private SimpleCounter _resourcePermissionCounter;
    private List<RoleModel> _roleModels;
    private long _sampleUserId;
    private UserModel _sampleUserModel;
    private Format _simpleDateFormat = FastDateFormatFactoryUtil.getSimpleDateFormat((String)"yyyy-MM-dd HH:mm:ss");
    private RoleModel _siteMemberRoleModel;
    private SimpleCounter _socialActivityCounter;
    private SimpleCounter _timeCounter;
    private RoleModel _userRoleModel;
    private SimpleCounter _userScreenNameCounter;
    private VirtualHostModel _virtualHostModel;

    public DataFactory(Properties properties) throws Exception {
        this.initContext(properties);
        this._counter = new SimpleCounter((long)(this._maxGroupsCount + 1));
        this._timeCounter = new SimpleCounter();
        this._futureDateCounter = new SimpleCounter();
        this._resourcePermissionCounter = new SimpleCounter();
        this._socialActivityCounter = new SimpleCounter();
        this._userScreenNameCounter = new SimpleCounter();
        this._classNameModels = new ArrayList<ClassNameModel>();
        List models = ModelHintsUtil.getModels();
        for (String model : models) {
            ClassNameModelImpl classNameModel = new ClassNameModelImpl();
            long classNameId = this._counter.get();
            classNameModel.setClassNameId(classNameId);
            classNameModel.setValue(model);
            this._classNameModels.add(classNameModel);
            this._classNameModelsMap.put(model, classNameId);
        }
        this._accountId = this._counter.get();
        this._companyId = this._counter.get();
        this._defaultUserId = this._counter.get();
        this._globalGroupId = this._counter.get();
        this._guestGroupId = this._counter.get();
        this._sampleUserId = this._counter.get();
        this._dlDDMStructureContent = StringUtil.read((InputStream)this.getResourceInputStream("ddm_structure_basic_document.xml"));
        this.initAssetCategoryModels();
        this.initAssetTagModels();
        this.initCompanyModel();
        this.initDLFileEntryTypeModel();
        this.initGroupModels();
        int maxJournalArticleSize = GetterUtil.getInteger((String)properties.getProperty("sample.sql.max.journal.article.size"));
        this.initJournalArticleContent(maxJournalArticleSize);
        this.initRoleModels();
        this.initUserNames();
        this.initUserModels();
        this.initVirtualHostModel();
    }

    public AccountModel getAccountModel() {
        return this._accountModel;
    }

    public RoleModel getAdministratorRoleModel() {
        return this._administratorRoleModel;
    }

    public List<Long> getAssetCategoryIds(long groupId) {
        List<AssetCategoryModel> assetCategoryModels;
        SimpleCounter counter = this._assetCategoryCounters.get(groupId);
        if (counter == null) {
            counter = new SimpleCounter(0L);
            this._assetCategoryCounters.put(groupId, counter);
        }
        if ((assetCategoryModels = this._assetCategoryModelsArray[(int)groupId - 1]) == null || assetCategoryModels.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Long> assetCategoryIds = new ArrayList<Long>(this._maxAssetEntryToAssetCategoryCount);
        int i2 = 0;
        while (i2 < this._maxAssetEntryToAssetCategoryCount) {
            int index = (int)counter.get() % assetCategoryModels.size();
            AssetCategoryModel assetCategoryModel = assetCategoryModels.get(index);
            assetCategoryIds.add(assetCategoryModel.getCategoryId());
            ++i2;
        }
        return assetCategoryIds;
    }

    public List<AssetCategoryModel> getAssetCategoryModels() {
        ArrayList<AssetCategoryModel> allAssetCategoryModels = new ArrayList<AssetCategoryModel>();
        List<AssetCategoryModel>[] listArray = this._assetCategoryModelsArray;
        int n = this._assetCategoryModelsArray.length;
        int n2 = 0;
        while (n2 < n) {
            List<AssetCategoryModel> assetCategoryModels = listArray[n2];
            allAssetCategoryModels.addAll(assetCategoryModels);
            ++n2;
        }
        return allAssetCategoryModels;
    }

    public List<Long> getAssetTagIds(long groupId) {
        List<AssetTagModel> assetTagModels;
        SimpleCounter counter = this._assetTagCounters.get(groupId);
        if (counter == null) {
            counter = new SimpleCounter(0L);
            this._assetTagCounters.put(groupId, counter);
        }
        if ((assetTagModels = this._assetTagModelsArray[(int)groupId - 1]) == null || assetTagModels.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Long> assetTagIds = new ArrayList<Long>(this._maxAssetEntryToAssetTagCount);
        int i2 = 0;
        while (i2 < this._maxAssetEntryToAssetTagCount) {
            int index = (int)counter.get() % assetTagModels.size();
            AssetTagModel assetTagModel = assetTagModels.get(index);
            assetTagIds.add(assetTagModel.getTagId());
            ++i2;
        }
        return assetTagIds;
    }

    public List<AssetTagModel> getAssetTagModels() {
        ArrayList<AssetTagModel> allAssetTagModels = new ArrayList<AssetTagModel>();
        List<AssetTagModel>[] listArray = this._assetTagModelsArray;
        int n = this._assetTagModelsArray.length;
        int n2 = 0;
        while (n2 < n) {
            List<AssetTagModel> assetTagModels = listArray[n2];
            allAssetTagModels.addAll(assetTagModels);
            ++n2;
        }
        return allAssetTagModels;
    }

    public List<AssetTagStatsModel> getAssetTagStatsModels() {
        ArrayList<AssetTagStatsModel> allAssetTagStatsModels = new ArrayList<AssetTagStatsModel>();
        List<AssetTagStatsModel>[] listArray = this._assetTagStatsModelsArray;
        int n = this._assetTagStatsModelsArray.length;
        int n2 = 0;
        while (n2 < n) {
            List<AssetTagStatsModel> assetTagStatsModels = listArray[n2];
            allAssetTagStatsModels.addAll(assetTagStatsModels);
            ++n2;
        }
        return allAssetTagStatsModels;
    }

    public List<AssetVocabularyModel> getAssetVocabularyModels() {
        ArrayList<AssetVocabularyModel> allAssetVocabularyModels = new ArrayList<AssetVocabularyModel>();
        allAssetVocabularyModels.add(this._defaultAssetVocabularyModel);
        List<AssetVocabularyModel>[] listArray = this._assetVocabularyModelsArray;
        int n = this._assetVocabularyModelsArray.length;
        int n2 = 0;
        while (n2 < n) {
            List<AssetVocabularyModel> assetVocabularyModels = listArray[n2];
            allAssetVocabularyModels.addAll(assetVocabularyModels);
            ++n2;
        }
        return allAssetVocabularyModels;
    }

    public long getBlogsEntryClassNameId() {
        return this._classNameModelsMap.get(BlogsEntry.class.getName());
    }

    public List<ClassNameModel> getClassNameModels() {
        return this._classNameModels;
    }

    public CompanyModel getCompanyModel() {
        return this._companyModel;
    }

    public SimpleCounter getCounter() {
        return this._counter;
    }

    public long getCounterNext() {
        return this._counter.get();
    }

    public String getDateLong(Date date) {
        return String.valueOf(date.getTime());
    }

    public String getDateString(Date date) {
        if (date == null) {
            return null;
        }
        return this._simpleDateFormat.format(date);
    }

    public long getDDLRecordSetClassNameId() {
        return this._classNameModelsMap.get(DDLRecordSet.class.getName());
    }

    public long getDefaultDLDDMStructureId() {
        return this._defaultDLDDMStructureModel.getStructureId();
    }

    public DDMStructureModel getDefaultDLDDMStructureModel() {
        return this._defaultDLDDMStructureModel;
    }

    public DLFileEntryTypeModel getDefaultDLFileEntryTypeModel() {
        return this._defaultDLFileEntryTypeModel;
    }

    public UserModel getDefaultUserModel() {
        return this._defaultUserModel;
    }

    public long getDLFileEntryClassNameId() {
        return this._classNameModelsMap.get(DLFileEntry.class.getName());
    }

    public GroupModel getGlobalGroupModel() {
        return this._globalGroupModel;
    }

    public long getGroupClassNameId() {
        return this._classNameModelsMap.get(Group.class.getName());
    }

    public List<GroupModel> getGroupModels() {
        return this._groupModels;
    }

    public GroupModel getGuestGroupModel() {
        return this._guestGroupModel;
    }

    public UserModel getGuestUserModel() {
        return this._guestUserModel;
    }

    public long getJournalArticleClassNameId() {
        return this._classNameModelsMap.get(JournalArticle.class.getName());
    }

    public String getJournalArticleLayoutColumn(String portletPrefix) {
        StringBundler sb = new StringBundler(3 * this._maxJournalArticleCount);
        int i2 = 1;
        while (i2 <= this._maxJournalArticleCount) {
            sb.append(portletPrefix);
            sb.append(i2);
            sb.append(",");
            ++i2;
        }
        return sb.toString();
    }

    public long getLayoutClassNameId() {
        return this._classNameModelsMap.get(Layout.class.getName());
    }

    public int getMaxAssetPublisherPageCount() {
        return this._maxAssetPublisherPageCount;
    }

    public int getMaxBlogsEntryCommentCount() {
        return this._maxBlogsEntryCommentCount;
    }

    public int getMaxDDLRecordCount() {
        return this._maxDDLRecordCount;
    }

    public int getMaxDDLRecordSetCount() {
        return this._maxDDLRecordSetCount;
    }

    public int getMaxDLFolderDepth() {
        return this._maxDLFolderDepth;
    }

    public int getMaxGroupCount() {
        return this._maxGroupsCount;
    }

    public int getMaxJournalArticleCount() {
        return this._maxJournalArticleCount;
    }

    public int getMaxJournalArticlePageCount() {
        return this._maxJournalArticlePageCount;
    }

    public int getMaxJournalArticleVersionCount() {
        return this._maxJournalArticleVersionCount;
    }

    public int getMaxWikiPageCommentCount() {
        return this._maxWikiPageCommentCount;
    }

    public List<Long> getNewUserGroupIds(long groupId) {
        ArrayList<Long> groupIds = new ArrayList<Long>(this._maxUserToGroupCount + 1);
        groupIds.add(this._guestGroupModel.getGroupId());
        if (groupId + (long)this._maxUserToGroupCount > (long)this._maxGroupsCount) {
            groupId = groupId - (long)this._maxUserToGroupCount + 1L;
        }
        int i2 = 0;
        while (i2 < this._maxUserToGroupCount) {
            groupIds.add(groupId + (long)i2);
            ++i2;
        }
        return groupIds;
    }

    public RoleModel getPowerUserRoleModel() {
        return this._powerUserRoleModel;
    }

    public List<RoleModel> getRoleModels() {
        return this._roleModels;
    }

    public UserModel getSampleUserModel() {
        return this._sampleUserModel;
    }

    public List<Integer> getSequence(int size) {
        ArrayList<Integer> sequence = new ArrayList<Integer>(size);
        int i2 = 1;
        while (i2 <= size) {
            sequence.add(i2);
            ++i2;
        }
        return sequence;
    }

    public RoleModel getUserRoleModel() {
        return this._userRoleModel;
    }

    public VirtualHostModel getVirtualHostModel() {
        return this._virtualHostModel;
    }

    public long getWikiPageClassNameId() {
        return this._classNameModelsMap.get(WikiPage.class.getName());
    }

    public void initAssetCategoryModels() {
        this._assetCategoryModelsArray = new List[this._maxGroupsCount];
        this._assetVocabularyModelsArray = new List[this._maxGroupsCount];
        this._defaultAssetVocabularyModel = this.newAssetVocabularyModel(this._globalGroupId, this._defaultUserId, null, PropsValues.ASSET_VOCABULARY_DEFAULT);
        StringBundler sb = new StringBundler(4);
        int i2 = 1;
        while (i2 <= this._maxGroupsCount) {
            ArrayList<AssetVocabularyModel> assetVocabularyModels = new ArrayList<AssetVocabularyModel>(this._maxAssetVocabularyCount);
            ArrayList<AssetCategoryModel> assetCategoryModels = new ArrayList<AssetCategoryModel>(this._maxAssetVocabularyCount * this._maxAssetCategoryCount);
            long lastRightCategoryId = 2L;
            int j = 0;
            while (j < this._maxAssetVocabularyCount) {
                sb.setIndex(0);
                sb.append("TestVocabulary_");
                sb.append(i2);
                sb.append("_");
                sb.append(j);
                AssetVocabularyModel assetVocabularyModel = this.newAssetVocabularyModel(i2, this._sampleUserId, _SAMPLE_USER_NAME, sb.toString());
                assetVocabularyModels.add(assetVocabularyModel);
                int k = 0;
                while (k < this._maxAssetCategoryCount) {
                    sb.setIndex(0);
                    sb.append("TestCategory_");
                    sb.append(assetVocabularyModel.getVocabularyId());
                    sb.append("_");
                    sb.append(k);
                    AssetCategoryModel assetCategoryModel = this.newAssetCategoryModel(i2, lastRightCategoryId, sb.toString(), assetVocabularyModel.getVocabularyId());
                    lastRightCategoryId += 2L;
                    assetCategoryModels.add(assetCategoryModel);
                    ++k;
                }
                ++j;
            }
            this._assetCategoryModelsArray[i2 - 1] = assetCategoryModels;
            this._assetVocabularyModelsArray[i2 - 1] = assetVocabularyModels;
            ++i2;
        }
    }

    public void initAssetTagModels() {
        this._assetTagModelsArray = new List[this._maxGroupsCount];
        this._assetTagStatsModelsArray = new List[this._maxGroupsCount];
        int i2 = 1;
        while (i2 <= this._maxGroupsCount) {
            ArrayList<AssetTagModel> assetTagModels = new ArrayList<AssetTagModel>(this._maxAssetTagCount);
            ArrayList<AssetTagStatsModel> assetTagStatsModels = new ArrayList<AssetTagStatsModel>(this._maxAssetTagCount * 3);
            int j = 0;
            while (j < this._maxAssetTagCount) {
                AssetTagModelImpl assetTagModel = new AssetTagModelImpl();
                assetTagModel.setTagId(this._counter.get());
                assetTagModel.setGroupId(i2);
                assetTagModel.setCompanyId(this._companyId);
                assetTagModel.setUserId(this._sampleUserId);
                assetTagModel.setUserName(_SAMPLE_USER_NAME);
                assetTagModel.setCreateDate(new Date());
                assetTagModel.setModifiedDate(new Date());
                assetTagModel.setName("TestTag_" + i2 + "_" + j);
                assetTagModels.add(assetTagModel);
                AssetTagStatsModel assetTagStatsModel = this.newAssetTagStatsModel(assetTagModel.getTagId(), this._classNameModelsMap.get(BlogsEntry.class.getName()));
                assetTagStatsModels.add(assetTagStatsModel);
                assetTagStatsModel = this.newAssetTagStatsModel(assetTagModel.getTagId(), this._classNameModelsMap.get(JournalArticle.class.getName()));
                assetTagStatsModels.add(assetTagStatsModel);
                assetTagStatsModel = this.newAssetTagStatsModel(assetTagModel.getTagId(), this._classNameModelsMap.get(WikiPage.class.getName()));
                assetTagStatsModels.add(assetTagStatsModel);
                ++j;
            }
            this._assetTagModelsArray[i2 - 1] = assetTagModels;
            this._assetTagStatsModelsArray[i2 - 1] = assetTagStatsModels;
            ++i2;
        }
    }

    public void initCompanyModel() {
        this._companyModel = new CompanyModelImpl();
        this._companyModel.setCompanyId(this._companyId);
        this._companyModel.setAccountId(this._accountId);
        this._companyModel.setWebId("liferay.com");
        this._companyModel.setMx("liferay.com");
        this._companyModel.setActive(true);
        this._accountModel = new AccountModelImpl();
        this._accountModel.setAccountId(this._accountId);
        this._accountModel.setCompanyId(this._companyId);
        this._accountModel.setCreateDate(new Date());
        this._accountModel.setModifiedDate(new Date());
        this._accountModel.setName("Liferay");
        this._accountModel.setLegalName("Liferay, Inc.");
    }

    public void initContext(Properties properties) {
        this._assetPublisherQueryName = GetterUtil.getString((String)properties.getProperty("sample.sql.asset.publisher.query.name"));
        if (!this._assetPublisherQueryName.equals("assetCategories")) {
            this._assetPublisherQueryName = "assetTags";
        }
        this._maxAssetCategoryCount = GetterUtil.getInteger((String)properties.getProperty("sample.sql.max.asset.category.count"));
        this._maxAssetEntryToAssetCategoryCount = GetterUtil.getInteger((String)properties.getProperty("sample.sql.max.asset.entry.to.asset.category.count"));
        this._maxAssetEntryToAssetTagCount = GetterUtil.getInteger((String)properties.getProperty("sample.sql.max.asset.entry.to.asset.tag.count"));
        this._maxAssetPublisherPageCount = GetterUtil.getInteger((String)properties.getProperty("sample.sql.max.asset.publisher.page.count"));
        this._maxAssetTagCount = GetterUtil.getInteger((String)properties.getProperty("sample.sql.max.asset.tag.count"));
        this._maxAssetVocabularyCount = GetterUtil.getInteger((String)properties.getProperty("sample.sql.max.asset.vocabulary.count"));
        this._maxBlogsEntryCommentCount = GetterUtil.getInteger((String)properties.getProperty("sample.sql.max.blogs.entry.comment.count"));
        this._maxBlogsEntryCount = GetterUtil.getInteger((String)properties.getProperty("sample.sql.max.blogs.entry.count"));
        this._maxDDLCustomFieldCount = GetterUtil.getInteger((String)properties.getProperty("sample.sql.max.ddl.custom.field.count"));
        this._maxDDLRecordCount = GetterUtil.getInteger((String)properties.getProperty("sample.sql.max.ddl.record.count"));
        this._maxDDLRecordSetCount = GetterUtil.getInteger((String)properties.getProperty("sample.sql.max.ddl.record.set.count"));
        this._maxDLFileEntryCount = GetterUtil.getInteger((String)properties.getProperty("sample.sql.max.dl.file.entry.count"));
        this._maxDLFileEntrySize = GetterUtil.getInteger((String)properties.getProperty("sample.sql.max.dl.file.entry.size"));
        this._maxDLFolderCount = GetterUtil.getInteger((String)properties.getProperty("sample.sql.max.dl.folder.count"));
        this._maxDLFolderDepth = GetterUtil.getInteger((String)properties.getProperty("sample.sql.max.dl.folder.depth"));
        this._maxGroupsCount = GetterUtil.getInteger((String)properties.getProperty("sample.sql.max.group.count"));
        this._maxJournalArticleCount = GetterUtil.getInteger((String)properties.getProperty("sample.sql.max.journal.article.count"));
        this._maxJournalArticlePageCount = GetterUtil.getInteger((String)properties.getProperty("sample.sql.max.journal.article.page.count"));
        this._maxJournalArticleVersionCount = GetterUtil.getInteger((String)properties.getProperty("sample.sql.max.journal.article.version.count"));
        this._maxMBCategoryCount = GetterUtil.getInteger((String)properties.getProperty("sample.sql.max.mb.category.count"));
        this._maxMBMessageCount = GetterUtil.getInteger((String)properties.getProperty("sample.sql.max.mb.message.count"));
        this._maxMBThreadCount = GetterUtil.getInteger((String)properties.getProperty("sample.sql.max.mb.thread.count"));
        this._maxUserCount = GetterUtil.getInteger((String)properties.getProperty("sample.sql.max.user.count"));
        this._maxUserToGroupCount = GetterUtil.getInteger((String)properties.getProperty("sample.sql.max.user.to.group.count"));
        this._maxWikiNodeCount = GetterUtil.getInteger((String)properties.getProperty("sample.sql.max.wiki.node.count"));
        this._maxWikiPageCommentCount = GetterUtil.getInteger((String)properties.getProperty("sample.sql.max.wiki.page.comment.count"));
        this._maxWikiPageCount = GetterUtil.getInteger((String)properties.getProperty("sample.sql.max.wiki.page.count"));
    }

    public void initDLFileEntryTypeModel() {
        this._defaultDLFileEntryTypeModel = new DLFileEntryTypeModelImpl();
        this._defaultDLFileEntryTypeModel.setUuid(SequentialUUID.generate());
        this._defaultDLFileEntryTypeModel.setFileEntryTypeId(0L);
        this._defaultDLFileEntryTypeModel.setCreateDate(this.nextFutureDate());
        this._defaultDLFileEntryTypeModel.setModifiedDate(this.nextFutureDate());
        this._defaultDLFileEntryTypeModel.setFileEntryTypeKey(StringUtil.toUpperCase((String)"basic-document"));
        StringBundler sb = new StringBundler(5);
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root ");
        sb.append("available-locales=\"en_US\" default-locale=\"en_US\">");
        sb.append("<name language-id=\"en_US\">");
        sb.append("basic-document");
        sb.append("</name></root>");
        this._defaultDLFileEntryTypeModel.setName(sb.toString());
        this._defaultDLDDMStructureModel = this.newDDMStructureModel(this._guestGroupId, this.getDLFileEntryClassNameId(), "TIKARAWMETADATA", this._dlDDMStructureContent);
    }

    public void initGroupModels() throws Exception {
        long groupClassNameId = this.getGroupClassNameId();
        this._globalGroupModel = this.newGroupModel(this._globalGroupId, this._classNameModelsMap.get(Company.class.getName()), this._companyId, "Global", false);
        this._guestGroupModel = this.newGroupModel(this._guestGroupId, groupClassNameId, this._guestGroupId, "Guest", true);
        this._groupModels = new ArrayList<GroupModel>(this._maxGroupsCount);
        int i2 = 1;
        while (i2 <= this._maxGroupsCount) {
            GroupModel groupModel = this.newGroupModel(i2, groupClassNameId, i2, "Site " + i2, true);
            this._groupModels.add(groupModel);
            ++i2;
        }
    }

    public void initJournalArticleContent(int maxJournalArticleSize) {
        StringBundler sb = new StringBundler(5);
        sb.append("<?xml version=\"1.0\"?><root available-locales=\"en_US\" ");
        sb.append("default-locale=\"en_US\"><static-content language-id=");
        sb.append("\"en_US\"><![CDATA[<p>");
        if (maxJournalArticleSize <= 0) {
            maxJournalArticleSize = 1;
        }
        char[] chars = new char[maxJournalArticleSize];
        int i2 = 0;
        while (i2 < maxJournalArticleSize) {
            chars[i2] = (char)(97 + i2 % 26);
            ++i2;
        }
        sb.append(new String(chars));
        sb.append("</p>]]></static-content></root>");
        this._journalArticleContent = sb.toString();
    }

    public void initRoleModels() {
        this._roleModels = new ArrayList<RoleModel>();
        this._administratorRoleModel = this.newRoleModel("Administrator", 1);
        this._roleModels.add(this._administratorRoleModel);
        this._guestRoleModel = this.newRoleModel("Guest", 1);
        this._roleModels.add(this._guestRoleModel);
        RoleModel organizationAdministratorRoleModel = this.newRoleModel("Organization Administrator", 3);
        this._roleModels.add(organizationAdministratorRoleModel);
        RoleModel organizationOwnerRoleModel = this.newRoleModel("Organization Owner", 3);
        this._roleModels.add(organizationOwnerRoleModel);
        RoleModel organizationUserRoleModel = this.newRoleModel("Organization User", 3);
        this._roleModels.add(organizationUserRoleModel);
        this._ownerRoleModel = this.newRoleModel("Owner", 1);
        this._roleModels.add(this._ownerRoleModel);
        this._powerUserRoleModel = this.newRoleModel("Power User", 1);
        this._roleModels.add(this._powerUserRoleModel);
        RoleModel siteAdministratorRoleModel = this.newRoleModel("Site Administrator", 2);
        this._roleModels.add(siteAdministratorRoleModel);
        this._siteMemberRoleModel = this.newRoleModel("Site Member", 2);
        this._roleModels.add(this._siteMemberRoleModel);
        RoleModel siteOwnerRoleModel = this.newRoleModel("Site Owner", 2);
        this._roleModels.add(siteOwnerRoleModel);
        this._userRoleModel = this.newRoleModel("User", 1);
        this._roleModels.add(this._userRoleModel);
    }

    public void initUserModels() {
        this._defaultUserModel = this.newUserModel(this._defaultUserId, "", "", "", true);
        this._guestUserModel = this.newUserModel(this._counter.get(), "Test", "Test", "Test", false);
        this._sampleUserModel = this.newUserModel(this._sampleUserId, _SAMPLE_USER_NAME, _SAMPLE_USER_NAME, _SAMPLE_USER_NAME, false);
    }

    public void initUserNames() throws IOException {
        this._firstNames = new ArrayList<String>();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new InputStreamReader(this.getResourceInputStream("first_names.txt")));
        String line = null;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            this._firstNames.add(line);
        }
        unsyncBufferedReader.close();
        this._lastNames = new ArrayList<String>();
        unsyncBufferedReader = new UnsyncBufferedReader((Reader)new InputStreamReader(this.getResourceInputStream("last_names.txt")));
        while ((line = unsyncBufferedReader.readLine()) != null) {
            this._lastNames.add(line);
        }
        unsyncBufferedReader.close();
    }

    public void initVirtualHostModel() {
        this._virtualHostModel = new VirtualHostModelImpl();
        this._virtualHostModel.setVirtualHostId(this._counter.get());
        this._virtualHostModel.setCompanyId(this._companyId);
        this._virtualHostModel.setHostname("localhost");
    }

    public AssetEntryModel newAssetEntryModel(BlogsEntryModel blogsEntryModel) {
        return this.newAssetEntryModel(blogsEntryModel.getGroupId(), blogsEntryModel.getCreateDate(), blogsEntryModel.getModifiedDate(), this.getBlogsEntryClassNameId(), blogsEntryModel.getEntryId(), blogsEntryModel.getUuid(), 0L, true, "text/html", blogsEntryModel.getTitle());
    }

    public AssetEntryModel newAssetEntryModel(DLFileEntryModel dLFileEntryModel) {
        return this.newAssetEntryModel(dLFileEntryModel.getGroupId(), dLFileEntryModel.getCreateDate(), dLFileEntryModel.getModifiedDate(), this.getDLFileEntryClassNameId(), dLFileEntryModel.getFileEntryId(), dLFileEntryModel.getUuid(), dLFileEntryModel.getFileEntryTypeId(), true, dLFileEntryModel.getMimeType(), dLFileEntryModel.getTitle());
    }

    public AssetEntryModel newAssetEntryModel(DLFolderModel dLFolderModel) {
        return this.newAssetEntryModel(dLFolderModel.getGroupId(), dLFolderModel.getCreateDate(), dLFolderModel.getModifiedDate(), this._classNameModelsMap.get(DLFolder.class.getName()), dLFolderModel.getFolderId(), dLFolderModel.getUuid(), 0L, true, null, dLFolderModel.getName());
    }

    public AssetEntryModel newAssetEntryModel(JournalArticleModel journalArticleModel) {
        return this.newAssetEntryModel(journalArticleModel.getGroupId(), journalArticleModel.getCreateDate(), journalArticleModel.getModifiedDate(), this.getJournalArticleClassNameId(), journalArticleModel.getResourcePrimKey(), journalArticleModel.getUuid(), 0L, true, "text/html", journalArticleModel.getTitle());
    }

    public AssetEntryModel newAssetEntryModel(MBMessageModel mbMessageModel) {
        long classNameId = 0L;
        boolean visible = false;
        if (mbMessageModel.getCategoryId() == -1L) {
            classNameId = this._classNameModelsMap.get(MBDiscussion.class.getName());
        } else {
            classNameId = this._classNameModelsMap.get(MBMessage.class.getName());
            visible = true;
        }
        return this.newAssetEntryModel(mbMessageModel.getGroupId(), mbMessageModel.getCreateDate(), mbMessageModel.getModifiedDate(), classNameId, mbMessageModel.getMessageId(), mbMessageModel.getUuid(), 0L, visible, "text/html", mbMessageModel.getSubject());
    }

    public AssetEntryModel newAssetEntryModel(MBThreadModel mbThreadModel) {
        return this.newAssetEntryModel(mbThreadModel.getGroupId(), mbThreadModel.getCreateDate(), mbThreadModel.getModifiedDate(), this._classNameModelsMap.get(MBThread.class.getName()), mbThreadModel.getThreadId(), mbThreadModel.getUuid(), 0L, false, "", String.valueOf(mbThreadModel.getRootMessageId()));
    }

    public AssetEntryModel newAssetEntryModel(WikiPageModel wikiPageModel) {
        return this.newAssetEntryModel(wikiPageModel.getGroupId(), wikiPageModel.getCreateDate(), wikiPageModel.getModifiedDate(), this.getWikiPageClassNameId(), wikiPageModel.getResourcePrimKey(), wikiPageModel.getUuid(), 0L, true, "text/html", wikiPageModel.getTitle());
    }

    public List<PortletPreferencesModel> newAssetPublisherPortletPreferencesModels(long plid) {
        ArrayList<PortletPreferencesModel> portletPreferencesModels = new ArrayList<PortletPreferencesModel>(4);
        portletPreferencesModels.add(this.newPortletPreferencesModel(plid, "33", "<portlet-preferences />"));
        portletPreferencesModels.add(this.newPortletPreferencesModel(plid, "145", "<portlet-preferences />"));
        portletPreferencesModels.add(this.newPortletPreferencesModel(plid, "15", "<portlet-preferences />"));
        portletPreferencesModels.add(this.newPortletPreferencesModel(plid, "36", "<portlet-preferences />"));
        return portletPreferencesModels;
    }

    public List<BlogsEntryModel> newBlogsEntryModels(long groupId) {
        ArrayList<BlogsEntryModel> blogEntryModels = new ArrayList<BlogsEntryModel>(this._maxBlogsEntryCount);
        int i2 = 1;
        while (i2 <= this._maxBlogsEntryCount) {
            blogEntryModels.add(this.newBlogsEntryModel(groupId, i2));
            ++i2;
        }
        return blogEntryModels;
    }

    public BlogsStatsUserModel newBlogsStatsUserModel(long groupId) {
        BlogsStatsUserModelImpl blogsStatsUserModel = new BlogsStatsUserModelImpl();
        blogsStatsUserModel.setStatsUserId(this._counter.get());
        blogsStatsUserModel.setGroupId(groupId);
        blogsStatsUserModel.setCompanyId(this._companyId);
        blogsStatsUserModel.setUserId(this._sampleUserId);
        blogsStatsUserModel.setEntryCount(this._maxBlogsEntryCount);
        blogsStatsUserModel.setLastPostDate(new Date());
        return blogsStatsUserModel;
    }

    public ContactModel newContactModel(UserModel userModel) {
        ContactModelImpl contactModel = new ContactModelImpl();
        contactModel.setContactId(userModel.getContactId());
        contactModel.setCompanyId(userModel.getCompanyId());
        contactModel.setUserId(userModel.getUserId());
        FullNameGenerator fullNameGenerator = FullNameGeneratorFactory.getInstance();
        String fullName = fullNameGenerator.getFullName(userModel.getFirstName(), userModel.getMiddleName(), userModel.getLastName());
        contactModel.setUserName(fullName);
        contactModel.setCreateDate(new Date());
        contactModel.setModifiedDate(new Date());
        contactModel.setClassNameId(this._classNameModelsMap.get(User.class.getName()));
        contactModel.setClassPK(userModel.getUserId());
        contactModel.setAccountId(this._accountId);
        contactModel.setParentContactId(0L);
        contactModel.setEmailAddress(userModel.getEmailAddress());
        contactModel.setFirstName(userModel.getFirstName());
        contactModel.setLastName(userModel.getLastName());
        contactModel.setMale(true);
        contactModel.setBirthday(new Date());
        return contactModel;
    }

    public List<CounterModel> newCounterModels() {
        ArrayList<CounterModel> counterModels = new ArrayList<CounterModel>();
        CounterModelImpl counterModel = new CounterModelImpl();
        counterModel.setName(Counter.class.getName());
        counterModel.setCurrentId(this._counter.get());
        counterModels.add(counterModel);
        counterModel = new CounterModelImpl();
        counterModel.setName(ResourcePermission.class.getName());
        counterModel.setCurrentId(this._resourcePermissionCounter.get());
        counterModels.add(counterModel);
        counterModel = new CounterModelImpl();
        counterModel.setName(SocialActivity.class.getName());
        counterModel.setCurrentId(this._socialActivityCounter.get());
        counterModels.add(counterModel);
        return counterModels;
    }

    public DDMStructureModel newDDLDDMStructureModel(long groupId) {
        StringBundler sb = new StringBundler(3 + this._maxDDLCustomFieldCount * 10);
        sb.append("<?xml version=\"1.0\"?>");
        sb.append("<root available-locales=\"en_US\" default-locale=\"en_US\">");
        int i2 = 0;
        while (i2 < this._maxDDLCustomFieldCount) {
            sb.append("<dynamic-element dataType=\"string\" indexType=\"keyword\"");
            sb.append(" name=\"");
            sb.append(this.nextDDLCustomFieldName(groupId, i2));
            sb.append("\" readOnly=\"false\" repeatable=\"false\" required=\"false");
            sb.append("\" showLabel=\"true\" type=\"text\" width=\"25\"><meta-data");
            sb.append(" locale=\"en_US\"><entry name=\"label\"><![CDATA[Text");
            sb.append(i2);
            sb.append("]]></entry><entry name=\"predefinedValue\"><![CDATA[]]>");
            sb.append("</entry><entry name=\"tip\"><![CDATA[]]></entry>");
            sb.append("</meta-data></dynamic-element>");
            ++i2;
        }
        sb.append("</root>");
        return this.newDDMStructureModel(groupId, this._classNameModelsMap.get(DDLRecordSet.class.getName()), "Test DDM Structure", sb.toString());
    }

    public DDLRecordModel newDDLRecordModel(DDLRecordSetModel dDLRecordSetModel) {
        DDLRecordModelImpl ddlRecordModel = new DDLRecordModelImpl();
        ddlRecordModel.setUuid(SequentialUUID.generate());
        ddlRecordModel.setRecordId(this._counter.get());
        ddlRecordModel.setGroupId(dDLRecordSetModel.getGroupId());
        ddlRecordModel.setCompanyId(this._companyId);
        ddlRecordModel.setUserId(this._sampleUserId);
        ddlRecordModel.setUserName(_SAMPLE_USER_NAME);
        ddlRecordModel.setVersionUserId(this._sampleUserId);
        ddlRecordModel.setVersionUserName(_SAMPLE_USER_NAME);
        ddlRecordModel.setCreateDate(new Date());
        ddlRecordModel.setModifiedDate(new Date());
        ddlRecordModel.setDDMStorageId(this._counter.get());
        ddlRecordModel.setRecordSetId(dDLRecordSetModel.getRecordSetId());
        ddlRecordModel.setVersion("1.0");
        ddlRecordModel.setDisplayIndex(0);
        return ddlRecordModel;
    }

    public DDLRecordSetModel newDDLRecordSetModel(DDMStructureModel ddmStructureModel, int currentIndex) {
        DDLRecordSetModelImpl ddlRecordSetModel = new DDLRecordSetModelImpl();
        ddlRecordSetModel.setUuid(SequentialUUID.generate());
        ddlRecordSetModel.setRecordSetId(this._counter.get());
        ddlRecordSetModel.setGroupId(ddmStructureModel.getGroupId());
        ddlRecordSetModel.setCompanyId(this._companyId);
        ddlRecordSetModel.setUserId(this._sampleUserId);
        ddlRecordSetModel.setUserName(_SAMPLE_USER_NAME);
        ddlRecordSetModel.setCreateDate(new Date());
        ddlRecordSetModel.setModifiedDate(new Date());
        ddlRecordSetModel.setDDMStructureId(ddmStructureModel.getStructureId());
        ddlRecordSetModel.setRecordSetKey(String.valueOf(this._counter.get()));
        StringBundler sb = new StringBundler(5);
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root ");
        sb.append("available-locales=\"en_US\" default-locale=\"en_US\">");
        sb.append("<name language-id=\"en_US\">Test DDL Record Set ");
        sb.append(currentIndex);
        sb.append("</name></root>");
        ddlRecordSetModel.setName(sb.toString());
        ddlRecordSetModel.setMinDisplayRows(10);
        ddlRecordSetModel.setScope(0);
        return ddlRecordSetModel;
    }

    public DDLRecordVersionModel newDDLRecordVersionModel(DDLRecordModel dDLRecordModel) {
        DDLRecordVersionModelImpl ddlRecordVersionModel = new DDLRecordVersionModelImpl();
        ddlRecordVersionModel.setRecordVersionId(this._counter.get());
        ddlRecordVersionModel.setGroupId(dDLRecordModel.getGroupId());
        ddlRecordVersionModel.setCompanyId(this._companyId);
        ddlRecordVersionModel.setUserId(this._sampleUserId);
        ddlRecordVersionModel.setUserName(_SAMPLE_USER_NAME);
        ddlRecordVersionModel.setCreateDate(dDLRecordModel.getModifiedDate());
        ddlRecordVersionModel.setDDMStorageId(dDLRecordModel.getDDMStorageId());
        ddlRecordVersionModel.setRecordSetId(dDLRecordModel.getRecordSetId());
        ddlRecordVersionModel.setRecordId(dDLRecordModel.getRecordId());
        ddlRecordVersionModel.setVersion(dDLRecordModel.getVersion());
        ddlRecordVersionModel.setDisplayIndex(dDLRecordModel.getDisplayIndex());
        ddlRecordVersionModel.setStatus(0);
        ddlRecordVersionModel.setStatusDate(dDLRecordModel.getModifiedDate());
        return ddlRecordVersionModel;
    }

    public DDMContentModel newDDMContentModel(DDLRecordModel ddlRecordModel, int currentIndex) {
        StringBundler sb = new StringBundler(3 + this._maxDDLCustomFieldCount * 10);
        sb.append("<?xml version=\"1.0\"?><root>");
        int i2 = 0;
        while (i2 < this._maxDDLCustomFieldCount) {
            sb.append("<dynamic-element default-language-id=\"en_US\" name=\"");
            sb.append(this.nextDDLCustomFieldName(ddlRecordModel.getGroupId(), i2));
            sb.append("\"><dynamic-content language-id=\"en_US\">");
            sb.append("<![CDATA[Test Record ");
            sb.append(currentIndex);
            sb.append("]]></dynamic-content></dynamic-element>");
            ++i2;
        }
        sb.append("<dynamic-element default-language-id=\"en_US\" name=\"_");
        sb.append("fieldsDisplay\"><dynamic-content language-id=\"en_US\"><![CDATA[");
        i2 = 0;
        while (i2 < this._maxDDLCustomFieldCount) {
            sb.append(this.nextDDLCustomFieldName(ddlRecordModel.getGroupId(), i2));
            sb.append("_INSTANCE_");
            sb.append(StringUtil.randomId());
            sb.append(",");
            ++i2;
        }
        sb.setStringAt("]]></dynamic-content></dynamic-element></root>", sb.index() - 1);
        return this.newDDMContentModel(ddlRecordModel.getDDMStorageId(), ddlRecordModel.getGroupId(), sb.toString());
    }

    public DDMContentModel newDDMContentModel(DLFileEntryModel dlFileEntryModel) {
        StringBundler sb = new StringBundler(5);
        sb.append("<?xml version=\"1.0\"?><root><dynamic-element ");
        sb.append("name=\"CONTENT_TYPE\"><dynamic-content>");
        sb.append("<![CDATA[text/plain]]></dynamic-content></dynamic-element>");
        sb.append("<dynamic-element <![CDATA[ISO-8859-1]]></dynamic-content>");
        sb.append("</dynamic-element></root>");
        return this.newDDMContentModel(this._counter.get(), dlFileEntryModel.getGroupId(), sb.toString());
    }

    public DDMStorageLinkModel newDDMStorageLinkModel(long ddmStorageLinkId, DDMContentModel ddmContentModel, long structureId) {
        DDMStorageLinkModelImpl ddmStorageLinkModel = new DDMStorageLinkModelImpl();
        ddmStorageLinkModel.setUuid(SequentialUUID.generate());
        ddmStorageLinkModel.setStorageLinkId(ddmStorageLinkId);
        ddmStorageLinkModel.setClassNameId(this._classNameModelsMap.get(DDMContent.class.getName()));
        ddmStorageLinkModel.setClassPK(ddmContentModel.getContentId());
        ddmStorageLinkModel.setStructureId(structureId);
        return ddmStorageLinkModel;
    }

    public DDMStructureLinkModel newDDMStructureLinkModel(DDLRecordSetModel ddlRecordSetModel) {
        return this.newDDMStructureLinkModel(this._classNameModelsMap.get(DDLRecordSet.class.getName()), ddlRecordSetModel.getRecordSetId(), ddlRecordSetModel.getDDMStructureId());
    }

    public DDMStructureLinkModel newDDMStructureLinkModel(DLFileEntryMetadataModel dLFileEntryMetadataModel) {
        return this.newDDMStructureLinkModel(this._classNameModelsMap.get(DLFileEntryMetadata.class.getName()), dLFileEntryMetadataModel.getFileEntryMetadataId(), dLFileEntryMetadataModel.getDDMStructureId());
    }

    public DLFileEntryMetadataModel newDLFileEntryMetadataModel(long ddmStorageLinkId, long ddmStructureId, DLFileVersionModel dlFileVersionModel) {
        DLFileEntryMetadataModelImpl dlFileEntryMetadataModel = new DLFileEntryMetadataModelImpl();
        dlFileEntryMetadataModel.setUuid(SequentialUUID.generate());
        dlFileEntryMetadataModel.setFileEntryMetadataId(this._counter.get());
        dlFileEntryMetadataModel.setDDMStorageId(ddmStorageLinkId);
        dlFileEntryMetadataModel.setDDMStructureId(ddmStructureId);
        dlFileEntryMetadataModel.setFileEntryTypeId(dlFileVersionModel.getFileEntryTypeId());
        dlFileEntryMetadataModel.setFileEntryId(dlFileVersionModel.getFileEntryId());
        dlFileEntryMetadataModel.setFileVersionId(dlFileVersionModel.getFileVersionId());
        return dlFileEntryMetadataModel;
    }

    public List<DLFileEntryModel> newDlFileEntryModels(DLFolderModel dlFolerModel) {
        ArrayList<DLFileEntryModel> dlFileEntryModels = new ArrayList<DLFileEntryModel>(this._maxDLFileEntryCount);
        int i2 = 1;
        while (i2 <= this._maxDLFileEntryCount) {
            dlFileEntryModels.add(this.newDlFileEntryModel(dlFolerModel, i2));
            ++i2;
        }
        return dlFileEntryModels;
    }

    public DLFileVersionModel newDLFileVersionModel(DLFileEntryModel dlFileEntryModel) {
        DLFileVersionModelImpl dlFileVersionModel = new DLFileVersionModelImpl();
        dlFileVersionModel.setUuid(SequentialUUID.generate());
        dlFileVersionModel.setFileVersionId(this._counter.get());
        dlFileVersionModel.setGroupId(dlFileEntryModel.getGroupId());
        dlFileVersionModel.setCompanyId(this._companyId);
        dlFileVersionModel.setUserId(this._sampleUserId);
        dlFileVersionModel.setUserName(_SAMPLE_USER_NAME);
        dlFileVersionModel.setCreateDate(this.nextFutureDate());
        dlFileVersionModel.setModifiedDate(this.nextFutureDate());
        dlFileVersionModel.setRepositoryId(dlFileEntryModel.getRepositoryId());
        dlFileVersionModel.setFolderId(dlFileEntryModel.getFolderId());
        dlFileVersionModel.setFileEntryId(dlFileEntryModel.getFileEntryId());
        dlFileVersionModel.setExtension(dlFileEntryModel.getExtension());
        dlFileVersionModel.setMimeType(dlFileEntryModel.getMimeType());
        dlFileVersionModel.setTitle(dlFileEntryModel.getTitle());
        dlFileVersionModel.setFileEntryTypeId(dlFileEntryModel.getFileEntryTypeId());
        dlFileVersionModel.setVersion(dlFileEntryModel.getVersion());
        dlFileVersionModel.setSize(dlFileEntryModel.getSize());
        return dlFileVersionModel;
    }

    public List<DLFolderModel> newDLFolderModels(long groupId, long parentFolderId) {
        ArrayList<DLFolderModel> dlFolderModels = new ArrayList<DLFolderModel>(this._maxDLFolderCount);
        int i2 = 1;
        while (i2 <= this._maxDLFolderCount) {
            dlFolderModels.add(this.newDLFolderModel(groupId, parentFolderId, i2));
            ++i2;
        }
        return dlFolderModels;
    }

    public GroupModel newGroupModel(UserModel userModel) throws Exception {
        return this.newGroupModel(this._counter.get(), this._classNameModelsMap.get(User.class.getName()), userModel.getUserId(), userModel.getScreenName(), false);
    }

    public IntegerWrapper newInteger() {
        return new IntegerWrapper();
    }

    public JournalArticleModel newJournalArticleModel(JournalArticleResourceModel journalArticleResourceModel, int articleIndex, int versionIndex) {
        JournalArticleModelImpl journalArticleModel = new JournalArticleModelImpl();
        journalArticleModel.setUuid(SequentialUUID.generate());
        journalArticleModel.setId(this._counter.get());
        journalArticleModel.setResourcePrimKey(journalArticleResourceModel.getResourcePrimKey());
        journalArticleModel.setGroupId(journalArticleResourceModel.getGroupId());
        journalArticleModel.setCompanyId(this._companyId);
        journalArticleModel.setUserId(this._sampleUserId);
        journalArticleModel.setUserName(_SAMPLE_USER_NAME);
        journalArticleModel.setCreateDate(new Date());
        journalArticleModel.setModifiedDate(new Date());
        journalArticleModel.setClassNameId(0L);
        journalArticleModel.setArticleId(journalArticleResourceModel.getArticleId());
        journalArticleModel.setVersion(versionIndex);
        StringBundler sb = new StringBundler(4);
        sb.append("TestJournalArticle_");
        sb.append(articleIndex);
        sb.append("_");
        sb.append(versionIndex);
        String urlTitle = sb.toString();
        sb = new StringBundler(5);
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root ");
        sb.append("available-locales=\"en_US\" default-locale=\"en_US\">");
        sb.append("<Title language-id=\"en_US\">");
        sb.append(urlTitle);
        sb.append("</Title></root>");
        String title = sb.toString();
        journalArticleModel.setTitle(title);
        journalArticleModel.setUrlTitle(urlTitle);
        journalArticleModel.setContent(this._journalArticleContent);
        journalArticleModel.setType("general");
        journalArticleModel.setDisplayDate(new Date());
        journalArticleModel.setExpirationDate(this.nextFutureDate());
        journalArticleModel.setReviewDate(new Date());
        journalArticleModel.setIndexable(true);
        journalArticleModel.setStatusDate(new Date());
        return journalArticleModel;
    }

    public JournalArticleResourceModel newJournalArticleResourceModel(long groupId) {
        JournalArticleResourceModelImpl journalArticleResourceModel = new JournalArticleResourceModelImpl();
        journalArticleResourceModel.setUuid(SequentialUUID.generate());
        journalArticleResourceModel.setResourcePrimKey(this._counter.get());
        journalArticleResourceModel.setGroupId(groupId);
        journalArticleResourceModel.setArticleId(String.valueOf(this._counter.get()));
        return journalArticleResourceModel;
    }

    public JournalContentSearchModel newJournalContentSearchModel(JournalArticleModel journalArticleModel, long layoutId) {
        JournalContentSearchModelImpl journalContentSearchModel = new JournalContentSearchModelImpl();
        journalContentSearchModel.setContentSearchId(this._counter.get());
        journalContentSearchModel.setGroupId(journalArticleModel.getGroupId());
        journalContentSearchModel.setCompanyId(this._companyId);
        journalContentSearchModel.setLayoutId(layoutId);
        journalContentSearchModel.setPortletId("56");
        journalContentSearchModel.setArticleId(journalArticleModel.getArticleId());
        return journalContentSearchModel;
    }

    public LayoutFriendlyURLModel newLayoutFriendlyURLModel(LayoutModel layoutModel) {
        LayoutFriendlyURLModelImpl layoutFriendlyURLModel = new LayoutFriendlyURLModelImpl();
        layoutFriendlyURLModel.setUuid(SequentialUUID.generate());
        layoutFriendlyURLModel.setLayoutFriendlyURLId(this._counter.get());
        layoutFriendlyURLModel.setGroupId(layoutModel.getGroupId());
        layoutFriendlyURLModel.setCompanyId(this._companyId);
        layoutFriendlyURLModel.setUserId(this._sampleUserId);
        layoutFriendlyURLModel.setUserName(_SAMPLE_USER_NAME);
        layoutFriendlyURLModel.setCreateDate(new Date());
        layoutFriendlyURLModel.setModifiedDate(new Date());
        layoutFriendlyURLModel.setPlid(layoutModel.getPlid());
        layoutFriendlyURLModel.setFriendlyURL(layoutModel.getFriendlyURL());
        layoutFriendlyURLModel.setLanguageId("en_US");
        return layoutFriendlyURLModel;
    }

    public LayoutModel newLayoutModel(long groupId, String name, String column1, String column2) {
        SimpleCounter simpleCounter = this._layoutCounters.get(groupId);
        if (simpleCounter == null) {
            simpleCounter = new SimpleCounter();
            this._layoutCounters.put(groupId, simpleCounter);
        }
        LayoutModelImpl layoutModel = new LayoutModelImpl();
        layoutModel.setUuid(SequentialUUID.generate());
        layoutModel.setPlid(this._counter.get());
        layoutModel.setGroupId(groupId);
        layoutModel.setCompanyId(this._companyId);
        layoutModel.setUserId(this._sampleUserId);
        layoutModel.setUserName(_SAMPLE_USER_NAME);
        layoutModel.setCreateDate(new Date());
        layoutModel.setModifiedDate(new Date());
        layoutModel.setLayoutId(simpleCounter.get());
        layoutModel.setName("<?xml version=\"1.0\"?><root><name>" + name + "</name></root>");
        layoutModel.setType("portlet");
        layoutModel.setFriendlyURL("/" + name);
        UnicodeProperties typeSettingsProperties = new UnicodeProperties(true);
        typeSettingsProperties.setProperty("layout-template-id", "2_columns_ii");
        typeSettingsProperties.setProperty("column-1", column1);
        typeSettingsProperties.setProperty("column-2", column2);
        String typeSettings = StringUtil.replace((String)typeSettingsProperties.toString(), (String)"\n", (String)"\\n");
        layoutModel.setTypeSettings(typeSettings);
        return layoutModel;
    }

    public List<LayoutSetModel> newLayoutSetModels(long groupId, int publicLayoutSetPageCount) {
        ArrayList<LayoutSetModel> layoutSetModels = new ArrayList<LayoutSetModel>(2);
        layoutSetModels.add(this.newLayoutSetModel(groupId, true, 0));
        layoutSetModels.add(this.newLayoutSetModel(groupId, false, publicLayoutSetPageCount));
        return layoutSetModels;
    }

    public List<MBCategoryModel> newMBCategoryModels(long groupId) {
        ArrayList<MBCategoryModel> mbCategoryModels = new ArrayList<MBCategoryModel>(this._maxMBCategoryCount);
        int i2 = 1;
        while (i2 <= this._maxMBCategoryCount) {
            mbCategoryModels.add(this.newMBCategoryModel(groupId, i2));
            ++i2;
        }
        return mbCategoryModels;
    }

    public MBDiscussionModel newMBDiscussionModel(long groupId, long classNameId, long classPK, long threadId) {
        MBDiscussionModelImpl mbDiscussionModel = new MBDiscussionModelImpl();
        mbDiscussionModel.setUuid(SequentialUUID.generate());
        mbDiscussionModel.setDiscussionId(this._counter.get());
        mbDiscussionModel.setGroupId(groupId);
        mbDiscussionModel.setCompanyId(this._companyId);
        mbDiscussionModel.setUserId(this._sampleUserId);
        mbDiscussionModel.setUserName(_SAMPLE_USER_NAME);
        mbDiscussionModel.setCreateDate(new Date());
        mbDiscussionModel.setModifiedDate(new Date());
        mbDiscussionModel.setClassNameId(classNameId);
        mbDiscussionModel.setClassPK(classPK);
        mbDiscussionModel.setThreadId(threadId);
        return mbDiscussionModel;
    }

    public MBMailingListModel newMBMailingListModel(MBCategoryModel mbCategoryModel) {
        MBMailingListModelImpl mbMailingListModel = new MBMailingListModelImpl();
        mbMailingListModel.setUuid(SequentialUUID.generate());
        mbMailingListModel.setMailingListId(this._counter.get());
        mbMailingListModel.setGroupId(mbCategoryModel.getGroupId());
        mbMailingListModel.setCompanyId(this._companyId);
        mbMailingListModel.setUserId(this._sampleUserId);
        mbMailingListModel.setUserName(_SAMPLE_USER_NAME);
        mbMailingListModel.setCreateDate(new Date());
        mbMailingListModel.setModifiedDate(new Date());
        mbMailingListModel.setCategoryId(mbCategoryModel.getCategoryId());
        mbMailingListModel.setInProtocol("pop3");
        mbMailingListModel.setInServerPort(110);
        mbMailingListModel.setInUserName(this._sampleUserModel.getEmailAddress());
        mbMailingListModel.setInPassword(this._sampleUserModel.getPassword());
        mbMailingListModel.setInReadInterval(5);
        mbMailingListModel.setOutServerPort(25);
        return mbMailingListModel;
    }

    public MBMessageModel newMBMessageModel(MBThreadModel mbThreadModel, long classNameId, long classPK, int index) {
        long messageId = 0L;
        long parentMessageId = 0L;
        String subject = null;
        String body = null;
        if (index == 0) {
            messageId = mbThreadModel.getRootMessageId();
            parentMessageId = 0L;
            subject = String.valueOf(classPK);
            body = String.valueOf(classPK);
        } else {
            messageId = this._counter.get();
            parentMessageId = mbThreadModel.getRootMessageId();
            subject = "N/A";
            body = "This is test comment " + index + ".";
        }
        return this.newMBMessageModel(mbThreadModel.getGroupId(), classNameId, classPK, -1L, mbThreadModel.getThreadId(), messageId, mbThreadModel.getRootMessageId(), parentMessageId, subject, body);
    }

    public List<MBMessageModel> newMBMessageModels(MBThreadModel mbThreadModel) {
        ArrayList<MBMessageModel> mbMessageModels = new ArrayList<MBMessageModel>(this._maxMBMessageCount);
        mbMessageModels.add(this.newMBMessageModel(mbThreadModel.getGroupId(), 0L, 0L, mbThreadModel.getCategoryId(), mbThreadModel.getThreadId(), mbThreadModel.getRootMessageId(), mbThreadModel.getRootMessageId(), 0L, "Test Message 1", "This is test message 1."));
        int i2 = 2;
        while (i2 <= this._maxMBMessageCount) {
            mbMessageModels.add(this.newMBMessageModel(mbThreadModel.getGroupId(), 0L, 0L, mbThreadModel.getCategoryId(), mbThreadModel.getThreadId(), this._counter.get(), mbThreadModel.getRootMessageId(), mbThreadModel.getRootMessageId(), "Test Message " + i2, "This is test message " + i2 + "."));
            ++i2;
        }
        return mbMessageModels;
    }

    public List<MBMessageModel> newMBMessageModels(MBThreadModel mbThreadModel, long classNameId, long classPK, int maxMessageCount) {
        ArrayList<MBMessageModel> mbMessageModels = new ArrayList<MBMessageModel>(maxMessageCount);
        int i2 = 1;
        while (i2 <= maxMessageCount) {
            mbMessageModels.add(this.newMBMessageModel(mbThreadModel, classNameId, classPK, i2));
            ++i2;
        }
        return mbMessageModels;
    }

    public MBStatsUserModel newMBStatsUserModel(long groupId) {
        MBStatsUserModelImpl mbStatsUserModel = new MBStatsUserModelImpl();
        mbStatsUserModel.setStatsUserId(this._counter.get());
        mbStatsUserModel.setGroupId(groupId);
        mbStatsUserModel.setUserId(this._sampleUserId);
        mbStatsUserModel.setMessageCount(this._maxMBCategoryCount * this._maxMBThreadCount * this._maxMBMessageCount);
        mbStatsUserModel.setLastPostDate(new Date());
        return mbStatsUserModel;
    }

    public MBThreadFlagModel newMBThreadFlagModel(MBThreadModel mbThreadModel) {
        MBThreadFlagModelImpl mbThreadFlagModel = new MBThreadFlagModelImpl();
        mbThreadFlagModel.setUuid(SequentialUUID.generate());
        mbThreadFlagModel.setThreadFlagId(this._counter.get());
        mbThreadFlagModel.setGroupId(mbThreadModel.getGroupId());
        mbThreadFlagModel.setCompanyId(this._companyId);
        mbThreadFlagModel.setUserId(this._sampleUserId);
        mbThreadFlagModel.setUserName(_SAMPLE_USER_NAME);
        mbThreadFlagModel.setCreateDate(new Date());
        mbThreadFlagModel.setModifiedDate(new Date());
        mbThreadFlagModel.setThreadId(mbThreadModel.getThreadId());
        return mbThreadFlagModel;
    }

    public MBThreadModel newMBThreadModel(long threadId, long groupId, long rootMessageId, int messageCount) {
        if (messageCount == 0) {
            messageCount = 1;
        }
        return this.newMBThreadModel(threadId, groupId, -1L, rootMessageId, messageCount);
    }

    public List<MBThreadModel> newMBThreadModels(MBCategoryModel mbCategoryModel) {
        ArrayList<MBThreadModel> mbThreadModels = new ArrayList<MBThreadModel>(this._maxMBThreadCount);
        int i2 = 0;
        while (i2 < this._maxMBThreadCount) {
            mbThreadModels.add(this.newMBThreadModel(this._counter.get(), mbCategoryModel.getGroupId(), mbCategoryModel.getCategoryId(), this._counter.get(), this._maxMBMessageCount));
            ++i2;
        }
        return mbThreadModels;
    }

    public PortletPreferencesModel newPortletPreferencesModel(long plid, long groupId, String portletId, int currentIndex) throws Exception {
        if (currentIndex == 1) {
            return this.newPortletPreferencesModel(plid, portletId, "<portlet-preferences />");
        }
        SimpleCounter counter = this._assetPublisherQueryCounter.get(groupId);
        if (counter == null) {
            counter = new SimpleCounter(0L);
            this._assetPublisherQueryCounter.put(groupId, counter);
        }
        String[] assetPublisherQueryValues = null;
        if (this._assetPublisherQueryName.equals("assetCategories")) {
            List<AssetCategoryModel> assetCategoryModels = this._assetCategoryModelsArray[(int)groupId - 1];
            if (assetCategoryModels == null || assetCategoryModels.isEmpty()) {
                return this.newPortletPreferencesModel(plid, portletId, "<portlet-preferences />");
            }
            assetPublisherQueryValues = this.getAssetPublisherAssetCategoriesQueryValues(assetCategoryModels, (int)counter.get());
        } else {
            List<AssetTagModel> assetTagModels = this._assetTagModelsArray[(int)groupId - 1];
            if (assetTagModels == null || assetTagModels.isEmpty()) {
                return this.newPortletPreferencesModel(plid, portletId, "<portlet-preferences />");
            }
            assetPublisherQueryValues = this.getAssetPublisherAssetTagsQueryValues(assetTagModels, (int)counter.get());
        }
        PortletPreferencesImpl jxPortletPreferences = new PortletPreferencesImpl();
        jxPortletPreferences.setValue("queryAndOperator0", "false");
        jxPortletPreferences.setValue("queryContains0", "true");
        jxPortletPreferences.setValue("queryName0", this._assetPublisherQueryName);
        jxPortletPreferences.setValues("queryValues0", new String[]{assetPublisherQueryValues[0], assetPublisherQueryValues[1], assetPublisherQueryValues[2]});
        jxPortletPreferences.setValue("queryAndOperator1", "false");
        jxPortletPreferences.setValue("queryContains1", "false");
        jxPortletPreferences.setValue("queryName1", this._assetPublisherQueryName);
        jxPortletPreferences.setValue("queryValues1", assetPublisherQueryValues[3]);
        return this.newPortletPreferencesModel(plid, portletId, _portletPreferencesFactory.toXML((PortletPreferences)jxPortletPreferences));
    }

    public PortletPreferencesModel newPortletPreferencesModel(long plid, String portletId, DDLRecordSetModel ddlRecordSetModel) throws Exception {
        PortletPreferencesImpl jxPortletPreferences = new PortletPreferencesImpl();
        jxPortletPreferences.setValue("editable", "true");
        jxPortletPreferences.setValue("recordSetId", String.valueOf(ddlRecordSetModel.getRecordSetId()));
        jxPortletPreferences.setValue("spreadsheet", "false");
        return this.newPortletPreferencesModel(plid, portletId, _portletPreferencesFactory.toXML((PortletPreferences)jxPortletPreferences));
    }

    public PortletPreferencesModel newPortletPreferencesModel(long plid, String portletId, JournalArticleResourceModel journalArticleResourceModel) throws Exception {
        PortletPreferencesImpl jxPortletPreferences = new PortletPreferencesImpl();
        jxPortletPreferences.setValue("articleId", journalArticleResourceModel.getArticleId());
        jxPortletPreferences.setValue("enableCommentRatings", "false");
        jxPortletPreferences.setValue("enableComments", "false");
        jxPortletPreferences.setValue("enablePrint", "false");
        jxPortletPreferences.setValue("enableRatings", "false");
        jxPortletPreferences.setValue("enableRelatedAssets", "true");
        jxPortletPreferences.setValue("enableViewCountIncrement", "false");
        jxPortletPreferences.setValue("groupId", String.valueOf(journalArticleResourceModel.getGroupId()));
        jxPortletPreferences.setValue("showAvailableLocales", "false");
        return this.newPortletPreferencesModel(plid, portletId, _portletPreferencesFactory.toXML((PortletPreferences)jxPortletPreferences));
    }

    public List<PortletPreferencesModel> newPortletPreferencesModels(long plid) {
        ArrayList<PortletPreferencesModel> portletPreferencesModels = new ArrayList<PortletPreferencesModel>(2);
        portletPreferencesModels.add(this.newPortletPreferencesModel(plid, "145", "<portlet-preferences />"));
        portletPreferencesModels.add(this.newPortletPreferencesModel(plid, "86", "<portlet-preferences />"));
        return portletPreferencesModels;
    }

    public List<LayoutModel> newPublicLayoutModels(long groupId) {
        ArrayList<LayoutModel> layoutModels = new ArrayList<LayoutModel>();
        layoutModels.add(this.newLayoutModel(groupId, "welcome", "58,", "47,"));
        layoutModels.add(this.newLayoutModel(groupId, "blogs", "", "33,"));
        layoutModels.add(this.newLayoutModel(groupId, "document_library", "", "20,"));
        layoutModels.add(this.newLayoutModel(groupId, "forums", "", "19,"));
        layoutModels.add(this.newLayoutModel(groupId, "wiki", "", "36,"));
        return layoutModels;
    }

    public List<ResourcePermissionModel> newResourcePermissionModels(AssetCategoryModel assetCategoryModel) {
        return this.newResourcePermissionModels(AssetCategory.class.getName(), String.valueOf(assetCategoryModel.getCategoryId()), this._sampleUserId);
    }

    public List<ResourcePermissionModel> newResourcePermissionModels(AssetTagModel assetTagModel) {
        return this.newResourcePermissionModels(AssetTag.class.getName(), String.valueOf(assetTagModel.getTagId()), this._sampleUserId);
    }

    public List<ResourcePermissionModel> newResourcePermissionModels(AssetVocabularyModel assetVocabularyModel) {
        if (assetVocabularyModel.getUserId() == this._defaultUserId) {
            ArrayList<ResourcePermissionModel> resourcePermissionModels = new ArrayList<ResourcePermissionModel>(1);
            resourcePermissionModels.add(this.newResourcePermissionModel(AssetVocabulary.class.getName(), String.valueOf(assetVocabularyModel.getVocabularyId()), this._ownerRoleModel.getRoleId(), this._defaultUserId));
            return resourcePermissionModels;
        }
        return this.newResourcePermissionModels(AssetVocabulary.class.getName(), String.valueOf(assetVocabularyModel.getVocabularyId()), this._sampleUserId);
    }

    public List<ResourcePermissionModel> newResourcePermissionModels(BlogsEntryModel blogsEntryModel) {
        return this.newResourcePermissionModels(BlogsEntry.class.getName(), String.valueOf(blogsEntryModel.getEntryId()), this._sampleUserId);
    }

    public List<ResourcePermissionModel> newResourcePermissionModels(DDLRecordSetModel ddlRecordSetModel) {
        ArrayList<ResourcePermissionModel> resourcePermissionModels = new ArrayList<ResourcePermissionModel>(1);
        resourcePermissionModels.add(this.newResourcePermissionModel(DDLRecordSet.class.getName(), String.valueOf(ddlRecordSetModel.getRecordSetId()), this._ownerRoleModel.getRoleId(), this._defaultUserId));
        return resourcePermissionModels;
    }

    public List<ResourcePermissionModel> newResourcePermissionModels(DDMStructureModel ddmStructureModel) {
        ArrayList<ResourcePermissionModel> resourcePermissionModels = new ArrayList<ResourcePermissionModel>(1);
        resourcePermissionModels.add(this.newResourcePermissionModel(DDMStructure.class.getName(), String.valueOf(ddmStructureModel.getStructureId()), this._ownerRoleModel.getRoleId(), this._defaultUserId));
        return resourcePermissionModels;
    }

    public List<ResourcePermissionModel> newResourcePermissionModels(DLFileEntryModel dlFileEntryModel) {
        return this.newResourcePermissionModels(DLFileEntry.class.getName(), String.valueOf(dlFileEntryModel.getFileEntryId()), this._sampleUserId);
    }

    public List<ResourcePermissionModel> newResourcePermissionModels(DLFolderModel dlFolderModel) {
        return this.newResourcePermissionModels(DLFolder.class.getName(), String.valueOf(dlFolderModel.getFolderId()), this._sampleUserId);
    }

    public List<ResourcePermissionModel> newResourcePermissionModels(JournalArticleResourceModel journalArticleResourceModel) {
        return this.newResourcePermissionModels(JournalArticle.class.getName(), String.valueOf(journalArticleResourceModel.getResourcePrimKey()), this._sampleUserId);
    }

    public List<ResourcePermissionModel> newResourcePermissionModels(LayoutModel layoutModel) {
        return this.newResourcePermissionModels(Layout.class.getName(), String.valueOf(layoutModel.getPlid()), this._sampleUserId);
    }

    public List<ResourcePermissionModel> newResourcePermissionModels(MBCategoryModel mbCategoryModel) {
        return this.newResourcePermissionModels(MBCategory.class.getName(), String.valueOf(mbCategoryModel.getCategoryId()), this._sampleUserId);
    }

    public List<ResourcePermissionModel> newResourcePermissionModels(MBMessageModel mbMessageModel) {
        return this.newResourcePermissionModels(MBMessage.class.getName(), String.valueOf(mbMessageModel.getMessageId()), this._sampleUserId);
    }

    public List<ResourcePermissionModel> newResourcePermissionModels(PortletPreferencesModel portletPreferencesModel) {
        String portletId;
        String name = portletId = portletPreferencesModel.getPortletId();
        int index = portletId.indexOf("_");
        if (index > 0) {
            name = portletId.substring(0, index);
        }
        String primKey = PortletPermissionUtil.getPrimaryKey((long)portletPreferencesModel.getPlid(), (String)portletId);
        return this.newResourcePermissionModels(name, primKey, 0L);
    }

    public List<ResourcePermissionModel> newResourcePermissionModels(WikiNodeModel wikiNodeModel) {
        return this.newResourcePermissionModels(WikiNode.class.getName(), String.valueOf(wikiNodeModel.getNodeId()), this._sampleUserId);
    }

    public List<ResourcePermissionModel> newResourcePermissionModels(WikiPageModel wikiPageModel) {
        return this.newResourcePermissionModels(WikiPage.class.getName(), String.valueOf(wikiPageModel.getResourcePrimKey()), this._sampleUserId);
    }

    public SocialActivityModel newSocialActivityModel(BlogsEntryModel blogsEntryModel) {
        return this.newSocialActivityModel(blogsEntryModel.getGroupId(), this._classNameModelsMap.get(BlogsEntry.class.getName()), blogsEntryModel.getEntryId(), 2, "{\"title\":\"" + blogsEntryModel.getTitle() + "\"}");
    }

    public SocialActivityModel newSocialActivityModel(DLFileEntryModel dlFileEntryModel) {
        return this.newSocialActivityModel(dlFileEntryModel.getGroupId(), this.getDLFileEntryClassNameId(), dlFileEntryModel.getFileEntryId(), 1, "");
    }

    public SocialActivityModel newSocialActivityModel(JournalArticleModel journalArticleModel) {
        int type = 2;
        if (journalArticleModel.getVersion() == 1.0) {
            type = 1;
        }
        return this.newSocialActivityModel(journalArticleModel.getGroupId(), this.getJournalArticleClassNameId(), journalArticleModel.getResourcePrimKey(), type, "{\"title\":\"" + journalArticleModel.getUrlTitle() + "\"}");
    }

    public SocialActivityModel newSocialActivityModel(MBMessageModel mbMessageModel) {
        long classNameId = mbMessageModel.getClassNameId();
        long classPk = mbMessageModel.getClassPK();
        int type = 0;
        String extraData = null;
        if (classNameId == this._classNameModelsMap.get(WikiPage.class.getName())) {
            extraData = "{\"version\":1}";
            type = 1;
        } else if (classNameId == 0L) {
            extraData = "{\"title\":\"" + mbMessageModel.getSubject() + "\"}";
            type = 1;
            classNameId = this._classNameModelsMap.get(MBMessage.class.getName());
            classPk = mbMessageModel.getMessageId();
        } else {
            StringBundler sb = new StringBundler(5);
            sb.append("{\"messageId\":\"");
            sb.append(mbMessageModel.getMessageId());
            sb.append("\", \"title\":");
            sb.append(mbMessageModel.getSubject());
            sb.append("}");
            extraData = sb.toString();
            type = 10005;
        }
        return this.newSocialActivityModel(mbMessageModel.getGroupId(), classNameId, classPk, type, extraData);
    }

    public SubscriptionModel newSubscriptionModel(BlogsEntryModel blogsEntryModel) {
        return this.newSubscriptionModel(this._classNameModelsMap.get(BlogsEntry.class.getName()), blogsEntryModel.getEntryId());
    }

    public SubscriptionModel newSubscriptionModel(MBThreadModel mBThreadModel) {
        return this.newSubscriptionModel(this._classNameModelsMap.get(MBThread.class.getName()), mBThreadModel.getThreadId());
    }

    public SubscriptionModel newSubscriptionModel(WikiPageModel wikiPageModel) {
        return this.newSubscriptionModel(this._classNameModelsMap.get(WikiPage.class.getName()), wikiPageModel.getResourcePrimKey());
    }

    public List<UserModel> newUserModels() {
        ArrayList<UserModel> userModels = new ArrayList<UserModel>(this._maxUserCount);
        int i2 = 0;
        while (i2 < this._maxUserCount) {
            String[] userName = this.nextUserName(i2);
            userModels.add(this.newUserModel(this._counter.get(), userName[0], userName[1], "test" + this._userScreenNameCounter.get(), false));
            ++i2;
        }
        return userModels;
    }

    public List<WikiNodeModel> newWikiNodeModels(long groupId) {
        ArrayList<WikiNodeModel> wikiNodeModels = new ArrayList<WikiNodeModel>(this._maxWikiNodeCount);
        int i2 = 1;
        while (i2 <= this._maxWikiNodeCount) {
            wikiNodeModels.add(this.newWikiNodeModel(groupId, i2));
            ++i2;
        }
        return wikiNodeModels;
    }

    public List<WikiPageModel> newWikiPageModels(WikiNodeModel wikiNodeModel) {
        ArrayList<WikiPageModel> wikiPageModels = new ArrayList<WikiPageModel>(this._maxWikiPageCount);
        int i2 = 1;
        while (i2 <= this._maxWikiPageCount) {
            wikiPageModels.add(this.newWikiPageModel(wikiNodeModel, i2));
            ++i2;
        }
        return wikiPageModels;
    }

    public WikiPageResourceModel newWikiPageResourceModel(WikiPageModel wikiPageModel) {
        WikiPageResourceModelImpl wikiPageResourceModel = new WikiPageResourceModelImpl();
        wikiPageResourceModel.setUuid(SequentialUUID.generate());
        wikiPageResourceModel.setResourcePrimKey(wikiPageModel.getResourcePrimKey());
        wikiPageResourceModel.setNodeId(wikiPageModel.getNodeId());
        wikiPageResourceModel.setTitle(wikiPageModel.getTitle());
        return wikiPageResourceModel;
    }

    public String[] nextUserName(long index) {
        String[] userName = new String[]{this._firstNames.get((int)(index / (long)this._lastNames.size()) % this._firstNames.size()), this._lastNames.get((int)(index % (long)this._lastNames.size()))};
        return userName;
    }

    protected String[] getAssetPublisherAssetCategoriesQueryValues(List<AssetCategoryModel> assetCategoryModels, int index) {
        AssetCategoryModel assetCategoryModel0 = assetCategoryModels.get(index % assetCategoryModels.size());
        AssetCategoryModel assetCategoryModel1 = assetCategoryModels.get((index + this._maxAssetEntryToAssetCategoryCount) % assetCategoryModels.size());
        AssetCategoryModel assetCategoryModel2 = assetCategoryModels.get((index + this._maxAssetEntryToAssetCategoryCount * 2) % assetCategoryModels.size());
        AssetCategoryModel assetCategoryModel3 = assetCategoryModels.get((index + this._maxAssetEntryToAssetCategoryCount * 3) % assetCategoryModels.size());
        return new String[]{String.valueOf(assetCategoryModel0.getCategoryId()), String.valueOf(assetCategoryModel1.getCategoryId()), String.valueOf(assetCategoryModel2.getCategoryId()), String.valueOf(assetCategoryModel3.getCategoryId())};
    }

    protected String[] getAssetPublisherAssetTagsQueryValues(List<AssetTagModel> assetTagModels, int index) {
        AssetTagModel assetTagModel0 = assetTagModels.get(index % assetTagModels.size());
        AssetTagModel assetTagModel1 = assetTagModels.get((index + this._maxAssetEntryToAssetTagCount) % assetTagModels.size());
        AssetTagModel assetTagModel2 = assetTagModels.get((index + this._maxAssetEntryToAssetTagCount * 2) % assetTagModels.size());
        AssetTagModel assetTagModel3 = assetTagModels.get((index + this._maxAssetEntryToAssetTagCount * 3) % assetTagModels.size());
        return new String[]{assetTagModel0.getName(), assetTagModel1.getName(), assetTagModel2.getName(), assetTagModel3.getName()};
    }

    protected InputStream getResourceInputStream(String resourceName) {
        Class<?> clazz = this.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        return classLoader.getResourceAsStream(_DEPENDENCIES_DIR + resourceName);
    }

    protected AssetCategoryModel newAssetCategoryModel(long groupId, long lastRightCategoryId, String name, long vocabularyId) {
        AssetCategoryModelImpl assetCategoryModel = new AssetCategoryModelImpl();
        assetCategoryModel.setUuid(SequentialUUID.generate());
        assetCategoryModel.setCategoryId(this._counter.get());
        assetCategoryModel.setGroupId(groupId);
        assetCategoryModel.setCompanyId(this._companyId);
        assetCategoryModel.setUserId(this._sampleUserId);
        assetCategoryModel.setUserName(_SAMPLE_USER_NAME);
        assetCategoryModel.setCreateDate(new Date());
        assetCategoryModel.setModifiedDate(new Date());
        assetCategoryModel.setParentCategoryId(0L);
        assetCategoryModel.setLeftCategoryId(lastRightCategoryId++);
        assetCategoryModel.setRightCategoryId(lastRightCategoryId++);
        assetCategoryModel.setName(name);
        StringBundler sb = new StringBundler(5);
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root ");
        sb.append("available-locales=\"en_US\" default-locale=\"en_US\">");
        sb.append("<Title language-id=\"en_US\">");
        sb.append(name);
        sb.append("</Title></root>");
        assetCategoryModel.setTitle(sb.toString());
        assetCategoryModel.setVocabularyId(vocabularyId);
        return assetCategoryModel;
    }

    protected AssetEntryModel newAssetEntryModel(long groupId, Date createDate, Date modifiedDate, long classNameId, long classPK, String uuid, long classTypeId, boolean visible, String mimeType, String title) {
        AssetEntryModelImpl assetEntryModel = new AssetEntryModelImpl();
        assetEntryModel.setEntryId(this._counter.get());
        assetEntryModel.setGroupId(groupId);
        assetEntryModel.setCompanyId(this._companyId);
        assetEntryModel.setUserId(this._sampleUserId);
        assetEntryModel.setUserName(_SAMPLE_USER_NAME);
        assetEntryModel.setCreateDate(createDate);
        assetEntryModel.setModifiedDate(modifiedDate);
        assetEntryModel.setClassNameId(classNameId);
        assetEntryModel.setClassPK(classPK);
        assetEntryModel.setClassUuid(uuid);
        assetEntryModel.setClassTypeId(classTypeId);
        assetEntryModel.setVisible(visible);
        assetEntryModel.setStartDate(createDate);
        assetEntryModel.setEndDate(this.nextFutureDate());
        assetEntryModel.setPublishDate(createDate);
        assetEntryModel.setExpirationDate(this.nextFutureDate());
        assetEntryModel.setMimeType(mimeType);
        assetEntryModel.setTitle(title);
        return assetEntryModel;
    }

    protected AssetTagStatsModel newAssetTagStatsModel(long tagId, long classNameId) {
        AssetTagStatsModelImpl assetTagStatsModel = new AssetTagStatsModelImpl();
        assetTagStatsModel.setTagStatsId(this._counter.get());
        assetTagStatsModel.setTagId(tagId);
        assetTagStatsModel.setClassNameId(classNameId);
        return assetTagStatsModel;
    }

    protected AssetVocabularyModel newAssetVocabularyModel(long grouId, long userId, String userName, String name) {
        AssetVocabularyModelImpl assetVocabularyModel = new AssetVocabularyModelImpl();
        assetVocabularyModel.setUuid(SequentialUUID.generate());
        assetVocabularyModel.setVocabularyId(this._counter.get());
        assetVocabularyModel.setGroupId(grouId);
        assetVocabularyModel.setCompanyId(this._companyId);
        assetVocabularyModel.setUserId(userId);
        assetVocabularyModel.setUserName(userName);
        assetVocabularyModel.setCreateDate(new Date());
        assetVocabularyModel.setModifiedDate(new Date());
        assetVocabularyModel.setName(name);
        StringBundler sb = new StringBundler(5);
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root ");
        sb.append("available-locales=\"en_US\" default-locale=\"en_US\">");
        sb.append("<Title language-id=\"en_US\">");
        sb.append(name);
        sb.append("</Title></root>");
        assetVocabularyModel.setTitle(sb.toString());
        assetVocabularyModel.setSettings("multiValued=true\\nselectedClassNameIds=0");
        return assetVocabularyModel;
    }

    protected BlogsEntryModel newBlogsEntryModel(long groupId, int index) {
        BlogsEntryModelImpl blogsEntryModel = new BlogsEntryModelImpl();
        blogsEntryModel.setUuid(SequentialUUID.generate());
        blogsEntryModel.setEntryId(this._counter.get());
        blogsEntryModel.setGroupId(groupId);
        blogsEntryModel.setCompanyId(this._companyId);
        blogsEntryModel.setUserId(this._sampleUserId);
        blogsEntryModel.setUserName(_SAMPLE_USER_NAME);
        blogsEntryModel.setCreateDate(new Date());
        blogsEntryModel.setModifiedDate(new Date());
        blogsEntryModel.setTitle("Test Blog " + index);
        blogsEntryModel.setUrlTitle("testblog" + index);
        blogsEntryModel.setContent("This is test blog " + index + ".");
        blogsEntryModel.setDisplayDate(new Date());
        blogsEntryModel.setStatusDate(new Date());
        return blogsEntryModel;
    }

    protected DDMContentModel newDDMContentModel(long contentId, long groupId, String xml) {
        DDMContentModelImpl ddmContentModel = new DDMContentModelImpl();
        ddmContentModel.setUuid(SequentialUUID.generate());
        ddmContentModel.setContentId(contentId);
        ddmContentModel.setGroupId(groupId);
        ddmContentModel.setCompanyId(this._companyId);
        ddmContentModel.setUserId(this._sampleUserId);
        ddmContentModel.setUserName(_SAMPLE_USER_NAME);
        ddmContentModel.setCreateDate(this.nextFutureDate());
        ddmContentModel.setModifiedDate(this.nextFutureDate());
        ddmContentModel.setName(DDMStorageLink.class.getName());
        ddmContentModel.setXml(xml);
        return ddmContentModel;
    }

    protected DDMStructureLinkModel newDDMStructureLinkModel(long classNameId, long classPK, long structureId) {
        DDMStructureLinkModelImpl ddmStructureLinkModel = new DDMStructureLinkModelImpl();
        ddmStructureLinkModel.setStructureLinkId(this._counter.get());
        ddmStructureLinkModel.setClassNameId(classNameId);
        ddmStructureLinkModel.setClassPK(classPK);
        ddmStructureLinkModel.setStructureId(structureId);
        return ddmStructureLinkModel;
    }

    protected DDMStructureModel newDDMStructureModel(long groupId, long classNameId, String structureKey, String xsd) {
        DDMStructureModelImpl dDMStructureModel = new DDMStructureModelImpl();
        dDMStructureModel.setUuid(SequentialUUID.generate());
        dDMStructureModel.setStructureId(this._counter.get());
        dDMStructureModel.setGroupId(groupId);
        dDMStructureModel.setCompanyId(this._companyId);
        dDMStructureModel.setUserId(this._sampleUserId);
        dDMStructureModel.setUserName(_SAMPLE_USER_NAME);
        dDMStructureModel.setCreateDate(this.nextFutureDate());
        dDMStructureModel.setModifiedDate(this.nextFutureDate());
        dDMStructureModel.setClassNameId(classNameId);
        dDMStructureModel.setStructureKey(structureKey);
        StringBundler sb = new StringBundler(5);
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><root ");
        sb.append("available-locales=\"en_US\" default-locale=\"en_US\">");
        sb.append("<name language-id=\"en_US\">");
        sb.append(structureKey);
        sb.append("</name></root>");
        dDMStructureModel.setName(sb.toString());
        dDMStructureModel.setXsd(xsd);
        dDMStructureModel.setStorageType("xml");
        return dDMStructureModel;
    }

    protected DLFileEntryModel newDlFileEntryModel(DLFolderModel dlFolerModel, int index) {
        DLFileEntryModelImpl dlFileEntryModel = new DLFileEntryModelImpl();
        dlFileEntryModel.setUuid(SequentialUUID.generate());
        dlFileEntryModel.setFileEntryId(this._counter.get());
        dlFileEntryModel.setGroupId(dlFolerModel.getGroupId());
        dlFileEntryModel.setCompanyId(this._companyId);
        dlFileEntryModel.setUserId(this._sampleUserId);
        dlFileEntryModel.setUserName(_SAMPLE_USER_NAME);
        dlFileEntryModel.setCreateDate(this.nextFutureDate());
        dlFileEntryModel.setModifiedDate(this.nextFutureDate());
        dlFileEntryModel.setRepositoryId(dlFolerModel.getRepositoryId());
        dlFileEntryModel.setFolderId(dlFolerModel.getFolderId());
        dlFileEntryModel.setName("TestFile" + index);
        dlFileEntryModel.setExtension("txt");
        dlFileEntryModel.setMimeType("text/plain");
        dlFileEntryModel.setTitle("TestFile" + index + ".txt");
        dlFileEntryModel.setFileEntryTypeId(0L);
        dlFileEntryModel.setVersion("1.0");
        dlFileEntryModel.setSize(this._maxDLFileEntrySize);
        return dlFileEntryModel;
    }

    protected DLFolderModel newDLFolderModel(long groupId, long parentFolderId, int index) {
        DLFolderModelImpl dlFolderModel = new DLFolderModelImpl();
        dlFolderModel.setUuid(SequentialUUID.generate());
        dlFolderModel.setFolderId(this._counter.get());
        dlFolderModel.setGroupId(groupId);
        dlFolderModel.setCompanyId(this._companyId);
        dlFolderModel.setUserId(this._sampleUserId);
        dlFolderModel.setUserName(_SAMPLE_USER_NAME);
        dlFolderModel.setCreateDate(this.nextFutureDate());
        dlFolderModel.setModifiedDate(this.nextFutureDate());
        dlFolderModel.setRepositoryId(groupId);
        dlFolderModel.setParentFolderId(parentFolderId);
        dlFolderModel.setName("Test Folder " + index);
        dlFolderModel.setLastPostDate(this.nextFutureDate());
        dlFolderModel.setDefaultFileEntryTypeId(this._defaultDLFileEntryTypeModel.getFileEntryTypeId());
        dlFolderModel.setStatusDate(this.nextFutureDate());
        return dlFolderModel;
    }

    protected GroupModel newGroupModel(long groupId, long classNameId, long classPK, String name, boolean site) throws Exception {
        GroupModelImpl groupModel = new GroupModelImpl();
        groupModel.setUuid(SequentialUUID.generate());
        groupModel.setGroupId(groupId);
        groupModel.setCompanyId(this._companyId);
        groupModel.setCreatorUserId(this._sampleUserId);
        groupModel.setClassNameId(classNameId);
        groupModel.setClassPK(classPK);
        groupModel.setTreePath("/" + groupModel.getGroupId() + "/");
        groupModel.setName(name);
        groupModel.setManualMembership(true);
        groupModel.setMembershipRestriction(0);
        groupModel.setFriendlyURL("/" + FriendlyURLNormalizerUtil.normalize((String)name));
        groupModel.setSite(site);
        groupModel.setActive(true);
        return groupModel;
    }

    protected LayoutSetModel newLayoutSetModel(long groupId, boolean privateLayout, int pageCount) {
        LayoutSetModelImpl layoutSetModel = new LayoutSetModelImpl();
        layoutSetModel.setLayoutSetId(this._counter.get());
        layoutSetModel.setGroupId(groupId);
        layoutSetModel.setCompanyId(this._companyId);
        layoutSetModel.setCreateDate(new Date());
        layoutSetModel.setModifiedDate(new Date());
        layoutSetModel.setPrivateLayout(privateLayout);
        layoutSetModel.setThemeId("classic");
        layoutSetModel.setColorSchemeId("01");
        layoutSetModel.setWapThemeId("mobile");
        layoutSetModel.setWapColorSchemeId("01");
        layoutSetModel.setPageCount(pageCount);
        return layoutSetModel;
    }

    protected MBCategoryModel newMBCategoryModel(long groupId, int index) {
        MBCategoryModelImpl mbCategoryModel = new MBCategoryModelImpl();
        mbCategoryModel.setUuid(SequentialUUID.generate());
        mbCategoryModel.setCategoryId(this._counter.get());
        mbCategoryModel.setGroupId(groupId);
        mbCategoryModel.setCompanyId(this._companyId);
        mbCategoryModel.setUserId(this._sampleUserId);
        mbCategoryModel.setUserName(_SAMPLE_USER_NAME);
        mbCategoryModel.setCreateDate(new Date());
        mbCategoryModel.setModifiedDate(new Date());
        mbCategoryModel.setParentCategoryId(0L);
        mbCategoryModel.setName("Test Category " + index);
        mbCategoryModel.setDisplayStyle(MBCategoryConstants.DEFAULT_DISPLAY_STYLE);
        mbCategoryModel.setThreadCount(this._maxMBThreadCount);
        mbCategoryModel.setMessageCount(this._maxMBThreadCount * this._maxMBMessageCount);
        mbCategoryModel.setLastPostDate(new Date());
        mbCategoryModel.setStatusDate(new Date());
        return mbCategoryModel;
    }

    protected MBMessageModel newMBMessageModel(long groupId, long classNameId, long classPK, long categoryId, long threadId, long messageId, long rootMessageId, long parentMessageId, String subject, String body) {
        MBMessageModelImpl mBMessageModel = new MBMessageModelImpl();
        mBMessageModel.setUuid(SequentialUUID.generate());
        mBMessageModel.setMessageId(messageId);
        mBMessageModel.setGroupId(groupId);
        mBMessageModel.setCompanyId(this._companyId);
        mBMessageModel.setUserId(this._sampleUserId);
        mBMessageModel.setUserName(_SAMPLE_USER_NAME);
        mBMessageModel.setCreateDate(new Date());
        mBMessageModel.setModifiedDate(new Date());
        mBMessageModel.setClassNameId(classNameId);
        mBMessageModel.setClassPK(classPK);
        mBMessageModel.setCategoryId(categoryId);
        mBMessageModel.setThreadId(threadId);
        mBMessageModel.setRootMessageId(rootMessageId);
        mBMessageModel.setParentMessageId(parentMessageId);
        mBMessageModel.setSubject(subject);
        mBMessageModel.setBody(body);
        mBMessageModel.setFormat(MBMessageConstants.DEFAULT_FORMAT);
        mBMessageModel.setStatusDate(new Date());
        return mBMessageModel;
    }

    protected MBThreadModel newMBThreadModel(long threadId, long groupId, long categoryId, long rootMessageId, int messageCount) {
        MBThreadModelImpl mbThreadModel = new MBThreadModelImpl();
        mbThreadModel.setUuid(SequentialUUID.generate());
        mbThreadModel.setThreadId(threadId);
        mbThreadModel.setGroupId(groupId);
        mbThreadModel.setCompanyId(this._companyId);
        mbThreadModel.setUserId(this._sampleUserId);
        mbThreadModel.setUserName(_SAMPLE_USER_NAME);
        mbThreadModel.setCreateDate(new Date());
        mbThreadModel.setModifiedDate(new Date());
        mbThreadModel.setCategoryId(categoryId);
        mbThreadModel.setRootMessageId(rootMessageId);
        mbThreadModel.setRootMessageUserId(this._sampleUserId);
        mbThreadModel.setMessageCount(messageCount);
        mbThreadModel.setLastPostByUserId(this._sampleUserId);
        mbThreadModel.setLastPostDate(new Date());
        mbThreadModel.setStatusDate(new Date());
        return mbThreadModel;
    }

    protected PortletPreferencesModel newPortletPreferencesModel(long plid, String portletId, String preferences) {
        PortletPreferencesModelImpl portletPreferencesModel = new PortletPreferencesModelImpl();
        portletPreferencesModel.setPortletPreferencesId(this._counter.get());
        portletPreferencesModel.setOwnerId(0L);
        portletPreferencesModel.setOwnerType(3);
        portletPreferencesModel.setPlid(plid);
        portletPreferencesModel.setPortletId(portletId);
        portletPreferencesModel.setPreferences(preferences);
        return portletPreferencesModel;
    }

    protected ResourcePermissionModel newResourcePermissionModel(String name, String primKey, long roleId, long ownerId) {
        ResourcePermissionModelImpl resourcePermissionModel = new ResourcePermissionModelImpl();
        resourcePermissionModel.setResourcePermissionId(this._resourcePermissionCounter.get());
        resourcePermissionModel.setCompanyId(this._companyId);
        resourcePermissionModel.setName(name);
        resourcePermissionModel.setScope(4);
        resourcePermissionModel.setPrimKey(primKey);
        resourcePermissionModel.setRoleId(roleId);
        resourcePermissionModel.setOwnerId(ownerId);
        resourcePermissionModel.setActionIds(1L);
        return resourcePermissionModel;
    }

    protected List<ResourcePermissionModel> newResourcePermissionModels(String name, String primKey, long ownerId) {
        ArrayList<ResourcePermissionModel> resourcePermissionModels = new ArrayList<ResourcePermissionModel>(3);
        resourcePermissionModels.add(this.newResourcePermissionModel(name, primKey, this._guestRoleModel.getRoleId(), 0L));
        resourcePermissionModels.add(this.newResourcePermissionModel(name, primKey, this._ownerRoleModel.getRoleId(), ownerId));
        resourcePermissionModels.add(this.newResourcePermissionModel(name, primKey, this._siteMemberRoleModel.getRoleId(), 0L));
        return resourcePermissionModels;
    }

    protected RoleModel newRoleModel(String name, int type) {
        RoleModelImpl roleModel = new RoleModelImpl();
        roleModel.setUuid(SequentialUUID.generate());
        roleModel.setRoleId(this._counter.get());
        roleModel.setCompanyId(this._companyId);
        roleModel.setUserId(this._sampleUserId);
        roleModel.setUserName(_SAMPLE_USER_NAME);
        roleModel.setCreateDate(new Date());
        roleModel.setModifiedDate(new Date());
        roleModel.setClassNameId(this._classNameModelsMap.get(Role.class.getName()));
        roleModel.setClassPK(roleModel.getRoleId());
        roleModel.setName(name);
        roleModel.setType(type);
        return roleModel;
    }

    protected SocialActivityModel newSocialActivityModel(long groupId, long classNameId, long classPK, int type, String extraData) {
        SocialActivityModelImpl socialActivityModel = new SocialActivityModelImpl();
        socialActivityModel.setActivityId(this._socialActivityCounter.get());
        socialActivityModel.setGroupId(groupId);
        socialActivityModel.setCompanyId(this._companyId);
        socialActivityModel.setUserId(this._sampleUserId);
        socialActivityModel.setCreateDate(_CURRENT_TIME + this._timeCounter.get());
        socialActivityModel.setClassNameId(classNameId);
        socialActivityModel.setClassPK(classPK);
        socialActivityModel.setType(type);
        socialActivityModel.setExtraData(extraData);
        return socialActivityModel;
    }

    protected SubscriptionModel newSubscriptionModel(long classNameId, long classPK) {
        SubscriptionModelImpl subscriptionModel = new SubscriptionModelImpl();
        subscriptionModel.setSubscriptionId(this._counter.get());
        subscriptionModel.setCompanyId(this._companyId);
        subscriptionModel.setUserId(this._sampleUserId);
        subscriptionModel.setUserName(_SAMPLE_USER_NAME);
        subscriptionModel.setCreateDate(new Date());
        subscriptionModel.setModifiedDate(new Date());
        subscriptionModel.setClassNameId(classNameId);
        subscriptionModel.setClassPK(classPK);
        subscriptionModel.setFrequency("instant");
        return subscriptionModel;
    }

    protected UserModel newUserModel(long userId, String firstName, String lastName, String screenName, boolean defaultUser) {
        if (Validator.isNull((String)screenName)) {
            screenName = String.valueOf(userId);
        }
        UserModelImpl userModel = new UserModelImpl();
        userModel.setUuid(SequentialUUID.generate());
        userModel.setUserId(userId);
        userModel.setCompanyId(this._companyId);
        userModel.setCreateDate(new Date());
        userModel.setModifiedDate(new Date());
        userModel.setDefaultUser(defaultUser);
        userModel.setContactId(this._counter.get());
        userModel.setPassword("test");
        userModel.setPasswordModifiedDate(new Date());
        userModel.setReminderQueryQuestion("What is your screen name?");
        userModel.setReminderQueryAnswer(screenName);
        userModel.setEmailAddress(String.valueOf(screenName) + "@liferay.com");
        userModel.setScreenName(screenName);
        userModel.setLanguageId("en_US");
        userModel.setGreeting("Welcome " + screenName + "!");
        userModel.setFirstName(firstName);
        userModel.setLastName(lastName);
        userModel.setLoginDate(new Date());
        userModel.setLastLoginDate(new Date());
        userModel.setLastFailedLoginDate(new Date());
        userModel.setLockoutDate(new Date());
        userModel.setAgreedToTermsOfUse(true);
        userModel.setEmailAddressVerified(true);
        return userModel;
    }

    protected WikiNodeModel newWikiNodeModel(long groupId, int index) {
        WikiNodeModelImpl wikiNodeModel = new WikiNodeModelImpl();
        wikiNodeModel.setUuid(SequentialUUID.generate());
        wikiNodeModel.setNodeId(this._counter.get());
        wikiNodeModel.setGroupId(groupId);
        wikiNodeModel.setCompanyId(this._companyId);
        wikiNodeModel.setUserId(this._sampleUserId);
        wikiNodeModel.setUserName(_SAMPLE_USER_NAME);
        wikiNodeModel.setCreateDate(new Date());
        wikiNodeModel.setModifiedDate(new Date());
        wikiNodeModel.setName("Test Node " + index);
        wikiNodeModel.setLastPostDate(new Date());
        wikiNodeModel.setStatusDate(new Date());
        return wikiNodeModel;
    }

    protected WikiPageModel newWikiPageModel(WikiNodeModel wikiNodeModel, int index) {
        WikiPageModelImpl wikiPageModel = new WikiPageModelImpl();
        wikiPageModel.setUuid(SequentialUUID.generate());
        wikiPageModel.setPageId(this._counter.get());
        wikiPageModel.setResourcePrimKey(this._counter.get());
        wikiPageModel.setGroupId(wikiNodeModel.getGroupId());
        wikiPageModel.setCompanyId(this._companyId);
        wikiPageModel.setUserId(this._sampleUserId);
        wikiPageModel.setUserName(_SAMPLE_USER_NAME);
        wikiPageModel.setCreateDate(new Date());
        wikiPageModel.setModifiedDate(new Date());
        wikiPageModel.setNodeId(wikiNodeModel.getNodeId());
        wikiPageModel.setTitle("Test Page " + index);
        wikiPageModel.setVersion(1.0);
        wikiPageModel.setContent("This is test page " + index + ".");
        wikiPageModel.setFormat(WikiPageConstants.DEFAULT_FORMAT);
        wikiPageModel.setHead(true);
        return wikiPageModel;
    }

    protected String nextDDLCustomFieldName(long groupId, int customFieldIndex) {
        StringBundler sb = new StringBundler(4);
        sb.append("costom_field_text_");
        sb.append(groupId);
        sb.append("_");
        sb.append(customFieldIndex);
        return sb.toString();
    }

    protected Date nextFutureDate() {
        return new Date(_FUTURE_TIME + this._futureDateCounter.get() * 1000L);
    }
}

