/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.deploy;

import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.deploy.BaseDeployer;
import com.liferay.portal.util.InitUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ThemeDeployer
extends BaseDeployer {
    public static void main(String[] args) {
        InitUtil.initWithSpring();
        ArrayList<String> wars = new ArrayList<String>();
        ArrayList<String> jars = new ArrayList<String>();
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg.endsWith(".war")) {
                wars.add(arg);
            } else if (arg.endsWith(".jar")) {
                jars.add(arg);
            }
            ++n2;
        }
        new ThemeDeployer(wars, jars);
    }

    public ThemeDeployer() {
    }

    public ThemeDeployer(List<String> wars, List<String> jars) {
        super(wars, jars);
    }

    @Override
    public void checkArguments() {
        super.checkArguments();
        if (Validator.isNull((String)this.themeTaglibDTD)) {
            throw new IllegalArgumentException("The system property deployer.theme.taglib.dtd is not set");
        }
        if (Validator.isNull((String)this.utilTaglibDTD)) {
            throw new IllegalArgumentException("The system property deployer.util.taglib.dtd is not set");
        }
    }

    @Override
    public String getExtraFiltersContent(double webXmlVersion, File srcFile) throws Exception {
        StringBundler sb = new StringBundler(3);
        String extraFiltersContent = super.getExtraFiltersContent(webXmlVersion, srcFile);
        sb.append(extraFiltersContent);
        sb.append(this.getIgnoreFiltersContent(srcFile));
        sb.append(this.getSpeedFiltersContent(srcFile));
        return sb.toString();
    }

    @Override
    public String getPluginType() {
        return "theme";
    }

    @Override
    public Map<String, String> processPluginPackageProperties(File srcFile, String displayName, PluginPackage pluginPackage) throws Exception {
        Map<String, String> filterMap = super.processPluginPackageProperties(srcFile, displayName, pluginPackage);
        if (filterMap == null) {
            return null;
        }
        String moduleArtifactId = filterMap.get("module_artifact_id");
        int pos = moduleArtifactId.indexOf("-theme");
        String themeId = moduleArtifactId.substring(0, pos);
        filterMap.put("theme_id", themeId);
        String themeName = filterMap.get("plugin_name");
        filterMap.put("theme_name", themeName);
        String liferayVersions = filterMap.get("liferay_versions");
        filterMap.put("theme_versions", StringUtil.replace((String)liferayVersions, (String)"liferay-version", (String)"version"));
        this.copyDependencyXml("liferay-look-and-feel.xml", srcFile + "/WEB-INF", filterMap, true);
        return filterMap;
    }
}

