/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.servlet.filters.absoluteredirects.AbsoluteRedirectsFilter;
import com.liferay.portal.util.InitUtil;
import com.liferay.portal.xml.DocumentImpl;
import com.liferay.util.xml.XMLMerger;
import com.liferay.util.xml.descriptor.WebXML23Descriptor;
import com.liferay.util.xml.descriptor.WebXML24Descriptor;
import com.liferay.util.xml.descriptor.XMLDescriptor;
import java.io.IOException;

public class WebXMLBuilder {
    public static void main(String[] args) {
        InitUtil.initWithSpring();
        if (args.length != 3) {
            throw new IllegalArgumentException();
        }
        new WebXMLBuilder(args[0], args[1], args[2]);
    }

    public static String organizeWebXML(String webXML) throws DocumentException, IOException {
        webXML = HtmlUtil.stripComments((String)webXML);
        Document document = SAXReaderUtil.read((String)webXML);
        Element rootElement = document.getRootElement();
        double version = 2.3;
        version = GetterUtil.getDouble((String)rootElement.attributeValue("version"), (double)version);
        XMLMerger xmlMerger = null;
        xmlMerger = version == 2.3 ? new XMLMerger((XMLDescriptor)new WebXML23Descriptor()) : new XMLMerger((XMLDescriptor)new WebXML24Descriptor());
        DocumentImpl documentImpl = (DocumentImpl)document;
        xmlMerger.organizeXML(documentImpl.getWrappedDocument());
        webXML = document.formattedString();
        return webXML;
    }

    public WebXMLBuilder(String originalWebXML, String customWebXML, String mergedWebXML) {
        try {
            String originalContent;
            String customContent = this.getCustomContent(customWebXML);
            String mergedContent = originalContent = FileUtil.read((String)originalWebXML);
            int x = customContent.indexOf("<filter-mapping>");
            if (x != -1) {
                int y = customContent.lastIndexOf("</filter-mapping>") + 17;
                String filterMappings = customContent.substring(x, y);
                int z = this.getOriginalContentIndex(originalContent);
                mergedContent = String.valueOf(mergedContent.substring(0, z)) + filterMappings + mergedContent.substring(z);
                customContent = String.valueOf(customContent.substring(0, x)) + customContent.substring(y + 1);
            }
            int z = this.getMergedContentIndex(mergedContent);
            mergedContent = String.valueOf(mergedContent.substring(0, z)) + customContent + mergedContent.substring(z);
            mergedContent = WebXMLBuilder.organizeWebXML(mergedContent);
            FileUtil.write((String)mergedWebXML, (String)mergedContent, (boolean)true);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    protected String getCustomContent(String customWebXML) throws IOException {
        String customContent = FileUtil.read((String)customWebXML);
        int x = customContent.indexOf("<web-app");
        x = customContent.indexOf(">", x) + 1;
        int y = customContent.indexOf("</web-app>");
        return customContent.substring(x, y);
    }

    protected int getMergedContentIndex(String content) {
        int x = content.indexOf("<web-app");
        x = content.indexOf(">", x) + 1;
        return x;
    }

    protected int getOriginalContentIndex(String content) {
        int x = content.indexOf(AbsoluteRedirectsFilter.class.getName());
        if (x == -1) {
            x = content.indexOf("<web-app");
            x = content.indexOf(">", x) + 1;
            return x;
        }
        x = content.lastIndexOf("<filter-name", x);
        x = content.indexOf(">", x) + 1;
        int y = content.indexOf("</filter-name>", x);
        String filterName = content.substring(x, y);
        x = content.lastIndexOf(filterName);
        y = content.indexOf("</filter-mapping>", x);
        y = content.indexOf(">", y) + 1;
        return y;
    }
}

