/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.templateparser;

import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.mobile.device.Device;
import com.liferay.portal.kernel.mobile.device.UnknownDevice;
import com.liferay.portal.kernel.template.StringTemplateResource;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.URLTemplateResource;
import com.liferay.portal.kernel.templateparser.TemplateNode;
import com.liferay.portal.kernel.templateparser.TransformException;
import com.liferay.portal.kernel.templateparser.TransformerListener;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.Company;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.xsl.XSLTemplateResource;
import com.liferay.portlet.journal.util.JournalXSLURIResolver;
import com.liferay.taglib.util.VelocityTaglib;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class Transformer {
    private static Log _log = LogFactoryUtil.getLog(Transformer.class);
    private static Log _logOutputAfterListener = LogFactoryUtil.getLog((String)(String.valueOf(Transformer.class.getName()) + ".OutputAfterListener"));
    private static Log _logOutputBeforeListener = LogFactoryUtil.getLog((String)(String.valueOf(Transformer.class.getName()) + ".OutputBeforeListener"));
    private static Log _logScriptAfterListener = LogFactoryUtil.getLog((String)(String.valueOf(Transformer.class.getName()) + ".ScriptAfterListener"));
    private static Log _logScriptBeforeListener = LogFactoryUtil.getLog((String)(String.valueOf(Transformer.class.getName()) + ".ScriptBeforeListener"));
    private static Log _logTokens = LogFactoryUtil.getLog((String)(String.valueOf(Transformer.class.getName()) + ".Tokens"));
    private static Log _logTransformBefore = LogFactoryUtil.getLog((String)(String.valueOf(Transformer.class.getName()) + ".TransformBefore"));
    private static Log _logTransfromAfter = LogFactoryUtil.getLog((String)(String.valueOf(Transformer.class.getName()) + ".TransformAfter"));
    private static Log _logXmlAfterListener = LogFactoryUtil.getLog((String)(String.valueOf(Transformer.class.getName()) + ".XmlAfterListener"));
    private static Log _logXmlBeforeListener = LogFactoryUtil.getLog((String)(String.valueOf(Transformer.class.getName()) + ".XmlBeforeListener"));
    private Map<String, String> _errorTemplateIds = new HashMap<String, String>();
    private boolean _restricted;
    private Set<String> _transformerListenerClassNames = new HashSet<String>();

    public Transformer(String errorTemplatePropertyKey, boolean restricted) {
        Set langTypes = TemplateManagerUtil.getSupportedLanguageTypes((String)errorTemplatePropertyKey);
        for (String langType : langTypes) {
            String errorTemplateId = PropsUtil.get(errorTemplatePropertyKey, new Filter(langType));
            if (!Validator.isNotNull((String)errorTemplateId)) continue;
            this._errorTemplateIds.put(langType, errorTemplateId);
        }
        this._restricted = restricted;
    }

    public Transformer(String transformerListenerPropertyKey, String errorTemplatePropertyKey, boolean restricted) {
        this(errorTemplatePropertyKey, restricted);
        this._transformerListenerClassNames = SetUtil.fromArray((Object[])PropsUtil.getArray(transformerListenerPropertyKey));
    }

    public String transform(ThemeDisplay themeDisplay, Map<String, Object> contextObjects, String script, String langType) throws Exception {
        if (Validator.isNull((String)langType)) {
            return null;
        }
        long companyId = 0L;
        long companyGroupId = 0L;
        long scopeGroupId = 0L;
        long siteGroupId = 0L;
        if (themeDisplay != null) {
            companyId = themeDisplay.getCompanyId();
            companyGroupId = themeDisplay.getCompanyGroupId();
            scopeGroupId = themeDisplay.getScopeGroupId();
            siteGroupId = themeDisplay.getSiteGroupId();
        }
        String templateId = String.valueOf(contextObjects.get("template_id"));
        templateId = this.getTemplateId(templateId, companyId, companyGroupId, scopeGroupId);
        Template template = this.getTemplate(templateId, script, langType);
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        try {
            this.prepareTemplate(themeDisplay, template);
            if (contextObjects != null) {
                for (String key : contextObjects.keySet()) {
                    template.put(key, contextObjects.get(key));
                }
            }
            template.put("company", (Object)this.getCompany(themeDisplay, companyId));
            template.put("companyId", (Object)companyId);
            template.put("device", (Object)this.getDevice(themeDisplay));
            String templatesPath = this.getTemplatesPath(companyId, scopeGroupId);
            template.put("journalTemplatesPath", (Object)templatesPath);
            template.put("permissionChecker", (Object)PermissionThreadLocal.getPermissionChecker());
            template.put("randomNamespace", (Object)(String.valueOf(StringUtil.randomId()) + "_"));
            template.put("scopeGroupId", (Object)scopeGroupId);
            template.put("siteGroupId", (Object)siteGroupId);
            template.put("templatesPath", (Object)templatesPath);
            template.put("groupId", (Object)scopeGroupId);
            this.mergeTemplate(template, unsyncStringWriter);
        }
        catch (Exception e2) {
            throw new TransformException("Unhandled exception", (Throwable)e2);
        }
        return unsyncStringWriter.toString();
    }

    public String transform(ThemeDisplay themeDisplay, Map<String, String> tokens, String viewMode, String languageId, String xml, String script, String langType) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Language " + languageId));
        }
        if (Validator.isNull((String)viewMode)) {
            viewMode = "view";
        }
        if (_logTokens.isDebugEnabled()) {
            String tokensString = PropertiesUtil.list(tokens);
            _logTokens.debug((Object)tokensString);
        }
        if (_logTransformBefore.isDebugEnabled()) {
            _logTransformBefore.debug((Object)xml);
        }
        ArrayList<TransformerListener> transformerListeners = new ArrayList<TransformerListener>();
        for (String transformerListenersClassName : this._transformerListenerClassNames) {
            TransformerListener transformerListener = null;
            try {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Instantiate listener " + transformerListenersClassName));
                }
                ClassLoader classLoader = PortalClassLoaderUtil.getClassLoader();
                transformerListener = (TransformerListener)InstanceFactory.newInstance((ClassLoader)classLoader, (String)transformerListenersClassName);
                transformerListeners.add(transformerListener);
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
            }
            if (_logXmlBeforeListener.isDebugEnabled()) {
                _logXmlBeforeListener.debug((Object)xml);
            }
            if (transformerListener != null) {
                xml = transformerListener.onXml(xml, languageId, tokens);
                if (_logXmlAfterListener.isDebugEnabled()) {
                    _logXmlAfterListener.debug((Object)xml);
                }
            }
            if (_logScriptBeforeListener.isDebugEnabled()) {
                _logScriptBeforeListener.debug((Object)script);
            }
            if (transformerListener == null) continue;
            script = transformerListener.onScript(script, xml, languageId, tokens);
            if (!_logScriptAfterListener.isDebugEnabled()) continue;
            _logScriptAfterListener.debug((Object)script);
        }
        String output = null;
        if (Validator.isNull((String)langType)) {
            output = LocalizationUtil.getLocalization((String)xml, (String)languageId);
        } else {
            long companyId = 0L;
            long companyGroupId = 0L;
            long articleGroupId = 0L;
            if (tokens != null) {
                companyId = GetterUtil.getLong((String)tokens.get("company_id"));
                companyGroupId = GetterUtil.getLong((String)tokens.get("company_group_id"));
                articleGroupId = GetterUtil.getLong((String)tokens.get("article_group_id"));
            }
            long scopeGroupId = 0L;
            long siteGroupId = 0L;
            if (themeDisplay != null) {
                companyId = themeDisplay.getCompanyId();
                companyGroupId = themeDisplay.getCompanyGroupId();
                scopeGroupId = themeDisplay.getScopeGroupId();
                siteGroupId = themeDisplay.getSiteGroupId();
            }
            String templateId = tokens.get("template_id");
            templateId = this.getTemplateId(templateId, companyId, companyGroupId, articleGroupId);
            Template template = this.getTemplate(templateId, tokens, languageId, xml, script, langType);
            UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
            try {
                if (Validator.isNotNull((String)xml)) {
                    Document document = SAXReaderUtil.read((String)xml);
                    Element rootElement = document.getRootElement();
                    List<TemplateNode> templateNodes = this.getTemplateNodes(themeDisplay, rootElement);
                    if (templateNodes != null) {
                        for (TemplateNode templateNode : templateNodes) {
                            template.put(templateNode.getName(), (Object)templateNode);
                        }
                    }
                    Element requestElement = rootElement.element("request");
                    template.put("request", this.insertRequestVariables(requestElement));
                    template.put("xmlRequest", (Object)requestElement.asXML());
                }
                template.put("articleGroupId", (Object)articleGroupId);
                template.put("company", (Object)this.getCompany(themeDisplay, companyId));
                template.put("companyId", (Object)companyId);
                template.put("device", (Object)this.getDevice(themeDisplay));
                String templatesPath = this.getTemplatesPath(companyId, articleGroupId);
                template.put("journalTemplatesPath", (Object)templatesPath);
                Locale locale = LocaleUtil.fromLanguageId((String)languageId);
                template.put("locale", (Object)locale);
                template.put("permissionChecker", (Object)PermissionThreadLocal.getPermissionChecker());
                template.put("randomNamespace", (Object)(String.valueOf(StringUtil.randomId()) + "_"));
                template.put("scopeGroupId", (Object)scopeGroupId);
                template.put("siteGroupId", (Object)siteGroupId);
                template.put("templatesPath", (Object)templatesPath);
                template.put("viewMode", (Object)viewMode);
                template.put("groupId", (Object)articleGroupId);
                this.mergeTemplate(template, unsyncStringWriter);
            }
            catch (Exception e3) {
                if (e3 instanceof DocumentException) {
                    throw new TransformException("Unable to read XML document", (Throwable)e3);
                }
                if (e3 instanceof IOException) {
                    throw new TransformException("Error reading template", (Throwable)e3);
                }
                if (e3 instanceof TransformException) {
                    throw (TransformException)e3;
                }
                throw new TransformException("Unhandled exception", (Throwable)e3);
            }
            output = unsyncStringWriter.toString();
        }
        for (TransformerListener transformerListener : transformerListeners) {
            if (_logOutputBeforeListener.isDebugEnabled()) {
                _logOutputBeforeListener.debug((Object)output);
            }
            output = transformerListener.onOutput(output, languageId, tokens);
            if (!_logOutputAfterListener.isDebugEnabled()) continue;
            _logOutputAfterListener.debug((Object)output);
        }
        if (_logTransfromAfter.isDebugEnabled()) {
            _logTransfromAfter.debug((Object)output);
        }
        return output;
    }

    protected Company getCompany(ThemeDisplay themeDisplay, long companyId) throws Exception {
        if (themeDisplay != null) {
            return themeDisplay.getCompany();
        }
        return CompanyLocalServiceUtil.getCompany((long)companyId);
    }

    protected Device getDevice(ThemeDisplay themeDisplay) {
        if (themeDisplay != null) {
            return themeDisplay.getDevice();
        }
        return UnknownDevice.getInstance();
    }

    protected TemplateResource getErrorTemplateResource(String langType) {
        try {
            Class<?> clazz = this.getClass();
            ClassLoader classLoader = clazz.getClassLoader();
            String errorTemplateId = this._errorTemplateIds.get(langType);
            URL url = classLoader.getResource(errorTemplateId);
            return new URLTemplateResource(errorTemplateId, url);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected Template getTemplate(String templateId, Map<String, String> tokens, String languageId, String xml, String script, String langType) throws Exception {
        Object templateResource = null;
        if (langType.equals("xsl")) {
            JournalXSLURIResolver xslURIResolver = new JournalXSLURIResolver(tokens, languageId);
            templateResource = new XSLTemplateResource(templateId, script, xslURIResolver, xml);
        } else {
            templateResource = new StringTemplateResource(templateId, script);
        }
        TemplateResource errorTemplateResource = this.getErrorTemplateResource(langType);
        return TemplateManagerUtil.getTemplate((String)langType, (TemplateResource)templateResource, (TemplateResource)errorTemplateResource, (boolean)this._restricted);
    }

    protected Template getTemplate(String templateId, String script, String langType) throws Exception {
        StringTemplateResource templateResource = new StringTemplateResource(templateId, script);
        TemplateResource errorTemplateResource = this.getErrorTemplateResource(langType);
        return TemplateManagerUtil.getTemplate((String)langType, (TemplateResource)templateResource, (TemplateResource)errorTemplateResource, (boolean)this._restricted);
    }

    protected String getTemplateId(String templateId, long companyId, long companyGroupId, long groupId) {
        StringBundler sb = new StringBundler(5);
        sb.append(companyId);
        sb.append("#");
        if (companyGroupId > 0L) {
            sb.append(companyGroupId);
        } else {
            sb.append(groupId);
        }
        sb.append("#");
        sb.append(templateId);
        return sb.toString();
    }

    protected List<TemplateNode> getTemplateNodes(ThemeDisplay themeDisplay, Element element) throws Exception {
        ArrayList<TemplateNode> templateNodes = new ArrayList<TemplateNode>();
        HashMap<String, TemplateNode> prototypeTemplateNodes = new HashMap<String, TemplateNode>();
        List dynamicElementElements = element.elements("dynamic-element");
        for (Element dynamicElementElement : dynamicElementElements) {
            String name;
            Element dynamicContentElement = dynamicElementElement.element("dynamic-content");
            String data = "";
            if (dynamicContentElement != null) {
                data = dynamicContentElement.getText();
            }
            if ((name = dynamicElementElement.attributeValue("name", "")).length() == 0) {
                throw new TransformException("Element missing \"name\" attribute");
            }
            String type = dynamicElementElement.attributeValue("type", "");
            TemplateNode templateNode = new TemplateNode(themeDisplay, name, this.stripCDATA(data), type);
            if (dynamicElementElement.element("dynamic-element") != null) {
                templateNode.appendChildren(this.getTemplateNodes(themeDisplay, dynamicElementElement));
            } else if (dynamicContentElement != null && dynamicContentElement.element("option") != null) {
                List optionElements = dynamicContentElement.elements("option");
                for (Element optionElement : optionElements) {
                    templateNode.appendOption(this.stripCDATA(optionElement.getText()));
                }
            }
            TemplateNode prototypeTemplateNode = (TemplateNode)prototypeTemplateNodes.get(name);
            if (prototypeTemplateNode == null) {
                prototypeTemplateNode = templateNode;
                prototypeTemplateNodes.put(name, prototypeTemplateNode);
                templateNodes.add(templateNode);
            }
            prototypeTemplateNode.appendSibling(templateNode);
        }
        return templateNodes;
    }

    protected String getTemplatesPath(long companyId, long groupId) {
        StringBundler sb = new StringBundler(5);
        sb.append("_TEMPLATE_CONTEXT_");
        sb.append("/");
        sb.append(companyId);
        sb.append("/");
        sb.append(groupId);
        return sb.toString();
    }

    protected Map<String, Object> insertRequestVariables(Element element) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (element == null) {
            return map;
        }
        for (Element childElement : element.elements()) {
            Element nameElement;
            String name = childElement.getName();
            if (name.equals("attribute")) {
                nameElement = childElement.element("name");
                Element valueElement = childElement.element("value");
                map.put(nameElement.getText(), valueElement.getText());
                continue;
            }
            if (name.equals("parameter")) {
                nameElement = childElement.element("name");
                List valueElements = childElement.elements("value");
                if (valueElements.size() == 1) {
                    Element valueElement = (Element)valueElements.get(0);
                    map.put(nameElement.getText(), valueElement.getText());
                    continue;
                }
                ArrayList<String> values = new ArrayList<String>();
                for (Element valueElement : valueElements) {
                    values.add(valueElement.getText());
                }
                map.put(nameElement.getText(), values);
                continue;
            }
            List elements = childElement.elements();
            if (!elements.isEmpty()) {
                map.put(name, this.insertRequestVariables(childElement));
                continue;
            }
            map.put(name, childElement.getText());
        }
        return map;
    }

    protected void mergeTemplate(Template template, UnsyncStringWriter unsyncStringWriter) throws Exception {
        VelocityTaglib velocityTaglib = (VelocityTaglib)template.get("taglibLiferay");
        if (velocityTaglib != null) {
            velocityTaglib.setTemplate(template);
        }
        template.processTemplate((Writer)unsyncStringWriter);
    }

    protected void prepareTemplate(ThemeDisplay themeDisplay, Template template) throws Exception {
        if (themeDisplay == null) {
            return;
        }
        template.prepare(themeDisplay.getRequest());
    }

    protected String stripCDATA(String s) {
        if (s.startsWith("<![CDATA[") && s.endsWith("]]>")) {
            s = s.substring("<![CDATA[".length(), s.length() - "]]>".length());
        }
        return s;
    }
}

