/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.struts;

import com.liferay.portal.LayoutPermissionException;
import com.liferay.portal.PortletActiveException;
import com.liferay.portal.UserActiveException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.FriendlyURLMapper;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.struts.LastPath;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.liveusers.LiveUsers;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletPreferencesIds;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserTracker;
import com.liferay.portal.model.UserTrackerPath;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.service.persistence.UserTrackerPathUtil;
import com.liferay.portal.setup.SetupWizardUtil;
import com.liferay.portal.struts.ActionAdapter;
import com.liferay.portal.struts.AuthPublicPathRegistry;
import com.liferay.portal.struts.StrutsActionRegistryUtil;
import com.liferay.portal.struts.StrutsUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.InvokerPortlet;
import com.liferay.portlet.PortletConfigFactoryUtil;
import com.liferay.portlet.PortletInstanceFactoryUtil;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.PortletURLImpl;
import com.liferay.portlet.RenderRequestFactory;
import com.liferay.portlet.RenderRequestImpl;
import com.liferay.portlet.RenderResponseFactory;
import com.liferay.portlet.RenderResponseImpl;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletResponse;
import javax.portlet.WindowState;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.tiles.TilesRequestProcessor;
import org.apache.struts.util.MessageResources;

public class PortalRequestProcessor
extends TilesRequestProcessor {
    private static final String _PATH_C = "/c";
    private static final String _PATH_COMMON = "/common";
    private static final String _PATH_COMMON_ERROR = "/common/error";
    private static final String _PATH_J_SECURITY_CHECK = "/j_security_check";
    private static final String _PATH_PORTAL = "/portal";
    private static final String _PATH_PORTAL_API_JSONWS = "/portal/api/jsonws";
    private static final String _PATH_PORTAL_ERROR = "/portal/error";
    private static final String _PATH_PORTAL_EXPIRE_SESSION = "/portal/expire_session";
    private static final String _PATH_PORTAL_EXTEND_SESSION = "/portal/extend_session";
    private static final String _PATH_PORTAL_FLASH = "/portal/flash";
    private static final String _PATH_PORTAL_J_LOGIN = "/portal/j_login";
    private static final String _PATH_PORTAL_JSON_SERVICE = "/portal/json_service";
    private static final String _PATH_PORTAL_LAYOUT = "/portal/layout";
    private static final String _PATH_PORTAL_LICENSE = "/portal/license";
    private static final String _PATH_PORTAL_LOGIN = "/portal/login";
    private static final String _PATH_PORTAL_LOGOUT = "/portal/logout";
    private static final String _PATH_PORTAL_PROTECTED = "/portal/protected";
    private static final String _PATH_PORTAL_RENDER_PORTLET = "/portal/render_portlet";
    private static final String _PATH_PORTAL_RESILIENCY = "/portal/resiliency";
    private static final String _PATH_PORTAL_SETUP_WIZARD = "/portal/setup_wizard";
    private static final String _PATH_PORTAL_STATUS = "/portal/status";
    private static final String _PATH_PORTAL_TCK = "/portal/tck";
    private static final String _PATH_PORTAL_TERMS_OF_USE = "/portal/terms_of_use";
    private static final String _PATH_PORTAL_UPDATE_EMAIL_ADDRESS = "/portal/update_email_address";
    private static final String _PATH_PORTAL_UPDATE_PASSWORD = "/portal/update_password";
    private static final String _PATH_PORTAL_UPDATE_REMINDER_QUERY = "/portal/update_reminder_query";
    private static final String _PATH_PORTAL_UPDATE_TERMS_OF_USE = "/portal/update_terms_of_use";
    private static final String _PATH_PORTAL_VERIFY_EMAIL_ADDRESS = "/portal/verify_email_address";
    private static Log _log = LogFactoryUtil.getLog(PortalRequestProcessor.class);
    private Set<String> _lastPaths = new HashSet<String>();
    private Set<String> _publicPaths;
    private Set<String> _trackerIgnorePaths;

    public PortalRequestProcessor() {
        this._lastPaths.add(_PATH_PORTAL_LAYOUT);
        this.addPaths(this._lastPaths, "auth.forward.last.paths");
        this._publicPaths = new HashSet<String>();
        this._publicPaths.add(_PATH_C);
        this._publicPaths.add(_PATH_PORTAL_API_JSONWS);
        this._publicPaths.add(_PATH_PORTAL_FLASH);
        this._publicPaths.add(_PATH_PORTAL_J_LOGIN);
        this._publicPaths.add(_PATH_PORTAL_LAYOUT);
        this._publicPaths.add(_PATH_PORTAL_LICENSE);
        this._publicPaths.add(_PATH_PORTAL_LOGIN);
        this._publicPaths.add(_PATH_PORTAL_RENDER_PORTLET);
        this._publicPaths.add(_PATH_PORTAL_RESILIENCY);
        this._publicPaths.add(_PATH_PORTAL_TCK);
        this._publicPaths.add(_PATH_PORTAL_UPDATE_PASSWORD);
        this._publicPaths.add(_PATH_PORTAL_VERIFY_EMAIL_ADDRESS);
        this._publicPaths.add(PropsValues.AUTH_LOGIN_DISABLED_PATH);
        this._trackerIgnorePaths = new HashSet<String>();
        this.addPaths(this._trackerIgnorePaths, "session.tracker.ignore.paths");
    }

    public void process(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HttpSession session = request.getSession();
        Boolean basicAuthEnabled = (Boolean)session.getAttribute("BASIC_AUTH_ENABLED");
        if (basicAuthEnabled != null) {
            session.removeAttribute("BASIC_AUTH_ENABLED");
        }
        String path = super.processPath(request, response);
        ActionMapping actionMapping = (ActionMapping)this.moduleConfig.findActionConfig(path);
        Action action = StrutsActionRegistryUtil.getAction(path);
        if (basicAuthEnabled != null && basicAuthEnabled.booleanValue() || actionMapping == null && action == null) {
            String lastPath = this.getLastPath(request);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Last path " + lastPath));
            }
            response.sendRedirect(lastPath);
            return;
        }
        super.process(request, response);
        try {
            if (this.isPortletPath(path)) {
                this.cleanUp(request);
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    protected void addPaths(Set<String> paths, String propsKey) {
        String[] pathsArray;
        String[] stringArray = pathsArray = PropsUtil.getArray(propsKey);
        int n = pathsArray.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            paths.add(path);
            ++n2;
        }
    }

    protected void callParentDoForward(String uri, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        super.doForward(uri, request, response);
    }

    protected HttpServletRequest callParentProcessMultipart(HttpServletRequest request) {
        return super.processMultipart(request);
    }

    protected String callParentProcessPath(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return super.processPath(request, response);
    }

    protected boolean callParentProcessRoles(HttpServletRequest request, HttpServletResponse response, ActionMapping actionMapping) throws IOException, ServletException {
        return super.processRoles(request, response, actionMapping);
    }

    protected void cleanUp(HttpServletRequest request) throws Exception {
        RenderRequestImpl renderRequestImpl = (RenderRequestImpl)request.getAttribute("javax.portlet.request");
        if (renderRequestImpl != null) {
            renderRequestImpl.cleanUp();
        }
    }

    protected void defineObjects(HttpServletRequest request, HttpServletResponse response, Portlet portlet) throws Exception {
        String portletId = portlet.getPortletId();
        ServletContext servletContext = (ServletContext)request.getAttribute("CTX");
        InvokerPortlet invokerPortlet = PortletInstanceFactoryUtil.create((Portlet)portlet, (ServletContext)servletContext);
        PortletPreferencesIds portletPreferencesIds = PortletPreferencesFactoryUtil.getPortletPreferencesIds((HttpServletRequest)request, (String)portletId);
        PortletPreferences portletPreferences = PortletPreferencesLocalServiceUtil.getStrictPreferences((PortletPreferencesIds)portletPreferencesIds);
        PortletConfig portletConfig = PortletConfigFactoryUtil.create((Portlet)portlet, (ServletContext)servletContext);
        PortletContext portletContext = portletConfig.getPortletContext();
        RenderRequestImpl renderRequestImpl = RenderRequestFactory.create(request, portlet, invokerPortlet, portletContext, WindowState.MAXIMIZED, PortletMode.VIEW, portletPreferences);
        RenderResponseImpl renderResponseImpl = RenderResponseFactory.create(renderRequestImpl, response, portletId, portlet.getCompanyId());
        renderRequestImpl.defineObjects(portletConfig, (PortletResponse)renderResponseImpl);
        request.setAttribute("PORTLET_STRUTS_EXECUTE", (Object)Boolean.TRUE);
    }

    protected void doForward(String uri, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        StrutsUtil.forward(uri, this.getServletContext(), request, response);
    }

    protected void doInclude(String uri, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        StrutsUtil.include(uri, this.getServletContext(), request, response);
    }

    protected String getFriendlyTrackerPath(String path, ThemeDisplay themeDisplay, HttpServletRequest request) throws Exception {
        if (!path.equals(_PATH_PORTAL_LAYOUT)) {
            return null;
        }
        long plid = ParamUtil.getLong((HttpServletRequest)request, (String)"p_l_id");
        if (plid == 0L) {
            return null;
        }
        Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
        String layoutFriendlyURL = PortalUtil.getLayoutFriendlyURL((Layout)layout, (ThemeDisplay)themeDisplay);
        String portletId = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_id");
        if (Validator.isNull((String)portletId)) {
            return layoutFriendlyURL;
        }
        long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
        Portlet portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)portletId);
        if (portlet == null) {
            String strutsPath = path.substring(1, path.lastIndexOf(47));
            portlet = PortletLocalServiceUtil.getPortletByStrutsPath((long)companyId, (String)strutsPath);
        }
        if (portlet == null || !portlet.isActive()) {
            return layoutFriendlyURL.concat("?").concat(request.getQueryString());
        }
        String namespace = PortalUtil.getPortletNamespace((String)portletId);
        FriendlyURLMapper friendlyURLMapper = portlet.getFriendlyURLMapperInstance();
        if (friendlyURLMapper == null) {
            return layoutFriendlyURL.concat("?").concat(request.getQueryString());
        }
        PortletURLImpl portletURL = new PortletURLImpl(request, portletId, plid, "RENDER_PHASE");
        Map parameterMap = request.getParameterMap();
        for (Map.Entry entry : parameterMap.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(namespace)) continue;
            key = key.substring(namespace.length());
            portletURL.setParameter(key, (String[])entry.getValue());
        }
        String portletFriendlyURL = friendlyURLMapper.buildPath((LiferayPortletURL)portletURL);
        if (portletFriendlyURL != null) {
            return layoutFriendlyURL.concat(portletFriendlyURL);
        }
        return layoutFriendlyURL.concat("?").concat(request.getQueryString());
    }

    protected String getLastPath(HttpServletRequest request) {
        ActionMapping actionMapping;
        HttpSession session = request.getSession();
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Boolean httpsInitial = (Boolean)session.getAttribute("HTTPS_INITIAL");
        String portalURL = null;
        portalURL = PropsValues.COMPANY_SECURITY_AUTH_REQUIRES_HTTPS && !PropsValues.SESSION_ENABLE_PHISHING_PROTECTION && httpsInitial != null && httpsInitial == false ? PortalUtil.getPortalURL((HttpServletRequest)request, (boolean)false) : PortalUtil.getPortalURL((HttpServletRequest)request);
        StringBundler sb = new StringBundler();
        sb.append(portalURL);
        sb.append(themeDisplay.getPathMain());
        sb.append(_PATH_PORTAL_LAYOUT);
        if (!PropsValues.AUTH_FORWARD_BY_LAST_PATH) {
            if (request.getRemoteUser() != null) {
                sb.append("?");
                sb.append("p_l_id");
                sb.append("=");
                sb.append(0L);
            }
            return sb.toString();
        }
        LastPath lastPath = (LastPath)session.getAttribute("LAST_PATH");
        if (lastPath == null) {
            return sb.toString();
        }
        Map parameterMap = lastPath.getParameterMap();
        if (lastPath.getContextPath().equals(themeDisplay.getPathMain()) && ((actionMapping = (ActionMapping)this.moduleConfig.findActionConfig(lastPath.getPath())) == null || parameterMap == null)) {
            return sb.toString();
        }
        StringBundler lastPathSB = new StringBundler(4);
        lastPathSB.append(portalURL);
        lastPathSB.append(lastPath.getContextPath());
        lastPathSB.append(lastPath.getPath());
        lastPathSB.append(HttpUtil.parameterMapToString((Map)parameterMap));
        return lastPathSB.toString();
    }

    protected boolean isPortletPath(String path) {
        return path != null && !path.equals(_PATH_C) && !path.startsWith(_PATH_COMMON) && !path.contains(_PATH_J_SECURITY_CHECK) && !path.startsWith(_PATH_PORTAL);
    }

    protected boolean isPublicPath(String path) {
        return path != null && (this._publicPaths.contains(path) || path.startsWith(_PATH_COMMON) || AuthPublicPathRegistry.contains(path));
    }

    protected Action processActionCreate(HttpServletRequest request, HttpServletResponse response, ActionMapping actionMapping) throws IOException {
        ActionAdapter actionAdapter = (ActionAdapter)StrutsActionRegistryUtil.getAction(actionMapping.getPath());
        if (actionAdapter != null) {
            ActionConfig actionConfig = this.moduleConfig.findActionConfig(actionMapping.getPath());
            if (actionConfig != null) {
                Action originalAction = super.processActionCreate(request, response, actionMapping);
                actionAdapter.setOriginalAction(originalAction);
            }
            return actionAdapter;
        }
        return super.processActionCreate(request, response, actionMapping);
    }

    protected ActionMapping processMapping(HttpServletRequest request, HttpServletResponse response, String path) throws IOException {
        if (path == null) {
            return null;
        }
        Action action = StrutsActionRegistryUtil.getAction(path);
        if (action != null) {
            ActionMapping actionMapping = (ActionMapping)this.moduleConfig.findActionConfig(path);
            if (actionMapping == null) {
                actionMapping = new ActionMapping();
                actionMapping.setModuleConfig(this.moduleConfig);
                actionMapping.setPath(path);
                request.setAttribute("org.apache.struts.action.mapping.instance", (Object)actionMapping);
            }
            return actionMapping;
        }
        ActionMapping actionMapping = super.processMapping(request, response, path);
        if (actionMapping == null) {
            MessageResources messageResources = this.getInternal();
            String msg = messageResources.getMessage("processInvalid");
            _log.error((Object)("User ID " + request.getRemoteUser()));
            _log.error((Object)("Current URL " + PortalUtil.getCurrentURL((HttpServletRequest)request)));
            _log.error((Object)("Referer " + request.getHeader("Referer")));
            _log.error((Object)("Remote address " + request.getRemoteAddr()));
            _log.error((Object)(String.valueOf(msg) + " " + path));
        }
        return actionMapping;
    }

    protected HttpServletRequest processMultipart(HttpServletRequest request) {
        return request;
    }

    protected String processPath(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String path = GetterUtil.getString((String)super.processPath(request, response));
        HttpSession session = request.getSession();
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        UserTracker userTracker = LiveUsers.getUserTracker(themeDisplay.getCompanyId(), session.getId());
        if (!(userTracker == null || path.equals(_PATH_C) || path.contains(_PATH_J_SECURITY_CHECK) || path.contains(_PATH_PORTAL_PROTECTED) || this._trackerIgnorePaths.contains(path))) {
            int pos;
            String fullPath = null;
            try {
                if (PropsValues.SESSION_TRACKER_FRIENDLY_PATHS_ENABLED) {
                    fullPath = this.getFriendlyTrackerPath(path, themeDisplay, request);
                }
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
            }
            String fullPathWithoutQueryString = fullPath;
            if (Validator.isNull(fullPath)) {
                String queryString = request.getQueryString();
                fullPathWithoutQueryString = path;
                fullPath = Validator.isNotNull((String)queryString) ? path.concat("?").concat(queryString) : path;
            }
            if ((pos = fullPathWithoutQueryString.indexOf("?")) != -1) {
                fullPathWithoutQueryString = fullPathWithoutQueryString.substring(0, pos);
            }
            if (!this._trackerIgnorePaths.contains(fullPathWithoutQueryString)) {
                UserTrackerPath userTrackerPath = UserTrackerPathUtil.create((long)0L);
                userTrackerPath.setUserTrackerId(userTracker.getUserTrackerId());
                userTrackerPath.setPath(fullPath);
                userTrackerPath.setPathDate(new Date());
                userTracker.addPath(userTrackerPath);
            }
        }
        String remoteUser = request.getRemoteUser();
        User user = null;
        try {
            user = PortalUtil.getUser((HttpServletRequest)request);
        }
        catch (Exception exception) {}
        if (this._lastPaths.contains(path) && !this._trackerIgnorePaths.contains(path)) {
            boolean saveLastPath = ParamUtil.getBoolean((HttpServletRequest)request, (String)"saveLastPath", (boolean)true);
            if (themeDisplay.isLifecycleResource() || themeDisplay.isStateExclusive() || themeDisplay.isStatePopUp() || !StringUtil.equalsIgnoreCase((String)request.getMethod(), (String)"GET")) {
                saveLastPath = false;
            }
            if (saveLastPath) {
                LastPath lastPath = (LastPath)request.getAttribute("LAST_PATH");
                if (lastPath == null) {
                    lastPath = new LastPath(themeDisplay.getPathMain(), path, request.getParameterMap());
                }
                session.setAttribute("LAST_PATH", (Object)lastPath);
            }
        }
        if (!SetupWizardUtil.isSetupFinished()) {
            if (!path.equals(_PATH_PORTAL_LICENSE) && !path.equals(_PATH_PORTAL_STATUS)) {
                return _PATH_PORTAL_SETUP_WIZARD;
            }
        } else if (path.equals(_PATH_PORTAL_SETUP_WIZARD)) {
            return _PATH_PORTAL_LAYOUT;
        }
        if ((remoteUser != null || user != null) && path.equals(_PATH_PORTAL_LOGOUT)) {
            return path;
        }
        if ((remoteUser != null || user != null) && (path.equals(_PATH_PORTAL_EXPIRE_SESSION) || path.equals(_PATH_PORTAL_EXTEND_SESSION))) {
            return path;
        }
        if ((remoteUser != null || user != null) && path.equals(_PATH_PORTAL_UPDATE_TERMS_OF_USE)) {
            return path;
        }
        if (remoteUser != null && user == null) {
            return _PATH_PORTAL_LOGOUT;
        }
        if (user != null && !user.isActive()) {
            SessionErrors.add((HttpServletRequest)request, (String)UserActiveException.class.getName());
            return _PATH_PORTAL_ERROR;
        }
        if (!(path.equals(_PATH_PORTAL_JSON_SERVICE) || path.equals(_PATH_PORTAL_RENDER_PORTLET) || ParamUtil.getBoolean((HttpServletRequest)request, (String)"wsrp") || themeDisplay.isImpersonated())) {
            if (user != null && !user.isAgreedToTermsOfUse()) {
                boolean termsOfUseRequired = false;
                try {
                    termsOfUseRequired = PrefsPropsUtil.getBoolean(user.getCompanyId(), "terms.of.use.required");
                }
                catch (SystemException systemException) {
                    termsOfUseRequired = PropsValues.TERMS_OF_USE_REQUIRED;
                }
                if (termsOfUseRequired) {
                    return _PATH_PORTAL_TERMS_OF_USE;
                }
            }
            boolean emailAddressVerificationRequired = false;
            try {
                Company company = PortalUtil.getCompany((HttpServletRequest)request);
                emailAddressVerificationRequired = company.isStrangersVerify();
            }
            catch (Exception e3) {
                _log.error((Object)e3, (Throwable)e3);
            }
            if (user != null && !user.isEmailAddressVerified() && emailAddressVerificationRequired) {
                if (path.equals(_PATH_PORTAL_UPDATE_EMAIL_ADDRESS)) {
                    return _PATH_PORTAL_UPDATE_EMAIL_ADDRESS;
                }
                return _PATH_PORTAL_VERIFY_EMAIL_ADDRESS;
            }
            if (user != null && user.isPasswordReset()) {
                return _PATH_PORTAL_UPDATE_PASSWORD;
            }
            if (user != null && !user.isPasswordReset() && path.equals(_PATH_PORTAL_UPDATE_PASSWORD)) {
                return null;
            }
            if (user != null && (Validator.isNull((String)user.getEmailAddress()) || PropsValues.USERS_EMAIL_ADDRESS_REQUIRED && Validator.isNull((String)user.getDisplayEmailAddress()))) {
                return _PATH_PORTAL_UPDATE_EMAIL_ADDRESS;
            }
            if (user != null && !user.isDefaultUser() && (Validator.isNull((String)user.getReminderQueryQuestion()) || Validator.isNull((String)user.getReminderQueryAnswer())) && PropsValues.USERS_REMINDER_QUERIES_ENABLED) {
                return _PATH_PORTAL_UPDATE_REMINDER_QUERY;
            }
        }
        if (!this.isPublicPath(path) && user == null) {
            SessionErrors.add((HttpServletRequest)request, (String)PrincipalException.class.getName());
            return _PATH_PORTAL_LOGIN;
        }
        ActionMapping actionMapping = (ActionMapping)this.moduleConfig.findActionConfig(path);
        if (actionMapping == null) {
            Action strutsAction = StrutsActionRegistryUtil.getAction(path);
            if (strutsAction == null) {
                return null;
            }
        } else {
            path = actionMapping.getPath();
        }
        if (this.isPortletPath(path)) {
            try {
                Portlet portlet = null;
                long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
                String portletId = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_id");
                if (Validator.isNotNull((String)portletId)) {
                    portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)portletId);
                }
                if (portlet == null) {
                    String strutsPath = path.substring(1, path.lastIndexOf(47));
                    portlet = PortletLocalServiceUtil.getPortletByStrutsPath((long)companyId, (String)strutsPath);
                }
                if (portlet != null && portlet.isActive()) {
                    this.defineObjects(request, response, portlet);
                }
            }
            catch (Exception e4) {
                request.setAttribute("javax.servlet.jsp.jspException", (Object)e4);
                path = _PATH_COMMON_ERROR;
            }
        }
        if (SessionErrors.contains((HttpServletRequest)request, (String)LayoutPermissionException.class.getName())) {
            return _PATH_PORTAL_ERROR;
        }
        return path;
    }

    protected boolean processRoles(HttpServletRequest request, HttpServletResponse response, ActionMapping actionMapping) throws IOException, ServletException {
        String path = actionMapping.getPath();
        if (this.isPublicPath(path)) {
            return true;
        }
        boolean authorized = true;
        User user = null;
        try {
            user = PortalUtil.getUser((HttpServletRequest)request);
        }
        catch (Exception exception) {}
        if (user != null && this.isPortletPath(path)) {
            block16: {
                if (!path.equals(_PATH_PORTAL_LOGOUT)) break block16;
                return true;
            }
            try {
                Portlet portlet = null;
                String portletId = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_id");
                if (Validator.isNotNull((String)portletId)) {
                    portlet = PortletLocalServiceUtil.getPortletById((long)user.getCompanyId(), (String)portletId);
                }
                String strutsPath = path.substring(1, path.lastIndexOf(47));
                if (portlet != null) {
                    if (!strutsPath.equals(portlet.getStrutsPath())) {
                        throw new PrincipalException();
                    }
                } else {
                    portlet = PortletLocalServiceUtil.getPortletByStrutsPath((long)user.getCompanyId(), (String)strutsPath);
                }
                if (portlet != null && portlet.isActive()) {
                    ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                    Layout layout = themeDisplay.getLayout();
                    PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
                    if (!PortletPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (Portlet)portlet, (String)"VIEW")) {
                        throw new PrincipalException();
                    }
                } else if (portlet != null && !portlet.isActive()) {
                    SessionErrors.add((HttpServletRequest)request, (String)PortletActiveException.class.getName());
                    authorized = false;
                }
            }
            catch (Exception exception) {
                SessionErrors.add((HttpServletRequest)request, (String)PrincipalException.class.getName());
                authorized = false;
            }
        }
        if (!authorized) {
            ActionForward forwardConfig = actionMapping.findForward(_PATH_PORTAL_ERROR);
            this.processForwardConfig(request, response, (ForwardConfig)forwardConfig);
            return false;
        }
        return true;
    }
}

