/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.transaction;

import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.util.PropsValues;
import java.util.ArrayList;
import java.util.List;
import org.springframework.transaction.interceptor.NoRollbackRuleAttribute;
import org.springframework.transaction.interceptor.RollbackRuleAttribute;
import org.springframework.transaction.interceptor.RuleBasedTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;

public class TransactionAttributeBuilder {
    public static TransactionAttribute build(Transactional transactional) {
        if (transactional == null) {
            return null;
        }
        return TransactionAttributeBuilder._build(transactional.enabled(), transactional.isolation().value(), transactional.propagation().value(), transactional.readOnly(), transactional.timeout(), transactional.rollbackFor(), transactional.rollbackForClassName(), transactional.noRollbackFor(), transactional.noRollbackForClassName());
    }

    private static TransactionAttribute _build(boolean enabled, int isolationLevel, int propagationBehavior, boolean readOnly, int timeout, Class<?>[] rollbackFor, String[] rollbackForClassName, Class<?>[] noRollbackFor, String[] noRollbackForClassName) {
        NoRollbackRuleAttribute noRollbackRuleAttribute;
        RollbackRuleAttribute rollbackRuleAttribute;
        if (!enabled) {
            return null;
        }
        RuleBasedTransactionAttribute ruleBasedTransactionAttribute = new RuleBasedTransactionAttribute();
        if (isolationLevel == -3) {
            ruleBasedTransactionAttribute.setIsolationLevel(PropsValues.TRANSACTION_ISOLATION_COUNTER);
        } else if (isolationLevel == -2) {
            ruleBasedTransactionAttribute.setIsolationLevel(PropsValues.TRANSACTION_ISOLATION_PORTAL);
        } else {
            ruleBasedTransactionAttribute.setIsolationLevel(isolationLevel);
        }
        ruleBasedTransactionAttribute.setPropagationBehavior(propagationBehavior);
        ruleBasedTransactionAttribute.setReadOnly(readOnly);
        ruleBasedTransactionAttribute.setTimeout(timeout);
        ArrayList<Object> rollbackRuleAttributes = new ArrayList<Object>();
        int i2 = 0;
        while (i2 < rollbackFor.length) {
            rollbackRuleAttribute = new RollbackRuleAttribute(rollbackFor[i2]);
            rollbackRuleAttributes.add(rollbackRuleAttribute);
            ++i2;
        }
        i2 = 0;
        while (i2 < rollbackForClassName.length) {
            rollbackRuleAttribute = new RollbackRuleAttribute(rollbackForClassName[i2]);
            rollbackRuleAttributes.add(rollbackRuleAttribute);
            ++i2;
        }
        i2 = 0;
        while (i2 < noRollbackFor.length) {
            noRollbackRuleAttribute = new NoRollbackRuleAttribute(noRollbackFor[i2]);
            rollbackRuleAttributes.add(noRollbackRuleAttribute);
            ++i2;
        }
        i2 = 0;
        while (i2 < noRollbackForClassName.length) {
            noRollbackRuleAttribute = new NoRollbackRuleAttribute(noRollbackForClassName[i2]);
            rollbackRuleAttributes.add(noRollbackRuleAttribute);
            ++i2;
        }
        List ruleBasedRollbackRuleAttributes = ruleBasedTransactionAttribute.getRollbackRules();
        ruleBasedRollbackRuleAttributes.addAll(rollbackRuleAttributes);
        return ruleBasedTransactionAttribute;
    }
}

