/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.secure;

import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.model.Company;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.util.PropsValues;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public class NonceUtil {
    private static final long _NONCE_EXPIRATION = (long)PropsValues.WEBDAV_NONCE_EXPIRATION * 60000L;
    private static DelayQueue<NonceDelayed> _nonceDelayQueue = new DelayQueue();

    public static String generate(long companyId, String remoteAddress) {
        String companyKey = null;
        try {
            Company company = CompanyLocalServiceUtil.getCompanyById((long)companyId);
            companyKey = company.getKey();
        }
        catch (Exception e2) {
            throw new RuntimeException("Invalid companyId " + companyId, e2);
        }
        long timestamp = System.currentTimeMillis();
        String nonce = DigesterUtil.digestHex((String)"MD5", (String[])new String[]{remoteAddress, String.valueOf(timestamp), companyKey});
        _nonceDelayQueue.put(new NonceDelayed(nonce));
        return nonce;
    }

    public static boolean verify(String nonce) {
        NonceUtil._cleanUp();
        return _nonceDelayQueue.contains(new NonceDelayed(nonce));
    }

    private static void _cleanUp() {
        while (_nonceDelayQueue.poll() != null) {
        }
    }

    private static class NonceDelayed
    implements Delayed {
        private final long _createTime;
        private final String _nonce;

        public NonceDelayed(String nonce) {
            if (nonce == null) {
                throw new NullPointerException("Nonce is null");
            }
            this._nonce = nonce;
            this._createTime = System.currentTimeMillis();
        }

        @Override
        public long getDelay(TimeUnit timeUnit) {
            long leftDelayTime = _NONCE_EXPIRATION + this._createTime - System.currentTimeMillis();
            return timeUnit.convert(leftDelayTime, TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed delayed) {
            NonceDelayed nonceDelayed = (NonceDelayed)delayed;
            long result = this._createTime - nonceDelayed._createTime;
            if (result == 0L) {
                return 0;
            }
            if (result > 0L) {
                return 1;
            }
            return -1;
        }

        public boolean equals(Object obj) {
            NonceDelayed nonceDelayed = (NonceDelayed)obj;
            return this._nonce.equals(nonceDelayed._nonce);
        }

        public int hashCode() {
            return this._nonce.hashCode();
        }
    }
}

