/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.etag;

import com.liferay.portal.kernel.servlet.RestrictedByteBufferCacheServletResponse;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.servlet.filters.etag.ETagUtil;
import com.liferay.portal.util.PropsValues;
import java.nio.ByteBuffer;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ETagFilter
extends BasePortalFilter {
    private static final String _ETAG = "etag";

    public boolean isFilterEnabled(HttpServletRequest request, HttpServletResponse response) {
        return ParamUtil.getBoolean((HttpServletRequest)request, (String)_ETAG, (boolean)true);
    }

    protected boolean isEligibleForEtag(int status) {
        return status >= 200 && status < 300;
    }

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        RestrictedByteBufferCacheServletResponse restrictedByteBufferCacheServletResponse = new RestrictedByteBufferCacheServletResponse(response, PropsValues.ETAG_RESPONSE_SIZE_MAX);
        this.processFilter(ETagFilter.class, request, (HttpServletResponse)restrictedByteBufferCacheServletResponse, filterChain);
        if (!restrictedByteBufferCacheServletResponse.isOverflowed()) {
            ByteBuffer byteBuffer = restrictedByteBufferCacheServletResponse.getByteBuffer();
            if (!this.isEligibleForEtag(restrictedByteBufferCacheServletResponse.getStatus()) || !ETagUtil.processETag(request, response, byteBuffer)) {
                restrictedByteBufferCacheServletResponse.finishResponse();
                restrictedByteBufferCacheServletResponse.flushCache();
            }
        }
    }
}

