/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;

public class ThreadLocalFacadeServletRequestWrapper
extends ServletRequestWrapper
implements Closeable {
    private static ThreadLocal<ServletRequest> _nextServletRequestThreadLocal = new AutoResetThreadLocal<ServletRequest>(ThreadLocalFacadeServletRequestWrapper.class + "._nextServletRequestThreadLocal"){

        protected ServletRequest copy(ServletRequest servletRequest) {
            return servletRequest;
        }
    };
    private List<Locale> _locales;
    private ServletRequestWrapper _servletRequestWrapper;

    public ThreadLocalFacadeServletRequestWrapper(ServletRequestWrapper servletRequestWrapper, ServletRequest nextServletRequest) {
        super(nextServletRequest);
        this._servletRequestWrapper = servletRequestWrapper;
        _nextServletRequestThreadLocal.set(nextServletRequest);
        this._locales = new ArrayList<Locale>();
        Enumeration enumeration = nextServletRequest.getLocales();
        while (enumeration.hasMoreElements()) {
            this._locales.add((Locale)enumeration.nextElement());
        }
    }

    @Override
    public void close() {
        if (this._servletRequestWrapper != null) {
            ServletRequest nextServletRequest = _nextServletRequestThreadLocal.get();
            this._servletRequestWrapper.setRequest(nextServletRequest);
        }
    }

    public Object getAttribute(String name) {
        ServletRequest servletRequest = this.getRequest();
        return servletRequest.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        ServletRequest servletRequest = this.getRequest();
        return servletRequest.getAttributeNames();
    }

    public Enumeration<Locale> getLocales() {
        return Collections.enumeration(this._locales);
    }

    public ServletRequest getRequest() {
        return _nextServletRequestThreadLocal.get();
    }

    public void removeAttribute(String name) {
        ServletRequest servletRequest = this.getRequest();
        servletRequest.removeAttribute(name);
    }

    public void setAttribute(String name, Object o) {
        ServletRequest servletRequest = this.getRequest();
        servletRequest.setAttribute(name, o);
    }

    public void setRequest(ServletRequest servletRequest) {
        _nextServletRequestThreadLocal.set(servletRequest);
    }
}

