/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.kernel.servlet.PersistentHttpServletRequestWrapper;
import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ThreadLocalFacadeHttpServletRequestWrapper
extends PersistentHttpServletRequestWrapper
implements Closeable {
    private static ThreadLocal<HttpServletRequest> _nextHttpServletRequestThreadLocal = new AutoResetThreadLocal<HttpServletRequest>(ThreadLocalFacadeHttpServletRequestWrapper.class + "._nextHttpServletRequestThreadLocal"){

        protected HttpServletRequest copy(HttpServletRequest httpServletRequest) {
            return httpServletRequest;
        }
    };
    private List<Locale> _locales;
    private ServletRequestWrapper _servletRequestWrapper;

    public ThreadLocalFacadeHttpServletRequestWrapper(ServletRequestWrapper servletRequestWrapper, HttpServletRequest httpServletRequest) {
        super(httpServletRequest);
        this._servletRequestWrapper = servletRequestWrapper;
        _nextHttpServletRequestThreadLocal.set(httpServletRequest);
        this._locales = new ArrayList<Locale>();
        Enumeration enumeration = httpServletRequest.getLocales();
        while (enumeration.hasMoreElements()) {
            this._locales.add((Locale)enumeration.nextElement());
        }
    }

    @Override
    public void close() {
        if (this._servletRequestWrapper != null) {
            HttpServletRequest nextHttpServletRequest = _nextHttpServletRequestThreadLocal.get();
            this._servletRequestWrapper.setRequest((ServletRequest)nextHttpServletRequest);
        }
    }

    public Object getAttribute(String name) {
        ServletRequest servletRequest = this.getRequest();
        return servletRequest.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        ServletRequest servletRequest = this.getRequest();
        return servletRequest.getAttributeNames();
    }

    public Enumeration<Locale> getLocales() {
        return Collections.enumeration(this._locales);
    }

    public ServletRequest getRequest() {
        return (ServletRequest)_nextHttpServletRequestThreadLocal.get();
    }

    public RequestDispatcher getRequestDispatcher(String uri) {
        HttpServletRequest httpServletRequest = _nextHttpServletRequestThreadLocal.get();
        return httpServletRequest.getRequestDispatcher(uri);
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)this.getRequest();
        return httpServletRequest.getSession(create);
    }

    public void removeAttribute(String name) {
        ServletRequest servletRequest = this.getRequest();
        servletRequest.removeAttribute(name);
    }

    public void setAttribute(String name, Object o) {
        ServletRequest servletRequest = this.getRequest();
        servletRequest.setAttribute(name, o);
    }

    public void setRequest(ServletRequest servletRequest) {
        _nextHttpServletRequestThreadLocal.set((HttpServletRequest)servletRequest);
    }
}

