/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.softwarecatalog.service.SCProductEntryLocalServiceUtil;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SoftwareCatalogServlet
extends HttpServlet {
    private static Log _log = LogFactoryUtil.getLog(SoftwareCatalogServlet.class);

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            long groupId = this.getGroupId(request);
            String version = this.getVersion(request);
            String baseImageURL = this.getBaseImageURL(request);
            Date oldestDate = this.getOldestDate(request);
            int maxNumOfVersions = ParamUtil.getInteger((HttpServletRequest)request, (String)"maxNumOfVersions");
            Properties repoSettings = this.getRepoSettings(request);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Group ID " + groupId));
                _log.debug((Object)("Base image URL " + baseImageURL));
                _log.debug((Object)("Oldtest date " + oldestDate));
                _log.debug((Object)("Maximum number of versions " + maxNumOfVersions));
            }
            String repositoryXML = SCProductEntryLocalServiceUtil.getRepositoryXML((long)groupId, (String)version, (String)baseImageURL, (Date)oldestDate, (int)maxNumOfVersions, (Properties)repoSettings);
            ServletResponseUtil.sendFile((HttpServletRequest)request, (HttpServletResponse)response, null, (byte[])repositoryXML.getBytes("UTF-8"), (String)"text/xml; charset=UTF-8");
        }
        catch (NoSuchGroupException nsge) {
            PortalUtil.sendError((int)404, (Exception)((Object)nsge), (HttpServletRequest)request, (HttpServletResponse)response);
        }
        catch (Exception e2) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e2, (Throwable)e2);
            }
            PortalUtil.sendError((int)500, (Exception)e2, (HttpServletRequest)request, (HttpServletResponse)response);
        }
    }

    protected String getBaseImageURL(HttpServletRequest request) {
        String host = PortalUtil.getHost((HttpServletRequest)request);
        String portalURL = PortalUtil.getPortalURL((String)host, (int)request.getServerPort(), (boolean)request.isSecure());
        String pathImage = PortalUtil.getPathImage();
        if (pathImage.startsWith("http://") || pathImage.startsWith("https://")) {
            return String.valueOf(pathImage) + "/software_catalog";
        }
        return String.valueOf(portalURL) + pathImage + "/software_catalog";
    }

    protected long getGroupId(HttpServletRequest request) throws PortalException, SystemException {
        long groupId = ParamUtil.getLong((HttpServletRequest)request, (String)"groupId");
        if (groupId <= 0L) {
            String path = GetterUtil.getString((String)request.getPathInfo());
            if (Validator.isNotNull((String)(path = StringUtil.replace((String)path, (String)"//", (String)"/")))) {
                int pos = path.indexOf(47, 1);
                if (pos == -1) {
                    pos = path.length();
                }
                groupId = GetterUtil.getLong((String)path.substring(1, pos));
            }
        }
        if (groupId <= 0L) {
            long companyId = PortalInstances.getCompanyId(request);
            Group guestGroup = GroupLocalServiceUtil.getGroup((long)companyId, (String)"Guest");
            groupId = guestGroup.getGroupId();
        }
        return groupId;
    }

    protected Date getOldestDate(HttpServletRequest request) {
        int daysOld;
        Date oldestDate = null;
        oldestDate = ParamUtil.getDate((HttpServletRequest)request, (String)"oldestDate", (DateFormat)DateFormatFactoryUtil.getSimpleDateFormat((String)"yyyy.MM.dd"), null);
        if (oldestDate == null && (daysOld = ParamUtil.getInteger((HttpServletRequest)request, (String)"maxAge", (int)-1)) != -1) {
            Calendar cal = Calendar.getInstance();
            cal.add(5, 0 - daysOld);
            oldestDate = cal.getTime();
        }
        return oldestDate;
    }

    protected Properties getRepoSettings(HttpServletRequest request) {
        Properties repoSettings = new Properties();
        String prefix = "setting_";
        Enumeration enu = request.getParameterNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            if (!name.startsWith(prefix)) continue;
            String settingName = name.substring(prefix.length());
            String value = ParamUtil.getString((HttpServletRequest)request, (String)name);
            if (!Validator.isNotNull((String)value)) continue;
            repoSettings.setProperty(settingName, value);
        }
        return repoSettings;
    }

    protected String getVersion(HttpServletRequest request) {
        int x;
        String path;
        String version = ParamUtil.getString((HttpServletRequest)request, (String)"version");
        String prefix = "liferay-plugin-repository-";
        String extension = ".xml";
        if (Validator.isNull((String)version) && Validator.isNotNull((String)(path = GetterUtil.getString((String)request.getPathInfo()))) && (x = path.indexOf(prefix)) != -1) {
            version = path.substring(x + prefix.length(), path.indexOf(extension, x));
        }
        if (_log.isDebugEnabled()) {
            if (Validator.isNull((String)version)) {
                _log.debug((Object)"Serving repository for all versions");
            } else {
                _log.debug((Object)("Serving repository for version " + version));
            }
        }
        return version;
    }
}

