/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.model.Organization;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.permission.OrganizationPermission;
import com.liferay.portal.service.permission.PortalPermissionUtil;

public class OrganizationPermissionImpl
implements OrganizationPermission {
    public void check(PermissionChecker permissionChecker, long organizationId, String actionId) throws PortalException, SystemException {
        if (!this.contains(permissionChecker, organizationId, actionId)) {
            throw new PrincipalException();
        }
    }

    public void check(PermissionChecker permissionChecker, Organization organization, String actionId) throws PortalException, SystemException {
        if (!this.contains(permissionChecker, organization, actionId)) {
            throw new PrincipalException();
        }
    }

    public boolean contains(PermissionChecker permissionChecker, long organizationId, String actionId) throws PortalException, SystemException {
        if (organizationId > 0L) {
            Organization organization = OrganizationLocalServiceUtil.getOrganization((long)organizationId);
            return this.contains(permissionChecker, organization, actionId);
        }
        return false;
    }

    public boolean contains(PermissionChecker permissionChecker, long[] organizationIds, String actionId) throws PortalException, SystemException {
        if (ArrayUtil.isEmpty((long[])organizationIds)) {
            return true;
        }
        long[] lArray = organizationIds;
        int n = organizationIds.length;
        int n2 = 0;
        while (n2 < n) {
            long organizationId = lArray[n2];
            this.check(permissionChecker, organizationId, actionId);
            ++n2;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public boolean contains(PermissionChecker permissionChecker, Organization organization, String actionId) throws PortalException, SystemException {
        groupId = organization.getGroupId();
        if (!this.contains(permissionChecker, groupId, organization, actionId)) ** GOTO lbl9
        return true;
lbl-1000:
        // 1 sources

        {
            parentOrganization = organization.getParentOrganization();
            groupId = parentOrganization.getGroupId();
            if (this.contains(permissionChecker, groupId, parentOrganization, "MANAGE_SUBORGANIZATIONS")) {
                return true;
            }
            organization = parentOrganization;
lbl9:
            // 2 sources

            ** while (!organization.isRoot())
        }
lbl10:
        // 1 sources

        return false;
    }

    protected boolean contains(PermissionChecker permissionChecker, long groupId, Organization organization, String actionId) throws PortalException, SystemException {
        while (organization != null && organization.getOrganizationId() != 0L) {
            if (actionId.equals("ADD_ORGANIZATION") && permissionChecker.hasPermission(groupId, Organization.class.getName(), organization.getOrganizationId(), "MANAGE_SUBORGANIZATIONS") || PortalPermissionUtil.contains((PermissionChecker)permissionChecker, (String)"ADD_ORGANIZATION")) {
                return true;
            }
            if (permissionChecker.hasPermission(groupId, Organization.class.getName(), organization.getOrganizationId(), actionId)) {
                return true;
            }
            organization = organization.getParentOrganization();
        }
        return false;
    }
}

