/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Group;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.permission.GroupPermission;
import com.liferay.portal.service.permission.PortalPermissionUtil;
import com.liferay.portal.service.permission.UserPermissionUtil;

public class GroupPermissionImpl
implements GroupPermission {
    public void check(PermissionChecker permissionChecker, Group group, String actionId) throws PortalException, SystemException {
        if (!this.contains(permissionChecker, group, actionId)) {
            throw new PrincipalException();
        }
    }

    public void check(PermissionChecker permissionChecker, long groupId, String actionId) throws PortalException, SystemException {
        if (!this.contains(permissionChecker, groupId, actionId)) {
            throw new PrincipalException();
        }
    }

    public void check(PermissionChecker permissionChecker, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, actionId)) {
            throw new PrincipalException();
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean contains(PermissionChecker permissionChecker, Group group, String actionId) throws PortalException, SystemException {
        if ((actionId.equals("ADD_LAYOUT") || actionId.equals("MANAGE_LAYOUTS")) && (group.hasLocalOrRemoteStagingGroup() || group.isLayoutPrototype())) {
            return false;
        }
        groupId = group.getGroupId();
        if (group.isStagingGroup()) {
            group = group.getLiveGroup();
        }
        if (group.isUser()) {
            user = UserLocalServiceUtil.getUserById((long)group.getClassPK());
            if (permissionChecker.getUserId() != user.getUserId() && UserPermissionUtil.contains((PermissionChecker)permissionChecker, (long)user.getUserId(), (long[])user.getOrganizationIds(), (String)"UPDATE")) {
                return true;
            }
        }
        if (actionId.equals("ADD_COMMUNITY") && permissionChecker.hasPermission(groupId, Group.class.getName(), groupId, "MANAGE_SUBGROUPS") || PortalPermissionUtil.contains((PermissionChecker)permissionChecker, (String)"ADD_COMMUNITY")) {
            return true;
        }
        if (actionId.equals("ADD_LAYOUT") && permissionChecker.hasPermission(groupId, Group.class.getName(), groupId, "MANAGE_LAYOUTS")) {
            return true;
        }
        if ((actionId.equals("EXPORT_IMPORT_LAYOUTS") || actionId.equals("EXPORT_IMPORT_PORTLET_INFO")) && permissionChecker.hasPermission(groupId, Group.class.getName(), groupId, "PUBLISH_STAGING")) {
            return true;
        }
        if (actionId.equals("VIEW") && (permissionChecker.hasPermission(groupId, Group.class.getName(), groupId, "ASSIGN_USER_ROLES") || permissionChecker.hasPermission(groupId, Group.class.getName(), groupId, "MANAGE_LAYOUTS"))) {
            return true;
        }
        if (actionId.equals("VIEW_STAGING") && (permissionChecker.hasPermission(groupId, Group.class.getName(), groupId, "MANAGE_LAYOUTS") || permissionChecker.hasPermission(groupId, Group.class.getName(), groupId, "MANAGE_STAGING") || permissionChecker.hasPermission(groupId, Group.class.getName(), groupId, "PUBLISH_STAGING") || permissionChecker.hasPermission(groupId, Group.class.getName(), groupId, "UPDATE"))) {
            return true;
        }
        if (!permissionChecker.hasPermission(groupId, Group.class.getName(), groupId, actionId)) ** GOTO lbl25
        return true;
lbl-1000:
        // 1 sources

        {
            if (this.contains(permissionChecker, group.getParentGroupId(), "MANAGE_SUBGROUPS")) {
                return true;
            }
            group = group.getParentGroup();
lbl25:
            // 2 sources

            ** while (!group.isRoot())
        }
lbl26:
        // 1 sources

        return false;
    }

    public boolean contains(PermissionChecker permissionChecker, long groupId, String actionId) throws PortalException, SystemException {
        if (groupId > 0L) {
            Group group = GroupLocalServiceUtil.getGroup((long)groupId);
            return this.contains(permissionChecker, group, actionId);
        }
        return false;
    }

    public boolean contains(PermissionChecker permissionChecker, String actionId) {
        return permissionChecker.hasPermission(0L, Group.class.getName(), 0L, actionId);
    }
}

