/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.VirtualHost;
import com.liferay.portal.service.base.VirtualHostLocalServiceBaseImpl;

public class VirtualHostLocalServiceImpl
extends VirtualHostLocalServiceBaseImpl {
    public VirtualHost fetchVirtualHost(long companyId, long layoutSetId) throws SystemException {
        return this.virtualHostPersistence.fetchByC_L(companyId, layoutSetId);
    }

    public VirtualHost fetchVirtualHost(String hostname) throws SystemException {
        return this.virtualHostPersistence.fetchByHostname(hostname);
    }

    public VirtualHost getVirtualHost(long companyId, long layoutSetId) throws PortalException, SystemException {
        return this.virtualHostPersistence.findByC_L(companyId, layoutSetId);
    }

    public VirtualHost getVirtualHost(String hostname) throws PortalException, SystemException {
        return this.virtualHostPersistence.findByHostname(hostname);
    }

    public VirtualHost updateVirtualHost(long companyId, long layoutSetId, String hostname) throws SystemException {
        LayoutSet layoutSet;
        VirtualHost virtualHost = this.virtualHostPersistence.fetchByC_L(companyId, layoutSetId);
        if (virtualHost == null) {
            long virtualHostId = this.counterLocalService.increment();
            virtualHost = this.virtualHostPersistence.create(virtualHostId);
            virtualHost.setCompanyId(companyId);
            virtualHost.setLayoutSetId(layoutSetId);
        }
        virtualHost.setHostname(hostname);
        this.virtualHostPersistence.update((BaseModel)virtualHost);
        Company company = this.companyPersistence.fetchByPrimaryKey(companyId);
        if (company != null) {
            this.companyPersistence.clearCache((BaseModel)company);
        }
        if ((layoutSet = this.layoutSetPersistence.fetchByPrimaryKey(layoutSetId)) != null) {
            this.layoutSetPersistence.clearCache((BaseModel)layoutSet);
        }
        return virtualHost;
    }
}

