/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.CompanyMaxUsersException;
import com.liferay.portal.ContactBirthdayException;
import com.liferay.portal.ContactFirstNameException;
import com.liferay.portal.ContactFullNameException;
import com.liferay.portal.ContactLastNameException;
import com.liferay.portal.DuplicateOpenIdException;
import com.liferay.portal.DuplicateUserEmailAddressException;
import com.liferay.portal.DuplicateUserScreenNameException;
import com.liferay.portal.GroupFriendlyURLException;
import com.liferay.portal.ModelListenerException;
import com.liferay.portal.NoSuchImageException;
import com.liferay.portal.NoSuchOrganizationException;
import com.liferay.portal.NoSuchRoleException;
import com.liferay.portal.NoSuchTicketException;
import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.NoSuchUserGroupException;
import com.liferay.portal.PasswordExpiredException;
import com.liferay.portal.RequiredUserException;
import com.liferay.portal.ReservedUserEmailAddressException;
import com.liferay.portal.ReservedUserScreenNameException;
import com.liferay.portal.UserEmailAddressException;
import com.liferay.portal.UserIdException;
import com.liferay.portal.UserLockoutException;
import com.liferay.portal.UserPasswordException;
import com.liferay.portal.UserPortraitSizeException;
import com.liferay.portal.UserPortraitTypeException;
import com.liferay.portal.UserReminderQueryException;
import com.liferay.portal.UserScreenNameException;
import com.liferay.portal.UserSmsException;
import com.liferay.portal.kernel.dao.shard.ShardCallable;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.image.ImageToolUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.spring.aop.Skip;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackRegistryUtil;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import com.liferay.portal.model.Account;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Contact;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.PasswordPolicy;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.Team;
import com.liferay.portal.model.Ticket;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.model.UserGroupRole;
import com.liferay.portal.model.impl.LayoutImpl;
import com.liferay.portal.security.auth.AuthPipeline;
import com.liferay.portal.security.auth.EmailAddressGenerator;
import com.liferay.portal.security.auth.EmailAddressGeneratorFactory;
import com.liferay.portal.security.auth.EmailAddressValidator;
import com.liferay.portal.security.auth.EmailAddressValidatorFactory;
import com.liferay.portal.security.auth.FullNameGenerator;
import com.liferay.portal.security.auth.FullNameGeneratorFactory;
import com.liferay.portal.security.auth.FullNameValidator;
import com.liferay.portal.security.auth.FullNameValidatorFactory;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.auth.ScreenNameGenerator;
import com.liferay.portal.security.auth.ScreenNameGeneratorFactory;
import com.liferay.portal.security.auth.ScreenNameValidator;
import com.liferay.portal.security.auth.ScreenNameValidatorFactory;
import com.liferay.portal.security.ldap.LDAPSettingsUtil;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.security.pwd.PasswordEncryptorUtil;
import com.liferay.portal.security.pwd.PwdAuthenticator;
import com.liferay.portal.security.pwd.PwdToolkitUtil;
import com.liferay.portal.security.pwd.RegExpToolkit;
import com.liferay.portal.service.BaseServiceImpl;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.UserLocalServiceBaseImpl;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.SubscriptionSender;
import com.liferay.portlet.documentlibrary.ImageSizeException;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.usersadmin.util.UsersAdminUtil;
import com.liferay.util.Encryptor;
import com.liferay.util.EncryptorException;
import com.liferay.util.PwdGenerator;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.Serializable;
import java.security.Key;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;

public class UserLocalServiceImpl
extends UserLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(UserLocalServiceImpl.class);
    private Map<Long, User> _defaultUsers = new ConcurrentHashMap<Long, User>();

    public User addDefaultAdminUser(long companyId, String screenName, String emailAddress, Locale locale, String firstName, String middleName, String lastName) throws PortalException, SystemException {
        User screenNameUser;
        String password1;
        long creatorUserId = 0L;
        boolean autoPassword = false;
        String password2 = password1 = PropsValues.DEFAULT_ADMIN_PASSWORD;
        boolean autoScreenName = false;
        screenName = this.getLogin(screenName);
        int i2 = 1;
        while ((screenNameUser = this.userPersistence.fetchByC_SN(companyId, screenName)) != null) {
            screenName = String.valueOf(screenName) + i2;
            ++i2;
        }
        long facebookId = 0L;
        String openId = "";
        int prefixId = 0;
        int suffixId = 0;
        boolean male = true;
        int birthdayMonth = 0;
        int birthdayDay = 1;
        int birthdayYear = 1970;
        String jobTitle = "";
        Group guestGroup = this.groupLocalService.getGroup(companyId, "Guest");
        long[] groupIds = new long[]{guestGroup.getGroupId()};
        long[] organizationIds = null;
        Role adminRole = this.roleLocalService.getRole(companyId, "Administrator");
        Role powerUserRole = this.roleLocalService.getRole(companyId, "Power User");
        long[] roleIds = new long[]{adminRole.getRoleId(), powerUserRole.getRoleId()};
        long[] userGroupIds = null;
        boolean sendEmail = false;
        ServiceContext serviceContext = new ServiceContext();
        User defaultAdminUser = this.addUser(creatorUserId, companyId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, facebookId, openId, locale, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, groupIds, organizationIds, roleIds, userGroupIds, sendEmail, serviceContext);
        this.updateEmailAddressVerified(defaultAdminUser.getUserId(), true);
        this.updateLastLogin(defaultAdminUser.getUserId(), defaultAdminUser.getLoginIP());
        this.updatePasswordReset(defaultAdminUser.getUserId(), false);
        return defaultAdminUser;
    }

    public void addDefaultGroups(long userId) throws PortalException, SystemException {
        String[] defaultOrganizationGroupNames;
        String[] defaultGroupNames;
        User user = this.userPersistence.findByPrimaryKey(userId);
        HashSet<Long> groupIdsSet = new HashSet<Long>();
        String[] stringArray = defaultGroupNames = PrefsPropsUtil.getStringArray(user.getCompanyId(), "admin.default.group.names", "\n", PropsValues.ADMIN_DEFAULT_GROUP_NAMES);
        int n = defaultGroupNames.length;
        int n2 = 0;
        while (n2 < n) {
            Group group;
            String defaultGroupName = stringArray[n2];
            Company company = this.companyPersistence.findByPrimaryKey(user.getCompanyId());
            Account account = company.getAccount();
            if (StringUtil.equalsIgnoreCase((String)defaultGroupName, (String)account.getName())) {
                defaultGroupName = "Guest";
            }
            if ((group = this.groupPersistence.fetchByC_N(user.getCompanyId(), defaultGroupName)) != null && !this.userPersistence.containsGroup(userId, group.getGroupId())) {
                groupIdsSet.add(group.getGroupId());
            }
            ++n2;
        }
        String[] stringArray2 = defaultOrganizationGroupNames = PrefsPropsUtil.getStringArray(user.getCompanyId(), "admin.default.organization.group.names", "\n", PropsValues.ADMIN_DEFAULT_ORGANIZATION_GROUP_NAMES);
        int n3 = defaultOrganizationGroupNames.length;
        n = 0;
        while (n < n3) {
            String defaultOrganizationGroupName = stringArray2[n];
            defaultOrganizationGroupName = String.valueOf(defaultOrganizationGroupName) + " LFR_ORGANIZATION";
            Group group = this.groupPersistence.fetchByC_N(user.getCompanyId(), defaultOrganizationGroupName);
            if (group != null && !this.userPersistence.containsGroup(userId, group.getGroupId())) {
                groupIdsSet.add(group.getGroupId());
            }
            ++n;
        }
        long[] groupIds = ArrayUtil.toArray((Long[])groupIdsSet.toArray(new Long[groupIdsSet.size()]));
        this.groupLocalService.addUserGroups(userId, groupIds);
    }

    public void addDefaultRoles(long userId) throws PortalException, SystemException {
        String[] defaultRoleNames;
        User user = this.userPersistence.findByPrimaryKey(userId);
        HashSet<Long> roleIdSet = new HashSet<Long>();
        String[] stringArray = defaultRoleNames = PrefsPropsUtil.getStringArray(user.getCompanyId(), "admin.default.role.names", "\n", PropsValues.ADMIN_DEFAULT_ROLE_NAMES);
        int n = defaultRoleNames.length;
        int n2 = 0;
        while (n2 < n) {
            String defaultRoleName = stringArray[n2];
            try {
                Role role = this.rolePersistence.findByC_N(user.getCompanyId(), defaultRoleName);
                if (!this.userPersistence.containsRole(userId, role.getRoleId())) {
                    roleIdSet.add(role.getRoleId());
                }
            }
            catch (NoSuchRoleException noSuchRoleException) {}
            ++n2;
        }
        long[] roleIds = ArrayUtil.toArray((Long[])roleIdSet.toArray(new Long[roleIdSet.size()]));
        roleIds = UsersAdminUtil.addRequiredRoles((User)user, (long[])roleIds);
        this.userPersistence.addRoles(userId, roleIds);
    }

    public void addDefaultUserGroups(long userId) throws PortalException, SystemException {
        String[] defaultUserGroupNames;
        User user = this.userPersistence.findByPrimaryKey(userId);
        HashSet<Long> userGroupIdSet = new HashSet<Long>();
        String[] stringArray = defaultUserGroupNames = PrefsPropsUtil.getStringArray(user.getCompanyId(), "admin.default.user.group.names", "\n", PropsValues.ADMIN_DEFAULT_USER_GROUP_NAMES);
        int n = defaultUserGroupNames.length;
        int n2 = 0;
        while (n2 < n) {
            String defaultUserGroupName = stringArray[n2];
            try {
                UserGroup userGroup = this.userGroupPersistence.findByC_N(user.getCompanyId(), defaultUserGroupName);
                if (!this.userPersistence.containsUserGroup(userId, userGroup.getUserGroupId())) {
                    userGroupIdSet.add(userGroup.getUserGroupId());
                }
            }
            catch (NoSuchUserGroupException noSuchUserGroupException) {}
            ++n2;
        }
        long[] userGroupIds = ArrayUtil.toArray((Long[])userGroupIdSet.toArray(new Long[userGroupIdSet.size()]));
        if (PropsValues.USER_GROUPS_COPY_LAYOUTS_TO_USER_PERSONAL_SITE) {
            long[] lArray = userGroupIds;
            int n3 = userGroupIds.length;
            int n4 = 0;
            while (n4 < n3) {
                long userGroupId = lArray[n4];
                this.userGroupLocalService.copyUserGroupLayouts(userGroupId, userId);
                ++n4;
            }
        }
        this.userPersistence.addUserGroups(userId, userGroupIds);
    }

    @Override
    public void addGroupUsers(long groupId, long[] userIds) throws PortalException, SystemException {
        this.groupPersistence.addUsers(groupId, userIds);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
        indexer.reindex((Object)userIds);
        PermissionCacheUtil.clearCache();
        this.addDefaultRolesAndTeams(groupId, userIds);
    }

    @Override
    public void addOrganizationUsers(long organizationId, long[] userIds) throws PortalException, SystemException {
        this.organizationPersistence.addUsers(organizationId, userIds);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
        indexer.reindex((Object)userIds);
        PermissionCacheUtil.clearCache();
    }

    public void addPasswordPolicyUsers(long passwordPolicyId, long[] userIds) throws SystemException {
        this.passwordPolicyRelLocalService.addPasswordPolicyRels(passwordPolicyId, User.class.getName(), userIds);
    }

    @Override
    public void addRoleUsers(long roleId, long[] userIds) throws PortalException, SystemException {
        this.rolePersistence.addUsers(roleId, userIds);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
        indexer.reindex((Object)userIds);
        PermissionCacheUtil.clearCache();
    }

    @Override
    public void addTeamUsers(long teamId, long[] userIds) throws PortalException, SystemException {
        this.teamPersistence.addUsers(teamId, userIds);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
        indexer.reindex((Object)userIds);
        PermissionCacheUtil.clearCache();
    }

    public User addUser(long creatorUserId, long companyId, boolean autoPassword, String password1, String password2, boolean autoScreenName, String screenName, String emailAddress, long facebookId, String openId, Locale locale, String firstName, String middleName, String lastName, int prefixId, int suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String jobTitle, long[] groupIds, long[] organizationIds, long[] roleIds, long[] userGroupIds, boolean sendEmail, ServiceContext serviceContext) throws PortalException, SystemException {
        boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
        try {
            WorkflowThreadLocal.setEnabled((boolean)false);
            if (serviceContext == null) {
                serviceContext = new ServiceContext();
            }
            if (serviceContext.getWorkflowAction() != 1) {
                serviceContext.setWorkflowAction(1);
            }
            User user = this.addUserWithWorkflow(creatorUserId, companyId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, facebookId, openId, locale, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, groupIds, organizationIds, roleIds, userGroupIds, sendEmail, serviceContext);
            return user;
        }
        finally {
            WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
        }
    }

    @Override
    public void addUserGroupUsers(long userGroupId, long[] userIds) throws PortalException, SystemException {
        if (PropsValues.USER_GROUPS_COPY_LAYOUTS_TO_USER_PERSONAL_SITE) {
            this.userGroupLocalService.copyUserGroupLayouts(userGroupId, userIds);
        }
        this.userGroupPersistence.addUsers(userGroupId, userIds);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
        indexer.reindex((Object)userIds);
        PermissionCacheUtil.clearCache();
    }

    public User addUserWithWorkflow(long creatorUserId, long companyId, boolean autoPassword, String password1, String password2, boolean autoScreenName, String screenName, String emailAddress, long facebookId, String openId, Locale locale, String firstName, String middleName, String lastName, int prefixId, int suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String jobTitle, long[] groupIds, long[] organizationIds, long[] roleIds, long[] userGroupIds, boolean sendEmail, ServiceContext serviceContext) throws PortalException, SystemException {
        String passwordUnencrypted;
        ServiceContext workflowServiceContext;
        long workflowUserId;
        int n;
        String uuid;
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        screenName = this.getLogin(screenName);
        openId = StringUtil.trim((String)openId);
        Date now = new Date();
        if (PrefsPropsUtil.getBoolean(companyId, "users.screen.name.always.autogenerate")) {
            autoScreenName = true;
        }
        long userId = this.counterLocalService.increment();
        EmailAddressGenerator emailAddressGenerator = EmailAddressGeneratorFactory.getInstance();
        emailAddress = emailAddress == null || emailAddressGenerator.isGenerated(emailAddress) ? "" : StringUtil.toLowerCase((String)emailAddress.trim());
        if (!PrefsPropsUtil.getBoolean(companyId, "users.email.address.required") && Validator.isNull((String)emailAddress)) {
            emailAddress = emailAddressGenerator.generate(companyId, userId);
        }
        this.validate(companyId, userId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, openId, firstName, middleName, lastName, organizationIds);
        if (!autoPassword && (Validator.isNull((String)password1) || Validator.isNull((String)password2))) {
            throw new UserPasswordException(3);
        }
        if (autoScreenName) {
            ScreenNameGenerator screenNameGenerator = ScreenNameGeneratorFactory.getInstance();
            try {
                screenName = screenNameGenerator.generate(companyId, userId, emailAddress);
            }
            catch (Exception e2) {
                throw new SystemException((Throwable)e2);
            }
        }
        User defaultUser = this.getDefaultUser(companyId);
        FullNameGenerator fullNameGenerator = FullNameGeneratorFactory.getInstance();
        String fullName = fullNameGenerator.getFullName(firstName, middleName, lastName);
        String greeting = LanguageUtil.format((Locale)locale, (String)"welcome-x", (Object)(" " + fullName), (boolean)false);
        User user = this.userPersistence.create(userId);
        if (serviceContext != null && Validator.isNotNull((String)(uuid = serviceContext.getUuid()))) {
            user.setUuid(uuid);
        }
        user.setCompanyId(companyId);
        user.setCreateDate(now);
        user.setModifiedDate(now);
        user.setDefaultUser(false);
        user.setContactId(this.counterLocalService.increment());
        if (Validator.isNotNull((String)password1)) {
            user.setPassword(PasswordEncryptorUtil.encrypt(password1));
            user.setPasswordUnencrypted(password1);
        }
        user.setPasswordEncrypted(true);
        PasswordPolicy passwordPolicy = defaultUser.getPasswordPolicy();
        boolean passwordReset = false;
        if (passwordPolicy != null) {
            if (passwordPolicy.isChangeable() && passwordPolicy.isChangeRequired()) {
                passwordReset = true;
            }
            this.addPasswordPolicyUsers(passwordPolicy.getPasswordPolicyId(), new long[]{userId});
        }
        user.setPasswordReset(passwordReset);
        user.setDigest("");
        user.setScreenName(screenName);
        user.setEmailAddress(emailAddress);
        user.setFacebookId(facebookId);
        Long ldapServerId = (Long)serviceContext.getAttribute("ldapServerId");
        if (ldapServerId != null) {
            user.setLdapServerId(ldapServerId.longValue());
        } else {
            user.setLdapServerId(-1L);
        }
        user.setOpenId(openId);
        user.setLanguageId(LocaleUtil.toLanguageId((Locale)locale));
        user.setTimeZoneId(defaultUser.getTimeZoneId());
        user.setGreeting(greeting);
        user.setFirstName(firstName);
        user.setMiddleName(middleName);
        user.setLastName(lastName);
        user.setJobTitle(jobTitle);
        user.setStatus(2);
        user.setExpandoBridgeAttributes(serviceContext);
        this.userPersistence.update((BaseModel)user, serviceContext);
        String creatorUserName = "";
        if (creatorUserId <= 0L) {
            creatorUserId = user.getUserId();
        } else {
            User creatorUser = this.userPersistence.findByPrimaryKey(creatorUserId);
            creatorUserName = creatorUser.getFullName();
        }
        this.resourceLocalService.addResources(companyId, 0L, creatorUserId, User.class.getName(), user.getUserId(), false, false, false);
        Date birthday = this.getBirthday(birthdayMonth, birthdayDay, birthdayYear);
        Contact contact = this.contactPersistence.create(user.getContactId());
        contact.setCompanyId(user.getCompanyId());
        contact.setUserId(creatorUserId);
        contact.setUserName(creatorUserName);
        contact.setCreateDate(now);
        contact.setModifiedDate(now);
        contact.setClassName(User.class.getName());
        contact.setClassPK(user.getUserId());
        contact.setAccountId(company.getAccountId());
        contact.setParentContactId(0L);
        contact.setEmailAddress(user.getEmailAddress());
        contact.setFirstName(firstName);
        contact.setMiddleName(middleName);
        contact.setLastName(lastName);
        contact.setPrefixId(prefixId);
        contact.setSuffixId(suffixId);
        contact.setMale(male);
        contact.setBirthday(birthday);
        contact.setJobTitle(jobTitle);
        this.contactPersistence.update((BaseModel)contact, serviceContext);
        this.groupLocalService.addGroup(user.getUserId(), 0L, User.class.getName(), user.getUserId(), null, null, 0, "/" + screenName, false, true, null);
        if (groupIds != null) {
            ArrayList<Group> groups = new ArrayList<Group>();
            long[] lArray = groupIds;
            int n2 = groupIds.length;
            n = 0;
            while (n < n2) {
                long groupId = lArray[n];
                Group group = this.groupLocalService.fetchGroup(groupId);
                if (group != null) {
                    groups.add(group);
                } else if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Group " + groupId + " does not exist"));
                }
                ++n;
            }
            this.groupLocalService.addUserGroups(userId, groups);
        }
        this.addDefaultGroups(userId);
        this.updateOrganizations(userId, organizationIds, false);
        if (roleIds != null) {
            roleIds = UsersAdminUtil.addRequiredRoles((User)user, (long[])roleIds);
            this.userPersistence.setRoles(userId, roleIds);
        }
        this.addDefaultRoles(userId);
        if (userGroupIds != null) {
            if (PropsValues.USER_GROUPS_COPY_LAYOUTS_TO_USER_PERSONAL_SITE) {
                long[] lArray = userGroupIds;
                n = userGroupIds.length;
                int n3 = 0;
                while (n3 < n) {
                    long userGroupId = lArray[n3];
                    this.userGroupLocalService.copyUserGroupLayouts(userGroupId, new long[]{userId});
                    ++n3;
                }
            }
            this.userPersistence.setUserGroups(userId, userGroupIds);
        }
        this.addDefaultUserGroups(userId);
        if (serviceContext != null) {
            this.updateAsset(creatorUserId, user, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        }
        if (serviceContext == null || serviceContext.isIndexingEnabled()) {
            this.reindex(user);
        }
        if ((workflowUserId = creatorUserId) == userId) {
            workflowUserId = defaultUser.getUserId();
        }
        if ((workflowServiceContext = serviceContext) == null) {
            workflowServiceContext = new ServiceContext();
        }
        workflowServiceContext.setAttribute("autoPassword", (Serializable)Boolean.valueOf(autoPassword));
        workflowServiceContext.setAttribute("sendEmail", (Serializable)Boolean.valueOf(sendEmail));
        this.startWorkflowInstance(companyId, workflowUserId, userId, user, workflowServiceContext);
        if (serviceContext != null && Validator.isNotNull((String)(passwordUnencrypted = (String)((Object)serviceContext.getAttribute("passwordUnencrypted"))))) {
            user.setPasswordUnencrypted(passwordUnencrypted);
        }
        return user;
    }

    public int authenticateByEmailAddress(long companyId, String emailAddress, String password, Map<String, String[]> headerMap, Map<String, String[]> parameterMap, Map<String, Object> resultsMap) throws PortalException, SystemException {
        return this.authenticate(companyId, emailAddress, password, "emailAddress", headerMap, parameterMap, resultsMap);
    }

    public int authenticateByScreenName(long companyId, String screenName, String password, Map<String, String[]> headerMap, Map<String, String[]> parameterMap, Map<String, Object> resultsMap) throws PortalException, SystemException {
        return this.authenticate(companyId, screenName, password, "screenName", headerMap, parameterMap, resultsMap);
    }

    public int authenticateByUserId(long companyId, long userId, String password, Map<String, String[]> headerMap, Map<String, String[]> parameterMap, Map<String, Object> resultsMap) throws PortalException, SystemException {
        return this.authenticate(companyId, String.valueOf(userId), password, "userId", headerMap, parameterMap, resultsMap);
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public long authenticateForBasic(long companyId, String authType, String login, String password) throws PortalException, SystemException {
        if (PropsValues.AUTH_LOGIN_DISABLED) {
            return 0L;
        }
        User user = null;
        if (authType.equals("emailAddress")) {
            user = this.fetchUserByEmailAddress(companyId, login);
        } else if (authType.equals("screenName")) {
            user = this.fetchUserByScreenName(companyId, login);
        } else if (authType.equals("userId")) {
            user = this.userPersistence.fetchByPrimaryKey(GetterUtil.getLong((String)login));
        }
        if (user == null) {
            return 0L;
        }
        if (user.isDefaultUser()) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Basic authentication is disabled for the default user");
            }
            return 0L;
        }
        if (!user.isActive()) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Basic authentication is disabled for inactive user " + user.getUserId()));
            }
            return 0L;
        }
        if (!PropsValues.BASIC_AUTH_PASSWORD_REQUIRED) {
            return user.getUserId();
        }
        String userPassword = user.getPassword();
        if (!user.isPasswordEncrypted()) {
            userPassword = PasswordEncryptorUtil.encrypt(userPassword);
        }
        String encPassword = PasswordEncryptorUtil.encrypt(password, userPassword);
        if (userPassword.equals(password) || userPassword.equals(encPassword)) {
            return user.getUserId();
        }
        return 0L;
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public long authenticateForDigest(long companyId, String username, String realm, String nonce, String method, String uri, String response) throws PortalException, SystemException {
        String[] digestArray;
        if (PropsValues.AUTH_LOGIN_DISABLED) {
            return 0L;
        }
        User user = this.fetchUserByEmailAddress(companyId, username);
        if (user == null) {
            user = this.fetchUserByScreenName(companyId, username);
        }
        if (user == null) {
            user = this.userPersistence.fetchByPrimaryKey(GetterUtil.getLong((String)username));
        }
        if (user == null) {
            return 0L;
        }
        if (user.isDefaultUser()) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Digest authentication is disabled for the default user");
            }
            return 0L;
        }
        if (!user.isActive()) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Digest authentication is disabled for inactive user " + user.getUserId()));
            }
            return 0L;
        }
        String digest = user.getDigest();
        if (Validator.isNull((String)digest)) {
            _log.error((Object)("User must first login through the portal " + user.getUserId()));
            return 0L;
        }
        String[] stringArray = digestArray = StringUtil.split((String)user.getDigest());
        int n = digestArray.length;
        int n2 = 0;
        while (n2 < n) {
            String ha1 = stringArray[n2];
            String ha2 = DigesterUtil.digestHex((String)"MD5", (String[])new String[]{method, uri});
            String curResponse = DigesterUtil.digestHex((String)"MD5", (String[])new String[]{ha1, nonce, ha2});
            if (response.equals(curResponse)) {
                return user.getUserId();
            }
            ++n2;
        }
        return 0L;
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public boolean authenticateForJAAS(long userId, String encPassword) {
        String userPassword;
        block16: {
            block14: {
                block15: {
                    User user;
                    block13: {
                        block12: {
                            if (PropsValues.AUTH_LOGIN_DISABLED) {
                                return false;
                            }
                            user = this.userPersistence.findByPrimaryKey(userId);
                            if (!user.isDefaultUser()) break block12;
                            if (_log.isInfoEnabled()) {
                                _log.info((Object)"JAAS authentication is disabled for the default user");
                            }
                            return false;
                        }
                        if (user.isActive()) break block13;
                        if (_log.isInfoEnabled()) {
                            _log.info((Object)("JAAS authentication is disabled for inactive user " + userId));
                        }
                        return false;
                    }
                    userPassword = user.getPassword();
                    if (!user.isPasswordEncrypted()) break block14;
                    if (!userPassword.equals(encPassword)) break block15;
                    return true;
                }
                if (!PropsValues.PORTAL_JAAS_STRICT_PASSWORD && userPassword.equals(encPassword = PasswordEncryptorUtil.encrypt(encPassword, userPassword))) {
                    return true;
                }
            }
            if (PropsValues.PORTAL_JAAS_STRICT_PASSWORD || !userPassword.equals(encPassword)) break block16;
            return true;
        }
        try {
            userPassword = PasswordEncryptorUtil.encrypt(userPassword, encPassword);
            if (userPassword.equals(encPassword)) {
                return true;
            }
        }
        catch (Exception e2) {
            _log.error((Throwable)e2);
        }
        return false;
    }

    public void checkLockout(User user) throws PortalException, SystemException {
        long requiredElapsedTime;
        long elapsedTime;
        if (LDAPSettingsUtil.isPasswordPolicyEnabled(user.getCompanyId())) {
            return;
        }
        PasswordPolicy passwordPolicy = user.getPasswordPolicy();
        if (!passwordPolicy.isLockout()) {
            return;
        }
        Date now = new Date();
        int failedLoginAttempts = user.getFailedLoginAttempts();
        if (failedLoginAttempts > 0) {
            long failedLoginTime = user.getLastFailedLoginDate().getTime();
            elapsedTime = now.getTime() - failedLoginTime;
            requiredElapsedTime = passwordPolicy.getResetFailureCount() * 1000L;
            if (requiredElapsedTime != 0L && elapsedTime > requiredElapsedTime) {
                user.setLastFailedLoginDate(null);
                user.setFailedLoginAttempts(0);
                this.userPersistence.update((BaseModel)user);
            }
        }
        if (user.isLockout()) {
            long lockoutTime = user.getLockoutDate().getTime();
            elapsedTime = now.getTime() - lockoutTime;
            requiredElapsedTime = passwordPolicy.getLockoutDuration() * 1000L;
            if (requiredElapsedTime != 0L && elapsedTime > requiredElapsedTime) {
                user.setLockout(false);
                user.setLockoutDate(null);
                this.userPersistence.update((BaseModel)user);
            }
        }
        if (user.isLockout()) {
            throw new UserLockoutException();
        }
    }

    public void checkLoginFailure(User user) throws SystemException {
        Date now = new Date();
        int failedLoginAttempts = user.getFailedLoginAttempts();
        user.setLastFailedLoginDate(now);
        user.setFailedLoginAttempts(++failedLoginAttempts);
        this.userPersistence.update((BaseModel)user);
    }

    public void checkLoginFailureByEmailAddress(long companyId, String emailAddress) throws PortalException, SystemException {
        User user = this.getUserByEmailAddress(companyId, emailAddress);
        this.checkLoginFailure(user);
    }

    public void checkLoginFailureById(long userId) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        this.checkLoginFailure(user);
    }

    public void checkLoginFailureByScreenName(long companyId, String screenName) throws PortalException, SystemException {
        User user = this.getUserByScreenName(companyId, screenName);
        this.checkLoginFailure(user);
    }

    public void checkPasswordExpired(User user) throws PortalException, SystemException {
        if (LDAPSettingsUtil.isPasswordPolicyEnabled(user.getCompanyId())) {
            return;
        }
        PasswordPolicy passwordPolicy = user.getPasswordPolicy();
        if (this.isPasswordExpired(user)) {
            int graceLoginCount = user.getGraceLoginCount();
            if (graceLoginCount < passwordPolicy.getGraceLimit()) {
                user.setGraceLoginCount(++graceLoginCount);
                this.userPersistence.update((BaseModel)user);
            } else {
                user.setDigest("");
                this.userPersistence.update((BaseModel)user);
                throw new PasswordExpiredException();
            }
        }
        if (passwordPolicy.isChangeable() && passwordPolicy.isChangeRequired() && user.getLastLoginDate() == null) {
            user.setPasswordReset(true);
            this.userPersistence.update((BaseModel)user);
        }
    }

    @Override
    public void clearOrganizationUsers(long organizationId) throws SystemException {
        this.organizationPersistence.clearUsers(organizationId);
        PermissionCacheUtil.clearCache();
    }

    @Override
    public void clearUserGroupUsers(long userGroupId) throws SystemException {
        this.userGroupPersistence.clearUsers(userGroupId);
        PermissionCacheUtil.clearCache();
    }

    public void completeUserRegistration(User user, ServiceContext serviceContext) throws PortalException, SystemException {
        Company company;
        boolean sendEmail;
        boolean autoPassword = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"autoPassword");
        String password = null;
        if (autoPassword) {
            if (LDAPSettingsUtil.isPasswordPolicyEnabled(user.getCompanyId())) {
                if (_log.isWarnEnabled()) {
                    StringBundler sb = new StringBundler(4);
                    sb.append("When LDAP password policy is enabled, it is ");
                    sb.append("possible that portal generated passwords will ");
                    sb.append("not match the LDAP policy. Using ");
                    sb.append("RegExpToolkit to generate new password.");
                    _log.warn((Object)sb.toString());
                }
                RegExpToolkit regExpToolkit = new RegExpToolkit();
                password = regExpToolkit.generate(null);
            } else {
                PasswordPolicy passwordPolicy = this.passwordPolicyLocalService.getPasswordPolicy(user.getCompanyId(), user.getOrganizationIds());
                password = PwdToolkitUtil.generate(passwordPolicy);
            }
            user.setPassword(PasswordEncryptorUtil.encrypt(password));
            user.setPasswordUnencrypted(password);
            user.setPasswordEncrypted(true);
            user.setPasswordModified(true);
            user.setPasswordModifiedDate(new Date());
            this.userPersistence.update((BaseModel)user);
            user.setPasswordModified(false);
        }
        if (user.hasCompanyMx()) {
            String mailPassword = password;
            if (Validator.isNull(mailPassword)) {
                mailPassword = user.getPasswordUnencrypted();
            }
            this.mailService.addUser(user.getCompanyId(), user.getUserId(), mailPassword, user.getFirstName(), user.getMiddleName(), user.getLastName(), user.getEmailAddress());
        }
        if (sendEmail = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"sendEmail")) {
            this.sendEmail(user, password, serviceContext);
        }
        if ((company = this.companyPersistence.findByPrimaryKey(user.getCompanyId())).isStrangersVerify() && serviceContext.getPlid() > 0L) {
            this.sendEmailAddressVerification(user, user.getEmailAddress(), serviceContext);
        }
    }

    public KeyValuePair decryptUserId(long companyId, String name, String password) throws PortalException, SystemException {
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        try {
            name = Encryptor.decrypt((Key)company.getKeyObj(), (String)name);
        }
        catch (EncryptorException ee) {
            throw new SystemException((Throwable)ee);
        }
        long userId = GetterUtil.getLong((String)name);
        User user = this.userPersistence.findByPrimaryKey(userId);
        try {
            password = Encryptor.decrypt((Key)company.getKeyObj(), (String)password);
        }
        catch (EncryptorException ee) {
            throw new SystemException((Throwable)ee);
        }
        String userPassword = user.getPassword();
        String encPassword = PasswordEncryptorUtil.encrypt(password, userPassword);
        if (userPassword.equals(encPassword)) {
            if (this.isPasswordExpired(user)) {
                user.setPasswordReset(true);
                this.userPersistence.update((BaseModel)user);
            }
            return new KeyValuePair(name, password);
        }
        throw new PrincipalException();
    }

    public void deletePortrait(long userId) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long portraitId = user.getPortraitId();
        if (portraitId > 0L) {
            user.setPortraitId(0L);
            this.userPersistence.update((BaseModel)user);
            this.imageLocalService.deleteImage(portraitId);
        }
    }

    @Override
    public void deleteRoleUser(long roleId, long userId) throws PortalException, SystemException {
        this.rolePersistence.removeUser(roleId, userId);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
        indexer.reindex((Object)userId);
        PermissionCacheUtil.clearCache();
    }

    @Override
    public User deleteUser(long userId) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        return this.deleteUser(user);
    }

    @Override
    public User deleteUser(User user) throws PortalException, SystemException {
        block6: {
            if (!PropsValues.USERS_DELETE) {
                throw new RequiredUserException();
            }
            this.browserTrackerLocalService.deleteUserBrowserTracker(user.getUserId());
            Group group = null;
            if (!user.isDefaultUser()) {
                group = user.getGroup();
            }
            if (group != null) {
                this.groupLocalService.deleteGroup(group);
            }
            try {
                this.imageLocalService.deleteImage(user.getPortraitId());
            }
            catch (NoSuchImageException noSuchImageException) {
                if (!_log.isWarnEnabled()) break block6;
                _log.warn((Object)("Unable to delete image " + user.getPortraitId()));
            }
        }
        this.passwordPolicyRelLocalService.deletePasswordPolicyRel(User.class.getName(), user.getUserId());
        this.passwordTrackerLocalService.deletePasswordTrackers(user.getUserId());
        this.subscriptionLocalService.deleteSubscriptions(user.getUserId());
        this.userIdMapperLocalService.deleteUserIdMappers(user.getUserId());
        this.announcementsDeliveryLocalService.deleteDeliveries(user.getUserId());
        this.assetEntryLocalService.deleteEntry(User.class.getName(), user.getUserId());
        this.blogsStatsUserLocalService.deleteStatsUserByUserId(user.getUserId());
        this.dlFileRankLocalService.deleteFileRanksByUserId(user.getUserId());
        this.expandoRowLocalService.deleteRows(user.getUserId());
        this.mbBanLocalService.deleteBansByBanUserId(user.getUserId());
        this.mbStatsUserLocalService.deleteStatsUsersByUserId(user.getUserId());
        this.mbThreadFlagLocalService.deleteThreadFlagsByUserId(user.getUserId());
        this.membershipRequestLocalService.deleteMembershipRequestsByUserId(user.getUserId());
        this.shoppingCartLocalService.deleteUserCarts(user.getUserId());
        this.socialActivityLocalService.deleteUserActivities(user.getUserId());
        this.socialRequestLocalService.deleteReceiverUserRequests(user.getUserId());
        this.socialRequestLocalService.deleteUserRequests(user.getUserId());
        this.mailService.deleteUser(user.getCompanyId(), user.getUserId());
        Contact contact = this.contactLocalService.fetchContact(user.getContactId());
        if (contact != null) {
            this.contactLocalService.deleteContact(contact);
        }
        this.resourceLocalService.deleteResource(user.getCompanyId(), User.class.getName(), 4, user.getUserId());
        this.userGroupRoleLocalService.deleteUserGroupRolesByUserId(user.getUserId());
        this.userPersistence.remove((BaseModel)user);
        PermissionCacheUtil.clearCache();
        this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(user.getCompanyId(), 0L, User.class.getName(), user.getUserId());
        return user;
    }

    @Override
    public void deleteUserGroupUser(long userGroupId, long userId) throws PortalException, SystemException {
        this.userGroupPersistence.removeUser(userGroupId, userId);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
        indexer.reindex((Object)userId);
        PermissionCacheUtil.clearCache();
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public String encryptUserId(String name) throws PortalException, SystemException {
        long userId = GetterUtil.getLong((String)name);
        User user = this.userPersistence.findByPrimaryKey(userId);
        Company company = this.companyPersistence.findByPrimaryKey(user.getCompanyId());
        try {
            return Encryptor.encrypt((Key)company.getKeyObj(), (String)name);
        }
        catch (EncryptorException ee) {
            throw new SystemException((Throwable)ee);
        }
    }

    public User fetchUserByEmailAddress(long companyId, String emailAddress) throws SystemException {
        emailAddress = this.getLogin(emailAddress);
        return this.userPersistence.fetchByC_EA(companyId, emailAddress);
    }

    public User fetchUserByFacebookId(long companyId, long facebookId) throws SystemException {
        return this.userPersistence.fetchByC_FID(companyId, facebookId);
    }

    public User fetchUserById(long userId) throws SystemException {
        return this.userPersistence.fetchByPrimaryKey(userId);
    }

    public User fetchUserByOpenId(long companyId, String openId) throws SystemException {
        return this.userPersistence.fetchByC_O(companyId, openId);
    }

    public User fetchUserByScreenName(long companyId, String screenName) throws SystemException {
        screenName = this.getLogin(screenName);
        return this.userPersistence.fetchByC_SN(companyId, screenName);
    }

    public List<User> getCompanyUsers(long companyId, int start, int end) throws SystemException {
        return this.userPersistence.findByCompanyId(companyId, start, end);
    }

    public int getCompanyUsersCount(long companyId) throws SystemException {
        return this.userPersistence.countByCompanyId(companyId);
    }

    @Skip
    public User getDefaultUser(long companyId) throws PortalException, SystemException {
        User userModel = this._defaultUsers.get(companyId);
        if (userModel == null) {
            userModel = this.userLocalService.loadGetDefaultUser(companyId);
            this._defaultUsers.put(companyId, userModel);
        }
        return userModel;
    }

    @Skip
    public long getDefaultUserId(long companyId) throws PortalException, SystemException {
        User user = this.getDefaultUser(companyId);
        return user.getUserId();
    }

    public long[] getGroupUserIds(long groupId) throws SystemException {
        return this.getUserIds(this.getGroupUsers(groupId));
    }

    public int getGroupUsersCount(long groupId, int status) throws PortalException, SystemException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("usersGroups", new Long(groupId));
        return this.searchCount(group.getCompanyId(), null, status, params);
    }

    public List<User> getNoAnnouncementsDeliveries(String type) throws SystemException {
        return this.userFinder.findByNoAnnouncementsDeliveries(type);
    }

    public List<User> getNoContacts() throws SystemException {
        return this.userFinder.findByNoContacts();
    }

    public List<User> getNoGroups() throws SystemException {
        return this.userFinder.findByNoGroups();
    }

    public long[] getOrganizationUserIds(long organizationId) throws SystemException {
        return this.getUserIds(this.getOrganizationUsers(organizationId));
    }

    public int getOrganizationUsersCount(long organizationId, int status) throws PortalException, SystemException {
        Organization organization = this.organizationPersistence.findByPrimaryKey(organizationId);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("usersOrgs", new Long(organizationId));
        return this.searchCount(organization.getCompanyId(), null, status, params);
    }

    public long[] getRoleUserIds(long roleId) throws SystemException {
        return this.getUserIds(this.getRoleUsers(roleId));
    }

    public int getRoleUsersCount(long roleId, int status) throws PortalException, SystemException {
        Role role = this.rolePersistence.findByPrimaryKey(roleId);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("usersRoles", new Long(roleId));
        return this.searchCount(role.getCompanyId(), null, status, params);
    }

    public List<User> getSocialUsers(long userId, int type, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("socialRelationType", new Long[]{userId, new Long(type)});
        return this.search(user.getCompanyId(), null, 0, params, start, end, obc);
    }

    public List<User> getSocialUsers(long userId, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("socialRelation", new Long[]{userId});
        return this.search(user.getCompanyId(), null, 0, params, start, end, obc);
    }

    public List<User> getSocialUsers(long userId1, long userId2, int type, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        User user1 = this.userPersistence.findByPrimaryKey(userId1);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("socialMutualRelationType", new Long[]{userId1, new Long(type), userId2, new Long(type)});
        return this.search(user1.getCompanyId(), null, 0, params, start, end, obc);
    }

    public List<User> getSocialUsers(long userId1, long userId2, int start, int end, OrderByComparator obc) throws PortalException, SystemException {
        User user1 = this.userPersistence.findByPrimaryKey(userId1);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("socialMutualRelation", new Long[]{userId1, userId2});
        return this.search(user1.getCompanyId(), null, 0, params, start, end, obc);
    }

    public int getSocialUsersCount(long userId) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("socialRelation", new Long[]{userId});
        return this.searchCount(user.getCompanyId(), null, 0, params);
    }

    public int getSocialUsersCount(long userId, int type) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("socialRelationType", new Long[]{userId, new Long(type)});
        return this.searchCount(user.getCompanyId(), null, 0, params);
    }

    public int getSocialUsersCount(long userId1, long userId2) throws PortalException, SystemException {
        User user1 = this.userPersistence.findByPrimaryKey(userId1);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("socialMutualRelation", new Long[]{userId1, userId2});
        return this.searchCount(user1.getCompanyId(), null, 0, params);
    }

    public int getSocialUsersCount(long userId1, long userId2, int type) throws PortalException, SystemException {
        User user1 = this.userPersistence.findByPrimaryKey(userId1);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("socialMutualRelationType", new Long[]{userId1, new Long(type), userId2, new Long(type)});
        return this.searchCount(user1.getCompanyId(), null, 0, params);
    }

    public User getUserByContactId(long contactId) throws PortalException, SystemException {
        return this.userPersistence.findByContactId(contactId);
    }

    public User getUserByEmailAddress(long companyId, String emailAddress) throws PortalException, SystemException {
        emailAddress = this.getLogin(emailAddress);
        return this.userPersistence.findByC_EA(companyId, emailAddress);
    }

    public User getUserByFacebookId(long companyId, long facebookId) throws PortalException, SystemException {
        return this.userPersistence.findByC_FID(companyId, facebookId);
    }

    public User getUserById(long userId) throws PortalException, SystemException {
        return this.userPersistence.findByPrimaryKey(userId);
    }

    public User getUserById(long companyId, long userId) throws PortalException, SystemException {
        return this.userPersistence.findByC_U(companyId, userId);
    }

    public User getUserByOpenId(long companyId, String openId) throws PortalException, SystemException {
        return this.userPersistence.findByC_O(companyId, openId);
    }

    public User getUserByPortraitId(long portraitId) throws PortalException, SystemException {
        return this.userPersistence.findByPortraitId(portraitId);
    }

    public User getUserByScreenName(long companyId, String screenName) throws PortalException, SystemException {
        screenName = this.getLogin(screenName);
        return this.userPersistence.findByC_SN(companyId, screenName);
    }

    public User getUserByUuid(String uuid) throws PortalException, SystemException {
        List users = this.userPersistence.findByUuid(uuid);
        if (users.isEmpty()) {
            throw new NoSuchUserException();
        }
        return (User)users.get(0);
    }

    @Override
    public User getUserByUuidAndCompanyId(String uuid, long companyId) throws PortalException, SystemException {
        List users = this.userPersistence.findByUuid_C(uuid, companyId);
        if (users.isEmpty()) {
            throw new NoSuchUserException();
        }
        return (User)users.get(0);
    }

    public int getUserGroupUsersCount(long userGroupId, int status) throws PortalException, SystemException {
        UserGroup userGroup = this.userGroupPersistence.findByPrimaryKey(userGroupId);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("usersUserGroups", new Long(userGroupId));
        return this.searchCount(userGroup.getCompanyId(), null, status, params);
    }

    public long getUserIdByEmailAddress(long companyId, String emailAddress) throws PortalException, SystemException {
        emailAddress = StringUtil.toLowerCase((String)emailAddress.trim());
        User user = this.userPersistence.findByC_EA(companyId, emailAddress);
        return user.getUserId();
    }

    public long getUserIdByScreenName(long companyId, String screenName) throws PortalException, SystemException {
        screenName = this.getLogin(screenName);
        User user = this.userPersistence.findByC_SN(companyId, screenName);
        return user.getUserId();
    }

    public boolean hasPasswordPolicyUser(long passwordPolicyId, long userId) throws SystemException {
        return this.passwordPolicyRelLocalService.hasPasswordPolicyRel(passwordPolicyId, User.class.getName(), userId);
    }

    public boolean hasRoleUser(long companyId, String name, long userId, boolean inherited) throws PortalException, SystemException {
        return this.roleLocalService.hasUserRole(userId, companyId, name, inherited);
    }

    public boolean isPasswordExpired(User user) throws PortalException, SystemException {
        PasswordPolicy passwordPolicy = user.getPasswordPolicy();
        if (passwordPolicy != null && passwordPolicy.getExpireable()) {
            Date now = new Date();
            if (user.getPasswordModifiedDate() == null) {
                user.setPasswordModifiedDate(now);
                this.userLocalService.updateUser(user);
            }
            long passwordStartTime = user.getPasswordModifiedDate().getTime();
            long elapsedTime = now.getTime() - passwordStartTime;
            return elapsedTime > passwordPolicy.getMaxAge() * 1000L;
        }
        return false;
    }

    public boolean isPasswordExpiringSoon(User user) throws PortalException, SystemException {
        PasswordPolicy passwordPolicy = user.getPasswordPolicy();
        if (passwordPolicy != null && passwordPolicy.isExpireable() && passwordPolicy.getWarningTime() > 0L) {
            Date now = new Date();
            if (user.getPasswordModifiedDate() == null) {
                user.setPasswordModifiedDate(now);
                this.userLocalService.updateUser(user);
            }
            long timeModified = user.getPasswordModifiedDate().getTime();
            long passwordExpiresOn = passwordPolicy.getMaxAge() * 1000L + timeModified;
            long timeStartWarning = passwordExpiresOn - passwordPolicy.getWarningTime() * 1000L;
            return now.getTime() > timeStartWarning;
        }
        return false;
    }

    public User loadGetDefaultUser(long companyId) throws PortalException, SystemException {
        return this.userPersistence.findByC_DU(companyId, true);
    }

    public List<User> search(long companyId, String keywords, int status, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator obc) throws SystemException {
        return this.userFinder.findByKeywords(companyId, keywords, status, params, start, end, obc);
    }

    public Hits search(long companyId, String keywords, int status, LinkedHashMap<String, Object> params, int start, int end, Sort sort) throws SystemException {
        String firstName = null;
        String middleName = null;
        String lastName = null;
        String fullName = null;
        String screenName = null;
        String emailAddress = null;
        String street = null;
        String city = null;
        String zip = null;
        String region = null;
        String country = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            firstName = keywords;
            middleName = keywords;
            lastName = keywords;
            fullName = keywords;
            screenName = keywords;
            emailAddress = keywords;
            street = keywords;
            city = keywords;
            zip = keywords;
            region = keywords;
            country = keywords;
        } else {
            andOperator = true;
        }
        if (params != null) {
            params.put("keywords", keywords);
        }
        return this.search(companyId, firstName, middleName, lastName, fullName, screenName, emailAddress, street, city, zip, region, country, status, params, andOperator, start, end, sort);
    }

    public List<User> search(long companyId, String firstName, String middleName, String lastName, String screenName, String emailAddress, int status, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, OrderByComparator obc) throws SystemException {
        return this.userFinder.findByC_FN_MN_LN_SN_EA_S(companyId, firstName, middleName, lastName, screenName, emailAddress, status, params, andSearch, start, end, obc);
    }

    public Hits search(long companyId, String firstName, String middleName, String lastName, String screenName, String emailAddress, int status, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort sort) throws SystemException {
        return this.search(companyId, firstName, middleName, lastName, null, screenName, emailAddress, null, null, null, null, null, status, params, andSearch, start, end, sort);
    }

    public int searchCount(long companyId, String keywords, int status, LinkedHashMap<String, Object> params) throws SystemException {
        return this.userFinder.countByKeywords(companyId, keywords, status, params);
    }

    public int searchCount(long companyId, String firstName, String middleName, String lastName, String screenName, String emailAddress, int status, LinkedHashMap<String, Object> params, boolean andSearch) throws SystemException {
        return this.userFinder.countByC_FN_MN_LN_SN_EA_S(companyId, firstName, middleName, lastName, screenName, emailAddress, status, params, andSearch);
    }

    public void sendEmailAddressVerification(User user, String emailAddress, ServiceContext serviceContext) throws PortalException, SystemException {
        if (user.isEmailAddressVerified() && StringUtil.equalsIgnoreCase((String)emailAddress, (String)user.getEmailAddress())) {
            return;
        }
        Ticket ticket = this.ticketLocalService.addTicket(user.getCompanyId(), User.class.getName(), user.getUserId(), 1, emailAddress, null, serviceContext);
        String verifyEmailAddressURL = String.valueOf(serviceContext.getPortalURL()) + serviceContext.getPathMain() + "/portal/verify_email_address?ticketKey=" + ticket.getKey();
        Layout layout = this.layoutLocalService.getLayout(serviceContext.getPlid());
        Group group = layout.getGroup();
        if (!layout.isPrivateLayout() && !group.isUser()) {
            verifyEmailAddressURL = String.valueOf(verifyEmailAddressURL) + "&p_l_id=" + serviceContext.getPlid();
        }
        String fromName = PrefsPropsUtil.getString(user.getCompanyId(), "admin.email.from.name");
        String fromAddress = PrefsPropsUtil.getString(user.getCompanyId(), "admin.email.from.address");
        String toName = user.getFullName();
        String toAddress = emailAddress;
        String subject = PrefsPropsUtil.getContent(user.getCompanyId(), "admin.email.verification.subject");
        String body = PrefsPropsUtil.getContent(user.getCompanyId(), "admin.email.verification.body");
        SubscriptionSender subscriptionSender = new SubscriptionSender();
        subscriptionSender.setBody(body);
        subscriptionSender.setCompanyId(user.getCompanyId());
        subscriptionSender.setContextAttributes(new Object[]{"[$EMAIL_VERIFICATION_CODE$]", ticket.getKey(), "[$EMAIL_VERIFICATION_URL$]", verifyEmailAddressURL, "[$REMOTE_ADDRESS$]", serviceContext.getRemoteAddr(), "[$REMOTE_HOST$]", serviceContext.getRemoteHost(), "[$USER_ID$]", user.getUserId(), "[$USER_SCREENNAME$]", user.getScreenName()});
        subscriptionSender.setFrom(fromAddress, fromName);
        subscriptionSender.setHtmlFormat(true);
        subscriptionSender.setMailId("user", new Object[]{user.getUserId(), System.currentTimeMillis(), PwdGenerator.getPassword()});
        subscriptionSender.setServiceContext(serviceContext);
        subscriptionSender.setSubject(subject);
        subscriptionSender.setUserId(user.getUserId());
        subscriptionSender.addRuntimeSubscribers(toAddress, toName);
        subscriptionSender.flushNotificationsAsync();
    }

    public void sendPassword(long companyId, String emailAddress, String fromName, String fromAddress, String subject, String body, ServiceContext serviceContext) throws PortalException, SystemException {
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        if (!company.isSendPassword() && !company.isSendPasswordResetLink()) {
            return;
        }
        if (Validator.isNull((String)(emailAddress = StringUtil.toLowerCase((String)emailAddress.trim())))) {
            throw new UserEmailAddressException();
        }
        User user = this.userPersistence.findByC_EA(companyId, emailAddress);
        PasswordPolicy passwordPolicy = user.getPasswordPolicy();
        String newPassword = "";
        String passwordResetURL = "";
        if (company.isSendPasswordResetLink()) {
            Date expirationDate = null;
            if (passwordPolicy != null && passwordPolicy.getResetTicketMaxAge() > 0L) {
                expirationDate = new Date(System.currentTimeMillis() + passwordPolicy.getResetTicketMaxAge() * 1000L);
            }
            Ticket ticket = this.ticketLocalService.addTicket(companyId, User.class.getName(), user.getUserId(), 3, null, expirationDate, serviceContext);
            passwordResetURL = String.valueOf(serviceContext.getPortalURL()) + serviceContext.getPathMain() + "/portal/update_password?p_l_id=" + serviceContext.getPlid() + "&ticketKey=" + ticket.getKey();
        } else if (!PasswordEncryptorUtil.PASSWORDS_ENCRYPTION_ALGORITHM.equals("NONE")) {
            if (LDAPSettingsUtil.isPasswordPolicyEnabled(user.getCompanyId())) {
                if (_log.isWarnEnabled()) {
                    StringBundler sb = new StringBundler(5);
                    sb.append("When LDAP password policy is enabled, ");
                    sb.append("it is possible that portal generated ");
                    sb.append("passwords will not match the LDAP policy.");
                    sb.append("Using RegExpToolkit to generate new ");
                    sb.append("password.");
                    _log.warn((Object)sb.toString());
                }
                RegExpToolkit regExpToolkit = new RegExpToolkit();
                newPassword = regExpToolkit.generate(null);
            } else {
                newPassword = PwdToolkitUtil.generate(passwordPolicy);
            }
            boolean passwordReset = false;
            if (passwordPolicy.getChangeable() && passwordPolicy.getChangeRequired()) {
                passwordReset = true;
            }
            user.setPassword(PasswordEncryptorUtil.encrypt(newPassword));
            user.setPasswordUnencrypted(newPassword);
            user.setPasswordEncrypted(true);
            user.setPasswordReset(passwordReset);
            user.setPasswordModified(true);
            user.setPasswordModifiedDate(new Date());
            this.userPersistence.update((BaseModel)user);
            user.setPasswordModified(false);
        } else {
            newPassword = user.getPassword();
        }
        if (Validator.isNull((String)fromName)) {
            fromName = PrefsPropsUtil.getString(companyId, "admin.email.from.name");
        }
        if (Validator.isNull((String)fromAddress)) {
            fromAddress = PrefsPropsUtil.getString(companyId, "admin.email.from.address");
        }
        String toName = user.getFullName();
        String toAddress = user.getEmailAddress();
        if (Validator.isNull((String)subject)) {
            subject = company.isSendPasswordResetLink() ? PrefsPropsUtil.getContent(companyId, "admin.email.password.reset.subject") : PrefsPropsUtil.getContent(companyId, "admin.email.password.sent.subject");
        }
        if (Validator.isNull((String)body)) {
            body = company.isSendPasswordResetLink() ? PrefsPropsUtil.getContent(companyId, "admin.email.password.reset.body") : PrefsPropsUtil.getContent(companyId, "admin.email.password.sent.body");
        }
        SubscriptionSender subscriptionSender = new SubscriptionSender();
        subscriptionSender.setBody(body);
        subscriptionSender.setCompanyId(companyId);
        subscriptionSender.setContextAttributes(new Object[]{"[$PASSWORD_RESET_URL$]", passwordResetURL, "[$REMOTE_ADDRESS$]", serviceContext.getRemoteAddr(), "[$REMOTE_HOST$]", serviceContext.getRemoteHost(), "[$USER_ID$]", user.getUserId(), "[$USER_PASSWORD$]", newPassword, "[$USER_SCREENNAME$]", user.getScreenName()});
        subscriptionSender.setFrom(fromAddress, fromName);
        subscriptionSender.setHtmlFormat(true);
        subscriptionSender.setMailId("user", new Object[]{user.getUserId(), System.currentTimeMillis(), PwdGenerator.getPassword()});
        subscriptionSender.setServiceContext(serviceContext);
        subscriptionSender.setSubject(subject);
        subscriptionSender.setUserId(user.getUserId());
        subscriptionSender.addRuntimeSubscribers(toAddress, toName);
        subscriptionSender.flushNotificationsAsync();
    }

    @Override
    public void setRoleUsers(long roleId, long[] userIds) throws PortalException, SystemException {
        this.rolePersistence.setUsers(roleId, userIds);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
        indexer.reindex((Object)userIds);
        PermissionCacheUtil.clearCache();
    }

    @Override
    public void setUserGroupUsers(long userGroupId, long[] userIds) throws PortalException, SystemException {
        if (PropsValues.USER_GROUPS_COPY_LAYOUTS_TO_USER_PERSONAL_SITE) {
            this.userGroupLocalService.copyUserGroupLayouts(userGroupId, userIds);
        }
        this.userGroupPersistence.setUsers(userGroupId, userIds);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
        indexer.reindex((Object)userIds);
        PermissionCacheUtil.clearCache();
    }

    public void unsetGroupTeamsUsers(long groupId, long[] userIds) throws PortalException, SystemException {
        List teams = this.teamPersistence.findByGroupId(groupId);
        for (Team team : teams) {
            this.unsetTeamUsers(team.getTeamId(), userIds);
        }
        PermissionCacheUtil.clearCache();
    }

    public void unsetGroupUsers(long groupId, long[] userIds, ServiceContext serviceContext) throws PortalException, SystemException {
        this.userGroupRoleLocalService.deleteUserGroupRoles(userIds, groupId, 2);
        this.userLocalService.unsetGroupTeamsUsers(groupId, userIds);
        this.groupPersistence.removeUsers(groupId, userIds);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
        indexer.reindex((Object)userIds);
        PermissionCacheUtil.clearCache();
    }

    public void unsetOrganizationUsers(long organizationId, long[] userIds) throws PortalException, SystemException {
        Organization organization = this.organizationPersistence.findByPrimaryKey(organizationId);
        Group group = organization.getGroup();
        this.userGroupRoleLocalService.deleteUserGroupRoles(userIds, group.getGroupId(), 3);
        this.organizationPersistence.removeUsers(organizationId, userIds);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
        indexer.reindex((Object)userIds);
        PermissionCacheUtil.clearCache();
    }

    public void unsetPasswordPolicyUsers(long passwordPolicyId, long[] userIds) throws SystemException {
        this.passwordPolicyRelLocalService.deletePasswordPolicyRels(passwordPolicyId, User.class.getName(), userIds);
    }

    public void unsetRoleUsers(long roleId, List<User> users) throws PortalException, SystemException {
        Role role = this.rolePersistence.findByPrimaryKey(roleId);
        String roleName = role.getName();
        if (roleName.equals("Administrator") && this.getRoleUsersCount(role.getRoleId()) <= 1 || roleName.equals("User")) {
            return;
        }
        this.rolePersistence.removeUsers(roleId, users);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
        indexer.reindex(users);
        PermissionCacheUtil.clearCache();
    }

    public void unsetRoleUsers(long roleId, long[] userIds) throws PortalException, SystemException {
        Role role = this.rolePersistence.findByPrimaryKey(roleId);
        String roleName = role.getName();
        if (roleName.equals("User") || roleName.equals("Administrator") && this.getRoleUsersCount(role.getRoleId()) <= 1) {
            return;
        }
        this.rolePersistence.removeUsers(roleId, userIds);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
        indexer.reindex((Object)userIds);
        PermissionCacheUtil.clearCache();
    }

    public void unsetTeamUsers(long teamId, long[] userIds) throws PortalException, SystemException {
        this.teamPersistence.removeUsers(teamId, userIds);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
        indexer.reindex((Object)userIds);
        PermissionCacheUtil.clearCache();
    }

    public void unsetUserGroupUsers(long userGroupId, long[] userIds) throws PortalException, SystemException {
        this.userGroupPersistence.removeUsers(userGroupId, userIds);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
        indexer.reindex((Object)userIds);
        PermissionCacheUtil.clearCache();
    }

    public User updateAgreedToTermsOfUse(long userId, boolean agreedToTermsOfUse) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        user.setAgreedToTermsOfUse(agreedToTermsOfUse);
        this.userPersistence.update((BaseModel)user);
        return user;
    }

    public void updateAsset(long userId, User user, long[] assetCategoryIds, String[] assetTagNames) throws PortalException, SystemException {
        User owner = this.userPersistence.findByPrimaryKey(userId);
        Company company = this.companyPersistence.findByPrimaryKey(owner.getCompanyId());
        Group companyGroup = company.getGroup();
        this.assetEntryLocalService.updateEntry(userId, companyGroup.getGroupId(), user.getCreateDate(), user.getModifiedDate(), User.class.getName(), user.getUserId(), user.getUuid(), 0L, assetCategoryIds, assetTagNames, false, null, null, null, null, user.getFullName(), null, null, null, null, 0, 0, null, false);
    }

    public User updateCreateDate(long userId, Date createDate) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        user.setCreateDate(createDate);
        this.userPersistence.update((BaseModel)user);
        return user;
    }

    public User updateEmailAddress(long userId, String password, String emailAddress1, String emailAddress2) throws PortalException, SystemException {
        emailAddress1 = StringUtil.toLowerCase((String)emailAddress1.trim());
        emailAddress2 = StringUtil.toLowerCase((String)emailAddress2.trim());
        User user = this.userPersistence.findByPrimaryKey(userId);
        this.validateEmailAddress(user, emailAddress1, emailAddress2);
        this.setEmailAddress(user, password, user.getFirstName(), user.getMiddleName(), user.getLastName(), emailAddress1);
        this.userPersistence.update((BaseModel)user);
        Contact contact = user.getContact();
        contact.setEmailAddress(user.getEmailAddress());
        this.contactPersistence.update((BaseModel)contact);
        return user;
    }

    public User updateEmailAddress(long userId, String password, String emailAddress1, String emailAddress2, ServiceContext serviceContext) throws PortalException, SystemException {
        emailAddress1 = StringUtil.toLowerCase((String)emailAddress1.trim());
        emailAddress2 = StringUtil.toLowerCase((String)emailAddress2.trim());
        User user = this.userPersistence.findByPrimaryKey(userId);
        this.validateEmailAddress(user, emailAddress1, emailAddress2);
        Company company = this.companyPersistence.findByPrimaryKey(user.getCompanyId());
        if (!company.isStrangersVerify()) {
            this.setEmailAddress(user, password, user.getFirstName(), user.getMiddleName(), user.getLastName(), emailAddress1);
            this.userPersistence.update((BaseModel)user);
            Contact contact = user.getContact();
            contact.setEmailAddress(user.getEmailAddress());
            this.contactPersistence.update((BaseModel)contact);
        } else {
            this.sendEmailAddressVerification(user, emailAddress1, serviceContext);
        }
        return user;
    }

    public User updateEmailAddressVerified(long userId, boolean emailAddressVerified) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        user.setEmailAddressVerified(emailAddressVerified);
        this.userPersistence.update((BaseModel)user);
        return user;
    }

    public User updateFacebookId(long userId, long facebookId) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        user.setFacebookId(facebookId);
        this.userPersistence.update((BaseModel)user);
        return user;
    }

    public void updateGroups(long userId, long[] newGroupIds, ServiceContext serviceContext) throws PortalException, SystemException {
        this.updateGroups(userId, newGroupIds, serviceContext, serviceContext.isIndexingEnabled());
    }

    public User updateIncompleteUser(long creatorUserId, long companyId, boolean autoPassword, String password1, String password2, boolean autoScreenName, String screenName, String emailAddress, long facebookId, String openId, Locale locale, String firstName, String middleName, String lastName, int prefixId, int suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String jobTitle, boolean updateUserInformation, boolean sendEmail, ServiceContext serviceContext) throws PortalException, SystemException {
        ServiceContext workflowServiceContext;
        User user = this.getUserByEmailAddress(companyId, emailAddress);
        if (user.getStatus() != 6) {
            throw new PortalException("Invalid user status");
        }
        User defaultUser = this.getDefaultUser(companyId);
        if (facebookId > 0L) {
            autoPassword = false;
            if (password1 == null || password2 == null) {
                password2 = password1 = PwdGenerator.getPassword();
            }
            sendEmail = false;
        }
        if (updateUserInformation) {
            autoScreenName = false;
            if (PrefsPropsUtil.getBoolean(companyId, "users.screen.name.always.autogenerate")) {
                autoScreenName = true;
            }
            this.validate(companyId, user.getUserId(), autoPassword, password1, password2, autoScreenName, screenName, emailAddress, openId, firstName, middleName, lastName, null);
            if (!autoPassword && (Validator.isNull((String)password1) || Validator.isNull((String)password2))) {
                throw new UserPasswordException(3);
            }
            if (autoScreenName) {
                ScreenNameGenerator screenNameGenerator = ScreenNameGeneratorFactory.getInstance();
                try {
                    screenName = screenNameGenerator.generate(companyId, user.getUserId(), emailAddress);
                }
                catch (Exception e2) {
                    throw new SystemException((Throwable)e2);
                }
            }
            FullNameGenerator fullNameGenerator = FullNameGeneratorFactory.getInstance();
            String fullName = fullNameGenerator.getFullName(firstName, middleName, lastName);
            String greeting = LanguageUtil.format((Locale)locale, (String)"welcome-x", (Object)(" " + fullName), (boolean)false);
            if (Validator.isNotNull((String)password1)) {
                user.setPassword(PasswordEncryptorUtil.encrypt(password1));
                user.setPasswordUnencrypted(password1);
            }
            user.setPasswordEncrypted(true);
            PasswordPolicy passwordPolicy = defaultUser.getPasswordPolicy();
            if (passwordPolicy != null && passwordPolicy.isChangeable() && passwordPolicy.isChangeRequired()) {
                user.setPasswordReset(true);
            } else {
                user.setPasswordReset(false);
            }
            user.setScreenName(screenName);
            user.setFacebookId(facebookId);
            user.setOpenId(openId);
            user.setLanguageId(locale.toString());
            user.setTimeZoneId(defaultUser.getTimeZoneId());
            user.setGreeting(greeting);
            user.setFirstName(firstName);
            user.setMiddleName(middleName);
            user.setLastName(lastName);
            user.setJobTitle(jobTitle);
            user.setExpandoBridgeAttributes(serviceContext);
            Date birthday = this.getBirthday(birthdayMonth, birthdayDay, birthdayYear);
            Contact contact = user.getContact();
            contact.setFirstName(firstName);
            contact.setMiddleName(middleName);
            contact.setLastName(lastName);
            contact.setPrefixId(prefixId);
            contact.setSuffixId(suffixId);
            contact.setMale(male);
            contact.setBirthday(birthday);
            contact.setJobTitle(jobTitle);
            this.contactPersistence.update((BaseModel)contact, serviceContext);
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
            indexer.reindex((Object)user);
        }
        user.setStatus(2);
        this.userPersistence.update((BaseModel)user, serviceContext);
        long workflowUserId = creatorUserId;
        if (workflowUserId == user.getUserId()) {
            workflowUserId = defaultUser.getUserId();
        }
        if ((workflowServiceContext = serviceContext) == null) {
            workflowServiceContext = new ServiceContext();
        }
        workflowServiceContext.setAttribute("autoPassword", (Serializable)Boolean.valueOf(autoPassword));
        workflowServiceContext.setAttribute("sendEmail", (Serializable)Boolean.valueOf(sendEmail));
        WorkflowHandlerRegistryUtil.startWorkflowInstance((long)companyId, (long)workflowUserId, (String)User.class.getName(), (long)user.getUserId(), (Object)user, (ServiceContext)workflowServiceContext);
        return this.getUserByEmailAddress(companyId, emailAddress);
    }

    public User updateJobTitle(long userId, String jobTitle) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        user.setJobTitle(jobTitle);
        this.userPersistence.update((BaseModel)user);
        Contact contact = this.contactPersistence.findByPrimaryKey(user.getContactId());
        contact.setJobTitle(jobTitle);
        this.contactPersistence.update((BaseModel)contact);
        return user;
    }

    public User updateLastLogin(long userId, String loginIP) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date lastLoginDate = user.getLoginDate();
        if (lastLoginDate == null) {
            lastLoginDate = new Date();
        }
        user.setLoginDate(new Date());
        user.setLoginIP(loginIP);
        user.setLastLoginDate(lastLoginDate);
        user.setLastLoginIP(user.getLoginIP());
        user.setLastFailedLoginDate(null);
        user.setFailedLoginAttempts(0);
        this.userPersistence.update((BaseModel)user);
        return user;
    }

    public User updateLockout(User user, boolean lockout) throws PortalException, SystemException {
        PasswordPolicy passwordPolicy = user.getPasswordPolicy();
        if (passwordPolicy == null || !passwordPolicy.isLockout()) {
            return user;
        }
        Date lockoutDate = null;
        if (lockout) {
            lockoutDate = new Date();
        }
        user.setLockout(lockout);
        user.setLockoutDate(lockoutDate);
        if (!lockout) {
            user.setLastFailedLoginDate(lockoutDate);
            user.setFailedLoginAttempts(0);
        }
        this.userPersistence.update((BaseModel)user);
        return user;
    }

    public User updateLockoutByEmailAddress(long companyId, String emailAddress, boolean lockout) throws PortalException, SystemException {
        User user = this.getUserByEmailAddress(companyId, emailAddress);
        return this.updateLockout(user, lockout);
    }

    public User updateLockoutById(long userId, boolean lockout) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        return this.updateLockout(user, lockout);
    }

    public User updateLockoutByScreenName(long companyId, String screenName, boolean lockout) throws PortalException, SystemException {
        User user = this.getUserByScreenName(companyId, screenName);
        return this.updateLockout(user, lockout);
    }

    public User updateModifiedDate(long userId, Date modifiedDate) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        user.setModifiedDate(modifiedDate);
        this.userPersistence.update((BaseModel)user);
        return user;
    }

    public User updateOpenId(long userId, String openId) throws PortalException, SystemException {
        openId = openId.trim();
        User user = this.userPersistence.findByPrimaryKey(userId);
        user.setOpenId(openId);
        this.userPersistence.update((BaseModel)user);
        return user;
    }

    public void updateOrganizations(long userId, long[] newOrganizationIds, ServiceContext serviceContext) throws PortalException, SystemException {
        this.updateOrganizations(userId, newOrganizationIds, serviceContext.isIndexingEnabled());
    }

    public User updatePassword(long userId, String password1, String password2, boolean passwordReset) throws PortalException, SystemException {
        return this.updatePassword(userId, password1, password2, passwordReset, false);
    }

    public User updatePassword(long userId, String password1, String password2, boolean passwordReset, boolean silentUpdate) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        if (!silentUpdate) {
            this.validatePassword(user.getCompanyId(), userId, password1, password2);
        }
        String oldEncPwd = user.getPassword();
        if (!user.isPasswordEncrypted()) {
            oldEncPwd = PasswordEncryptorUtil.encrypt(user.getPassword());
        }
        String newEncPwd = PasswordEncryptorUtil.encrypt(password1);
        if (user.hasCompanyMx()) {
            this.mailService.updatePassword(user.getCompanyId(), userId, password1);
        }
        user.setPassword(newEncPwd);
        user.setPasswordUnencrypted(password1);
        user.setPasswordEncrypted(true);
        user.setPasswordReset(passwordReset);
        user.setPasswordModifiedDate(new Date());
        user.setDigest("");
        user.setGraceLoginCount(0);
        if (!silentUpdate) {
            user.setPasswordModified(true);
        }
        try {
            this.userPersistence.update((BaseModel)user);
        }
        catch (ModelListenerException mle) {
            String passwordHistory;
            String msg = GetterUtil.getString((String)mle.getCause().getMessage());
            if (LDAPSettingsUtil.isPasswordPolicyEnabled(user.getCompanyId()) && msg.contains(passwordHistory = PrefsPropsUtil.getString(user.getCompanyId(), "ldap.error.password.history"))) {
                throw new UserPasswordException(1);
            }
            throw new UserPasswordException(3);
        }
        if (!silentUpdate) {
            user.setPasswordModified(false);
            this.passwordTrackerLocalService.trackPassword(userId, oldEncPwd);
        }
        return user;
    }

    public User updatePasswordManually(long userId, String password, boolean passwordEncrypted, boolean passwordReset, Date passwordModifiedDate) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        user.setPassword(password);
        user.setPasswordEncrypted(passwordEncrypted);
        user.setPasswordReset(passwordReset);
        user.setPasswordModifiedDate(passwordModifiedDate);
        user.setDigest("");
        this.userPersistence.update((BaseModel)user);
        return user;
    }

    public User updatePasswordReset(long userId, boolean passwordReset) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        user.setPasswordReset(passwordReset);
        this.userPersistence.update((BaseModel)user);
        return user;
    }

    public User updatePortrait(long userId, byte[] bytes) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long imageMaxSize = PrefsPropsUtil.getLong("users.image.max.size");
        if (imageMaxSize > 0L && (bytes == null || (long)bytes.length > imageMaxSize)) {
            throw new UserPortraitSizeException();
        }
        long portraitId = user.getPortraitId();
        if (portraitId <= 0L) {
            portraitId = this.counterLocalService.increment();
            user.setPortraitId(portraitId);
        }
        try {
            ImageBag imageBag = ImageToolUtil.read((byte[])bytes);
            RenderedImage renderedImage = imageBag.getRenderedImage();
            if (renderedImage == null) {
                throw new UserPortraitTypeException();
            }
            renderedImage = ImageToolUtil.scale((RenderedImage)renderedImage, (int)PropsValues.USERS_IMAGE_MAX_HEIGHT, (int)PropsValues.USERS_IMAGE_MAX_WIDTH);
            String contentType = imageBag.getType();
            this.imageLocalService.updateImage(portraitId, ImageToolUtil.getBytes((RenderedImage)renderedImage, (String)contentType));
        }
        catch (IOException ioe) {
            throw new ImageSizeException((Throwable)ioe);
        }
        this.userPersistence.update((BaseModel)user);
        return user;
    }

    public User updateReminderQuery(long userId, String question, String answer) throws PortalException, SystemException {
        this.validateReminderQuery(question, answer);
        User user = this.userPersistence.findByPrimaryKey(userId);
        user.setReminderQueryQuestion(question);
        user.setReminderQueryAnswer(answer);
        this.userPersistence.update((BaseModel)user);
        return user;
    }

    public User updateScreenName(long userId, String screenName) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        screenName = this.getLogin(screenName);
        this.validateScreenName(user.getCompanyId(), userId, screenName);
        if (!StringUtil.equalsIgnoreCase((String)user.getScreenName(), (String)screenName)) {
            user.setDigest("");
        }
        user.setScreenName(screenName);
        this.userPersistence.update((BaseModel)user);
        Group group = this.groupLocalService.getUserGroup(user.getCompanyId(), userId);
        group.setFriendlyURL("/" + screenName);
        this.groupPersistence.update((BaseModel)group);
        return user;
    }

    public User updateStatus(long userId, int status) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        if (status == 0 && user.getStatus() != 0) {
            this.validateCompanyMaxUsers(user.getCompanyId());
        }
        user.setStatus(status);
        this.userPersistence.update((BaseModel)user);
        this.reindex(user);
        return user;
    }

    public User updateUser(long userId, String oldPassword, String newPassword1, String newPassword2, boolean passwordReset, String reminderQueryQuestion, String reminderQueryAnswer, String screenName, String emailAddress, long facebookId, String openId, String languageId, String timeZoneId, String greeting, String comments, String firstName, String middleName, String lastName, int prefixId, int suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String smsSn, String aimSn, String facebookSn, String icqSn, String jabberSn, String msnSn, String mySpaceSn, String skypeSn, String twitterSn, String ymSn, String jobTitle, long[] groupIds, long[] organizationIds, long[] roleIds, List<UserGroupRole> userGroupRoles, long[] userGroupIds, ServiceContext serviceContext) throws PortalException, SystemException {
        String uuid;
        User user = this.userPersistence.findByPrimaryKey(userId);
        Company company = this.companyPersistence.findByPrimaryKey(user.getCompanyId());
        String password = oldPassword;
        screenName = this.getLogin(screenName);
        emailAddress = StringUtil.toLowerCase((String)emailAddress.trim());
        openId = openId.trim();
        String oldFullName = user.getFullName();
        aimSn = StringUtil.toLowerCase((String)aimSn.trim());
        facebookSn = StringUtil.toLowerCase((String)facebookSn.trim());
        icqSn = StringUtil.toLowerCase((String)icqSn.trim());
        jabberSn = StringUtil.toLowerCase((String)jabberSn.trim());
        msnSn = StringUtil.toLowerCase((String)msnSn.trim());
        mySpaceSn = StringUtil.toLowerCase((String)mySpaceSn.trim());
        skypeSn = StringUtil.toLowerCase((String)skypeSn.trim());
        twitterSn = StringUtil.toLowerCase((String)twitterSn.trim());
        ymSn = StringUtil.toLowerCase((String)ymSn.trim());
        Date now = new Date();
        EmailAddressGenerator emailAddressGenerator = EmailAddressGeneratorFactory.getInstance();
        if (emailAddressGenerator.isGenerated(emailAddress)) {
            emailAddress = "";
        }
        if (!PropsValues.USERS_EMAIL_ADDRESS_REQUIRED && Validator.isNull((String)emailAddress)) {
            emailAddress = emailAddressGenerator.generate(user.getCompanyId(), userId);
        }
        this.validate(userId, screenName, emailAddress, openId, firstName, middleName, lastName, smsSn);
        if (Validator.isNotNull((String)newPassword1) || Validator.isNotNull((String)newPassword2)) {
            user = this.updatePassword(userId, newPassword1, newPassword2, passwordReset);
            password = newPassword1;
            user.setDigest("");
        }
        user.setModifiedDate(now);
        if (user.getContactId() <= 0L) {
            user.setContactId(this.counterLocalService.increment());
        }
        user.setPasswordReset(passwordReset);
        if (Validator.isNotNull((String)reminderQueryQuestion) && Validator.isNotNull((String)reminderQueryAnswer)) {
            user.setReminderQueryQuestion(reminderQueryQuestion);
            user.setReminderQueryAnswer(reminderQueryAnswer);
        }
        if (!StringUtil.equalsIgnoreCase((String)user.getScreenName(), (String)screenName)) {
            user.setScreenName(screenName);
            user.setDigest("");
        }
        boolean sendEmailAddressVerification = false;
        if (!company.isStrangersVerify()) {
            this.setEmailAddress(user, password, firstName, middleName, lastName, emailAddress);
        } else {
            sendEmailAddressVerification = true;
        }
        if (serviceContext != null && Validator.isNotNull((String)(uuid = serviceContext.getUuid()))) {
            user.setUuid(uuid);
        }
        user.setFacebookId(facebookId);
        Long ldapServerId = (Long)serviceContext.getAttribute("ldapServerId");
        if (ldapServerId != null) {
            user.setLdapServerId(ldapServerId.longValue());
        }
        user.setOpenId(openId);
        user.setLanguageId(languageId);
        user.setTimeZoneId(timeZoneId);
        user.setGreeting(greeting);
        user.setComments(comments);
        user.setFirstName(firstName);
        user.setMiddleName(middleName);
        user.setLastName(lastName);
        user.setJobTitle(jobTitle);
        user.setExpandoBridgeAttributes(serviceContext);
        this.userPersistence.update((BaseModel)user, serviceContext);
        Date birthday = this.getBirthday(birthdayMonth, birthdayDay, birthdayYear);
        long contactId = user.getContactId();
        Contact contact = this.contactPersistence.fetchByPrimaryKey(contactId);
        if (contact == null) {
            contact = this.contactPersistence.create(contactId);
            contact.setCompanyId(user.getCompanyId());
            contact.setUserName("");
            contact.setCreateDate(now);
            contact.setClassName(User.class.getName());
            contact.setClassPK(user.getUserId());
            contact.setAccountId(company.getAccountId());
            contact.setParentContactId(0L);
        }
        contact.setModifiedDate(now);
        contact.setEmailAddress(user.getEmailAddress());
        contact.setFirstName(firstName);
        contact.setMiddleName(middleName);
        contact.setLastName(lastName);
        contact.setPrefixId(prefixId);
        contact.setSuffixId(suffixId);
        contact.setMale(male);
        contact.setBirthday(birthday);
        contact.setSmsSn(smsSn);
        contact.setAimSn(aimSn);
        contact.setFacebookSn(facebookSn);
        contact.setIcqSn(icqSn);
        contact.setJabberSn(jabberSn);
        contact.setMsnSn(msnSn);
        contact.setMySpaceSn(mySpaceSn);
        contact.setSkypeSn(skypeSn);
        contact.setTwitterSn(twitterSn);
        contact.setYmSn(ymSn);
        contact.setJobTitle(jobTitle);
        this.contactPersistence.update((BaseModel)contact, serviceContext);
        Group group = this.groupLocalService.getUserGroup(user.getCompanyId(), userId);
        group.setFriendlyURL("/" + screenName);
        this.groupPersistence.update((BaseModel)group);
        List previousUserGroupRoles = this.userGroupRolePersistence.findByUserId(userId);
        this.updateGroups(userId, groupIds, serviceContext, false);
        this.updateOrganizations(userId, organizationIds, false);
        if (roleIds != null) {
            roleIds = UsersAdminUtil.addRequiredRoles((User)user, (long[])roleIds);
            this.userPersistence.setRoles(userId, roleIds);
        }
        this.updateUserGroupRoles(user, groupIds, organizationIds, userGroupRoles, previousUserGroupRoles);
        if (userGroupIds != null) {
            if (PropsValues.USER_GROUPS_COPY_LAYOUTS_TO_USER_PERSONAL_SITE) {
                this.userGroupLocalService.copyUserGroupLayouts(userGroupIds, userId);
            }
            this.userPersistence.setUserGroups(userId, userGroupIds);
        }
        this.announcementsDeliveryLocalService.getUserDeliveries(user.getUserId());
        if (serviceContext != null) {
            this.updateAsset(userId, user, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        }
        if (GetterUtil.getBoolean((String)("users.update.user.name." + MBMessage.class.getName())) && !oldFullName.equals(user.getFullName())) {
            this.mbMessageLocalService.updateUserName(userId, user.getFullName());
        }
        if (serviceContext == null || serviceContext.isIndexingEnabled()) {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
            indexer.reindex((Object)user);
        }
        if (serviceContext != null && sendEmailAddressVerification) {
            this.sendEmailAddressVerification(user, emailAddress, serviceContext);
        }
        PermissionCacheUtil.clearCache();
        return user;
    }

    public void verifyEmailAddress(String ticketKey) throws PortalException, SystemException {
        Ticket ticket = this.ticketLocalService.getTicket(ticketKey);
        if (ticket.isExpired() || ticket.getType() != 1) {
            throw new NoSuchTicketException();
        }
        User user = this.userPersistence.findByPrimaryKey(ticket.getClassPK());
        String emailAddress = ticket.getExtraInfo();
        if (!(emailAddress = StringUtil.toLowerCase((String)emailAddress).trim()).equals(user.getEmailAddress())) {
            if (this.userPersistence.fetchByC_EA(user.getCompanyId(), emailAddress) != null) {
                throw new DuplicateUserEmailAddressException();
            }
            this.setEmailAddress(user, "", user.getFirstName(), user.getMiddleName(), user.getLastName(), emailAddress);
            Contact contact = user.getContact();
            contact.setEmailAddress(user.getEmailAddress());
            this.contactPersistence.update((BaseModel)contact);
        }
        user.setEmailAddressVerified(true);
        this.userPersistence.update((BaseModel)user);
        this.ticketLocalService.deleteTicket(ticket);
    }

    protected void addDefaultRolesAndTeams(long groupId, long[] userIds) throws PortalException, SystemException {
        long[] defaultTeamIds;
        long[] defaultSiteRoleIds;
        ArrayList<Role> defaultSiteRoles = new ArrayList<Role>();
        Group group = this.groupLocalService.getGroup(groupId);
        UnicodeProperties typeSettingsProperties = group.getTypeSettingsProperties();
        long[] lArray = defaultSiteRoleIds = StringUtil.split((String)typeSettingsProperties.getProperty("defaultSiteRoleIds"), (long)0L);
        int n = defaultSiteRoleIds.length;
        int n2 = 0;
        while (n2 < n) {
            long defaultSiteRoleId = lArray[n2];
            Role defaultSiteRole = this.rolePersistence.fetchByPrimaryKey(defaultSiteRoleId);
            if (defaultSiteRole == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Unable to find role " + defaultSiteRoleId));
                }
            } else {
                defaultSiteRoles.add(defaultSiteRole);
            }
            ++n2;
        }
        ArrayList<Team> defaultTeams = new ArrayList<Team>();
        long[] lArray2 = defaultTeamIds = StringUtil.split((String)typeSettingsProperties.getProperty("defaultTeamIds"), (long)0L);
        int n3 = defaultTeamIds.length;
        int n4 = 0;
        while (n4 < n3) {
            long defaultTeamId = lArray2[n4];
            Team defaultTeam = this.teamPersistence.findByPrimaryKey(defaultTeamId);
            if (defaultTeam == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Unable to find team " + defaultTeamId));
                }
            } else {
                defaultTeams.add(defaultTeam);
            }
            ++n4;
        }
        lArray2 = userIds;
        n3 = userIds.length;
        n4 = 0;
        while (n4 < n3) {
            long userId = lArray2[n4];
            HashSet<Long> userRoleIdsSet = new HashSet<Long>();
            for (Role role : defaultSiteRoles) {
                if (this.userPersistence.containsRole(userId, role.getRoleId())) continue;
                userRoleIdsSet.add(role.getRoleId());
            }
            long[] userRoleIds = ArrayUtil.toArray((Long[])userRoleIdsSet.toArray(new Long[userRoleIdsSet.size()]));
            this.userGroupRoleLocalService.addUserGroupRoles(userId, groupId, userRoleIds);
            HashSet<Long> userTeamIdsSet = new HashSet<Long>();
            for (Team team : defaultTeams) {
                if (this.userPersistence.containsTeam(userId, team.getTeamId())) continue;
                userTeamIdsSet.add(team.getTeamId());
            }
            long[] userTeamIds = ArrayUtil.toArray((Long[])userTeamIdsSet.toArray(new Long[userTeamIdsSet.size()]));
            this.userPersistence.addTeams(userId, userTeamIds);
            ++n4;
        }
    }

    protected int authenticate(long companyId, String login, String password, String authType, Map<String, String[]> headerMap, Map<String, String[]> parameterMap, Map<String, Object> resultsMap) throws PortalException, SystemException {
        if (PropsValues.AUTH_LOGIN_DISABLED) {
            return -1;
        }
        login = StringUtil.toLowerCase((String)login.trim());
        long userId = GetterUtil.getLong((String)login);
        if (authType.equals("emailAddress")) {
            if (Validator.isNull((String)login)) {
                throw new UserEmailAddressException();
            }
        } else if (authType.equals("screenName")) {
            if (Validator.isNull((String)login)) {
                throw new UserScreenNameException();
            }
        } else if (authType.equals("userId") && Validator.isNull((String)login)) {
            throw new UserIdException();
        }
        if (Validator.isNull((String)password)) {
            throw new UserPasswordException(3);
        }
        int authResult = -1;
        if (authType.equals("emailAddress")) {
            authResult = AuthPipeline.authenticateByEmailAddress("auth.pipeline.pre", companyId, login, password, headerMap, parameterMap);
        } else if (authType.equals("screenName")) {
            authResult = AuthPipeline.authenticateByScreenName("auth.pipeline.pre", companyId, login, password, headerMap, parameterMap);
        } else if (authType.equals("userId")) {
            authResult = AuthPipeline.authenticateByUserId("auth.pipeline.pre", companyId, userId, password, headerMap, parameterMap);
        }
        User user = null;
        if (authType.equals("emailAddress")) {
            user = this.fetchUserByEmailAddress(companyId, login);
        } else if (authType.equals("screenName")) {
            user = this.fetchUserByScreenName(companyId, login);
        } else if (authType.equals("userId")) {
            user = this.userPersistence.fetchByPrimaryKey(GetterUtil.getLong((String)login));
        }
        if (user == null) {
            return 0;
        }
        if (user.isDefaultUser()) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Authentication is disabled for the default user");
            }
            return 0;
        }
        if (!user.isActive()) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Authentication is disabled for inactive user " + user.getUserId()));
            }
            return -1;
        }
        if (!user.isPasswordEncrypted()) {
            user.setPassword(PasswordEncryptorUtil.encrypt(user.getPassword()));
            user.setPasswordEncrypted(true);
            this.userPersistence.update((BaseModel)user);
        }
        this.checkLockout(user);
        this.checkPasswordExpired(user);
        boolean skipLiferayCheck = false;
        if (authResult == 2) {
            authResult = 1;
            skipLiferayCheck = true;
        } else if (authResult == 1 && PropsValues.AUTH_PIPELINE_ENABLE_LIFERAY_CHECK) {
            boolean authenticated = PwdAuthenticator.authenticate(login, password, user.getPassword());
            authResult = authenticated ? 1 : -1;
        }
        if (authResult == 1) {
            if (authType.equals("emailAddress")) {
                authResult = AuthPipeline.authenticateByEmailAddress("auth.pipeline.post", companyId, login, password, headerMap, parameterMap);
            } else if (authType.equals("screenName")) {
                authResult = AuthPipeline.authenticateByScreenName("auth.pipeline.post", companyId, login, password, headerMap, parameterMap);
            } else if (authType.equals("userId")) {
                authResult = AuthPipeline.authenticateByUserId("auth.pipeline.post", companyId, userId, password, headerMap, parameterMap);
            }
        }
        if (authResult == 1) {
            if (resultsMap != null) {
                resultsMap.put("userId", user.getUserId());
            }
            if (skipLiferayCheck || !PropsValues.AUTH_PIPELINE_ENABLE_LIFERAY_CHECK || Validator.isNull((String)user.getDigest())) {
                String digest = user.getDigest(password);
                user.setDigest(digest);
                this.userPersistence.update((BaseModel)user);
            }
        }
        if (authResult == -1) {
            block53: {
                if (authType.equals("emailAddress")) {
                    AuthPipeline.onFailureByEmailAddress("auth.failure", companyId, login, headerMap, parameterMap);
                } else if (authType.equals("screenName")) {
                    AuthPipeline.onFailureByScreenName("auth.failure", companyId, login, headerMap, parameterMap);
                } else if (authType.equals("userId")) {
                    AuthPipeline.onFailureByUserId("auth.failure", companyId, userId, headerMap, parameterMap);
                }
                user = this.userPersistence.fetchByPrimaryKey(user.getUserId());
                if (user != null) break block53;
                return 0;
            }
            try {
                if (!LDAPSettingsUtil.isPasswordPolicyEnabled(user.getCompanyId())) {
                    int maxFailures;
                    PasswordPolicy passwordPolicy = user.getPasswordPolicy();
                    int failedLoginAttempts = (user = this.userPersistence.fetchByPrimaryKey(user.getUserId())).getFailedLoginAttempts();
                    if (failedLoginAttempts >= (maxFailures = passwordPolicy.getMaxFailure()) && maxFailures != 0) {
                        if (authType.equals("emailAddress")) {
                            AuthPipeline.onMaxFailuresByEmailAddress("auth.max.failures", companyId, login, headerMap, parameterMap);
                        } else if (authType.equals("screenName")) {
                            AuthPipeline.onMaxFailuresByScreenName("auth.max.failures", companyId, login, headerMap, parameterMap);
                        } else if (authType.equals("userId")) {
                            AuthPipeline.onMaxFailuresByUserId("auth.max.failures", companyId, userId, headerMap, parameterMap);
                        }
                    }
                }
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
            }
        }
        return authResult;
    }

    protected Date getBirthday(int birthdayMonth, int birthdayDay, int birthdayYear) throws PortalException {
        Date now;
        Date birthday = PortalUtil.getDate((int)birthdayMonth, (int)birthdayDay, (int)birthdayYear, ContactBirthdayException.class);
        if (birthday.after(now = new Date())) {
            throw new ContactBirthdayException();
        }
        return birthday;
    }

    protected String getLogin(String login) {
        return StringUtil.lowerCase((String)StringUtil.trim((String)login));
    }

    protected long[] getUserIds(List<User> users) {
        long[] userIds = new long[users.size()];
        int i2 = 0;
        while (i2 < users.size()) {
            User user = users.get(i2);
            userIds[i2] = user.getUserId();
            ++i2;
        }
        return userIds;
    }

    protected void reindex(final User user) {
        final Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
        ShardCallable<Void> callable = new ShardCallable<Void>(user.getCompanyId()){

            protected Void doCall() throws Exception {
                indexer.reindex((Object)user);
                return null;
            }
        };
        TransactionCommitCallbackRegistryUtil.registerCallback((Callable)callable);
    }

    protected Hits search(long companyId, String firstName, String middleName, String lastName, String fullName, String screenName, String emailAddress, String street, String city, String zip, String region, String country, int status, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort sort) throws SystemException {
        try {
            String keywords;
            SearchContext searchContext = new SearchContext();
            searchContext.setAndSearch(andSearch);
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("city", city);
            attributes.put("country", country);
            attributes.put("emailAddress", emailAddress);
            attributes.put("firstName", firstName);
            attributes.put("fullName", fullName);
            attributes.put("lastName", lastName);
            attributes.put("middleName", middleName);
            attributes.put("params", params);
            attributes.put("region", region);
            attributes.put("screenName", screenName);
            attributes.put("street", street);
            attributes.put("status", status);
            attributes.put("zip", zip);
            searchContext.setAttributes(attributes);
            searchContext.setCompanyId(companyId);
            searchContext.setEnd(end);
            if (params != null && Validator.isNotNull((String)(keywords = (String)params.remove("keywords")))) {
                searchContext.setKeywords(keywords);
            }
            QueryConfig queryConfig = new QueryConfig();
            queryConfig.setHighlightEnabled(false);
            queryConfig.setScoreEnabled(false);
            searchContext.setQueryConfig(queryConfig);
            if (sort != null) {
                searchContext.setSorts(new Sort[]{sort});
            }
            searchContext.setStart(start);
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
            return indexer.search(searchContext);
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
    }

    protected void sendEmail(User user, String password, ServiceContext serviceContext) throws SystemException {
        if (!PrefsPropsUtil.getBoolean(user.getCompanyId(), "admin.email.user.added.enabled")) {
            return;
        }
        String fromName = PrefsPropsUtil.getString(user.getCompanyId(), "admin.email.from.name");
        String fromAddress = PrefsPropsUtil.getString(user.getCompanyId(), "admin.email.from.address");
        String toName = user.getFullName();
        String toAddress = user.getEmailAddress();
        String subject = PrefsPropsUtil.getContent(user.getCompanyId(), "admin.email.user.added.subject");
        String body = null;
        body = Validator.isNotNull((String)password) ? PrefsPropsUtil.getContent(user.getCompanyId(), "admin.email.user.added.body") : PrefsPropsUtil.getContent(user.getCompanyId(), "admin.email.user.added.no.password.body");
        SubscriptionSender subscriptionSender = new SubscriptionSender();
        subscriptionSender.setBody(body);
        subscriptionSender.setCompanyId(user.getCompanyId());
        subscriptionSender.setContextAttributes(new Object[]{"[$USER_ID$]", user.getUserId(), "[$USER_PASSWORD$]", password, "[$USER_SCREENNAME$]", user.getScreenName()});
        subscriptionSender.setFrom(fromAddress, fromName);
        subscriptionSender.setHtmlFormat(true);
        subscriptionSender.setMailId("user", new Object[]{user.getUserId(), System.currentTimeMillis(), PwdGenerator.getPassword()});
        subscriptionSender.setServiceContext(serviceContext);
        subscriptionSender.setSubject(subject);
        subscriptionSender.setUserId(user.getUserId());
        subscriptionSender.addRuntimeSubscribers(toAddress, toName);
        subscriptionSender.flushNotificationsAsync();
    }

    protected void setEmailAddress(User user, String password, String firstName, String middleName, String lastName, String emailAddress) throws PortalException, SystemException {
        if (StringUtil.equalsIgnoreCase((String)emailAddress, (String)user.getEmailAddress())) {
            return;
        }
        long userId = user.getUserId();
        if (!user.hasCompanyMx() && user.hasCompanyMx(emailAddress) && Validator.isNotNull((String)password)) {
            this.mailService.addUser(user.getCompanyId(), userId, password, firstName, middleName, lastName, emailAddress);
        } else if (user.hasCompanyMx() && user.hasCompanyMx(emailAddress)) {
            this.mailService.updateEmailAddress(user.getCompanyId(), userId, emailAddress);
        } else if (user.hasCompanyMx() && !user.hasCompanyMx(emailAddress)) {
            this.mailService.deleteEmailAddress(user.getCompanyId(), userId);
        }
        user.setEmailAddress(emailAddress);
        user.setDigest("");
    }

    protected void startWorkflowInstance(final long companyId, final long workflowUserId, final long userId, final User user, final ServiceContext workflowServiceContext) {
        final boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
        ShardCallable<Void> callable = new ShardCallable<Void>(companyId){

            protected Void doCall() throws Exception {
                boolean currentWorkflowEnabled = WorkflowThreadLocal.isEnabled();
                try {
                    WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
                    WorkflowHandlerRegistryUtil.startWorkflowInstance((long)companyId, (long)workflowUserId, (String)User.class.getName(), (long)userId, (Object)user, (ServiceContext)workflowServiceContext);
                    return null;
                }
                finally {
                    WorkflowThreadLocal.setEnabled((boolean)currentWorkflowEnabled);
                }
            }
        };
        TransactionCommitCallbackRegistryUtil.registerCallback((Callable)callable);
    }

    protected void updateGroups(long userId, long[] newGroupIds, ServiceContext serviceContext, boolean indexingEnabled) throws PortalException, SystemException {
        if (newGroupIds == null) {
            return;
        }
        List oldGroups = this.userPersistence.getGroups(userId);
        HashSet<Long> oldGroupIds = new HashSet<Long>(oldGroups.size());
        for (Group oldGroup : oldGroups) {
            long oldGroupId = oldGroup.getGroupId();
            oldGroupIds.add(oldGroupId);
            if (ArrayUtil.contains((long[])newGroupIds, (long)oldGroupId)) continue;
            this.unsetGroupUsers(oldGroupId, new long[]{userId}, serviceContext);
        }
        long[] lArray = newGroupIds;
        int n = newGroupIds.length;
        int n2 = 0;
        while (n2 < n) {
            long newGroupId = lArray[n2];
            if (!oldGroupIds.contains(newGroupId)) {
                this.addGroupUsers(newGroupId, new long[]{userId});
            }
            ++n2;
        }
        if (indexingEnabled) {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
            indexer.reindex((Object)new long[]{userId});
        }
        PermissionCacheUtil.clearCache();
    }

    protected void updateOrganizations(long userId, long[] newOrganizationIds, boolean indexingEnabled) throws PortalException, SystemException {
        if (newOrganizationIds == null) {
            return;
        }
        List oldOrganizations = this.userPersistence.getOrganizations(userId);
        HashSet<Long> oldOrganizationIds = new HashSet<Long>(oldOrganizations.size());
        for (Organization oldOrganization : oldOrganizations) {
            long oldOrganizationId = oldOrganization.getOrganizationId();
            oldOrganizationIds.add(oldOrganizationId);
            if (ArrayUtil.contains((long[])newOrganizationIds, (long)oldOrganizationId)) continue;
            this.unsetOrganizationUsers(oldOrganizationId, new long[]{userId});
        }
        long[] lArray = newOrganizationIds;
        int n = newOrganizationIds.length;
        int n2 = 0;
        while (n2 < n) {
            long newOrganizationId = lArray[n2];
            if (!oldOrganizationIds.contains(newOrganizationId)) {
                this.addOrganizationUsers(newOrganizationId, new long[]{userId});
            }
            ++n2;
        }
        if (indexingEnabled) {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
            indexer.reindex((Object)new long[]{userId});
        }
        PermissionCacheUtil.clearCache();
    }

    protected void updateUserGroupRoles(User user, long[] groupIds, long[] organizationIds, List<UserGroupRole> userGroupRoles, List<UserGroupRole> previousUserGroupRoles) throws PortalException, SystemException {
        if (userGroupRoles == null) {
            return;
        }
        for (UserGroupRole userGroupRole : previousUserGroupRoles) {
            if (userGroupRoles.contains(userGroupRole)) {
                userGroupRoles.remove(userGroupRole);
                continue;
            }
            this.userGroupRoleLocalService.deleteUserGroupRole(userGroupRole);
        }
        long[] validGroupIds = null;
        validGroupIds = groupIds != null ? ArrayUtil.clone((long[])groupIds) : user.getGroupIds();
        if (organizationIds == null) {
            organizationIds = user.getOrganizationIds();
        }
        long[] organizationGroupIds = new long[organizationIds.length];
        int i2 = 0;
        while (i2 < organizationIds.length) {
            long organizationId = organizationIds[i2];
            Organization organization = this.organizationPersistence.findByPrimaryKey(organizationId);
            organizationGroupIds[i2] = organization.getGroupId();
            ++i2;
        }
        validGroupIds = ArrayUtil.append((long[][])new long[][]{validGroupIds, organizationGroupIds});
        Arrays.sort(validGroupIds);
        for (UserGroupRole userGroupRole : userGroupRoles) {
            if (Arrays.binarySearch(validGroupIds, userGroupRole.getGroupId()) < 0) continue;
            this.userGroupRoleLocalService.addUserGroupRole(userGroupRole);
        }
    }

    protected void validate(long companyId, long userId, boolean autoPassword, String password1, String password2, boolean autoScreenName, String screenName, String emailAddress, String openId, String firstName, String middleName, String lastName, long[] organizationIds) throws PortalException, SystemException {
        User user;
        this.validateCompanyMaxUsers(companyId);
        if (!autoScreenName) {
            this.validateScreenName(companyId, userId, screenName);
        }
        if (!autoPassword) {
            PasswordPolicy passwordPolicy = this.passwordPolicyLocalService.getDefaultPasswordPolicy(companyId);
            PwdToolkitUtil.validate(companyId, 0L, password1, password2, passwordPolicy);
        }
        this.validateEmailAddress(companyId, emailAddress);
        if (Validator.isNotNull((String)emailAddress) && (user = this.userPersistence.fetchByC_EA(companyId, emailAddress)) != null && user.getUserId() != userId) {
            throw new DuplicateUserEmailAddressException();
        }
        this.validateOpenId(companyId, userId, openId);
        this.validateFullName(companyId, firstName, middleName, lastName);
        if (organizationIds != null) {
            long[] lArray = organizationIds;
            int n = organizationIds.length;
            int n2 = 0;
            while (n2 < n) {
                long organizationId = lArray[n2];
                Organization organization = this.organizationPersistence.fetchByPrimaryKey(organizationId);
                if (organization == null) {
                    throw new NoSuchOrganizationException();
                }
                ++n2;
            }
        }
    }

    protected void validate(long userId, String screenName, String emailAddress, String openId, String firstName, String middleName, String lastName, String smsSn) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        if (!StringUtil.equalsIgnoreCase((String)user.getScreenName(), (String)screenName)) {
            this.validateScreenName(user.getCompanyId(), userId, screenName);
        }
        this.validateEmailAddress(user.getCompanyId(), emailAddress);
        this.validateOpenId(user.getCompanyId(), userId, openId);
        if (!user.isDefaultUser()) {
            if (Validator.isNotNull((String)emailAddress) && !StringUtil.equalsIgnoreCase((String)user.getEmailAddress(), (String)emailAddress) && this.userPersistence.fetchByC_EA(user.getCompanyId(), emailAddress) != null) {
                throw new DuplicateUserEmailAddressException();
            }
            this.validateFullName(user.getCompanyId(), firstName, middleName, lastName);
        }
        if (Validator.isNotNull((String)smsSn) && !Validator.isEmailAddress((String)smsSn)) {
            throw new UserSmsException();
        }
    }

    protected void validateCompanyMaxUsers(long companyId) throws PortalException, SystemException {
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        if (company.isSystem() || company.getMaxUsers() == 0) {
            return;
        }
        int userCount = this.searchCount(companyId, null, 0, null);
        if (userCount >= company.getMaxUsers()) {
            throw new CompanyMaxUsersException();
        }
    }

    protected void validateEmailAddress(long companyId, String emailAddress) throws PortalException, SystemException {
        String[] reservedEmailAddresses;
        if (Validator.isNull((String)emailAddress) && !PropsValues.USERS_EMAIL_ADDRESS_REQUIRED) {
            return;
        }
        EmailAddressValidator emailAddressValidator = EmailAddressValidatorFactory.getInstance();
        if (!emailAddressValidator.validate(companyId, emailAddress)) {
            throw new UserEmailAddressException();
        }
        String pop3User = PrefsPropsUtil.getString("mail.session.mail.pop3.user", PropsValues.MAIL_SESSION_MAIL_POP3_USER);
        if (StringUtil.equalsIgnoreCase((String)emailAddress, (String)pop3User)) {
            throw new ReservedUserEmailAddressException();
        }
        String[] stringArray = reservedEmailAddresses = PrefsPropsUtil.getStringArray(companyId, "admin.reserved.email.addresses", "\n", PropsValues.ADMIN_RESERVED_EMAIL_ADDRESSES);
        int n = reservedEmailAddresses.length;
        int n2 = 0;
        while (n2 < n) {
            String reservedEmailAddress = stringArray[n2];
            if (StringUtil.equalsIgnoreCase((String)emailAddress, (String)reservedEmailAddress)) {
                throw new ReservedUserEmailAddressException();
            }
            ++n2;
        }
    }

    protected void validateEmailAddress(User user, String emailAddress1, String emailAddress2) throws PortalException, SystemException {
        if (!emailAddress1.equals(emailAddress2)) {
            throw new UserEmailAddressException();
        }
        this.validateEmailAddress(user.getCompanyId(), emailAddress1);
        this.validateEmailAddress(user.getCompanyId(), emailAddress2);
        if (!StringUtil.equalsIgnoreCase((String)emailAddress1, (String)user.getEmailAddress()) && this.userPersistence.fetchByC_EA(user.getCompanyId(), emailAddress1) != null) {
            throw new DuplicateUserEmailAddressException();
        }
    }

    protected void validateFullName(long companyId, String firstName, String middleName, String lastName) throws PortalException, SystemException {
        if (Validator.isNull((String)firstName)) {
            throw new ContactFirstNameException();
        }
        if (Validator.isNull((String)lastName) && PrefsPropsUtil.getBoolean(companyId, "users.last.name.required", PropsValues.USERS_LAST_NAME_REQUIRED)) {
            throw new ContactLastNameException();
        }
        FullNameValidator fullNameValidator = FullNameValidatorFactory.getInstance();
        if (!fullNameValidator.validate(companyId, firstName, middleName, lastName)) {
            throw new ContactFullNameException();
        }
    }

    protected void validateOpenId(long companyId, long userId, String openId) throws PortalException, SystemException {
        if (Validator.isNull((String)openId)) {
            return;
        }
        User user = this.userPersistence.fetchByC_O(companyId, openId);
        if (user != null && user.getUserId() != userId) {
            throw new DuplicateOpenIdException();
        }
    }

    protected void validatePassword(long companyId, long userId, String password1, String password2) throws PortalException, SystemException {
        if (Validator.isNull((String)password1) || Validator.isNull((String)password2)) {
            throw new UserPasswordException(3);
        }
        if (!password1.equals(password2)) {
            throw new UserPasswordException(10);
        }
        PasswordPolicy passwordPolicy = this.passwordPolicyLocalService.getPasswordPolicyByUserId(userId);
        PwdToolkitUtil.validate(companyId, userId, password1, password2, passwordPolicy);
    }

    protected void validateReminderQuery(String question, String answer) throws PortalException {
        if (!PropsValues.USERS_REMINDER_QUERIES_ENABLED) {
            return;
        }
        if (Validator.isNull((String)question)) {
            throw new UserReminderQueryException("Question is null");
        }
        if (Validator.isNull((String)answer)) {
            throw new UserReminderQueryException("Answer is null");
        }
    }

    protected void validateScreenName(long companyId, long userId, String screenName) throws PortalException, SystemException {
        String[] reservedScreenNames;
        String[] anonymousNames;
        if (Validator.isNull((String)screenName)) {
            throw new UserScreenNameException();
        }
        ScreenNameValidator screenNameValidator = ScreenNameValidatorFactory.getInstance();
        if (!screenNameValidator.validate(companyId, screenName)) {
            throw new UserScreenNameException();
        }
        if (Validator.isNumber((String)screenName)) {
            Group group;
            if (!PropsValues.USERS_SCREEN_NAME_ALLOW_NUMERIC) {
                throw new UserScreenNameException();
            }
            if (!screenName.equals(String.valueOf(userId)) && (group = this.groupPersistence.fetchByPrimaryKey(GetterUtil.getLong((String)screenName))) != null) {
                throw new UserScreenNameException();
            }
        }
        char[] cArray = screenName.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c2 = cArray[n2];
            if (!Validator.isChar((char)c2) && !Validator.isDigit((char)c2) && c2 != '-' && c2 != '.' && c2 != '_') {
                throw new UserScreenNameException();
            }
            ++n2;
        }
        String[] stringArray = anonymousNames = BaseServiceImpl.ANONYMOUS_NAMES;
        int n3 = anonymousNames.length;
        n = 0;
        while (n < n3) {
            String anonymousName = stringArray[n];
            if (StringUtil.equalsIgnoreCase((String)screenName, (String)anonymousName)) {
                throw new UserScreenNameException();
            }
            ++n;
        }
        User user = this.userPersistence.fetchByC_SN(companyId, screenName);
        if (user != null && user.getUserId() != userId) {
            throw new DuplicateUserScreenNameException();
        }
        String friendlyURL = "/" + screenName;
        Group group = this.groupPersistence.fetchByC_F(companyId, friendlyURL);
        if (group != null && group.getClassPK() != userId) {
            throw new GroupFriendlyURLException(6);
        }
        int exceptionType = LayoutImpl.validateFriendlyURL(friendlyURL);
        if (exceptionType != -1) {
            throw new UserScreenNameException((Throwable)new GroupFriendlyURLException(exceptionType));
        }
        String[] stringArray2 = reservedScreenNames = PrefsPropsUtil.getStringArray(companyId, "admin.reserved.screen.names", "\n", PropsValues.ADMIN_RESERVED_SCREEN_NAMES);
        int n4 = reservedScreenNames.length;
        int n5 = 0;
        while (n5 < n4) {
            String reservedScreenName = stringArray2[n5];
            if (StringUtil.equalsIgnoreCase((String)screenName, (String)reservedScreenName)) {
                throw new ReservedUserScreenNameException();
            }
            ++n5;
        }
    }
}

