/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.lar.ExportImportThreadLocal;
import com.liferay.portal.kernel.lar.MissingReferences;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Repository;
import com.liferay.portal.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.StagingLocalServiceBaseImpl;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.NoSuchFolderException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;

public class StagingLocalServiceImpl
extends StagingLocalServiceBaseImpl {
    private static final String _ASSEMBLED_LAR_PREFIX = "assembled_";
    private static Log _log = LogFactoryUtil.getLog(StagingLocalServiceImpl.class);

    public void cleanUpStagingRequest(long stagingRequestId) throws PortalException, SystemException {
        block2: {
            try {
                PortletFileRepositoryUtil.deleteFolder((long)stagingRequestId);
            }
            catch (NoSuchFolderException nsfe) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)("Unable to clean up staging request " + stagingRequestId), (Throwable)nsfe);
            }
        }
    }

    public long createStagingRequest(long userId, long groupId, String checksum) throws PortalException, SystemException {
        ServiceContext serviceContext = new ServiceContext();
        Repository repository = PortletFileRepositoryUtil.addPortletRepository((long)groupId, (String)"134", (ServiceContext)serviceContext);
        Folder folder = PortletFileRepositoryUtil.addPortletFolder((long)userId, (long)repository.getRepositoryId(), (long)0L, (String)checksum, (ServiceContext)serviceContext);
        return folder.getFolderId();
    }

    public void publishStagingRequest(long userId, long stagingRequestId, boolean privateLayout, Map<String, String[]> parameterMap) throws PortalException, SystemException {
        try {
            ExportImportThreadLocal.setLayoutImportInProcess((boolean)true);
            Folder folder = PortletFileRepositoryUtil.getPortletFolder((long)stagingRequestId);
            FileEntry stagingRequestFileEntry = this.getStagingRequestFileEntry(userId, stagingRequestId, folder);
            this.layoutLocalService.importLayouts(userId, folder.getGroupId(), privateLayout, parameterMap, stagingRequestFileEntry.getContentStream());
        }
        finally {
            ExportImportThreadLocal.setLayoutImportInProcess((boolean)false);
        }
    }

    public void updateStagingRequest(long userId, long stagingRequestId, String fileName, byte[] bytes) throws PortalException, SystemException {
        Folder folder = PortletFileRepositoryUtil.getPortletFolder((long)stagingRequestId);
        fileName = String.valueOf(fileName) + PortletFileRepositoryUtil.getPortletFileEntriesCount((long)folder.getGroupId(), (long)folder.getFolderId());
        PortletFileRepositoryUtil.addPortletFileEntry((long)folder.getGroupId(), (long)userId, (String)Group.class.getName(), (long)folder.getGroupId(), (String)"134", (long)folder.getFolderId(), (InputStream)new UnsyncByteArrayInputStream(bytes), (String)fileName, (String)"application/zip", (boolean)false);
    }

    public MissingReferences validateStagingRequest(long userId, long stagingRequestId, boolean privateLayout, Map<String, String[]> parameterMap) throws PortalException, SystemException {
        try {
            ExportImportThreadLocal.setLayoutValidationInProcess((boolean)true);
            Folder folder = PortletFileRepositoryUtil.getPortletFolder((long)stagingRequestId);
            FileEntry fileEntry = this.getStagingRequestFileEntry(userId, stagingRequestId, folder);
            MissingReferences missingReferences = this.layoutLocalService.validateImportLayoutsFile(userId, folder.getGroupId(), privateLayout, parameterMap, fileEntry.getContentStream());
            return missingReferences;
        }
        finally {
            ExportImportThreadLocal.setLayoutValidationInProcess((boolean)false);
        }
    }

    protected FileEntry fetchStagingRequestFileEntry(long stagingRequestId, Folder folder) throws PortalException, SystemException {
        try {
            return PortletFileRepositoryUtil.getPortletFileEntry((long)folder.getGroupId(), (long)folder.getFolderId(), (String)this.getAssembledFileName(stagingRequestId));
        }
        catch (NoSuchFileEntryException noSuchFileEntryException) {
            return null;
        }
    }

    protected String getAssembledFileName(long stagingRequestId) {
        return _ASSEMBLED_LAR_PREFIX + String.valueOf(stagingRequestId) + ".lar";
    }

    protected FileEntry getStagingRequestFileEntry(long userId, long stagingRequestId, Folder folder) throws PortalException, SystemException {
        FileEntry fileEntry;
        FileEntry stagingRequestFileEntry = this.fetchStagingRequestFileEntry(stagingRequestId, folder);
        if (stagingRequestFileEntry != null) {
            return stagingRequestFileEntry;
        }
        FileOutputStream fileOutputStream = null;
        File tempFile = null;
        try {
            tempFile = FileUtil.createTempFile((String)"lar");
            fileOutputStream = new FileOutputStream(tempFile);
            List fileEntries = PortletFileRepositoryUtil.getPortletFileEntries((long)folder.getGroupId(), (long)folder.getFolderId());
            for (FileEntry fileEntry2 : fileEntries) {
                InputStream inputStream = fileEntry2.getContentStream();
                try {
                    StreamUtil.transfer((InputStream)inputStream, (OutputStream)fileOutputStream, (boolean)false);
                }
                finally {
                    StreamUtil.cleanUp((InputStream)inputStream);
                    PortletFileRepositoryUtil.deletePortletFileEntry((long)fileEntry2.getFileEntryId());
                }
            }
            String checksum = FileUtil.getMD5Checksum((File)tempFile);
            if (!checksum.equals(folder.getName())) {
                throw new SystemException("Invalid checksum for LAR file");
            }
            PortletFileRepositoryUtil.addPortletFileEntry((long)folder.getGroupId(), (long)userId, (String)Group.class.getName(), (long)folder.getGroupId(), (String)"134", (long)folder.getFolderId(), (File)tempFile, (String)this.getAssembledFileName(stagingRequestId), (String)"application/zip", (boolean)false);
            stagingRequestFileEntry = this.fetchStagingRequestFileEntry(stagingRequestId, folder);
            if (stagingRequestFileEntry == null) {
                throw new SystemException("Unable to assemble LAR file");
            }
            fileEntry = stagingRequestFileEntry;
        }
        catch (IOException ioe) {
            try {
                throw new SystemException("Unable to reassemble LAR file", (Throwable)ioe);
            }
            catch (Throwable throwable) {
                StreamUtil.cleanUp(fileOutputStream);
                FileUtil.delete((File)tempFile);
                throw throwable;
            }
        }
        StreamUtil.cleanUp((OutputStream)fileOutputStream);
        FileUtil.delete((File)tempFile);
        return fileEntry;
    }
}

