/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.PortletIdException;
import com.liferay.portal.kernel.cluster.Clusterable;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.image.SpriteProcessorUtil;
import com.liferay.portal.kernel.lar.DefaultConfigurationPortletDataHandler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.portlet.FriendlyURLMapper;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletLayoutListener;
import com.liferay.portal.kernel.scheduler.SchedulerEntry;
import com.liferay.portal.kernel.scheduler.SchedulerEntryImpl;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.TriggerType;
import com.liferay.portal.kernel.servlet.ServletContextUtil;
import com.liferay.portal.kernel.spring.aop.Skip;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.ContextPathUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.EventDefinition;
import com.liferay.portal.model.ModelHintsUtil;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletApp;
import com.liferay.portal.model.PortletCategory;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.PortletFilter;
import com.liferay.portal.model.PortletInfo;
import com.liferay.portal.model.PortletPreferences;
import com.liferay.portal.model.PortletURLListener;
import com.liferay.portal.model.PublicRenderParameter;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.impl.EventDefinitionImpl;
import com.liferay.portal.model.impl.PortletAppImpl;
import com.liferay.portal.model.impl.PortletFilterImpl;
import com.liferay.portal.model.impl.PortletImpl;
import com.liferay.portal.model.impl.PortletURLListenerImpl;
import com.liferay.portal.model.impl.PublicRenderParameterImpl;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.base.PortletLocalServiceBaseImpl;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.WebAppPool;
import com.liferay.portlet.PortletConfigFactoryUtil;
import com.liferay.portlet.PortletContextFactory;
import com.liferay.portlet.PortletInstanceFactoryUtil;
import com.liferay.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portlet.PortletQNameUtil;
import com.liferay.portlet.expando.model.CustomAttributesDisplay;
import com.liferay.util.ContentUtil;
import com.liferay.util.bridges.mvc.MVCPortlet;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletMode;
import javax.portlet.PreferencesValidator;
import javax.portlet.WindowState;
import javax.servlet.ServletContext;

public class PortletLocalServiceImpl
extends PortletLocalServiceBaseImpl {
    private static final int _PORTLET_ID_MAX_LENGTH = ModelHintsUtil.getMaxLength((String)Portlet.class.getName(), (String)"portletId") - "_INSTANCE_".length() + "_USER_".length() + 39;
    private static Log _log = LogFactoryUtil.getLog(PortletLocalServiceImpl.class);
    private static Map<Long, Map<String, Portlet>> _companyPortletsPool = new ConcurrentHashMap<Long, Map<String, Portlet>>();
    private static Map<String, Portlet> _customAttributesDisplayPortlets = new ConcurrentHashMap<String, Portlet>();
    private static Map<String, Portlet> _friendlyURLMapperPortlets = new ConcurrentHashMap<String, Portlet>();
    private static Map<String, PortletApp> _portletAppsPool = new ConcurrentHashMap<String, PortletApp>();
    private static Map<String, String> _portletIdsByStrutsPath = new ConcurrentHashMap<String, String>();
    private static Map<String, Portlet> _portletsPool = new ConcurrentHashMap<String, Portlet>();

    @Skip
    public void addPortletCategory(long companyId, String categoryName) {
        PortletCategory portletCategory = (PortletCategory)WebAppPool.get(companyId, "PORTLET_CATEGORY");
        if (portletCategory == null) {
            _log.error((Object)("Unable to add portlet category for company " + companyId + " because it does not exist"));
            return;
        }
        PortletCategory newPortletCategory = new PortletCategory(categoryName);
        if (newPortletCategory.getParentCategory() == null) {
            PortletCategory rootPortletCategory = new PortletCategory();
            rootPortletCategory.addCategory(newPortletCategory);
        }
        portletCategory.merge(newPortletCategory.getRootCategory());
    }

    public void checkPortlet(Portlet portlet) throws PortalException, SystemException {
        if (portlet.isSystem()) {
            return;
        }
        String[] roleNames = portlet.getRolesArray();
        if (roleNames.length == 0) {
            return;
        }
        long companyId = portlet.getCompanyId();
        String name = portlet.getPortletId();
        int scope = 1;
        String primKey = String.valueOf(companyId);
        String actionId = "ADD_TO_PAGE";
        List actionIds = ResourceActionsUtil.getPortletResourceActions((String)name);
        if (actionIds.contains(actionId)) {
            String[] stringArray = roleNames;
            int n = roleNames.length;
            int n2 = 0;
            while (n2 < n) {
                String roleName = stringArray[n2];
                Role role = this.roleLocalService.getRole(companyId, roleName);
                if (this.resourceBlockLocalService.isSupported(name)) {
                    this.resourceBlockLocalService.addCompanyScopePermission(companyId, name, role.getRoleId(), actionId);
                } else {
                    this.resourcePermissionLocalService.addResourcePermission(companyId, name, scope, primKey, role.getRoleId(), actionId);
                }
                ++n2;
            }
        }
        this.updatePortlet(companyId, portlet.getPortletId(), "", portlet.isActive());
    }

    public void checkPortlets(long companyId) throws PortalException, SystemException {
        List<Portlet> portlets = this.getPortlets(companyId);
        for (Portlet portlet : portlets) {
            this.checkPortlet(portlet);
        }
    }

    @Skip
    public void clearCache() {
        _portletIdsByStrutsPath.clear();
        this.portletLocalService.clearCompanyPortletsPool();
    }

    @Clusterable
    @Transactional(enabled=false)
    public void clearCompanyPortletsPool() {
        _companyPortletsPool.clear();
    }

    @Skip
    public Portlet clonePortlet(long companyId, String portletId) {
        return this.clonePortlet(portletId);
    }

    @Skip
    public Portlet clonePortlet(String portletId) {
        Portlet portlet = this.getPortletById(portletId);
        return (Portlet)portlet.clone();
    }

    public void deletePortlet(long companyId, String portletId, long plid) throws PortalException, SystemException {
        String rootPortletId = PortletConstants.getRootPortletId((String)portletId);
        this.resourceLocalService.deleteResource(companyId, rootPortletId, 4, PortletPermissionUtil.getPrimaryKey((long)plid, (String)portletId));
        int ownerType = 3;
        if (PortletConstants.hasUserId((String)portletId)) {
            ownerType = 4;
        }
        List portletPreferencesList = this.portletPreferencesLocalService.getPortletPreferences(ownerType, plid, portletId);
        Portlet portlet = this.getPortletById(companyId, portletId);
        PortletLayoutListener portletLayoutListener = null;
        if (portlet != null) {
            portletLayoutListener = portlet.getPortletLayoutListenerInstance();
            PortletInstanceFactoryUtil.delete((Portlet)portlet);
        }
        for (PortletPreferences portletPreferences : portletPreferencesList) {
            if (portletLayoutListener != null) {
                portletLayoutListener.onRemoveFromLayout(portletPreferences.getPortletId(), plid);
            }
            this.portletPreferencesLocalService.deletePortletPreferences(portletPreferences.getPortletPreferencesId());
        }
    }

    public void deletePortlets(long companyId, String[] portletIds, long plid) throws PortalException, SystemException {
        String[] stringArray = portletIds;
        int n = portletIds.length;
        int n2 = 0;
        while (n2 < n) {
            String portletId = stringArray[n2];
            this.deletePortlet(companyId, portletId, plid);
            ++n2;
        }
    }

    public Portlet deployRemotePortlet(Portlet portlet, String categoryName) throws PortalException, SystemException {
        return this.deployRemotePortlet(portlet, new String[]{categoryName});
    }

    public Portlet deployRemotePortlet(Portlet portlet, String[] categoryNames) throws PortalException, SystemException {
        Map<String, Portlet> portletsPool = this._getPortletsPool();
        portletsPool.put(portlet.getPortletId(), portlet);
        PortletInstanceFactoryUtil.clear((Portlet)portlet, (boolean)false);
        PortletConfigFactoryUtil.destroy((Portlet)portlet);
        this.clearCache();
        List portletActions = ResourceActionsUtil.getPortletResourceActions((String)portlet.getPortletId());
        this.resourceActionLocalService.checkResourceActions(portlet.getPortletId(), portletActions);
        PortletCategory portletCategory = (PortletCategory)WebAppPool.get(portlet.getCompanyId(), "PORTLET_CATEGORY");
        if (portletCategory == null) {
            _log.error((Object)("Unable to register remote portlet for company " + portlet.getCompanyId() + " because it does not exist"));
            return portlet;
        }
        portletCategory.separate(portlet.getPortletId());
        String[] stringArray = categoryNames;
        int n = categoryNames.length;
        int n2 = 0;
        while (n2 < n) {
            String categoryName = stringArray[n2];
            PortletCategory newPortletCategory = new PortletCategory(categoryName);
            if (newPortletCategory.getParentCategory() == null) {
                PortletCategory rootPortletCategory = new PortletCategory();
                rootPortletCategory.addCategory(newPortletCategory);
            }
            Set portletIds = newPortletCategory.getPortletIds();
            portletIds.add(portlet.getPortletId());
            portletCategory.merge(newPortletCategory.getRootCategory());
            ++n2;
        }
        this.checkPortlet(portlet);
        return portlet;
    }

    @Skip
    public void destroyPortlet(Portlet portlet) {
        String portletId = portlet.getRootPortletId();
        _friendlyURLMapperPortlets.remove(portletId);
        Map<String, Portlet> portletsPool = this._getPortletsPool();
        portletsPool.remove(portletId);
        PortletApp portletApp = portlet.getPortletApp();
        if (portletApp != null) {
            _portletAppsPool.remove(portletApp.getServletContextName());
        }
        this.clearCache();
    }

    @Skip
    public void destroyRemotePortlet(Portlet portlet) {
        this.destroyPortlet(portlet);
    }

    @Skip
    public List<CustomAttributesDisplay> getCustomAttributesDisplays() {
        ArrayList<CustomAttributesDisplay> customAttributesDisplays = new ArrayList<CustomAttributesDisplay>(_customAttributesDisplayPortlets.size());
        for (Map.Entry<String, Portlet> entry : _customAttributesDisplayPortlets.entrySet()) {
            Portlet portlet = entry.getValue();
            List portletCustomAttributesDisplays = portlet.getCustomAttributesDisplayInstances();
            if (portletCustomAttributesDisplays == null || portletCustomAttributesDisplays.isEmpty()) continue;
            customAttributesDisplays.addAll(portletCustomAttributesDisplays);
        }
        return customAttributesDisplays;
    }

    @Skip
    public PortletCategory getEARDisplay(String xml) throws SystemException {
        try {
            return this._readLiferayDisplayXML(xml);
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
    }

    @Skip
    public List<Portlet> getFriendlyURLMapperPortlets() {
        ArrayList<Portlet> portlets = new ArrayList<Portlet>(_friendlyURLMapperPortlets.size());
        for (Map.Entry<String, Portlet> entry : _friendlyURLMapperPortlets.entrySet()) {
            Portlet portlet = entry.getValue();
            FriendlyURLMapper friendlyURLMapper = portlet.getFriendlyURLMapperInstance();
            if (friendlyURLMapper == null) continue;
            portlets.add(portlet);
        }
        return portlets;
    }

    @Skip
    public List<FriendlyURLMapper> getFriendlyURLMappers() {
        ArrayList<FriendlyURLMapper> friendlyURLMappers = new ArrayList<FriendlyURLMapper>(_friendlyURLMapperPortlets.size());
        for (Map.Entry<String, Portlet> entry : _friendlyURLMapperPortlets.entrySet()) {
            Portlet portlet = entry.getValue();
            FriendlyURLMapper friendlyURLMapper = portlet.getFriendlyURLMapperInstance();
            if (friendlyURLMapper == null) continue;
            friendlyURLMappers.add(friendlyURLMapper);
        }
        return friendlyURLMappers;
    }

    @Skip
    public PortletApp getPortletApp(String servletContextName) {
        return this._getPortletApp(servletContextName);
    }

    @Skip
    public Portlet getPortletById(long companyId, String portletId) throws SystemException {
        portletId = PortalUtil.getJsSafePortletId((String)portletId);
        Portlet portlet = null;
        Map<String, Portlet> companyPortletsPool = this._getPortletsPool(companyId);
        String rootPortletId = PortletConstants.getRootPortletId((String)portletId);
        if (portletId.equals(rootPortletId)) {
            portlet = companyPortletsPool.get(portletId);
        } else {
            portlet = companyPortletsPool.get(rootPortletId);
            if (portlet != null) {
                portlet = portlet.getClonedInstance(portletId);
            }
        }
        if (portlet != null) {
            return portlet;
        }
        if (portletId.equals("LIFERAY_PORTAL")) {
            return portlet;
        }
        if (_portletsPool.isEmpty()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"No portlets are installed");
            }
        } else {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Portlet not found for " + companyId + " " + portletId));
            }
            portlet = new PortletImpl(0L, portletId);
            portlet.setTimestamp(System.currentTimeMillis());
            PortletApp portletApp = this._getPortletApp("");
            portlet.setPortletApp(portletApp);
            portlet.setPortletName(portletId);
            portlet.setDisplayName(portletId);
            portlet.setPortletClass(MVCPortlet.class.getName());
            Map initParams = portlet.getInitParams();
            initParams.put("view-jsp", "/html/portal/undeployed_portlet.jsp");
            HashSet<String> mimeTypePortletModes = new HashSet<String>();
            mimeTypePortletModes.add(StringUtil.toLowerCase((String)PortletMode.VIEW.toString()));
            Map portletModes = portlet.getPortletModes();
            portletModes.put("text/html", mimeTypePortletModes);
            HashSet<String> mimeTypeWindowStates = new HashSet<String>();
            mimeTypeWindowStates.add(StringUtil.toLowerCase((String)WindowState.NORMAL.toString()));
            Map windowStates = portlet.getWindowStates();
            windowStates.put("text/html", mimeTypeWindowStates);
            portlet.setPortletInfo(new PortletInfo(portletId, portletId, portletId, portletId));
            if (PortletConstants.hasInstanceId((String)portletId)) {
                portlet.setInstanceable(true);
            }
            portlet.setActive(true);
            portlet.setUndeployedPortlet(true);
        }
        return portlet;
    }

    @Skip
    public Portlet getPortletById(String portletId) {
        Map<String, Portlet> portletsPool = this._getPortletsPool();
        String rootPortletId = PortletConstants.getRootPortletId((String)portletId);
        return portletsPool.get(rootPortletId);
    }

    @Skip
    public Portlet getPortletByStrutsPath(long companyId, String strutsPath) throws SystemException {
        return this.getPortletById(companyId, this._getPortletId(strutsPath));
    }

    @Skip
    public List<Portlet> getPortlets() {
        Map<String, Portlet> portletsPool = this._getPortletsPool();
        return ListUtil.fromMapValues(portletsPool);
    }

    @Skip
    public List<Portlet> getPortlets(long companyId) throws SystemException {
        return this.getPortlets(companyId, true, true);
    }

    @Skip
    public List<Portlet> getPortlets(long companyId, boolean showSystem, boolean showPortal) throws SystemException {
        Map<String, Portlet> portletsPool = this._getPortletsPool(companyId);
        List portlets = ListUtil.fromMapValues(portletsPool);
        if (showSystem && showPortal) {
            return portlets;
        }
        Iterator itr = portlets.iterator();
        while (itr.hasNext()) {
            Portlet portlet = (Portlet)itr.next();
            if (showPortal && portlet.getPortletId().equals("90")) continue;
            if (!showPortal && portlet.getPortletId().equals("90")) {
                itr.remove();
                continue;
            }
            if (showSystem || !portlet.isSystem()) continue;
            itr.remove();
        }
        return portlets;
    }

    @Skip
    public List<Portlet> getScopablePortlets() {
        Map<String, Portlet> portletsPool = this._getPortletsPool();
        List portlets = ListUtil.fromMapValues(portletsPool);
        Iterator itr = portlets.iterator();
        while (itr.hasNext()) {
            Portlet portlet = (Portlet)itr.next();
            if (portlet.isScopeable()) continue;
            itr.remove();
        }
        return portlets;
    }

    @Skip
    public PortletCategory getWARDisplay(String servletContextName, String xml) throws SystemException {
        try {
            return this._readLiferayDisplayXML(servletContextName, xml);
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
    }

    @Skip
    public boolean hasPortlet(long companyId, String portletId) throws SystemException {
        portletId = PortalUtil.getJsSafePortletId((String)portletId);
        Portlet portlet = null;
        Map<String, Portlet> companyPortletsPool = this._getPortletsPool(companyId);
        String rootPortletId = PortletConstants.getRootPortletId((String)portletId);
        portlet = portletId.equals(rootPortletId) ? companyPortletsPool.get(portletId) : companyPortletsPool.get(rootPortletId);
        return portlet != null;
    }

    @Skip
    public void initEAR(ServletContext servletContext, String[] xmls, PluginPackage pluginPackage) {
        this.portletLocalService.clearCompanyPortletsPool();
        _portletAppsPool.clear();
        _portletsPool.clear();
        _portletIdsByStrutsPath.clear();
        _friendlyURLMapperPortlets.clear();
        Map<String, Portlet> portletsPool = this._getPortletsPool();
        try {
            Set<String> servletURLPatterns = this._readWebXML(xmls[4]);
            Set<String> portletIds = this._readPortletXML(servletContext, xmls[0], portletsPool, servletURLPatterns, pluginPackage);
            portletIds.addAll(this._readPortletXML(servletContext, xmls[1], portletsPool, servletURLPatterns, pluginPackage));
            Set<String> liferayPortletIds = this._readLiferayPortletXML(xmls[2], portletsPool);
            liferayPortletIds.addAll(this._readLiferayPortletXML(xmls[3], portletsPool));
            for (String portletId : portletIds) {
                if (!_log.isWarnEnabled() || liferayPortletIds.contains(portletId)) continue;
                _log.warn((Object)("Portlet with the name " + portletId + " is described in portlet.xml but does not " + "have a matching entry in liferay-portlet.xml"));
            }
            for (String portletId : liferayPortletIds) {
                if (!_log.isWarnEnabled() || portletIds.contains(portletId)) continue;
                _log.warn((Object)("Portlet with the name " + portletId + " is described in liferay-portlet.xml but does " + "not have a matching entry in portlet.xml"));
            }
            Iterator<Map.Entry<String, Portlet>> portletPoolsItr = portletsPool.entrySet().iterator();
            while (portletPoolsItr.hasNext()) {
                Map.Entry<String, Portlet> entry = portletPoolsItr.next();
                Portlet portletModel = entry.getValue();
                if (portletModel.getPortletId().equals("9") || portletModel.getPortletId().equals("2") || portletModel.isInclude()) continue;
                portletPoolsItr.remove();
                _friendlyURLMapperPortlets.remove(portletModel.getPortletId());
            }
            PortletApp portletApp = this._getPortletApp("");
            this._setSpriteImages(servletContext, portletApp, "/html/icons/");
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    @Skip
    public List<Portlet> initWAR(String servletContextName, ServletContext servletContext, String[] xmls, PluginPackage pluginPackage) {
        ArrayList<Portlet> portlets = new ArrayList<Portlet>();
        Map<String, Portlet> portletsPool = this._getPortletsPool();
        try {
            Set<String> servletURLPatterns = this._readWebXML(xmls[3]);
            Set<String> portletIds = this._readPortletXML(servletContextName, servletContext, xmls[0], portletsPool, servletURLPatterns, pluginPackage);
            portletIds.addAll(this._readPortletXML(servletContextName, servletContext, xmls[1], portletsPool, servletURLPatterns, pluginPackage));
            Set<String> liferayPortletIds = this._readLiferayPortletXML(servletContextName, xmls[2], portletsPool);
            for (String portletId : portletIds) {
                if (!_log.isWarnEnabled() || liferayPortletIds.contains(portletId)) continue;
                _log.warn((Object)("Portlet with the name " + portletId + " is described in portlet.xml but does not " + "have a matching entry in liferay-portlet.xml"));
            }
            for (String portletId : liferayPortletIds) {
                if (!_log.isWarnEnabled() || portletIds.contains(portletId)) continue;
                _log.warn((Object)("Portlet with the name " + portletId + " is described in liferay-portlet.xml but does " + "not have a matching entry in portlet.xml"));
            }
            for (String portletId : portletIds) {
                Portlet portlet = this._getPortletsPool().get(portletId);
                portlets.add(portlet);
                PortletInstanceFactoryUtil.clear((Portlet)portlet);
                PortletConfigFactoryUtil.destroy((Portlet)portlet);
                PortletContextFactory.destroy(portlet);
            }
            PortletApp portletApp = this._getPortletApp(servletContextName);
            this._setSpriteImages(servletContext, portletApp, "/icons/");
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        this.clearCache();
        return portlets;
    }

    public Map<String, Portlet> loadGetPortletsPool(long companyId) throws SystemException {
        ConcurrentHashMap<String, Portlet> portletsPool = new ConcurrentHashMap<String, Portlet>();
        Map<String, Portlet> parentPortletsPool = this._getPortletsPool();
        if (parentPortletsPool == null) {
            return portletsPool;
        }
        for (Portlet portlet : parentPortletsPool.values()) {
            portlet = (Portlet)portlet.clone();
            portlet.setCompanyId(companyId);
            portletsPool.put(portlet.getPortletId(), portlet);
        }
        List portlets = this.portletPersistence.findByCompanyId(companyId);
        for (Portlet portlet : portlets) {
            Portlet portletModel = (Portlet)portletsPool.get(portlet.getPortletId());
            if (portletModel == null) continue;
            portletModel.setPluginPackage(portlet.getPluginPackage());
            portletModel.setDefaultPluginSetting(portlet.getDefaultPluginSetting());
            portletModel.setRoles(portlet.getRoles());
            portletModel.setActive(portlet.getActive());
        }
        return portletsPool;
    }

    @Clusterable
    @Transactional(enabled=false)
    public void removeCompanyPortletsPool(long companyId) {
        _companyPortletsPool.remove(companyId);
    }

    public Portlet updatePortlet(long companyId, String portletId, String roles, boolean active) throws SystemException {
        Portlet portlet = this.portletPersistence.fetchByC_P(companyId, portletId = PortalUtil.getJsSafePortletId((String)portletId));
        if (portlet == null) {
            long id = this.counterLocalService.increment();
            portlet = this.portletPersistence.create(id);
            portlet.setCompanyId(companyId);
            portlet.setPortletId(portletId);
        }
        portlet.setRoles(roles);
        portlet.setActive(active);
        this.portletPersistence.update((BaseModel)portlet);
        portlet = this.getPortletById(companyId, portletId);
        portlet.setRoles(roles);
        portlet.setActive(active);
        this.portletLocalService.removeCompanyPortletsPool(companyId);
        return portlet;
    }

    private PortletApp _getPortletApp(String servletContextName) {
        PortletApp portletApp = _portletAppsPool.get(servletContextName);
        if (portletApp == null) {
            portletApp = new PortletAppImpl(servletContextName);
            _portletAppsPool.put(servletContextName, portletApp);
        }
        return portletApp;
    }

    private String _getPortletId(String securityPath) {
        String portletId;
        if (_portletIdsByStrutsPath.isEmpty()) {
            for (Portlet portlet : this._getPortletsPool().values()) {
                String strutsPath = portlet.getStrutsPath();
                if (_portletIdsByStrutsPath.containsKey(strutsPath)) {
                    _log.warn((Object)("Duplicate struts path " + strutsPath));
                }
                _portletIdsByStrutsPath.put(strutsPath, portlet.getPortletId());
            }
        }
        if (Validator.isNull((String)(portletId = _portletIdsByStrutsPath.get(securityPath)))) {
            for (String strutsPath : _portletIdsByStrutsPath.keySet()) {
                if (!securityPath.startsWith(strutsPath.concat("/"))) continue;
                portletId = _portletIdsByStrutsPath.get(strutsPath);
                break;
            }
        }
        if (Validator.isNull((String)portletId)) {
            _log.error((Object)("Struts path " + securityPath + " is not mapped to a portlet " + "in liferay-portlet.xml"));
        }
        return portletId;
    }

    private List<Portlet> _getPortletsByPortletName(String portletName, String servletContextName, Map<String, Portlet> portletsPool) {
        List<Object> portlets = null;
        int pos = portletName.indexOf(42);
        if (pos == -1) {
            Portlet portlet;
            portlets = new ArrayList();
            String portletId = portletName;
            if (Validator.isNotNull((String)servletContextName)) {
                portletId = String.valueOf(portletId) + "_WAR_" + servletContextName;
            }
            if ((portlet = portletsPool.get(portletId = PortalUtil.getJsSafePortletId((String)portletId))) != null) {
                portlets.add(portlet);
            }
            return portlets;
        }
        String portletNamePrefix = portletName.substring(0, pos);
        portlets = this._getPortletsByServletContextName(servletContextName, portletsPool);
        Iterator<Object> itr = portlets.iterator();
        while (itr.hasNext()) {
            Portlet portlet = (Portlet)itr.next();
            String portletId = portlet.getPortletId();
            if (portletId.startsWith(portletNamePrefix)) continue;
            itr.remove();
        }
        return portlets;
    }

    private List<Portlet> _getPortletsByServletContextName(String servletContextName, Map<String, Portlet> portletsPool) {
        ArrayList<Portlet> portlets = new ArrayList<Portlet>();
        String servletContextNameSuffix = servletContextName;
        if (Validator.isNotNull((String)servletContextName)) {
            servletContextNameSuffix = PortalUtil.getJsSafePortletId((String)"_WAR_".concat(servletContextName));
        }
        for (Map.Entry<String, Portlet> entry : portletsPool.entrySet()) {
            String portletId = entry.getKey();
            Portlet portlet = entry.getValue();
            if (Validator.isNotNull((String)servletContextNameSuffix)) {
                if (!portletId.endsWith(servletContextNameSuffix)) continue;
                portlets.add(portlet);
                continue;
            }
            if (portletId.contains("_WAR_")) continue;
            portlets.add(portlet);
        }
        return portlets;
    }

    private Map<String, Portlet> _getPortletsPool() {
        return _portletsPool;
    }

    private Map<String, Portlet> _getPortletsPool(long companyId) throws SystemException {
        Map portletsPool = _companyPortletsPool.get(companyId);
        if (portletsPool == null) {
            portletsPool = this.portletLocalService.loadGetPortletsPool(companyId);
            _companyPortletsPool.put(companyId, portletsPool);
        }
        return portletsPool;
    }

    private void _readLiferayDisplay(String servletContextName, Element element, PortletCategory portletCategory, Set<String> portletIds) {
        for (Element categoryElement : element.elements("category")) {
            String name = categoryElement.attributeValue("name");
            PortletCategory curPortletCategory = new PortletCategory(name);
            portletCategory.addCategory(curPortletCategory);
            Set curPortletIds = curPortletCategory.getPortletIds();
            for (Element portletElement : categoryElement.elements("portlet")) {
                String portletId = portletElement.attributeValue("id");
                if (Validator.isNotNull((String)servletContextName)) {
                    portletId = String.valueOf(portletId) + "_WAR_" + servletContextName;
                }
                portletId = PortalUtil.getJsSafePortletId((String)portletId);
                portletIds.add(portletId);
                curPortletIds.add(portletId);
            }
            this._readLiferayDisplay(servletContextName, categoryElement, curPortletCategory, portletIds);
        }
    }

    private PortletCategory _readLiferayDisplayXML(String xml) throws Exception {
        return this._readLiferayDisplayXML(null, xml);
    }

    private PortletCategory _readLiferayDisplayXML(String servletContextName, String xml) throws Exception {
        PortletCategory portletCategory = new PortletCategory();
        if (xml == null) {
            xml = ContentUtil.get((String)"com/liferay/portal/deploy/dependencies/liferay-display.xml");
        }
        Document document = SAXReaderUtil.read((String)xml, (boolean)true);
        Element rootElement = document.getRootElement();
        HashSet<String> portletIds = new HashSet<String>();
        this._readLiferayDisplay(servletContextName, rootElement, portletCategory, portletIds);
        HashSet<String> undefinedPortletIds = new HashSet<String>();
        for (Portlet portlet : this._getPortletsPool().values()) {
            String portletId = portlet.getPortletId();
            PortletApp portletApp = portlet.getPortletApp();
            if (servletContextName != null && portletApp.isWARFile() && portletId.endsWith("_WAR_" + PortalUtil.getJsSafePortletId((String)servletContextName)) && !portletIds.contains(portletId)) {
                undefinedPortletIds.add(portletId);
                continue;
            }
            if (servletContextName != null || portletApp.isWARFile() || portletId.contains("_WAR_") || portletIds.contains(portletId)) continue;
            undefinedPortletIds.add(portletId);
        }
        if (!undefinedPortletIds.isEmpty()) {
            PortletCategory undefinedCategory = new PortletCategory("category.undefined");
            portletCategory.addCategory(undefinedCategory);
            undefinedCategory.getPortletIds().addAll(undefinedPortletIds);
        }
        return portletCategory;
    }

    private Set<String> _readLiferayPortletXML(String xml, Map<String, Portlet> portletsPool) throws Exception {
        return this._readLiferayPortletXML("", xml, portletsPool);
    }

    private void _readLiferayPortletXML(String servletContextName, Map<String, Portlet> portletsPool, Set<String> liferayPortletIds, Map<String, String> roleMappers, Element portletElement) {
        String portletId = portletElement.elementText("portlet-name");
        if (Validator.isNotNull((String)servletContextName)) {
            portletId = portletId.concat("_WAR_").concat(servletContextName);
        }
        portletId = PortalUtil.getJsSafePortletId((String)portletId);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Reading portlet extension " + portletId));
        }
        liferayPortletIds.add(portletId);
        Portlet portletModel = portletsPool.get(portletId);
        if (portletModel == null) {
            return;
        }
        portletModel.setIcon(GetterUtil.getString((String)portletElement.elementText("icon"), (String)portletModel.getIcon()));
        portletModel.setVirtualPath(GetterUtil.getString((String)portletElement.elementText("virtual-path"), (String)portletModel.getVirtualPath()));
        portletModel.setStrutsPath(GetterUtil.getString((String)portletElement.elementText("struts-path"), (String)portletModel.getStrutsPath()));
        String strutsPath = portletModel.getStrutsPath();
        if (Validator.isNotNull((String)strutsPath)) {
            String strutsPathPortletId;
            if (_portletIdsByStrutsPath.containsKey(strutsPath) && !(strutsPathPortletId = _portletIdsByStrutsPath.get(strutsPath)).equals(portletId)) {
                _log.warn((Object)("Duplicate struts path " + strutsPath));
            }
            _portletIdsByStrutsPath.put(strutsPath, portletId);
        }
        portletModel.setParentStrutsPath(GetterUtil.getString((String)portletElement.elementText("parent-struts-path"), (String)portletModel.getParentStrutsPath()));
        if (Validator.isNotNull((String)portletElement.elementText("configuration-path"))) {
            _log.error((Object)"The configuration-path element is no longer supported. Use configuration-action-class instead.");
        }
        portletModel.setConfigurationActionClass(GetterUtil.getString((String)portletElement.elementText("configuration-action-class"), (String)portletModel.getConfigurationActionClass()));
        ArrayList<String> indexerClasses = new ArrayList<String>();
        for (Element indexerClassElement : portletElement.elements("indexer-class")) {
            indexerClasses.add(indexerClassElement.getText());
        }
        portletModel.setIndexerClasses(indexerClasses);
        portletModel.setOpenSearchClass(GetterUtil.getString((String)portletElement.elementText("open-search-class"), (String)portletModel.getOpenSearchClass()));
        for (Element schedulerEntryElement : portletElement.elements("scheduler-entry")) {
            Element propertyKeyElement;
            SchedulerEntryImpl schedulerEntry = new SchedulerEntryImpl();
            schedulerEntry.setDescription(GetterUtil.getString((String)schedulerEntryElement.elementText("scheduler-description")));
            schedulerEntry.setEventListenerClass(GetterUtil.getString((String)schedulerEntryElement.elementText("scheduler-event-listener-class"), (String)schedulerEntry.getEventListenerClass()));
            Element triggerElement = schedulerEntryElement.element("trigger");
            Element cronElement = triggerElement.element("cron");
            Element simpleElement = triggerElement.element("simple");
            if (cronElement != null) {
                schedulerEntry.setTriggerType(TriggerType.CRON);
                propertyKeyElement = cronElement.element("property-key");
                if (propertyKeyElement != null) {
                    schedulerEntry.setPropertyKey(propertyKeyElement.getTextTrim());
                } else {
                    schedulerEntry.setTriggerValue(cronElement.elementText("cron-trigger-value"));
                }
            } else if (simpleElement != null) {
                schedulerEntry.setTriggerType(TriggerType.SIMPLE);
                propertyKeyElement = simpleElement.element("property-key");
                if (propertyKeyElement != null) {
                    schedulerEntry.setPropertyKey(propertyKeyElement.getTextTrim());
                } else {
                    Element simpleTriggerValueElement = simpleElement.element("simple-trigger-value");
                    schedulerEntry.setTriggerValue(simpleTriggerValueElement.getTextTrim());
                }
                String timeUnit = GetterUtil.getString((String)simpleElement.elementText("time-unit"), (String)TimeUnit.SECOND.getValue());
                schedulerEntry.setTimeUnit(TimeUnit.parse((String)StringUtil.toLowerCase((String)timeUnit)));
            }
            portletModel.addSchedulerEntry((SchedulerEntry)schedulerEntry);
        }
        portletModel.setPortletURLClass(GetterUtil.getString((String)portletElement.elementText("portlet-url-class"), (String)portletModel.getPortletURLClass()));
        portletModel.setFriendlyURLMapperClass(GetterUtil.getString((String)portletElement.elementText("friendly-url-mapper-class"), (String)portletModel.getFriendlyURLMapperClass()));
        if (Validator.isNull((String)portletModel.getFriendlyURLMapperClass())) {
            _friendlyURLMapperPortlets.remove(portletId);
        } else {
            _friendlyURLMapperPortlets.put(portletId, portletModel);
        }
        portletModel.setFriendlyURLMapping(GetterUtil.getString((String)portletElement.elementText("friendly-url-mapping"), (String)portletModel.getFriendlyURLMapping()));
        portletModel.setFriendlyURLRoutes(GetterUtil.getString((String)portletElement.elementText("friendly-url-routes"), (String)portletModel.getFriendlyURLRoutes()));
        portletModel.setURLEncoderClass(GetterUtil.getString((String)portletElement.elementText("url-encoder-class"), (String)portletModel.getURLEncoderClass()));
        String portletDataHandlerClass = GetterUtil.getString((String)portletElement.elementText("portlet-data-handler-class"), (String)portletModel.getPortletDataHandlerClass());
        if (Validator.isNull((String)portletDataHandlerClass)) {
            portletDataHandlerClass = DefaultConfigurationPortletDataHandler.class.getName();
        }
        portletModel.setPortletDataHandlerClass(portletDataHandlerClass);
        ArrayList<String> stagedModelDataHandlerClasses = new ArrayList<String>();
        for (Element stagedModelDataHandlerClassElement : portletElement.elements("staged-model-data-handler-class")) {
            stagedModelDataHandlerClasses.add(stagedModelDataHandlerClassElement.getText());
        }
        portletModel.setStagedModelDataHandlerClasses(stagedModelDataHandlerClasses);
        portletModel.setTemplateHandlerClass(GetterUtil.getString((String)portletElement.elementText("template-handler"), (String)portletModel.getTemplateHandlerClass()));
        portletModel.setPortletLayoutListenerClass(GetterUtil.getString((String)portletElement.elementText("portlet-layout-listener-class"), (String)portletModel.getPortletLayoutListenerClass()));
        portletModel.setPollerProcessorClass(GetterUtil.getString((String)portletElement.elementText("poller-processor-class"), (String)portletModel.getPollerProcessorClass()));
        portletModel.setPopMessageListenerClass(GetterUtil.getString((String)portletElement.elementText("pop-message-listener-class"), (String)portletModel.getPopMessageListenerClass()));
        ArrayList<String> socialActivityInterpreterClasses = new ArrayList<String>();
        for (Element socialActivityInterpreterClassElement : portletElement.elements("social-activity-interpreter-class")) {
            socialActivityInterpreterClasses.add(socialActivityInterpreterClassElement.getText());
        }
        portletModel.setSocialActivityInterpreterClasses(socialActivityInterpreterClasses);
        portletModel.setSocialRequestInterpreterClass(GetterUtil.getString((String)portletElement.elementText("social-request-interpreter-class"), (String)portletModel.getSocialRequestInterpreterClass()));
        portletModel.setUserNotificationDefinitions(GetterUtil.getString((String)portletElement.elementText("user-notification-definitions"), (String)portletModel.getUserNotificationDefinitions()));
        ArrayList<String> userNotificationHandlerClasses = new ArrayList<String>();
        for (Element userNotificationHandlerClassElement : portletElement.elements("user-notification-handler-class")) {
            userNotificationHandlerClasses.add(userNotificationHandlerClassElement.getText());
        }
        portletModel.setUserNotificationHandlerClasses(userNotificationHandlerClasses);
        portletModel.setWebDAVStorageToken(GetterUtil.getString((String)portletElement.elementText("webdav-storage-token"), (String)portletModel.getWebDAVStorageToken()));
        portletModel.setWebDAVStorageClass(GetterUtil.getString((String)portletElement.elementText("webdav-storage-class"), (String)portletModel.getWebDAVStorageClass()));
        portletModel.setXmlRpcMethodClass(GetterUtil.getString((String)portletElement.elementText("xml-rpc-method-class"), (String)portletModel.getXmlRpcMethodClass()));
        String controlPanelEntryCategory = GetterUtil.getString((String)portletElement.elementText("control-panel-entry-category"), (String)portletModel.getControlPanelEntryCategory());
        if (Validator.equals((Object)controlPanelEntryCategory, (Object)"content")) {
            controlPanelEntryCategory = "site_administration.content";
        } else if (Validator.equals((Object)controlPanelEntryCategory, (Object)"marketplace")) {
            controlPanelEntryCategory = "apps";
        } else if (Validator.equals((Object)controlPanelEntryCategory, (Object)"portal")) {
            controlPanelEntryCategory = "users";
        } else if (Validator.equals((Object)controlPanelEntryCategory, (Object)"server")) {
            controlPanelEntryCategory = "apps";
        }
        portletModel.setControlPanelEntryCategory(controlPanelEntryCategory);
        portletModel.setControlPanelEntryWeight(GetterUtil.getDouble((String)portletElement.elementText("control-panel-entry-weight"), (double)portletModel.getControlPanelEntryWeight()));
        portletModel.setControlPanelEntryClass(GetterUtil.getString((String)portletElement.elementText("control-panel-entry-class"), (String)portletModel.getControlPanelEntryClass()));
        ArrayList<String> assetRendererFactoryClasses = new ArrayList<String>();
        for (Element assetRendererFactoryClassElement : portletElement.elements("asset-renderer-factory")) {
            assetRendererFactoryClasses.add(assetRendererFactoryClassElement.getText());
        }
        portletModel.setAssetRendererFactoryClasses(assetRendererFactoryClasses);
        ArrayList<String> atomCollectionAdapterClasses = new ArrayList<String>();
        for (Element atomCollectionAdapterClassElement : portletElement.elements("atom-collection-adapter")) {
            atomCollectionAdapterClasses.add(atomCollectionAdapterClassElement.getText());
        }
        portletModel.setAtomCollectionAdapterClasses(atomCollectionAdapterClasses);
        ArrayList<String> customAttributesDisplayClasses = new ArrayList<String>();
        for (Element customAttributesDisplayClassElement : portletElement.elements("custom-attributes-display")) {
            customAttributesDisplayClasses.add(customAttributesDisplayClassElement.getText());
        }
        portletModel.setCustomAttributesDisplayClasses(customAttributesDisplayClasses);
        if (customAttributesDisplayClasses.isEmpty()) {
            _customAttributesDisplayPortlets.remove(portletId);
        } else {
            _customAttributesDisplayPortlets.put(portletId, portletModel);
        }
        portletModel.setDDMDisplayClass(GetterUtil.getString((String)portletElement.elementText("ddm-display"), (String)portletModel.getDDMDisplayClass()));
        portletModel.setPermissionPropagatorClass(GetterUtil.getString((String)portletElement.elementText("permission-propagator"), (String)portletModel.getPermissionPropagatorClass()));
        ArrayList<String> trashHandlerClasses = new ArrayList<String>();
        for (Element trashHandlerClassElement : portletElement.elements("trash-handler")) {
            trashHandlerClasses.add(trashHandlerClassElement.getText());
        }
        portletModel.setTrashHandlerClasses(trashHandlerClasses);
        ArrayList<String> workflowHandlerClasses = new ArrayList<String>();
        for (Element workflowHandlerClassElement : portletElement.elements("workflow-handler")) {
            workflowHandlerClasses.add(workflowHandlerClassElement.getText());
        }
        portletModel.setWorkflowHandlerClasses(workflowHandlerClasses);
        portletModel.setPreferencesCompanyWide(GetterUtil.getBoolean((String)portletElement.elementText("preferences-company-wide"), (boolean)portletModel.isPreferencesCompanyWide()));
        portletModel.setPreferencesUniquePerLayout(GetterUtil.getBoolean((String)portletElement.elementText("preferences-unique-per-layout"), (boolean)portletModel.isPreferencesUniquePerLayout()));
        portletModel.setPreferencesOwnedByGroup(GetterUtil.getBoolean((String)portletElement.elementText("preferences-owned-by-group"), (boolean)portletModel.isPreferencesOwnedByGroup()));
        portletModel.setUseDefaultTemplate(GetterUtil.getBoolean((String)portletElement.elementText("use-default-template"), (boolean)portletModel.isUseDefaultTemplate()));
        portletModel.setShowPortletAccessDenied(GetterUtil.getBoolean((String)portletElement.elementText("show-portlet-access-denied"), (boolean)portletModel.isShowPortletAccessDenied()));
        portletModel.setShowPortletInactive(GetterUtil.getBoolean((String)portletElement.elementText("show-portlet-inactive"), (boolean)portletModel.isShowPortletInactive()));
        portletModel.setActionURLRedirect(GetterUtil.getBoolean((String)portletElement.elementText("action-url-redirect"), (boolean)portletModel.isActionURLRedirect()));
        portletModel.setRestoreCurrentView(GetterUtil.getBoolean((String)portletElement.elementText("restore-current-view"), (boolean)portletModel.isRestoreCurrentView()));
        portletModel.setMaximizeEdit(GetterUtil.getBoolean((String)portletElement.elementText("maximize-edit"), (boolean)portletModel.isMaximizeEdit()));
        portletModel.setMaximizeHelp(GetterUtil.getBoolean((String)portletElement.elementText("maximize-help"), (boolean)portletModel.isMaximizeHelp()));
        portletModel.setPopUpPrint(GetterUtil.getBoolean((String)portletElement.elementText("pop-up-print"), (boolean)portletModel.isPopUpPrint()));
        portletModel.setLayoutCacheable(GetterUtil.getBoolean((String)portletElement.elementText("layout-cacheable"), (boolean)portletModel.isLayoutCacheable()));
        portletModel.setInstanceable(GetterUtil.getBoolean((String)portletElement.elementText("instanceable"), (boolean)portletModel.isInstanceable()));
        portletModel.setRemoteable(GetterUtil.getBoolean((String)portletElement.elementText("remoteable"), (boolean)portletModel.isRemoteable()));
        portletModel.setScopeable(GetterUtil.getBoolean((String)portletElement.elementText("scopeable"), (boolean)portletModel.isScopeable()));
        portletModel.setUserPrincipalStrategy(GetterUtil.getString((String)portletElement.elementText("user-principal-strategy"), (String)portletModel.getUserPrincipalStrategy()));
        portletModel.setPrivateRequestAttributes(GetterUtil.getBoolean((String)portletElement.elementText("private-request-attributes"), (boolean)portletModel.isPrivateRequestAttributes()));
        portletModel.setPrivateSessionAttributes(GetterUtil.getBoolean((String)portletElement.elementText("private-session-attributes"), (boolean)portletModel.isPrivateSessionAttributes()));
        Element autopropagatedParametersElement = portletElement.element("autopropagated-parameters");
        HashSet<String> autopropagatedParameters = new HashSet<String>();
        if (autopropagatedParametersElement != null) {
            String[] autopropagatedParametersArray = StringUtil.split((String)autopropagatedParametersElement.getText());
            String[] stringArray = autopropagatedParametersArray;
            int n = autopropagatedParametersArray.length;
            int n2 = 0;
            while (n2 < n) {
                String autopropagatedParameter = stringArray[n2];
                autopropagatedParameters.add(autopropagatedParameter);
                ++n2;
            }
        }
        portletModel.setAutopropagatedParameters(autopropagatedParameters);
        portletModel.setRequiresNamespacedParameters(GetterUtil.getBoolean((String)portletElement.elementText("requires-namespaced-parameters"), (boolean)portletModel.isRequiresNamespacedParameters()));
        portletModel.setActionTimeout(GetterUtil.getInteger((String)portletElement.elementText("action-timeout"), (int)portletModel.getActionTimeout()));
        portletModel.setRenderTimeout(GetterUtil.getInteger((String)portletElement.elementText("render-timeout"), (int)portletModel.getRenderTimeout()));
        portletModel.setRenderWeight(GetterUtil.getInteger((String)portletElement.elementText("render-weight"), (int)portletModel.getRenderWeight()));
        portletModel.setAjaxable(GetterUtil.getBoolean((String)portletElement.elementText("ajaxable"), (boolean)portletModel.isAjaxable()));
        ArrayList<String> headerPortalCssList = new ArrayList<String>();
        for (Element headerPortalCssElement : portletElement.elements("header-portal-css")) {
            headerPortalCssList.add(headerPortalCssElement.getText());
        }
        portletModel.setHeaderPortalCss(headerPortalCssList);
        ArrayList<String> headerPortletCssList = new ArrayList<String>();
        for (Element headerPortletCssElement : portletElement.elements("header-portlet-css")) {
            headerPortletCssList.add(headerPortletCssElement.getText());
        }
        portletModel.setHeaderPortletCss(headerPortletCssList);
        ArrayList<String> headerPortalJavaScriptList = new ArrayList<String>();
        for (Element headerPortalJavaScriptElement : portletElement.elements("header-portal-javascript")) {
            headerPortalJavaScriptList.add(headerPortalJavaScriptElement.getText());
        }
        portletModel.setHeaderPortalJavaScript(headerPortalJavaScriptList);
        ArrayList<String> headerPortletJavaScriptList = new ArrayList<String>();
        for (Element headerPortletJavaScriptElement : portletElement.elements("header-portlet-javascript")) {
            headerPortletJavaScriptList.add(headerPortletJavaScriptElement.getText());
        }
        portletModel.setHeaderPortletJavaScript(headerPortletJavaScriptList);
        ArrayList<String> footerPortalCssList = new ArrayList<String>();
        for (Element footerPortalCssElement : portletElement.elements("footer-portal-css")) {
            footerPortalCssList.add(footerPortalCssElement.getText());
        }
        portletModel.setFooterPortalCss(footerPortalCssList);
        ArrayList<String> footerPortletCssList = new ArrayList<String>();
        for (Element footerPortletCssElement : portletElement.elements("footer-portlet-css")) {
            footerPortletCssList.add(footerPortletCssElement.getText());
        }
        portletModel.setFooterPortletCss(footerPortletCssList);
        ArrayList<String> footerPortalJavaScriptList = new ArrayList<String>();
        for (Element footerPortalJavaScriptElement : portletElement.elements("footer-portal-javascript")) {
            footerPortalJavaScriptList.add(footerPortalJavaScriptElement.getText());
        }
        portletModel.setFooterPortalJavaScript(footerPortalJavaScriptList);
        ArrayList<String> footerPortletJavaScriptList = new ArrayList<String>();
        for (Element footerPortletJavaScriptElement : portletElement.elements("footer-portlet-javascript")) {
            footerPortletJavaScriptList.add(footerPortletJavaScriptElement.getText());
        }
        portletModel.setFooterPortletJavaScript(footerPortletJavaScriptList);
        portletModel.setCssClassWrapper(GetterUtil.getString((String)portletElement.elementText("css-class-wrapper"), (String)portletModel.getCssClassWrapper()));
        portletModel.setFacebookIntegration(GetterUtil.getString((String)portletElement.elementText("facebook-integration"), (String)portletModel.getFacebookIntegration()));
        portletModel.setAddDefaultResource(GetterUtil.getBoolean((String)portletElement.elementText("add-default-resource"), (boolean)portletModel.isAddDefaultResource()));
        portletModel.setSystem(GetterUtil.getBoolean((String)portletElement.elementText("system"), (boolean)portletModel.isSystem()));
        portletModel.setActive(GetterUtil.getBoolean((String)portletElement.elementText("active"), (boolean)portletModel.isActive()));
        portletModel.setInclude(GetterUtil.getBoolean((String)portletElement.elementText("include"), (boolean)portletModel.isInclude()));
        if (Validator.isNull((String)servletContextName)) {
            portletModel.setReady(true);
        }
        if (!portletModel.isAjaxable() && portletModel.getRenderWeight() < 1) {
            portletModel.setRenderWeight(1);
        }
        portletModel.getRoleMappers().putAll(roleMappers);
        portletModel.linkRoles();
    }

    private Set<String> _readLiferayPortletXML(String servletContextName, String xml, Map<String, Portlet> portletsPool) throws Exception {
        HashSet<String> liferayPortletIds = new HashSet<String>();
        if (xml == null) {
            return liferayPortletIds;
        }
        Document document = SAXReaderUtil.read((String)xml, (boolean)true);
        Element rootElement = document.getRootElement();
        PortletApp portletApp = this._getPortletApp(servletContextName);
        HashMap<String, String> roleMappers = new HashMap<String, String>();
        for (Element roleMapperElement : rootElement.elements("role-mapper")) {
            String roleName = roleMapperElement.elementText("role-name");
            String roleLink = roleMapperElement.elementText("role-link");
            roleMappers.put(roleName, roleLink);
        }
        Map customUserAttributes = portletApp.getCustomUserAttributes();
        for (Element customUserAttributeElement : rootElement.elements("custom-user-attribute")) {
            String customClass = customUserAttributeElement.elementText("custom-class");
            for (Element nameElement : customUserAttributeElement.elements("name")) {
                String name = nameElement.getText();
                customUserAttributes.put(name, customClass);
            }
        }
        for (Element portletElement : rootElement.elements("portlet")) {
            this._readLiferayPortletXML(servletContextName, portletsPool, liferayPortletIds, roleMappers, portletElement);
        }
        return liferayPortletIds;
    }

    private Set<String> _readPortletXML(ServletContext servletContext, String xml, Map<String, Portlet> portletsPool, Set<String> servletURLPatterns, PluginPackage pluginPackage) throws Exception {
        return this._readPortletXML("", servletContext, xml, portletsPool, servletURLPatterns, pluginPackage);
    }

    private void _readPortletXML(String servletContextName, Map<String, Portlet> portletsPool, PluginPackage pluginPackage, PortletApp portletApp, Set<String> portletIds, long timestamp, Element portletElement) throws PortletIdException {
        Portlet portletModel;
        block23: {
            String portletName;
            String portletId = portletName = portletElement.elementText("portlet-name");
            if (Validator.isNotNull((String)servletContextName)) {
                portletId = portletId.concat("_WAR_").concat(servletContextName);
            }
            if ((portletId = PortalUtil.getJsSafePortletId((String)portletId)).length() > _PORTLET_ID_MAX_LENGTH) {
                throw new PortletIdException("Portlet id " + portletId + " has more than " + _PORTLET_ID_MAX_LENGTH + " characters");
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Reading portlet " + portletId));
            }
            portletIds.add(portletId);
            portletModel = portletsPool.get(portletId);
            if (portletModel == null) {
                portletModel = new PortletImpl(0L, portletId);
                portletsPool.put(portletId, portletModel);
            }
            portletModel.setTimestamp(timestamp);
            portletModel.setPluginPackage(pluginPackage);
            portletModel.setPortletApp(portletApp);
            portletModel.setPortletName(portletName);
            portletModel.setDisplayName(GetterUtil.getString((String)portletElement.elementText("display-name"), (String)portletModel.getDisplayName()));
            portletModel.setPortletClass(GetterUtil.getString((String)portletElement.elementText("portlet-class")));
            HashMap<String, String> initParams = new HashMap<String, String>();
            for (Element initParamElement : portletElement.elements("init-param")) {
                initParams.put(initParamElement.elementText("name"), initParamElement.elementText("value"));
            }
            portletModel.setInitParams(initParams);
            Element expirationCacheElement = portletElement.element("expiration-cache");
            if (expirationCacheElement != null) {
                portletModel.setExpCache(Integer.valueOf(GetterUtil.getInteger((String)expirationCacheElement.getText())));
            }
            HashMap portletModes = new HashMap();
            HashMap windowStates = new HashMap();
            for (Element supportsElement : portletElement.elements("supports")) {
                String mimeType = supportsElement.elementText("mime-type");
                HashSet<String> mimeTypePortletModes = new HashSet<String>();
                mimeTypePortletModes.add(StringUtil.toLowerCase((String)PortletMode.VIEW.toString()));
                for (Element portletModeElement : supportsElement.elements("portlet-mode")) {
                    mimeTypePortletModes.add(StringUtil.toLowerCase((String)portletModeElement.getTextTrim()));
                }
                portletModes.put(mimeType, mimeTypePortletModes);
                HashSet<String> mimeTypeWindowStates = new HashSet<String>();
                mimeTypeWindowStates.add(StringUtil.toLowerCase((String)WindowState.NORMAL.toString()));
                List windowStateElements = supportsElement.elements("window-state");
                if (windowStateElements.isEmpty()) {
                    mimeTypeWindowStates.add(StringUtil.toLowerCase((String)WindowState.MAXIMIZED.toString()));
                    mimeTypeWindowStates.add(StringUtil.toLowerCase((String)WindowState.MINIMIZED.toString()));
                    mimeTypeWindowStates.add(StringUtil.toLowerCase((String)LiferayWindowState.EXCLUSIVE.toString()));
                    mimeTypeWindowStates.add(StringUtil.toLowerCase((String)LiferayWindowState.POP_UP.toString()));
                }
                for (Element windowStateElement : windowStateElements) {
                    mimeTypeWindowStates.add(StringUtil.toLowerCase((String)windowStateElement.getTextTrim()));
                }
                windowStates.put(mimeType, mimeTypeWindowStates);
            }
            portletModel.setPortletModes(portletModes);
            portletModel.setWindowStates(windowStates);
            HashSet<String> supportedLocales = new HashSet<String>();
            for (Element supportedLocaleElement : portletElement.elements("supported-locale")) {
                String supportedLocale = supportedLocaleElement.getText();
                supportedLocales.add(supportedLocale);
            }
            portletModel.setSupportedLocales(supportedLocales);
            portletModel.setResourceBundle(portletElement.elementText("resource-bundle"));
            Element portletInfoElement = portletElement.element("portlet-info");
            String portletInfoTitle = null;
            String portletInfoShortTitle = null;
            String portletInfoKeyWords = null;
            String portletInfoDescription = null;
            if (portletInfoElement != null) {
                portletInfoTitle = portletInfoElement.elementText("title");
                portletInfoShortTitle = portletInfoElement.elementText("short-title");
                portletInfoKeyWords = portletInfoElement.elementText("keywords");
            }
            PortletInfo portletInfo = new PortletInfo(portletInfoTitle, portletInfoShortTitle, portletInfoKeyWords, portletInfoDescription);
            portletModel.setPortletInfo(portletInfo);
            Element portletPreferencesElement = portletElement.element("portlet-preferences");
            String defaultPreferences = null;
            String preferencesValidator = null;
            if (portletPreferencesElement != null) {
                Element preferencesValidatorElement = portletPreferencesElement.element("preferences-validator");
                if (preferencesValidatorElement != null) {
                    preferencesValidator = preferencesValidatorElement.getText();
                    portletPreferencesElement.remove(preferencesValidatorElement);
                }
                defaultPreferences = portletPreferencesElement.asXML();
            }
            portletModel.setDefaultPreferences(defaultPreferences);
            portletModel.setPreferencesValidator(preferencesValidator);
            if (!portletApp.isWARFile() && Validator.isNotNull((String)preferencesValidator) && PropsValues.PREFERENCE_VALIDATE_ON_STARTUP) {
                try {
                    PreferencesValidator preferencesValidatorObj = PortalUtil.getPreferencesValidator((Portlet)portletModel);
                    preferencesValidatorObj.validate(PortletPreferencesFactoryUtil.fromDefaultXML((String)defaultPreferences));
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block23;
                    _log.warn((Object)("Portlet with the name " + portletId + " does not have valid default preferences"));
                }
            }
        }
        HashSet<String> unlinkedRoles = new HashSet<String>();
        for (Element roleElement : portletElement.elements("security-role-ref")) {
            unlinkedRoles.add(roleElement.elementText("role-name"));
        }
        portletModel.setUnlinkedRoles(unlinkedRoles);
        HashSet<QName> processingEvents = new HashSet<QName>();
        for (Element supportedProcessingEventElement : portletElement.elements("supported-processing-event")) {
            Element qNameElement = supportedProcessingEventElement.element("qname");
            Element nameElement = supportedProcessingEventElement.element("name");
            QName qName = PortletQNameUtil.getQName((Element)qNameElement, (Element)nameElement, (String)portletApp.getDefaultNamespace());
            processingEvents.add(qName);
            Set eventDefinitions = portletApp.getEventDefinitions();
            for (EventDefinition eventDefinition : eventDefinitions) {
                Set qNames = eventDefinition.getQNames();
                if (!qNames.contains(qName)) continue;
                processingEvents.addAll(qNames);
            }
        }
        portletModel.setProcessingEvents(processingEvents);
        HashSet<QName> publishingEvents = new HashSet<QName>();
        for (Element supportedPublishingEventElement : portletElement.elements("supported-publishing-event")) {
            Element qNameElement = supportedPublishingEventElement.element("qname");
            Element nameElement = supportedPublishingEventElement.element("name");
            QName qName = PortletQNameUtil.getQName((Element)qNameElement, (Element)nameElement, (String)portletApp.getDefaultNamespace());
            publishingEvents.add(qName);
        }
        portletModel.setPublishingEvents(publishingEvents);
        HashSet<PublicRenderParameter> publicRenderParameters = new HashSet<PublicRenderParameter>();
        for (Element supportedPublicRenderParameter : portletElement.elements("supported-public-render-parameter")) {
            String identifier = supportedPublicRenderParameter.getTextTrim();
            PublicRenderParameter publicRenderParameter = portletApp.getPublicRenderParameter(identifier);
            if (publicRenderParameter == null) {
                _log.error((Object)("Supported public render parameter references unnknown identifier " + identifier));
                continue;
            }
            publicRenderParameters.add(publicRenderParameter);
        }
        portletModel.setPublicRenderParameters(publicRenderParameters);
    }

    private Set<String> _readPortletXML(String servletContextName, ServletContext servletContext, String xml, Map<String, Portlet> portletsPool, Set<String> servletURLPatterns, PluginPackage pluginPackage) throws Exception {
        PortletFilter portletFilter;
        String filterName;
        Object qName;
        HashSet<String> portletIds = new HashSet<String>();
        if (xml == null) {
            return portletIds;
        }
        Document document = SAXReaderUtil.read((String)xml, (boolean)PropsValues.PORTLET_XML_VALIDATE);
        Element rootElement = document.getRootElement();
        PortletApp portletApp = this._getPortletApp(servletContextName);
        portletApp.addServletURLPatterns(servletURLPatterns);
        Set userAttributes = portletApp.getUserAttributes();
        for (Element userAttributeElement : rootElement.elements("user-attribute")) {
            String name = userAttributeElement.elementText("name");
            userAttributes.add(name);
        }
        String defaultNamespace = rootElement.elementText("default-namespace");
        if (Validator.isNotNull((String)defaultNamespace)) {
            portletApp.setDefaultNamespace(defaultNamespace);
        }
        for (Element eventDefinitionElement : rootElement.elements("event-definition")) {
            Element qNameElement = eventDefinitionElement.element("qname");
            Element nameElement = eventDefinitionElement.element("name");
            String valueType = eventDefinitionElement.elementText("value-type");
            qName = PortletQNameUtil.getQName((Element)qNameElement, (Element)nameElement, (String)portletApp.getDefaultNamespace());
            EventDefinitionImpl eventDefinition = new EventDefinitionImpl((QName)qName, valueType, portletApp);
            List aliases = eventDefinitionElement.elements("alias");
            for (Object alias : aliases) {
                qName = PortletQNameUtil.getQName((Element)alias, null, (String)portletApp.getDefaultNamespace());
                eventDefinition.addAliasQName((QName)qName);
            }
            portletApp.addEventDefinition((EventDefinition)eventDefinition);
        }
        for (Element publicRenderParameterElement : rootElement.elements("public-render-parameter")) {
            String identifier = publicRenderParameterElement.elementText("identifier");
            Element qNameElement = publicRenderParameterElement.element("qname");
            Element nameElement = publicRenderParameterElement.element("name");
            qName = PortletQNameUtil.getQName((Element)qNameElement, (Element)nameElement, (String)portletApp.getDefaultNamespace());
            PublicRenderParameterImpl publicRenderParameter = new PublicRenderParameterImpl(identifier, (QName)qName, portletApp);
            portletApp.addPublicRenderParameter((PublicRenderParameter)publicRenderParameter);
        }
        for (Element containerRuntimeOptionElement : rootElement.elements("container-runtime-option")) {
            String name = GetterUtil.getString((String)containerRuntimeOptionElement.elementText("name"));
            ArrayList<String> values = new ArrayList<String>();
            for (Element valueElement : containerRuntimeOptionElement.elements("value")) {
                values.add(valueElement.getTextTrim());
            }
            Map containerRuntimeOptions = portletApp.getContainerRuntimeOptions();
            containerRuntimeOptions.put(name, values.toArray(new String[values.size()]));
            if (!name.equals("com.liferay.portal.portalContext") || values.isEmpty() || !GetterUtil.getBoolean((String)((String)values.get(0)))) continue;
            portletApp.setWARFile(false);
        }
        long timestamp = ServletContextUtil.getLastModified((ServletContext)servletContext);
        for (Element portletElement : rootElement.elements("portlet")) {
            this._readPortletXML(servletContextName, portletsPool, pluginPackage, portletApp, portletIds, timestamp, portletElement);
        }
        for (Element filterElement : rootElement.elements("filter")) {
            filterName = filterElement.elementText("filter-name");
            String filterClass = filterElement.elementText("filter-class");
            LinkedHashSet<String> lifecycles = new LinkedHashSet<String>();
            for (Element lifecycleElement : filterElement.elements("lifecycle")) {
                lifecycles.add(lifecycleElement.getText());
            }
            HashMap<String, String> initParams = new HashMap<String, String>();
            for (Element initParamElement : filterElement.elements("init-param")) {
                initParams.put(initParamElement.elementText("name"), initParamElement.elementText("value"));
            }
            portletFilter = new PortletFilterImpl(filterName, filterClass, lifecycles, initParams, portletApp);
            portletApp.addPortletFilter(portletFilter);
        }
        for (Element filterMappingElement : rootElement.elements("filter-mapping")) {
            filterName = filterMappingElement.elementText("filter-name");
            for (Element portletNameElement : filterMappingElement.elements("portlet-name")) {
                String portletName = portletNameElement.getTextTrim();
                portletFilter = portletApp.getPortletFilter(filterName);
                if (portletFilter == null) {
                    _log.error((Object)("Filter mapping references unnknown filter name " + filterName));
                    continue;
                }
                List<Portlet> portletModels = this._getPortletsByPortletName(portletName, servletContextName, portletsPool);
                if (portletModels.size() == 0) {
                    _log.error((Object)("Filter mapping with filter name " + filterName + " references unnknown portlet name " + portletName));
                }
                for (Portlet portletModel : portletModels) {
                    portletModel.getPortletFilters().put(filterName, portletFilter);
                }
            }
        }
        for (Element listenerElement : rootElement.elements("listener")) {
            String listenerClass = listenerElement.elementText("listener-class");
            PortletURLListenerImpl portletURLListener = new PortletURLListenerImpl(listenerClass, portletApp);
            portletApp.addPortletURLListener((PortletURLListener)portletURLListener);
        }
        return portletIds;
    }

    private Set<String> _readWebXML(String xml) throws Exception {
        LinkedHashSet<String> servletURLPatterns = new LinkedHashSet<String>();
        if (xml == null) {
            return servletURLPatterns;
        }
        Document document = SAXReaderUtil.read((String)xml);
        Element rootElement = document.getRootElement();
        for (Element servletMappingElement : rootElement.elements("servlet-mapping")) {
            String urlPattern = servletMappingElement.elementText("url-pattern");
            servletURLPatterns.add(urlPattern);
        }
        return servletURLPatterns;
    }

    private void _setSpriteImages(ServletContext servletContext, PortletApp portletApp, String resourcePath) throws Exception {
        String rootPath;
        String spritePropertiesFileName;
        Set resourcePaths = servletContext.getResourcePaths(resourcePath);
        if (resourcePaths == null || resourcePaths.isEmpty()) {
            return;
        }
        ArrayList<URL> imageURLs = new ArrayList<URL>(resourcePaths.size());
        for (String curResourcePath : resourcePaths) {
            if (curResourcePath.endsWith("/")) {
                this._setSpriteImages(servletContext, portletApp, curResourcePath);
                continue;
            }
            if (!curResourcePath.endsWith(".png")) continue;
            URL imageURL = servletContext.getResource(curResourcePath);
            if (imageURL != null) {
                imageURLs.add(imageURL);
                continue;
            }
            _log.error((Object)("Resource URL for " + curResourcePath + " is null"));
        }
        String spriteRootDirName = PropsValues.SPRITE_ROOT_DIR;
        String spriteFileName = resourcePath.concat(PropsValues.SPRITE_FILE_NAME);
        Properties spriteProperties = SpriteProcessorUtil.generate((ServletContext)servletContext, imageURLs, (String)spriteRootDirName, (String)spriteFileName, (String)(spritePropertiesFileName = resourcePath.concat(PropsValues.SPRITE_PROPERTIES_FILE_NAME)), (String)(rootPath = ServletContextUtil.getRootPath((ServletContext)servletContext)), (int)16, (int)16, (int)10240);
        if (spriteProperties == null) {
            return;
        }
        String contextPath = ContextPathUtil.getContextPath((ServletContext)servletContext);
        spriteFileName = contextPath.concat("/sprite").concat(spriteFileName);
        portletApp.setSpriteImages(spriteFileName, spriteProperties);
    }
}

