/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UniqueList;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.membershippolicy.SiteMembershipPolicyUtil;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.GroupServiceBaseImpl;
import com.liferay.portal.service.permission.GroupPermissionUtil;
import com.liferay.portal.service.permission.PortalPermissionUtil;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import com.liferay.portal.service.permission.RolePermissionUtil;
import com.liferay.portal.service.permission.UserPermissionUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.expando.model.ExpandoBridge;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GroupServiceImpl
extends GroupServiceBaseImpl {
    public Group addGroup(long parentGroupId, long liveGroupId, String name, String description, int type, boolean manualMembership, int membershipRestriction, String friendlyURL, boolean site, boolean active, ServiceContext serviceContext) throws PortalException, SystemException {
        if (parentGroupId == 0L) {
            PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"ADD_COMMUNITY");
        } else {
            GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)parentGroupId, (String)"ADD_COMMUNITY");
        }
        Group group = this.groupLocalService.addGroup(this.getUserId(), parentGroupId, null, 0L, liveGroupId, name, description, type, manualMembership, membershipRestriction, friendlyURL, site, active, serviceContext);
        if (site) {
            SiteMembershipPolicyUtil.verifyPolicy((Group)group);
        }
        return group;
    }

    public Group addGroup(long parentGroupId, String name, String description, int type, String friendlyURL, boolean site, boolean active, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.addGroup(parentGroupId, 0L, name, description, type, true, 0, friendlyURL, site, active, serviceContext);
    }

    public Group addGroup(String name, String description, int type, String friendlyURL, boolean site, boolean active, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.addGroup(0L, name, description, type, friendlyURL, site, active, serviceContext);
    }

    public void addRoleGroups(long roleId, long[] groupIds) throws PortalException, SystemException {
        RolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)roleId, (String)"UPDATE");
        this.groupLocalService.addRoleGroups(roleId, groupIds);
    }

    public void checkRemoteStagingGroup(long groupId) throws PortalException, SystemException {
        Group group = this.getGroup(groupId);
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (group.getCompanyId() != permissionChecker.getCompanyId()) {
            throw new NoSuchGroupException("Group " + groupId + " does not belong in company " + permissionChecker.getCompanyId());
        }
    }

    public void deleteGroup(long groupId) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"DELETE");
        this.groupLocalService.deleteGroup(groupId);
    }

    public void disableStaging(long groupId) throws PortalException, SystemException {
        Group group = this.groupLocalService.getGroup(groupId);
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Group)group, (String)"UPDATE");
        this.groupLocalService.disableStaging(groupId);
    }

    public void enableStaging(long groupId) throws PortalException, SystemException {
        Group group = this.groupLocalService.getGroup(groupId);
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Group)group, (String)"UPDATE");
        this.groupLocalService.enableStaging(groupId);
    }

    public Group getCompanyGroup(long companyId) throws PortalException, SystemException {
        Group group = this.groupLocalService.getCompanyGroup(companyId);
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)group.getGroupId(), (String)"VIEW");
        return group;
    }

    public Group getGroup(long groupId) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"VIEW");
        return this.groupLocalService.getGroup(groupId);
    }

    public Group getGroup(long companyId, String name) throws PortalException, SystemException {
        Group group = this.groupLocalService.getGroup(companyId, name);
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)group.getGroupId(), (String)"VIEW");
        return group;
    }

    public List<Group> getGroups(long companyId, long parentGroupId, boolean site) throws PortalException, SystemException {
        return this.filterGroups(this.groupLocalService.getGroups(companyId, parentGroupId, site));
    }

    public List<Group> getManageableSiteGroups(Collection<Portlet> portlets, int max) throws PortalException, SystemException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (permissionChecker.isCompanyAdmin()) {
            LinkedHashMap<String, Boolean> params = new LinkedHashMap<String, Boolean>();
            params.put("site", Boolean.TRUE);
            return this.groupLocalService.search(permissionChecker.getCompanyId(), null, null, null, params, true, 0, max);
        }
        UniqueList groups = new UniqueList();
        List<Group> userSitesGroups = this.getUserSitesGroups(null, max);
        for (Group group : userSitesGroups) {
            if (!group.isSite() || !PortletPermissionUtil.hasControlPanelAccessPermission((PermissionChecker)permissionChecker, (long)group.getGroupId(), portlets)) continue;
            groups.add(group);
        }
        return groups;
    }

    public List<Group> getManageableSites(Collection<Portlet> portlets, int max) throws PortalException, SystemException {
        return this.getManageableSiteGroups(portlets, max);
    }

    public List<Group> getOrganizationsGroups(List<Organization> organizations) throws PortalException, SystemException {
        List groups = this.groupLocalService.getOrganizationsGroups(organizations);
        return this.filterGroups(groups);
    }

    public Group getUserGroup(long companyId, long userId) throws PortalException, SystemException {
        Group group = this.groupLocalService.getUserGroup(companyId, userId);
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)group.getGroupId(), (String)"VIEW");
        return group;
    }

    public List<Group> getUserGroupsGroups(List<UserGroup> userGroups) throws PortalException, SystemException {
        List groups = this.groupLocalService.getUserGroupsGroups(userGroups);
        return this.filterGroups(groups);
    }

    public List<Group> getUserOrganizationsGroups(long userId, int start, int end) throws PortalException, SystemException {
        List groups = this.groupLocalService.getUserOrganizationsGroups(userId, start, end);
        return this.filterGroups(groups);
    }

    public List<Group> getUserPlaces(long userId, String[] classNames, boolean includeControlPanel, int max) throws PortalException, SystemException {
        return this.getUserSitesGroups(userId, classNames, includeControlPanel, max);
    }

    public List<Group> getUserPlaces(long userId, String[] classNames, int max) throws PortalException, SystemException {
        return this.getUserSitesGroups(userId, classNames, max);
    }

    public List<Group> getUserPlaces(long userId, String[] classNames, String name, boolean active, boolean includeControlPanel, int start, int end) throws PortalException, SystemException {
        return this.getUserSitesGroups(userId, classNames, name, active, includeControlPanel, start, end);
    }

    public List<Group> getUserPlaces(String[] classNames, int max) throws PortalException, SystemException {
        return this.getUserSitesGroups(classNames, max);
    }

    public int getUserPlacesCount() throws PortalException, SystemException {
        return this.getUserSitesGroupsCount();
    }

    public List<Group> getUserSites() throws PortalException, SystemException {
        return this.getUserSitesGroups();
    }

    public List<Group> getUserSitesGroups() throws PortalException, SystemException {
        return this.getUserSitesGroups(null, -1);
    }

    public List<Group> getUserSitesGroups(long userId, String[] classNames, boolean includeControlPanel, int max) throws PortalException, SystemException {
        return this.getUserSitesGroups(userId, classNames, null, true, includeControlPanel, -1, max);
    }

    public List<Group> getUserSitesGroups(long userId, String[] classNames, int max) throws PortalException, SystemException {
        return this.getUserSitesGroups(userId, classNames, false, max);
    }

    public List<Group> getUserSitesGroups(long userId, String[] classNames, String name, boolean active, boolean includeControlPanel, int start, int end) throws PortalException, SystemException {
        PermissionChecker permissionChecker;
        User user = this.userPersistence.fetchByPrimaryKey(userId);
        if (user.isDefaultUser()) {
            return Collections.emptyList();
        }
        UniqueList userSiteGroups = new UniqueList();
        if (classNames == null || ArrayUtil.contains((Object[])classNames, (Object)Group.class.getName())) {
            LinkedHashMap<String, Comparable<Boolean>> groupParams = new LinkedHashMap<String, Comparable<Boolean>>();
            groupParams.put("active", Boolean.valueOf(active));
            groupParams.put("usersGroups", new Long(userId));
            userSiteGroups.addAll(this.groupLocalService.search(user.getCompanyId(), name, groupParams, start, end));
        }
        if (classNames == null || ArrayUtil.contains((Object[])classNames, (Object)Organization.class.getName())) {
            List userOrgs = this.organizationLocalService.getOrganizations(userId, start, end, null);
            for (Organization organization : userOrgs) {
                if (!organization.hasPrivateLayouts() && !organization.hasPublicLayouts()) {
                    userSiteGroups.remove(organization.getGroup());
                } else {
                    userSiteGroups.add(0, organization.getGroup());
                }
                if (PropsValues.ORGANIZATIONS_MEMBERSHIP_STRICT) continue;
                for (Organization ancestorOrganization : organization.getAncestors()) {
                    if (!organization.hasPrivateLayouts() && !organization.hasPublicLayouts()) continue;
                    userSiteGroups.add(0, ancestorOrganization.getGroup());
                }
            }
        }
        if ((classNames == null || ArrayUtil.contains((Object[])classNames, (Object)User.class.getName())) && (PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_ENABLED || PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_ENABLED)) {
            Group userGroup = user.getGroup();
            userSiteGroups.add(0, userGroup);
        }
        if ((permissionChecker = this.getPermissionChecker()).getUserId() != userId) {
            try {
                permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
            }
            catch (Exception e2) {
                throw new PrincipalException((Throwable)e2);
            }
        }
        if (includeControlPanel && PortalPermissionUtil.contains((PermissionChecker)permissionChecker, (String)"VIEW_CONTROL_PANEL")) {
            Group controlPanelGroup = this.groupLocalService.getGroup(user.getCompanyId(), "Control Panel");
            userSiteGroups.add(0, controlPanelGroup);
        }
        return Collections.unmodifiableList(ListUtil.subList((List)userSiteGroups, (int)start, (int)end));
    }

    public List<Group> getUserSitesGroups(String[] classNames, int max) throws PortalException, SystemException {
        return this.getUserSitesGroups(this.getGuestOrUserId(), classNames, false, max);
    }

    public int getUserSitesGroupsCount() throws PortalException, SystemException {
        List<Group> userSitesGroups = this.getUserSitesGroups(this.getGuestOrUserId(), null, true, -1);
        return userSitesGroups.size();
    }

    public boolean hasUserGroup(long userId, long groupId) throws PortalException, SystemException {
        try {
            UserPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)userId, (String)"VIEW");
        }
        catch (PrincipalException principalException) {
            GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"VIEW_MEMBERS");
        }
        return this.groupLocalService.hasUserGroup(userId, groupId);
    }

    public List<Group> search(long companyId, String name, String description, String[] params, int start, int end) throws PortalException, SystemException {
        if (params == null) {
            params = new String[]{};
        }
        LinkedHashMap paramsObj = MapUtil.toLinkedHashMap((String[])params);
        List groups = this.groupLocalService.search(companyId, name, description, paramsObj, true, start, end);
        return this.filterGroups(groups);
    }

    public int searchCount(long companyId, String name, String description, String[] params) throws SystemException {
        if (params == null) {
            params = new String[]{};
        }
        LinkedHashMap paramsObj = MapUtil.toLinkedHashMap((String[])params);
        return this.groupLocalService.searchCount(companyId, name, description, paramsObj, true);
    }

    public void setRoleGroups(long roleId, long[] groupIds) throws PortalException, SystemException {
        RolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)roleId, (String)"ASSIGN_MEMBERS");
        this.groupLocalService.setRoleGroups(roleId, groupIds);
    }

    public void unsetRoleGroups(long roleId, long[] groupIds) throws PortalException, SystemException {
        RolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)roleId, (String)"ASSIGN_MEMBERS");
        this.groupLocalService.unsetRoleGroups(roleId, groupIds);
    }

    public Group updateFriendlyURL(long groupId, String friendlyURL) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"UPDATE");
        return this.groupLocalService.updateFriendlyURL(groupId, friendlyURL);
    }

    public Group updateGroup(long groupId, long parentGroupId, String name, String description, int type, boolean manualMembership, int membershipRestriction, String friendlyURL, boolean active, ServiceContext serviceContext) throws PortalException, SystemException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Group)group, (String)"UPDATE");
        if (group.getParentGroupId() != parentGroupId) {
            if (parentGroupId == 0L) {
                PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"ADD_COMMUNITY");
            } else {
                GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)parentGroupId, (String)"ADD_COMMUNITY");
            }
        }
        if (group.isSite()) {
            Group oldGroup = group;
            List oldAssetCategories = this.assetCategoryLocalService.getCategories(Group.class.getName(), groupId);
            List oldAssetTags = this.assetTagLocalService.getTags(Group.class.getName(), groupId);
            ExpandoBridge oldExpandoBridge = oldGroup.getExpandoBridge();
            Map oldExpandoAttributes = oldExpandoBridge.getAttributes();
            group = this.groupLocalService.updateGroup(groupId, parentGroupId, name, description, type, manualMembership, membershipRestriction, friendlyURL, active, serviceContext);
            SiteMembershipPolicyUtil.verifyPolicy((Group)group, (Group)oldGroup, (List)oldAssetCategories, (List)oldAssetTags, (Map)oldExpandoAttributes, null);
            return group;
        }
        return this.groupLocalService.updateGroup(groupId, parentGroupId, name, description, type, manualMembership, membershipRestriction, friendlyURL, active, serviceContext);
    }

    public Group updateGroup(long groupId, String typeSettings) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"UPDATE");
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        if (group.isSite()) {
            Group oldGroup = group;
            UnicodeProperties oldTypeSettingsProperties = oldGroup.getTypeSettingsProperties();
            group = this.groupLocalService.updateGroup(groupId, typeSettings);
            SiteMembershipPolicyUtil.verifyPolicy((Group)group, (Group)oldGroup, null, null, null, (UnicodeProperties)oldTypeSettingsProperties);
            return group;
        }
        return this.groupLocalService.updateGroup(groupId, typeSettings);
    }

    public void updateStagedPortlets(long groupId, Map<String, String> stagedPortletIds) throws PortalException, SystemException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"UPDATE");
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        UnicodeProperties typeSettingsProperties = group.getTypeSettingsProperties();
        for (String stagedPortletId : stagedPortletIds.keySet()) {
            typeSettingsProperties.setProperty(StagingUtil.getStagedPortletId((String)stagedPortletId), stagedPortletIds.get(stagedPortletId));
        }
        this.groupLocalService.updateGroup(group);
    }

    protected List<Group> filterGroups(List<Group> groups) throws PortalException, SystemException {
        ArrayList<Group> filteredGroups = new ArrayList<Group>();
        for (Group group : groups) {
            if (!GroupPermissionUtil.contains((PermissionChecker)this.getPermissionChecker(), (long)group.getGroupId(), (String)"VIEW")) continue;
            filteredGroups.add(group);
        }
        return filteredGroups;
    }
}

