/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.DuplicateGroupException;
import com.liferay.portal.GroupFriendlyURLException;
import com.liferay.portal.GroupNameException;
import com.liferay.portal.GroupParentException;
import com.liferay.portal.LocaleException;
import com.liferay.portal.NoSuchGroupException;
import com.liferay.portal.NoSuchLayoutSetException;
import com.liferay.portal.PendingBackgroundTaskException;
import com.liferay.portal.RequiredGroupException;
import com.liferay.portal.kernel.cache.ThreadLocalCachable;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataContextFactoryUtil;
import com.liferay.portal.kernel.lar.PortletDataHandler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelperUtil;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.spring.aop.Skip;
import com.liferay.portal.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.GroupThreadLocal;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UniqueList;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandler;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.model.Account;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutPrototype;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.model.LayoutSetPrototype;
import com.liferay.portal.model.LayoutTemplate;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.ResourceAction;
import com.liferay.portal.model.ResourcePermission;
import com.liferay.portal.model.ResourceTypePermission;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.model.UserGroupRole;
import com.liferay.portal.model.UserPersonalSite;
import com.liferay.portal.model.WorkflowDefinitionLink;
import com.liferay.portal.model.impl.LayoutImpl;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.security.permission.ResourceActionsUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.GroupLocalServiceBaseImpl;
import com.liferay.portal.theme.ThemeLoader;
import com.liferay.portal.theme.ThemeLoaderFactory;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.comparator.GroupNameComparator;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class GroupLocalServiceImpl
extends GroupLocalServiceBaseImpl {
    public static final String ORGANIZATION_NAME_SUFFIX = " LFR_ORGANIZATION";
    protected File publicLARFile;
    private static Log _log = LogFactoryUtil.getLog(GroupLocalServiceImpl.class);
    private volatile long[] _classNameIds;
    private volatile long[] _complexSQLClassNameIds;
    private Map<String, Group> _systemGroupsMap = new HashMap<String, Group>();

    public GroupLocalServiceImpl() {
        this.initImportLARFile();
    }

    public Group addGroup(long userId, long parentGroupId, String className, long classPK, long liveGroupId, String name, String description, int type, boolean manualMembership, int membershipRestriction, String friendlyURL, boolean site, boolean active, ServiceContext serviceContext) throws PortalException, SystemException {
        User screenNameUser;
        User user = this.userPersistence.findByPrimaryKey(userId);
        className = GetterUtil.getString((String)className);
        long classNameId = PortalUtil.getClassNameId((String)className);
        String friendlyName = name;
        long groupId = 0L;
        do {
            groupId = this.counterLocalService.increment();
        } while ((screenNameUser = this.userPersistence.fetchByC_SN(user.getCompanyId(), String.valueOf(groupId))) != null);
        boolean staging = this.isStaging(serviceContext);
        long groupClassNameId = PortalUtil.getClassNameId(Group.class);
        if (classNameId <= 0L || className.equals(Group.class.getName()) || className.equals(Company.class.getName()) && staging) {
            className = Group.class.getName();
            classNameId = groupClassNameId;
            classPK = groupId;
        } else if (className.equals(Organization.class.getName())) {
            name = this.getOrgGroupName(name);
        } else if (!"User Personal Site".equals(name)) {
            name = String.valueOf(classPK);
        }
        if (className.equals(Organization.class.getName()) && staging) {
            classPK = liveGroupId;
        }
        if (className.equals(Layout.class.getName())) {
            Layout layout = this.layoutLocalService.getLayout(classPK);
            parentGroupId = layout.getGroupId();
        }
        friendlyURL = this.getFriendlyURL(user.getCompanyId(), groupId, classNameId, classPK, friendlyName, friendlyURL);
        if (staging) {
            name = name.concat(" (Staging)");
            friendlyURL = this.getFriendlyURL(friendlyURL.concat("-staging"));
        }
        if (parentGroupId == 0L) {
            membershipRestriction = 0;
        }
        if (className.equals(Group.class.getName()) ? !site && liveGroupId == 0L && !name.equals("Control Panel") : !className.equals(Company.class.getName()) && !className.equals(Organization.class.getName()) && className.startsWith("com.liferay.portal.model.") && site) {
            throw new IllegalArgumentException();
        }
        if (classNameId <= 0L || className.equals(Group.class.getName())) {
            this.validateName(groupId, user.getCompanyId(), name, site);
        }
        this.validateFriendlyURL(user.getCompanyId(), groupId, classNameId, classPK, friendlyURL);
        this.validateParentGroup(groupId, parentGroupId);
        Group group = this.groupPersistence.create(groupId);
        if (serviceContext != null) {
            group.setUuid(serviceContext.getUuid());
        }
        group.setCompanyId(user.getCompanyId());
        group.setCreatorUserId(userId);
        group.setClassNameId(classNameId);
        group.setClassPK(classPK);
        group.setParentGroupId(parentGroupId);
        group.setLiveGroupId(liveGroupId);
        group.setTreePath(group.buildTreePath());
        group.setName(name);
        group.setDescription(description);
        group.setType(type);
        group.setManualMembership(manualMembership);
        group.setMembershipRestriction(membershipRestriction);
        group.setFriendlyURL(friendlyURL);
        group.setSite(site);
        group.setActive(active);
        if (serviceContext != null && classNameId == groupClassNameId && !user.isDefaultUser()) {
            group.setExpandoBridgeAttributes(serviceContext);
        }
        this.groupPersistence.update((BaseModel)group);
        this.layoutSetLocalService.addLayoutSet(groupId, true);
        this.layoutSetLocalService.addLayoutSet(groupId, false);
        if (classNameId == groupClassNameId && !user.isDefaultUser()) {
            this.resourceLocalService.addResources(group.getCompanyId(), 0L, 0L, Group.class.getName(), group.getGroupId(), false, false, false);
            Role role = this.roleLocalService.getRole(group.getCompanyId(), "Site Owner");
            this.userGroupRoleLocalService.addUserGroupRoles(userId, groupId, new long[]{role.getRoleId()});
            this.userLocalService.addGroupUsers(group.getGroupId(), new long[]{userId});
            if (serviceContext != null) {
                this.updateAsset(userId, group, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
            }
        } else if (className.equals(Organization.class.getName()) && !user.isDefaultUser()) {
            this.resourceLocalService.addResources(group.getCompanyId(), 0L, 0L, Group.class.getName(), group.getGroupId(), false, false, false);
        }
        return group;
    }

    public Group addGroup(long userId, long parentGroupId, String className, long classPK, String name, String description, int type, String friendlyURL, boolean site, boolean active, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.addGroup(userId, parentGroupId, className, classPK, 0L, name, description, type, true, 0, friendlyURL, site, active, serviceContext);
    }

    public Group addGroup(long userId, String className, long classPK, long liveGroupId, String name, String description, int type, String friendlyURL, boolean site, boolean active, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.addGroup(userId, 0L, className, classPK, liveGroupId, name, description, type, true, 0, friendlyURL, site, active, serviceContext);
    }

    public Group addGroup(long userId, String className, long classPK, String name, String description, int type, String friendlyURL, boolean site, boolean active, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.addGroup(userId, 0L, className, classPK, 0L, name, description, type, true, 0, friendlyURL, site, active, serviceContext);
    }

    @Override
    public void addRoleGroups(long roleId, long[] groupIds) throws SystemException {
        this.rolePersistence.addGroups(roleId, groupIds);
        PermissionCacheUtil.clearCache();
    }

    @Override
    public void addUserGroups(long userId, long[] groupIds) throws SystemException {
        this.userPersistence.addGroups(userId, groupIds);
        PermissionCacheUtil.clearCache();
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public void checkCompanyGroup(long companyId) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId(Company.class);
        int count = this.groupPersistence.countByC_C_C(companyId, classNameId, companyId);
        if (count == 0) {
            long defaultUserId = this.userLocalService.getDefaultUserId(companyId);
            this.groupLocalService.addGroup(defaultUserId, 0L, Company.class.getName(), companyId, 0L, "Global", null, 0, true, 0, "/global", true, true, null);
        }
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public void checkSystemGroups(long companyId) throws PortalException, SystemException {
        String[] systemGroups;
        String companyIdHexString = StringUtil.toHexString((long)companyId);
        for (Group group : this.groupFinder.findBySystem(companyId)) {
            this._systemGroupsMap.put(companyIdHexString.concat(group.getName()), group);
        }
        long defaultUserId = this.userLocalService.getDefaultUserId(companyId);
        String[] stringArray = systemGroups = PortalUtil.getSystemGroups();
        int n = systemGroups.length;
        int n2 = 0;
        while (n2 < n) {
            LayoutSet layoutSet;
            String name = stringArray[n2];
            String groupCacheKey = companyIdHexString.concat(name);
            Group group = this._systemGroupsMap.get(groupCacheKey);
            if (group == null) {
                group = this.groupPersistence.fetchByC_N(companyId, name);
            }
            if (group == null) {
                String className = null;
                long classPK = 0L;
                int type = 1;
                String friendlyURL = null;
                boolean site = true;
                if (name.equals("Control Panel")) {
                    type = 3;
                    friendlyURL = "/control_panel";
                    site = false;
                } else if (name.equals("Guest")) {
                    friendlyURL = "/guest";
                } else if (name.equals("User Personal Site")) {
                    className = UserPersonalSite.class.getName();
                    classPK = defaultUserId;
                    type = 3;
                    friendlyURL = "/personal_site";
                    site = false;
                }
                group = this.groupLocalService.addGroup(defaultUserId, 0L, className, classPK, 0L, name, null, type, true, 0, friendlyURL, site, true, null);
                if (name.equals("User Personal Site")) {
                    this.initUserPersonalSitePermissions(group);
                }
            }
            if (group.isControlPanel() && (layoutSet = this.layoutSetLocalService.getLayoutSet(group.getGroupId(), true)).getPageCount() == 0) {
                this.addControlPanelLayouts(group);
            }
            if (group.getName().equals("Guest") && (layoutSet = this.layoutSetLocalService.getLayoutSet(group.getGroupId(), false)).getPageCount() == 0) {
                this.addDefaultGuestPublicLayouts(group);
            }
            this._systemGroupsMap.put(groupCacheKey, group);
            ++n2;
        }
    }

    @Override
    public Group deleteGroup(Group group) throws PortalException, SystemException {
        boolean deleteInProcess = GroupThreadLocal.isDeleteInProcess();
        try {
            ThemeLoader themeLoader;
            GroupThreadLocal.setDeleteInProcess((boolean)true);
            if ((group.isCompany() && !group.isCompanyStagingGroup() || PortalUtil.isSystemGroup((String)group.getName())) && !CompanyThreadLocal.isDeleteInProcess()) {
                throw new RequiredGroupException(String.valueOf(group.getGroupId()), 1);
            }
            if (this.groupPersistence.countByC_P_S(group.getCompanyId(), group.getGroupId(), true) > 0) {
                throw new RequiredGroupException(String.valueOf(group.getGroupId()), 2);
            }
            List backgroundTasks = this.backgroundTaskLocalService.getBackgroundTasks(group.getGroupId(), 1);
            if (!backgroundTasks.isEmpty()) {
                throw new PendingBackgroundTaskException("Unable to delete group with pending background tasks");
            }
            this.backgroundTaskLocalService.deleteGroupBackgroundTasks(group.getGroupId());
            this.layoutSetBranchLocalService.deleteLayoutSetBranches(group.getGroupId(), true, true);
            this.layoutSetBranchLocalService.deleteLayoutSetBranches(group.getGroupId(), false, true);
            ServiceContext serviceContext = new ServiceContext();
            try {
                this.layoutSetLocalService.deleteLayoutSet(group.getGroupId(), true, serviceContext);
            }
            catch (NoSuchLayoutSetException noSuchLayoutSetException) {}
            try {
                this.layoutSetLocalService.deleteLayoutSet(group.getGroupId(), false, serviceContext);
            }
            catch (NoSuchLayoutSetException noSuchLayoutSetException) {}
            this.userGroupRoleLocalService.deleteUserGroupRolesByGroupId(group.getGroupId());
            this.userGroupGroupRoleLocalService.deleteUserGroupGroupRolesByGroupId(group.getGroupId());
            this.membershipRequestLocalService.deleteMembershipRequests(group.getGroupId());
            this.portletPreferencesLocalService.deletePortletPreferences(group.getGroupId(), 2, 0L);
            this.repositoryLocalService.deleteRepositories(group.getGroupId());
            this.subscriptionLocalService.deleteSubscriptions(group.getCompanyId(), BlogsEntry.class.getName(), group.getGroupId());
            this.subscriptionLocalService.deleteSubscriptions(group.getCompanyId(), JournalArticle.class.getName(), group.getGroupId());
            this.teamLocalService.deleteTeams(group.getGroupId());
            this.unscheduleStaging(group);
            if (group.hasStagingGroup()) {
                try {
                    StagingUtil.disableStaging((Group)group, (ServiceContext)serviceContext);
                }
                catch (Exception exception) {
                    _log.error((Object)("Unable to disable staging for group " + group.getGroupId()));
                }
            }
            if ((themeLoader = ThemeLoaderFactory.getDefaultThemeLoader()) != null) {
                String themePath = themeLoader.getFileStorage() + "/" + group.getGroupId();
                FileUtil.deltree((String)(String.valueOf(themePath) + "-private"));
                FileUtil.deltree((String)(String.valueOf(themePath) + "-public"));
            }
            this.deletePortletData(group);
            if (group.isRegularSite()) {
                this.assetEntryLocalService.deleteEntry(Group.class.getName(), group.getGroupId());
            }
            this.assetTagLocalService.deleteGroupTags(group.getGroupId());
            this.assetVocabularyLocalService.deleteVocabularies(group.getGroupId());
            this.expandoRowLocalService.deleteRows(group.getGroupId());
            this.shoppingCartLocalService.deleteGroupCarts(group.getGroupId());
            this.shoppingCategoryLocalService.deleteCategories(group.getGroupId());
            this.shoppingCouponLocalService.deleteCoupons(group.getGroupId());
            this.shoppingOrderLocalService.deleteOrders(group.getGroupId());
            this.socialActivityLocalService.deleteActivities(group.getGroupId());
            this.socialActivitySettingLocalService.deleteActivitySettings(group.getGroupId());
            this.scFrameworkVersionLocalService.deleteFrameworkVersions(group.getGroupId());
            this.scProductEntryLocalService.deleteProductEntries(group.getGroupId());
            List resourcePermissions = this.resourcePermissionPersistence.findByC_LikeP(group.getCompanyId(), String.valueOf(group.getGroupId()));
            for (ResourcePermission resourcePermission : resourcePermissions) {
                this.resourcePermissionLocalService.deleteResourcePermission(resourcePermission);
            }
            if (!group.isStagingGroup() && (group.isOrganization() || group.isRegularSite())) {
                this.resourceLocalService.deleteResource(group.getCompanyId(), Group.class.getName(), 4, group.getGroupId());
            }
            List scopeableWorkflowHandlers = WorkflowHandlerRegistryUtil.getScopeableWorkflowHandlers();
            for (WorkflowHandler scopeableWorkflowHandler : scopeableWorkflowHandlers) {
                WorkflowDefinitionLink workflowDefinitionLink;
                if (!scopeableWorkflowHandler.isVisible() || (workflowDefinitionLink = this.workflowDefinitionLinkLocalService.fetchWorkflowDefinitionLink(group.getCompanyId(), group.getGroupId(), scopeableWorkflowHandler.getClassName(), 0L, 0L, true)) == null) continue;
                this.workflowDefinitionLinkLocalService.deleteWorkflowDefinitionLink(workflowDefinitionLink);
            }
            if (!group.isStagingGroup() && group.isOrganization() && group.isSite()) {
                group.setSite(false);
                this.groupPersistence.update((BaseModel)group);
            } else {
                this.groupPersistence.remove((BaseModel)group);
            }
            PermissionCacheUtil.clearCache();
            Group group2 = group;
            return group2;
        }
        finally {
            GroupThreadLocal.setDeleteInProcess((boolean)deleteInProcess);
        }
    }

    @Override
    public Group deleteGroup(long groupId) throws PortalException, SystemException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        return this.deleteGroup(group);
    }

    public synchronized void disableStaging(long groupId) throws PortalException, SystemException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        int stagingGroupCount = group.getRemoteStagingGroupCount();
        if (stagingGroupCount > 0) {
            group.setRemoteStagingGroupCount(--stagingGroupCount);
            if (stagingGroupCount == 0) {
                UnicodeProperties typeSettingsProperties = group.getTypeSettingsProperties();
                ArrayList<String> keys = new ArrayList<String>();
                for (String key : typeSettingsProperties.keySet()) {
                    if (!key.startsWith("staged-portlet_")) continue;
                    keys.add(key);
                }
                for (String key : keys) {
                    typeSettingsProperties.remove((Object)key);
                }
                group.setTypeSettingsProperties(typeSettingsProperties);
            }
            this.groupPersistence.update((BaseModel)group);
        }
    }

    public synchronized void enableStaging(long groupId) throws PortalException, SystemException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        int stagingGroupCount = group.getRemoteStagingGroupCount() + 1;
        group.setRemoteStagingGroupCount(stagingGroupCount);
        this.groupPersistence.update((BaseModel)group);
    }

    public Group fetchFriendlyURLGroup(long companyId, String friendlyURL) throws SystemException {
        if (Validator.isNull((String)friendlyURL)) {
            return null;
        }
        friendlyURL = this.getFriendlyURL(friendlyURL);
        return this.groupPersistence.fetchByC_F(companyId, friendlyURL);
    }

    @Skip
    public Group fetchGroup(long companyId, String name) throws SystemException {
        Group group = this._systemGroupsMap.get(StringUtil.toHexString((long)companyId).concat(name));
        if (group != null) {
            return group;
        }
        return this.groupLocalService.loadFetchGroup(companyId, name);
    }

    public Group getCompanyGroup(long companyId) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId(Company.class);
        return this.groupPersistence.findByC_C_C(companyId, classNameId, companyId);
    }

    public List<Group> getCompanyGroups(long companyId, int start, int end) throws SystemException {
        return this.groupPersistence.findByCompanyId(companyId, start, end);
    }

    public int getCompanyGroupsCount(long companyId) throws SystemException {
        return this.groupPersistence.countByCompanyId(companyId);
    }

    public Group getFriendlyURLGroup(long companyId, String friendlyURL) throws PortalException, SystemException {
        if (Validator.isNull((String)friendlyURL)) {
            throw new NoSuchGroupException();
        }
        friendlyURL = this.getFriendlyURL(friendlyURL);
        return this.groupPersistence.findByC_F(companyId, friendlyURL);
    }

    @Override
    @ThreadLocalCachable
    public Group getGroup(long groupId) throws PortalException, SystemException {
        return this.groupPersistence.findByPrimaryKey(groupId);
    }

    @Skip
    public Group getGroup(long companyId, String name) throws PortalException, SystemException {
        Group group = this._systemGroupsMap.get(StringUtil.toHexString((long)companyId).concat(name));
        if (group != null) {
            return group;
        }
        return this.groupLocalService.loadGetGroup(companyId, name);
    }

    public String getGroupDescriptiveName(Group group, Locale locale) throws PortalException, SystemException {
        String name = group.getName();
        if (group.isCompany() && !group.isCompanyStagingGroup()) {
            name = LanguageUtil.get((Locale)locale, (String)"global");
        } else if (group.isControlPanel()) {
            name = LanguageUtil.get((Locale)locale, (String)"control-panel");
        } else if (group.isLayout()) {
            Layout layout = this.layoutLocalService.getLayout(group.getClassPK());
            name = layout.getName(locale);
        } else if (group.isLayoutPrototype()) {
            LayoutPrototype layoutPrototype = this.layoutPrototypeLocalService.getLayoutPrototype(group.getClassPK());
            name = layoutPrototype.getName(locale);
        } else if (group.isLayoutSetPrototype()) {
            LayoutSetPrototype layoutSetPrototype = this.layoutSetPrototypePersistence.findByPrimaryKey(group.getClassPK());
            name = layoutSetPrototype.getName(locale);
        } else if (group.isOrganization()) {
            long organizationId = group.getOrganizationId();
            Organization organization = this.organizationPersistence.findByPrimaryKey(organizationId);
            name = organization.getName();
            group = organization.getGroup();
        } else if (group.isUser()) {
            long userId = group.getClassPK();
            User user = this.userPersistence.findByPrimaryKey(userId);
            name = user.getFullName();
        } else if (group.isUserGroup()) {
            long userGroupId = group.getClassPK();
            UserGroup userGroup = this.userGroupPersistence.findByPrimaryKey(userGroupId);
            name = userGroup.getName();
        } else if (group.isUserPersonalSite()) {
            name = LanguageUtil.get((Locale)locale, (String)"user-personal-site");
        } else if (name.equals("Guest")) {
            Company company = this.companyPersistence.findByPrimaryKey(group.getCompanyId());
            Account account = company.getAccount();
            name = account.getName();
        }
        if (group.isStaged() && !group.isStagedRemotely() && group.isStagingGroup()) {
            Group liveGroup = group.getLiveGroup();
            name = liveGroup.getDescriptiveName(locale);
        }
        return name;
    }

    public String getGroupDescriptiveName(long groupId, Locale locale) throws PortalException, SystemException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        return this.getGroupDescriptiveName(group, locale);
    }

    public List<Group> getGroups(long companyId, long parentGroupId, boolean site) throws SystemException {
        if (parentGroupId == -1L) {
            return this.groupPersistence.findByC_S(companyId, site);
        }
        return this.groupPersistence.findByC_P_S(companyId, parentGroupId, site);
    }

    public List<Group> getGroups(long companyId, String className, long parentGroupId) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.groupPersistence.findByC_C_P(companyId, classNameId, parentGroupId);
    }

    public List<Group> getGroups(long companyId, String className, long parentGroupId, int start, int end) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.groupPersistence.findByC_C_P(companyId, classNameId, parentGroupId, start, end);
    }

    public List<Group> getGroups(long[] groupIds) throws PortalException, SystemException {
        ArrayList<Group> groups = new ArrayList<Group>(groupIds.length);
        long[] lArray = groupIds;
        int n = groupIds.length;
        int n2 = 0;
        while (n2 < n) {
            long groupId = lArray[n2];
            Group group = this.getGroup(groupId);
            groups.add(group);
            ++n2;
        }
        return groups;
    }

    public int getGroupsCount(long companyId, long parentGroupId, boolean site) throws SystemException {
        if (parentGroupId == -1L) {
            return this.groupPersistence.countByC_S(companyId, site);
        }
        return this.groupPersistence.countByC_P_S(companyId, parentGroupId, site);
    }

    public int getGroupsCount(long companyId, String className, long parentGroupId) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.groupPersistence.countByC_C_P(companyId, classNameId, parentGroupId);
    }

    public Group getLayoutGroup(long companyId, long plid) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId(Layout.class);
        return this.groupPersistence.findByC_C_C(companyId, classNameId, plid);
    }

    public Group getLayoutPrototypeGroup(long companyId, long layoutPrototypeId) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId(LayoutPrototype.class);
        return this.groupPersistence.findByC_C_C(companyId, classNameId, layoutPrototypeId);
    }

    public Group getLayoutSetPrototypeGroup(long companyId, long layoutSetPrototypeId) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId(LayoutSetPrototype.class);
        return this.groupPersistence.findByC_C_C(companyId, classNameId, layoutSetPrototypeId);
    }

    public List<Group> getLayoutsGroups(long companyId, long parentGroupId, boolean site, int start, int end) throws SystemException {
        return this.groupFinder.findByLayouts(companyId, parentGroupId, site, start, end);
    }

    public int getLayoutsGroupsCount(long companyId, long parentGroupId, boolean site) throws SystemException {
        return this.groupFinder.countByLayouts(companyId, parentGroupId, site);
    }

    public List<Group> getLiveGroups() throws SystemException {
        return this.groupFinder.findByLiveGroups();
    }

    public List<Group> getNoLayoutsGroups(String className, boolean privateLayout, int start, int end) throws SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.groupFinder.findByNoLayouts(classNameId, privateLayout, start, end);
    }

    public List<Group> getNullFriendlyURLGroups() throws SystemException {
        return this.groupFinder.findByNullFriendlyURL();
    }

    public Group getOrganizationGroup(long companyId, long organizationId) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId(Organization.class);
        return this.groupPersistence.findByC_C_C(companyId, classNameId, organizationId);
    }

    public List<Group> getOrganizationsGroups(List<Organization> organizations) {
        ArrayList<Group> organizationGroups = new ArrayList<Group>();
        int i2 = 0;
        while (i2 < organizations.size()) {
            Organization organization = organizations.get(i2);
            Group group = organization.getGroup();
            organizationGroups.add(group);
            ++i2;
        }
        return organizationGroups;
    }

    public List<Group> getOrganizationsRelatedGroups(List<Organization> organizations) throws SystemException {
        ArrayList<Group> organizationGroups = new ArrayList<Group>();
        int i2 = 0;
        while (i2 < organizations.size()) {
            Organization organization = organizations.get(i2);
            List groups = this.organizationPersistence.getGroups(organization.getOrganizationId());
            organizationGroups.addAll(groups);
            ++i2;
        }
        return organizationGroups;
    }

    public List<Group> getParentGroups(long groupId) throws PortalException, SystemException {
        if (groupId == 0L) {
            return new ArrayList<Group>();
        }
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        return group.getAncestors();
    }

    public Group getStagingGroup(long liveGroupId) throws PortalException, SystemException {
        return this.groupPersistence.findByLiveGroupId(liveGroupId);
    }

    public Group getUserGroup(long companyId, long userId) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId(User.class);
        return this.groupPersistence.findByC_C_C(companyId, classNameId, userId);
    }

    public Group getUserGroupGroup(long companyId, long userGroupId) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId(UserGroup.class);
        return this.groupPersistence.findByC_C_C(companyId, classNameId, userGroupId);
    }

    public List<Group> getUserGroups(long userId, boolean inherit) throws PortalException, SystemException {
        return this.getUserGroups(userId, inherit, -1, -1);
    }

    public List<Group> getUserGroups(long userId, boolean inherit, int start, int end) throws PortalException, SystemException {
        if (inherit) {
            User user = this.userPersistence.findByPrimaryKey(userId);
            LinkedHashMap<String, Object> groupParams = new LinkedHashMap<String, Object>();
            groupParams.put("usersGroups", new Long(userId));
            return this.search(user.getCompanyId(), null, null, groupParams, start, end);
        }
        return this.userPersistence.getGroups(userId, start, end);
    }

    public List<Group> getUserGroupsGroups(List<UserGroup> userGroups) throws PortalException, SystemException {
        ArrayList<Group> userGroupGroups = new ArrayList<Group>();
        int i2 = 0;
        while (i2 < userGroups.size()) {
            UserGroup userGroup = userGroups.get(i2);
            Group group = userGroup.getGroup();
            userGroupGroups.add(group);
            ++i2;
        }
        return userGroupGroups;
    }

    public List<Group> getUserGroupsRelatedGroups(List<UserGroup> userGroups) throws SystemException {
        ArrayList<Group> userGroupGroups = new ArrayList<Group>();
        int i2 = 0;
        while (i2 < userGroups.size()) {
            UserGroup userGroup = userGroups.get(i2);
            List groups = this.userGroupPersistence.getGroups(userGroup.getUserGroupId());
            userGroupGroups.addAll(groups);
            ++i2;
        }
        return userGroupGroups;
    }

    public List<Group> getUserOrganizationsGroups(long userId, int start, int end) throws PortalException, SystemException {
        UniqueList userOrgsGroups = new UniqueList();
        List userOrgs = this.organizationLocalService.getUserOrganizations(userId, start, end);
        for (Organization organization : userOrgs) {
            userOrgsGroups.add(0, organization.getGroup());
            if (PropsValues.ORGANIZATIONS_MEMBERSHIP_STRICT) continue;
            for (Organization ancestorOrganization : organization.getAncestors()) {
                userOrgsGroups.add(0, ancestorOrganization.getGroup());
            }
        }
        return userOrgsGroups;
    }

    public Group getUserPersonalSiteGroup(long companyId) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId(UserPersonalSite.class);
        long defaultUserId = this.userLocalService.getDefaultUserId(companyId);
        return this.groupPersistence.findByC_C_C(companyId, classNameId, defaultUserId);
    }

    public List<Group> getUserSitesGroups(long userId) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        LinkedHashMap<String, Comparable<Boolean>> groupParams = new LinkedHashMap<String, Comparable<Boolean>>();
        groupParams.put("inherit", Boolean.TRUE);
        groupParams.put("site", Boolean.TRUE);
        groupParams.put("usersGroups", Long.valueOf(userId));
        return this.groupFinder.findByCompanyId(user.getCompanyId(), groupParams, -1, -1, (OrderByComparator)new GroupNameComparator(true));
    }

    public List<Group> getUserSitesGroups(long userId, boolean includeAdministrative) throws PortalException, SystemException {
        if (!includeAdministrative) {
            return this.getUserSitesGroups(userId);
        }
        HashSet<Group> sites = new HashSet<Group>();
        List userGroupRoles = this.userGroupRoleLocalService.getUserGroupRoles(userId);
        for (UserGroupRole userGroupRole : userGroupRoles) {
            Role role = userGroupRole.getRole();
            String roleName = role.getName();
            if (!roleName.equals("Site Administrator") && !roleName.equals("Site Owner")) continue;
            Group group = userGroupRole.getGroup();
            sites.add(group);
        }
        sites.addAll(this.getUserSitesGroups(userId));
        return new ArrayList<Group>(sites);
    }

    public boolean hasStagingGroup(long liveGroupId) throws SystemException {
        return this.groupPersistence.fetchByLiveGroupId(liveGroupId) != null;
    }

    @Override
    public boolean hasUserGroup(long userId, long groupId) throws SystemException {
        return this.hasUserGroup(userId, groupId, true);
    }

    public boolean hasUserGroup(long userId, long groupId, boolean inherit) throws SystemException {
        return this.groupFinder.countByG_U(groupId, userId, inherit) > 0;
    }

    public Group loadFetchGroup(long companyId, String name) throws SystemException {
        return this.groupPersistence.fetchByC_N(companyId, name);
    }

    public Group loadGetGroup(long companyId, String name) throws PortalException, SystemException {
        return this.groupPersistence.findByC_N(companyId, name);
    }

    public void rebuildTree(long companyId) throws PortalException, SystemException {
        List groups = this.groupPersistence.findByCompanyId(companyId);
        for (Group group : groups) {
            group.setTreePath(group.buildTreePath());
            this.groupPersistence.update((BaseModel)group);
        }
    }

    public List<Group> search(long companyId, LinkedHashMap<String, Object> params, int start, int end) throws SystemException {
        return this.groupFinder.findByCompanyId(companyId, params, start, end, (OrderByComparator)new GroupNameComparator(true));
    }

    public List<Group> search(long companyId, long parentGroupId, String keywords, LinkedHashMap<String, Object> params, int start, int end) throws SystemException {
        return this.search(companyId, this.getClassNameIds(), parentGroupId, keywords, params, start, end, null);
    }

    public List<Group> search(long companyId, long parentGroupId, String keywords, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator obc) throws SystemException {
        return this.search(companyId, this.getClassNameIds(), parentGroupId, keywords, params, start, end, obc);
    }

    public List<Group> search(long companyId, long parentGroupId, String name, String description, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end) throws SystemException {
        return this.search(companyId, this.getClassNameIds(), parentGroupId, name, description, params, andOperator, start, end, null);
    }

    public List<Group> search(long companyId, long parentGroupId, String name, String description, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end, OrderByComparator obc) throws SystemException {
        return this.search(companyId, this.getClassNameIds(), parentGroupId, name, description, params, andOperator, start, end, obc);
    }

    public List<Group> search(long companyId, long[] classNameIds, long parentGroupId, String keywords, LinkedHashMap<String, Object> params, int start, int end) throws SystemException {
        return this.search(companyId, classNameIds, parentGroupId, keywords, params, start, end, null);
    }

    public List<Group> search(long companyId, long[] classNameIds, long parentGroupId, String keywords, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator obc) throws SystemException {
        String[] keywordsArray = this.getSearchNames(companyId, keywords);
        boolean andOperator = false;
        if (Validator.isNull((String)keywords)) {
            andOperator = true;
        }
        if (this.isUseComplexSQL(classNameIds)) {
            return this.groupFinder.findByC_C_PG_N_D(companyId, classNameIds, parentGroupId, keywordsArray, keywordsArray, params, andOperator, start, end, obc);
        }
        List<Group> groups = this.doSearch(companyId, classNameIds, parentGroupId, keywordsArray, keywordsArray, params, andOperator);
        return this.sort(groups, start, end, obc);
    }

    public List<Group> search(long companyId, long[] classNameIds, long parentGroupId, String name, String description, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end) throws SystemException {
        return this.search(companyId, classNameIds, parentGroupId, name, description, params, andOperator, start, end, null);
    }

    public List<Group> search(long companyId, long[] classNameIds, long parentGroupId, String name, String description, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end, OrderByComparator obc) throws SystemException {
        String[] names = this.getSearchNames(companyId, name);
        String[] descriptions = CustomSQLUtil.keywords((String)description);
        if (this.isUseComplexSQL(classNameIds)) {
            return this.groupFinder.findByC_C_PG_N_D(companyId, classNameIds, parentGroupId, names, descriptions, params, andOperator, start, end, obc);
        }
        List<Group> groups = this.doSearch(companyId, classNameIds, parentGroupId, names, descriptions, params, andOperator);
        return this.sort(groups, start, end, obc);
    }

    public List<Group> search(long companyId, long[] classNameIds, String keywords, LinkedHashMap<String, Object> params, int start, int end) throws SystemException {
        return this.search(companyId, classNameIds, -1L, keywords, params, start, end, null);
    }

    public List<Group> search(long companyId, long[] classNameIds, String keywords, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator obc) throws SystemException {
        return this.search(companyId, classNameIds, -1L, keywords, params, start, end, obc);
    }

    public List<Group> search(long companyId, long[] classNameIds, String name, String description, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end) throws SystemException {
        return this.search(companyId, classNameIds, -1L, name, description, params, andOperator, start, end, null);
    }

    public List<Group> search(long companyId, long[] classNameIds, String name, String description, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end, OrderByComparator obc) throws SystemException {
        return this.search(companyId, classNameIds, -1L, name, description, params, andOperator, start, end, obc);
    }

    @ThreadLocalCachable
    public List<Group> search(long companyId, String keywords, LinkedHashMap<String, Object> params, int start, int end) throws SystemException {
        return this.search(companyId, this.getClassNameIds(), -1L, keywords, params, start, end, null);
    }

    public List<Group> search(long companyId, String keywords, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator obc) throws SystemException {
        return this.search(companyId, this.getClassNameIds(), -1L, keywords, params, start, end, obc);
    }

    public List<Group> search(long companyId, String name, String description, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end) throws SystemException {
        return this.search(companyId, this.getClassNameIds(), -1L, name, description, params, andOperator, start, end, null);
    }

    public List<Group> search(long companyId, String name, String description, LinkedHashMap<String, Object> params, boolean andOperator, int start, int end, OrderByComparator obc) throws SystemException {
        return this.search(companyId, this.getClassNameIds(), -1L, name, description, params, andOperator, start, end, obc);
    }

    @ThreadLocalCachable
    public int searchCount(long companyId, long parentGroupId, String keywords, LinkedHashMap<String, Object> params) throws SystemException {
        return this.searchCount(companyId, this.getClassNameIds(), parentGroupId, keywords, params);
    }

    @ThreadLocalCachable
    public int searchCount(long companyId, long parentGroupId, String name, String description, LinkedHashMap<String, Object> params, boolean andOperator) throws SystemException {
        return this.searchCount(companyId, this.getClassNameIds(), parentGroupId, name, description, params, andOperator);
    }

    @ThreadLocalCachable
    public int searchCount(long companyId, long[] classNameIds, long parentGroupId, String keywords, LinkedHashMap<String, Object> params) throws SystemException {
        String[] keywordsArray = this.getSearchNames(companyId, keywords);
        boolean andOperator = false;
        if (Validator.isNull((String)keywords)) {
            andOperator = true;
        }
        if (this.isUseComplexSQL(classNameIds)) {
            return this.groupFinder.countByC_C_PG_N_D(companyId, classNameIds, parentGroupId, keywordsArray, keywordsArray, params, andOperator);
        }
        List<Group> groups = this.doSearch(companyId, classNameIds, parentGroupId, keywordsArray, keywordsArray, params, andOperator);
        return groups.size();
    }

    @ThreadLocalCachable
    public int searchCount(long companyId, long[] classNameIds, long parentGroupId, String name, String description, LinkedHashMap<String, Object> params, boolean andOperator) throws SystemException {
        String[] names = this.getSearchNames(companyId, name);
        String[] descriptions = CustomSQLUtil.keywords((String)description);
        if (this.isUseComplexSQL(classNameIds)) {
            return this.groupFinder.countByC_C_PG_N_D(companyId, classNameIds, parentGroupId, names, descriptions, params, andOperator);
        }
        List<Group> groups = this.doSearch(companyId, classNameIds, parentGroupId, names, descriptions, params, andOperator);
        return groups.size();
    }

    @ThreadLocalCachable
    public int searchCount(long companyId, long[] classNameIds, String keywords, LinkedHashMap<String, Object> params) throws SystemException {
        return this.searchCount(companyId, classNameIds, -1L, keywords, params);
    }

    @ThreadLocalCachable
    public int searchCount(long companyId, long[] classNameIds, String name, String description, LinkedHashMap<String, Object> params, boolean andOperator) throws SystemException {
        return this.searchCount(companyId, classNameIds, -1L, name, description, params, andOperator);
    }

    @ThreadLocalCachable
    public int searchCount(long companyId, String keywords, LinkedHashMap<String, Object> params) throws SystemException {
        return this.searchCount(companyId, this.getClassNameIds(), -1L, keywords, params);
    }

    @ThreadLocalCachable
    public int searchCount(long companyId, String name, String description, LinkedHashMap<String, Object> params, boolean andOperator) throws SystemException {
        return this.searchCount(companyId, this.getClassNameIds(), -1L, name, description, params, andOperator);
    }

    @Override
    public void setRoleGroups(long roleId, long[] groupIds) throws SystemException {
        this.rolePersistence.setGroups(roleId, groupIds);
        PermissionCacheUtil.clearCache();
    }

    public void unsetRoleGroups(long roleId, long[] groupIds) throws SystemException {
        this.rolePersistence.removeGroups(roleId, groupIds);
        PermissionCacheUtil.clearCache();
    }

    public void unsetUserGroups(long userId, long[] groupIds) throws SystemException {
        this.userGroupRoleLocalService.deleteUserGroupRoles(userId, groupIds);
        this.userPersistence.removeGroups(userId, groupIds);
        PermissionCacheUtil.clearCache();
    }

    public void updateAsset(long userId, Group group, long[] assetCategoryIds, String[] assetTagNames) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Company company = this.companyPersistence.findByPrimaryKey(user.getCompanyId());
        Group companyGroup = company.getGroup();
        this.assetEntryLocalService.updateEntry(userId, companyGroup.getGroupId(), null, null, Group.class.getName(), group.getGroupId(), null, 0L, assetCategoryIds, assetTagNames, false, null, null, null, null, group.getDescriptiveName(), group.getDescription(), null, null, null, 0, 0, null, false);
    }

    public Group updateFriendlyURL(long groupId, String friendlyURL) throws PortalException, SystemException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        if (group.isUser()) {
            User user = this.userPersistence.findByPrimaryKey(group.getClassPK());
            friendlyURL = "/" + user.getScreenName();
            if (group.getFriendlyURL().equals(friendlyURL)) {
                return group;
            }
        }
        friendlyURL = this.getFriendlyURL(group.getCompanyId(), groupId, group.getClassNameId(), group.getClassPK(), "", friendlyURL);
        this.validateFriendlyURL(group.getCompanyId(), group.getGroupId(), group.getClassNameId(), group.getClassPK(), friendlyURL);
        group.setFriendlyURL(friendlyURL);
        this.groupPersistence.update((BaseModel)group);
        return group;
    }

    public Group updateGroup(long groupId, long parentGroupId, String name, String description, int type, boolean manualMembership, int membershipRestriction, String friendlyURL, boolean active, ServiceContext serviceContext) throws PortalException, SystemException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        String className = group.getClassName();
        long classNameId = group.getClassNameId();
        long classPK = group.getClassPK();
        friendlyURL = this.getFriendlyURL(group.getCompanyId(), groupId, classNameId, classPK, "", friendlyURL);
        if (classNameId <= 0L || className.equals(Group.class.getName())) {
            this.validateName(group.getGroupId(), group.getCompanyId(), name, group.isSite());
        } else if (className.equals(Organization.class.getName())) {
            Organization organization = this.organizationPersistence.findByPrimaryKey(classPK);
            name = this.getOrgGroupName(organization.getName());
        } else if (!"User Personal Site".equals(name)) {
            name = String.valueOf(classPK);
        }
        if (PortalUtil.isSystemGroup((String)group.getName()) && !name.equals(group.getName())) {
            throw new RequiredGroupException(String.valueOf(group.getGroupId()), 1);
        }
        this.validateFriendlyURL(group.getCompanyId(), group.getGroupId(), group.getClassNameId(), group.getClassPK(), friendlyURL);
        this.validateParentGroup(group.getGroupId(), parentGroupId);
        group.setParentGroupId(parentGroupId);
        group.setTreePath(group.buildTreePath());
        group.setName(name);
        group.setDescription(description);
        group.setType(type);
        group.setManualMembership(manualMembership);
        group.setMembershipRestriction(membershipRestriction);
        group.setFriendlyURL(friendlyURL);
        group.setActive(active);
        if (serviceContext != null && group.isSite()) {
            group.setExpandoBridgeAttributes(serviceContext);
        }
        this.groupPersistence.update((BaseModel)group);
        if (serviceContext == null || !group.isSite()) {
            return group;
        }
        User user = null;
        user = this.userPersistence.fetchByPrimaryKey(group.getCreatorUserId());
        if (user == null) {
            user = this.userPersistence.fetchByPrimaryKey(serviceContext.getUserId());
        }
        if (user == null) {
            user = this.userLocalService.getDefaultUser(group.getCompanyId());
        }
        this.updateAsset(user.getUserId(), group, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        return group;
    }

    public Group updateGroup(long groupId, String typeSettings) throws PortalException, SystemException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        UnicodeProperties oldTypeSettingsProperties = group.getTypeSettingsProperties();
        UnicodeProperties typeSettingsProperties = new UnicodeProperties(true);
        typeSettingsProperties.fastLoad(typeSettings);
        String newLanguageIds = typeSettingsProperties.getProperty("locales");
        if (newLanguageIds != null) {
            String oldLanguageIds = oldTypeSettingsProperties.getProperty("locales", "");
            String defaultLanguageId = typeSettingsProperties.getProperty("languageId", LocaleUtil.toLanguageId((Locale)LocaleUtil.getDefault()));
            if (!Validator.equals((Object)oldLanguageIds, (Object)newLanguageIds)) {
                this.validateLanguageIds(defaultLanguageId, newLanguageIds);
                LanguageUtil.resetAvailableGroupLocales((long)groupId);
            }
        }
        group.setTypeSettings(typeSettings);
        this.groupPersistence.update((BaseModel)group);
        return group;
    }

    public Group updateSite(long groupId, boolean site) throws PortalException, SystemException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        if (!group.isOrganization()) {
            return group;
        }
        group.setSite(site);
        this.groupPersistence.update((BaseModel)group);
        return group;
    }

    protected void addControlPanelLayouts(Group group) throws PortalException, SystemException {
        long defaultUserId = this.userLocalService.getDefaultUserId(group.getCompanyId());
        String friendlyURL = this.getFriendlyURL(PropsValues.CONTROL_PANEL_LAYOUT_FRIENDLY_URL);
        ServiceContext serviceContext = new ServiceContext();
        this.layoutLocalService.addLayout(defaultUserId, group.getGroupId(), true, 0L, PropsValues.CONTROL_PANEL_LAYOUT_NAME, "", "", "control_panel", false, friendlyURL, serviceContext);
    }

    protected void addDefaultGuestPublicLayoutByProperties(Group group) throws PortalException, SystemException {
        List portlets = this.portletLocalService.getPortlets(group.getCompanyId());
        if (portlets.isEmpty()) {
            return;
        }
        long defaultUserId = this.userLocalService.getDefaultUserId(group.getCompanyId());
        String friendlyURL = this.getFriendlyURL(PropsValues.DEFAULT_GUEST_PUBLIC_LAYOUT_FRIENDLY_URL);
        ServiceContext serviceContext = new ServiceContext();
        Layout layout = this.layoutLocalService.addLayout(defaultUserId, group.getGroupId(), false, 0L, PropsValues.DEFAULT_GUEST_PUBLIC_LAYOUT_NAME, "", "", "portlet", false, friendlyURL, serviceContext);
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        layoutTypePortlet.setLayoutTemplateId(0L, PropsValues.DEFAULT_GUEST_PUBLIC_LAYOUT_TEMPLATE_ID, false);
        LayoutTemplate layoutTemplate = layoutTypePortlet.getLayoutTemplate();
        for (String columnId : layoutTemplate.getColumns()) {
            String keyPrefix = "default.guest.public.layout.";
            String portletIds = PropsUtil.get(keyPrefix.concat(columnId));
            layoutTypePortlet.addPortletIds(0L, StringUtil.split((String)portletIds), columnId, false);
        }
        this.layoutLocalService.updateLayout(layout.getGroupId(), layout.isPrivateLayout(), layout.getLayoutId(), layout.getTypeSettings());
        boolean updateLayoutSet = false;
        LayoutSet layoutSet = layout.getLayoutSet();
        if (Validator.isNotNull((String)PropsValues.DEFAULT_GUEST_PUBLIC_LAYOUT_REGULAR_THEME_ID)) {
            layoutSet.setThemeId(PropsValues.DEFAULT_GUEST_PUBLIC_LAYOUT_REGULAR_THEME_ID);
            updateLayoutSet = true;
        }
        if (Validator.isNotNull((String)PropsValues.DEFAULT_GUEST_PUBLIC_LAYOUT_REGULAR_COLOR_SCHEME_ID)) {
            layoutSet.setColorSchemeId(PropsValues.DEFAULT_GUEST_PUBLIC_LAYOUT_REGULAR_COLOR_SCHEME_ID);
            updateLayoutSet = true;
        }
        if (Validator.isNotNull((String)PropsValues.DEFAULT_GUEST_PUBLIC_LAYOUT_WAP_THEME_ID)) {
            layoutSet.setWapThemeId(PropsValues.DEFAULT_GUEST_PUBLIC_LAYOUT_WAP_THEME_ID);
            updateLayoutSet = true;
        }
        if (Validator.isNotNull((String)PropsValues.DEFAULT_GUEST_PUBLIC_LAYOUT_WAP_COLOR_SCHEME_ID)) {
            layoutSet.setWapColorSchemeId(PropsValues.DEFAULT_GUEST_PUBLIC_LAYOUT_WAP_COLOR_SCHEME_ID);
            updateLayoutSet = true;
        }
        if (updateLayoutSet) {
            this.layoutSetLocalService.updateLayoutSet(layoutSet);
        }
    }

    protected void addDefaultGuestPublicLayouts(Group group) throws PortalException, SystemException {
        if (this.publicLARFile != null) {
            this.addDefaultGuestPublicLayoutsByLAR(group, this.publicLARFile);
        } else {
            this.addDefaultGuestPublicLayoutByProperties(group);
        }
    }

    protected void addDefaultGuestPublicLayoutsByLAR(Group group, File larFile) throws PortalException, SystemException {
        long defaultUserId = this.userLocalService.getDefaultUserId(group.getCompanyId());
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
        parameterMap.put("CATEGORIES", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PERMISSIONS", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_CONFIGURATION", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_DATA", new String[]{Boolean.TRUE.toString()});
        parameterMap.put("PORTLET_DATA_CONTROL_DEFAULT", new String[]{Boolean.TRUE.toString()});
        this.layoutLocalService.importLayouts(defaultUserId, group.getGroupId(), false, parameterMap, larFile);
    }

    protected void deletePortletData(Group group) throws PortalException, SystemException {
        List portlets = this.portletLocalService.getPortlets(group.getCompanyId());
        for (Portlet portlet : portlets) {
            PortletDataHandler portletDataHandler;
            if (!portlet.isActive() || (portletDataHandler = portlet.getPortletDataHandlerInstance()) == null || portletDataHandler.isDataPortalLevel()) continue;
            PortletDataContext portletDataContext = PortletDataContextFactoryUtil.createExportPortletDataContext((long)group.getCompanyId(), (long)group.getGroupId(), null, null, null, null);
            portletDataHandler.deleteData(portletDataContext, portlet.getPortletId(), null);
        }
    }

    protected List<Group> doSearch(long companyId, long[] classNameIds, long parentGroupId, String[] names, String[] descriptions, LinkedHashMap<String, Object> params, boolean andOperator) throws SystemException {
        Long userId;
        boolean parentGroupIdEquals = true;
        if (parentGroupId == -1L) {
            parentGroupIdEquals = false;
        }
        params = new LinkedHashMap<String, Object>(params);
        Boolean active = (Boolean)params.remove("active");
        List excludedGroupIds = (List)params.remove("excludedGroupIds");
        List groupsTree = (List)params.remove("groupsTree");
        Boolean manualMembership = (Boolean)params.remove("manualMembership");
        Integer membershipRestriction = (Integer)params.remove("membershipRestriction");
        Boolean site = (Boolean)params.remove("site");
        List types = (List)params.remove("types");
        ArrayList<Group> groups = new ArrayList<Group>();
        long[] lArray = classNameIds;
        int n = classNameIds.length;
        int n2 = 0;
        while (n2 < n) {
            long classNameId = lArray[n2];
            groups.addAll(this.groupPersistence.findByC_C(companyId, classNameId));
            ++n2;
        }
        Iterator iterator = groups.iterator();
        while (iterator.hasNext()) {
            Group group = (Group)iterator.next();
            long liveGroupId = group.getLiveGroupId();
            if (liveGroupId != 0L) {
                iterator.remove();
                continue;
            }
            long groupParentGroupId = group.getParentGroupId();
            if (parentGroupIdEquals && groupParentGroupId != parentGroupId || !parentGroupIdEquals && groupParentGroupId == parentGroupId) {
                iterator.remove();
                continue;
            }
            String name = group.getName();
            if (name.equals("Control Panel")) {
                iterator.remove();
                continue;
            }
            boolean containsName = this.matches(name, names);
            boolean containsDescription = this.matches(group.getDescription(), descriptions);
            if (andOperator && (!containsName || !containsDescription) || !andOperator && !containsName && !containsDescription) {
                iterator.remove();
                continue;
            }
            if (active != null && active.booleanValue() != group.isActive()) {
                iterator.remove();
                continue;
            }
            if (excludedGroupIds != null && excludedGroupIds.contains(group.getGroupId())) {
                iterator.remove();
                continue;
            }
            if (groupsTree != null) {
                String treePath = group.getTreePath();
                boolean matched = false;
                for (Group groupTree : groupsTree) {
                    String groupTreePath = StringUtil.quote((String)String.valueOf(groupTree.getGroupId()), (String)"/");
                    if (!treePath.contains(groupTreePath)) continue;
                    matched = true;
                    break;
                }
                if (!matched) {
                    iterator.remove();
                    continue;
                }
            }
            if (manualMembership != null && manualMembership.booleanValue() != group.isManualMembership()) {
                iterator.remove();
                continue;
            }
            if (membershipRestriction != null && membershipRestriction.intValue() != group.getMembershipRestriction()) {
                iterator.remove();
                continue;
            }
            if (site != null && site.booleanValue() != group.isSite()) {
                iterator.remove();
                continue;
            }
            int type = group.getType();
            if (type == 4) {
                iterator.remove();
                continue;
            }
            if (types == null || types.contains(type)) continue;
            iterator.remove();
        }
        List rolePermissions = (List)params.remove("rolePermissions");
        if (rolePermissions != null) {
            String resourceName = (String)rolePermissions.get(0);
            Integer resourceScope = (Integer)rolePermissions.get(1);
            String resourceActionId = (String)rolePermissions.get(2);
            Long resourceRoleId = (Long)rolePermissions.get(3);
            ResourceAction resourceAction = this.resourceActionLocalService.fetchResourceAction(resourceName, resourceActionId);
            if (resourceAction != null) {
                Group group;
                long bitwiseValue = resourceAction.getBitwiseValue();
                if (this.resourceBlockLocalService.isSupported(resourceName)) {
                    iterator = groups.iterator();
                    while (iterator.hasNext()) {
                        group = (Group)iterator.next();
                        ResourceTypePermission resourceTypePermission = this.resourceTypePermissionPersistence.fetchByC_G_N_R(companyId, group.getGroupId(), resourceName, resourceRoleId.longValue());
                        if (resourceTypePermission != null && (resourceTypePermission.getActionIds() & bitwiseValue) != 0L) continue;
                        iterator.remove();
                    }
                } else {
                    iterator = groups.iterator();
                    while (iterator.hasNext()) {
                        group = (Group)iterator.next();
                        ResourcePermission resourcePermission = this.resourcePermissionPersistence.fetchByC_N_S_P_R(companyId, resourceName, resourceScope.intValue(), String.valueOf(group.getGroupId()), resourceRoleId.longValue());
                        if (resourcePermission != null && (resourcePermission.getActionIds() & bitwiseValue) != 0L) continue;
                        iterator.remove();
                    }
                }
            }
        }
        if ((userId = (Long)params.remove("usersGroups")) == null) {
            return groups;
        }
        HashSet<Group> resultGroups = new HashSet<Group>(groups);
        Long roleId = (Long)params.remove("groupsRoles");
        if (roleId != null) {
            resultGroups.retainAll(this.rolePersistence.getGroups(roleId.longValue()));
        }
        resultGroups.retainAll(this.userPersistence.getGroups(userId.longValue()));
        boolean inherit = GetterUtil.getBoolean(params.remove("inherit"), (boolean)true);
        if (inherit) {
            List organizations = this.userPersistence.getOrganizations(userId.longValue());
            for (Organization organization : organizations) {
                long organizationId = organization.getOrganizationId();
                for (Group group : groups) {
                    if (organizationId != group.getClassPK()) continue;
                    resultGroups.add(group);
                }
            }
            for (Organization organization : organizations) {
                ArrayList<Group> tempGroups = new ArrayList<Group>(groups);
                tempGroups.retainAll(this.organizationPersistence.getGroups(organization.getOrganizationId()));
                if (tempGroups.isEmpty()) continue;
                resultGroups.addAll(tempGroups);
            }
            List userGroups = this.userPersistence.getUserGroups(userId.longValue());
            for (UserGroup userGroup : userGroups) {
                ArrayList<Group> tempGroups = new ArrayList<Group>(groups);
                tempGroups.retainAll(this.userGroupPersistence.getGroups(userGroup.getUserGroupId()));
                if (tempGroups.isEmpty()) continue;
                resultGroups.addAll(tempGroups);
            }
        }
        if (_log.isDebugEnabled() && !params.isEmpty()) {
            _log.debug((Object)("Unprocessed parameters " + MapUtil.toString(params)));
        }
        return new ArrayList<Group>(resultGroups);
    }

    protected long[] getClassNameIds() {
        if (this._classNameIds == null) {
            this._classNameIds = new long[]{this.classNameLocalService.getClassNameId(Group.class), this.classNameLocalService.getClassNameId(Organization.class)};
        }
        return this._classNameIds;
    }

    protected String getFriendlyURL(long companyId, long groupId, long classNameId, long classPK, String friendlyName, String friendlyURL) throws PortalException, SystemException {
        if (Validator.isNotNull((String)(friendlyURL = this.getFriendlyURL(friendlyURL)))) {
            return friendlyURL;
        }
        String originalFriendlyURL = friendlyURL = "/" + this.getFriendlyURL(friendlyName);
        int i2 = 1;
        while (true) {
            try {
                this.validateFriendlyURL(companyId, groupId, classNameId, classPK, friendlyURL);
            }
            catch (GroupFriendlyURLException gfurle) {
                int type = gfurle.getType();
                if (type != 6) {
                    friendlyURL = "/" + classPK;
                    break;
                }
                friendlyURL = String.valueOf(originalFriendlyURL) + i2;
                ++i2;
                continue;
            }
            break;
        }
        return friendlyURL;
    }

    protected String getFriendlyURL(String friendlyURL) {
        return FriendlyURLNormalizerUtil.normalize((String)friendlyURL);
    }

    protected String getOrgGroupName(String name) {
        return String.valueOf(name) + ORGANIZATION_NAME_SUFFIX;
    }

    protected String[] getSearchNames(long companyId, String name) throws SystemException {
        if (Validator.isNull((String)name)) {
            return new String[1];
        }
        Company company = this.companyPersistence.fetchByPrimaryKey(companyId);
        if (company == null) {
            return CustomSQLUtil.keywords((String)name);
        }
        Account account = this.accountPersistence.fetchByPrimaryKey(company.getAccountId());
        if (account == null) {
            return CustomSQLUtil.keywords((String)name);
        }
        String companyName = account.getName();
        if (StringUtil.wildcardMatches((String)companyName, (String)name, (char)'_', (char)'%', (char)'\\', (boolean)false)) {
            Object[] searchNames = CustomSQLUtil.keywords((String)name);
            String guestName = StringUtil.quote((String)StringUtil.toLowerCase((String)"Guest"), (String)"%");
            return (String[])ArrayUtil.append((Object[])searchNames, (Object)guestName);
        }
        return CustomSQLUtil.keywords((String)name);
    }

    protected void initImportLARFile() {
        String publicLARFileName = PropsValues.DEFAULT_GUEST_PUBLIC_LAYOUTS_LAR;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Reading public LAR file " + publicLARFileName));
        }
        if (Validator.isNotNull((String)publicLARFileName)) {
            this.publicLARFile = new File(publicLARFileName);
            if (!this.publicLARFile.exists()) {
                _log.error((Object)("Public LAR file " + this.publicLARFile + " does not exist"));
                this.publicLARFile = null;
            } else if (_log.isDebugEnabled()) {
                _log.debug((Object)("Using public LAR file " + publicLARFileName));
            }
        }
    }

    protected void initUserPersonalSitePermissions(Group group) throws PortalException, SystemException {
        Role role = this.roleLocalService.getRole(group.getCompanyId(), "User");
        List portlets = this.portletLocalService.getPortlets(group.getCompanyId(), false, false);
        for (Portlet portlet : portlets) {
            this.setRolePermissions(group, role, portlet.getPortletId(), new String[]{"VIEW"});
        }
        this.setRolePermissions(group, role, Layout.class.getName(), new String[]{"VIEW"});
        this.setRolePermissions(group, role, "com.liferay.portlet.blogs", new String[]{"ADD_ENTRY", "PERMISSIONS", "SUBSCRIBE"});
        role = this.roleLocalService.getRole(group.getCompanyId(), "Power User");
        for (Portlet portlet : portlets) {
            List actions = ResourceActionsUtil.getPortletResourceActions((String)portlet.getPortletId());
            String controlPanelEntryCategory = GetterUtil.getString((String)portlet.getControlPanelEntryCategory());
            if (!actions.contains("ACCESS_IN_CONTROL_PANEL") || !controlPanelEntryCategory.startsWith("site_administration.")) continue;
            this.setRolePermissions(group, role, portlet.getPortletId(), new String[]{"ACCESS_IN_CONTROL_PANEL"});
        }
        this.setRolePermissions(group, role, Group.class.getName(), new String[]{"MANAGE_LAYOUTS", "VIEW_SITE_ADMINISTRATION"});
        this.setRolePermissions(group, role, "com.liferay.portlet.asset");
        this.setRolePermissions(group, role, "com.liferay.portlet.blogs");
        this.setRolePermissions(group, role, "com.liferay.portlet.bookmarks");
        this.setRolePermissions(group, role, "com.liferay.portlet.documentlibrary");
        this.setRolePermissions(group, role, "com.liferay.portlet.imagegallery");
        this.setRolePermissions(group, role, "com.liferay.portlet.messageboards");
        this.setRolePermissions(group, role, "com.liferay.portlet.polls");
        this.setRolePermissions(group, role, "com.liferay.portlet.wiki");
    }

    protected boolean isParentGroup(long parentGroupId, long groupId) throws PortalException, SystemException {
        if (groupId == 0L) {
            return false;
        }
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        String treePath = group.getTreePath();
        return treePath.contains("/" + parentGroupId + "/");
    }

    protected boolean isStaging(ServiceContext serviceContext) {
        if (serviceContext != null) {
            return ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"staging");
        }
        return false;
    }

    protected boolean isUseComplexSQL(long[] classNameIds) {
        if (ArrayUtil.isEmpty((long[])classNameIds)) {
            return true;
        }
        if (this._complexSQLClassNameIds == null) {
            String[] complexSQLClassNames = PropsValues.GROUPS_COMPLEX_SQL_CLASS_NAMES;
            long[] complexSQLClassNameIds = new long[complexSQLClassNames.length];
            int i2 = 0;
            while (i2 < complexSQLClassNames.length) {
                String complexSQLClassName = complexSQLClassNames[i2];
                complexSQLClassNameIds[i2] = PortalUtil.getClassNameId((String)complexSQLClassName);
                ++i2;
            }
            this._complexSQLClassNameIds = complexSQLClassNameIds;
        }
        long[] lArray = classNameIds;
        int n = classNameIds.length;
        int n2 = 0;
        while (n2 < n) {
            long classNameId = lArray[n2];
            if (ArrayUtil.contains((long[])this._complexSQLClassNameIds, (long)classNameId)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean matches(String s, String[] keywords) {
        if (keywords == null || keywords.length == 1 && keywords[0] == null) {
            return true;
        }
        String[] stringArray = keywords;
        int n = keywords.length;
        int n2 = 0;
        while (n2 < n) {
            String keyword = stringArray[n2];
            if (StringUtil.wildcardMatches((String)s, (String)keyword, (char)'_', (char)'%', (char)'\\', (boolean)false)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void setCompanyPermissions(Role role, String name, String[] actionIds) throws PortalException, SystemException {
        if (this.resourceBlockLocalService.isSupported(name)) {
            this.resourceBlockLocalService.setCompanyScopePermissions(role.getCompanyId(), name, role.getRoleId(), Arrays.asList(actionIds));
        } else {
            this.resourcePermissionLocalService.setResourcePermissions(role.getCompanyId(), name, 1, String.valueOf(role.getCompanyId()), role.getRoleId(), actionIds);
        }
    }

    protected void setRolePermissions(Group group, Role role, String name) throws PortalException, SystemException {
        List actions = ResourceActionsUtil.getModelResourceActions((String)name);
        this.setRolePermissions(group, role, name, actions.toArray(new String[actions.size()]));
    }

    protected void setRolePermissions(Group group, Role role, String name, String[] actionIds) throws PortalException, SystemException {
        if (this.resourceBlockLocalService.isSupported(name)) {
            this.resourceBlockLocalService.setGroupScopePermissions(role.getCompanyId(), group.getGroupId(), name, role.getRoleId(), Arrays.asList(actionIds));
        } else {
            this.resourcePermissionLocalService.setResourcePermissions(group.getCompanyId(), name, 2, String.valueOf(group.getGroupId()), role.getRoleId(), actionIds);
        }
    }

    protected List<Group> sort(List<Group> groups, int start, int end, OrderByComparator obc) {
        if (obc == null) {
            obc = new GroupNameComparator(true);
        }
        Collections.sort(groups, obc);
        return Collections.unmodifiableList(ListUtil.subList(groups, (int)start, (int)end));
    }

    protected void unscheduleStaging(Group group) {
        try {
            String groupName = StagingUtil.getSchedulerGroupName((String)"liferay/layouts_remote_publisher", (long)group.getGroupId());
            SchedulerEngineHelperUtil.delete((String)groupName, (StorageType)StorageType.PERSISTED);
            long liveGroupId = 0L;
            long stagingGroupId = 0L;
            if (group.isStagingGroup()) {
                liveGroupId = group.getLiveGroupId();
                stagingGroupId = group.getGroupId();
            } else if (group.hasStagingGroup()) {
                liveGroupId = group.getGroupId();
                stagingGroupId = group.getStagingGroup().getGroupId();
            }
            if (liveGroupId != 0L && stagingGroupId != 0L) {
                groupName = StagingUtil.getSchedulerGroupName((String)"liferay/layouts_local_publisher", (long)liveGroupId);
                SchedulerEngineHelperUtil.delete((String)groupName, (StorageType)StorageType.PERSISTED);
                groupName = StagingUtil.getSchedulerGroupName((String)"liferay/layouts_local_publisher", (long)stagingGroupId);
                SchedulerEngineHelperUtil.delete((String)groupName, (StorageType)StorageType.PERSISTED);
            }
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to unschedule events for group: " + group.getGroupId()));
        }
    }

    protected void validateFriendlyURL(long companyId, long groupId, long classNameId, long classPK, String friendlyURL) throws PortalException, SystemException {
        long userClassNameId;
        long groupClassNameId;
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        if (company.isSystem()) {
            return;
        }
        if (Validator.isNull((String)friendlyURL)) {
            return;
        }
        int exceptionType = LayoutImpl.validateFriendlyURL(friendlyURL);
        if (exceptionType != -1) {
            throw new GroupFriendlyURLException(exceptionType);
        }
        Group group = this.groupPersistence.fetchByC_F(companyId, friendlyURL);
        if (group != null && group.getGroupId() != groupId) {
            throw new GroupFriendlyURLException(6);
        }
        String groupIdFriendlyURL = friendlyURL.substring(1);
        if (Validator.isNumber((String)groupIdFriendlyURL) && (classNameId != (groupClassNameId = PortalUtil.getClassNameId(Group.class)) && !groupIdFriendlyURL.equals(String.valueOf(classPK)) && !PropsValues.USERS_SCREEN_NAME_ALLOW_NUMERIC || classNameId == groupClassNameId && !groupIdFriendlyURL.equals(String.valueOf(groupId)))) {
            GroupFriendlyURLException gfurle = new GroupFriendlyURLException(8);
            gfurle.setKeywordConflict(groupIdFriendlyURL);
            throw gfurle;
        }
        String screenName = friendlyURL.substring(1);
        User user = this.userPersistence.fetchByC_SN(companyId, screenName);
        if (user != null && (classNameId != (userClassNameId = PortalUtil.getClassNameId(User.class)) || classPK != user.getUserId())) {
            throw new GroupFriendlyURLException(6);
        }
        if (StringUtil.count((String)friendlyURL, (String)"/") > 1) {
            throw new GroupFriendlyURLException(9);
        }
    }

    protected void validateLanguageIds(String defaultLanguageId, String languageIds) throws PortalException {
        Object[] languageIdsArray;
        Locale[] availableLocales = LanguageUtil.getAvailableLocales();
        Object[] availableLanguageIds = LocaleUtil.toLanguageIds((Locale[])availableLocales);
        Object[] objectArray = languageIdsArray = StringUtil.split((String)languageIds);
        int n = languageIdsArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object languageId = objectArray[n2];
            if (!ArrayUtil.contains((Object[])availableLanguageIds, (Object)languageId)) {
                LocaleException le = new LocaleException(1);
                le.setSourceAvailableLocales(availableLocales);
                le.setTargetAvailableLocales(LocaleUtil.fromLanguageIds((String[])languageIdsArray));
                throw le;
            }
            ++n2;
        }
        if (!ArrayUtil.contains((Object[])languageIdsArray, (Object)defaultLanguageId)) {
            LocaleException le = new LocaleException(4);
            le.setSourceAvailableLocales(availableLocales);
            le.setTargetAvailableLocales(LocaleUtil.fromLanguageIds((String[])languageIdsArray));
            throw le;
        }
    }

    protected void validateName(long groupId, long companyId, String name, boolean site) throws PortalException, SystemException {
        Company company;
        if (Validator.isNull((String)name) || Validator.isNumber((String)name) || name.contains("*") || name.contains(ORGANIZATION_NAME_SUFFIX)) {
            throw new GroupNameException();
        }
        try {
            Group group = this.groupFinder.findByC_N(companyId, name);
            if (groupId <= 0L || group.getGroupId() != groupId) {
                throw new DuplicateGroupException();
            }
        }
        catch (NoSuchGroupException noSuchGroupException) {}
        if (site && name.equals((company = this.companyLocalService.getCompany(companyId)).getName())) {
            throw new DuplicateGroupException();
        }
    }

    protected void validateParentGroup(long groupId, long parentGroupId) throws PortalException, SystemException {
        Group stagingGroup;
        if (parentGroupId == 0L) {
            return;
        }
        if (groupId == parentGroupId) {
            throw new GroupParentException(1);
        }
        Group group = this.groupPersistence.fetchByPrimaryKey(groupId);
        if (group == null) {
            return;
        }
        if (groupId > 0L && parentGroupId != 0L && this.isParentGroup(groupId, parentGroupId)) {
            throw new GroupParentException(3);
        }
        Group parentGroup = this.groupPersistence.findByPrimaryKey(parentGroupId);
        if (group.isStagingGroup() && groupId == (stagingGroup = parentGroup.getStagingGroup()).getGroupId()) {
            throw new GroupParentException(2);
        }
    }
}

