/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.model.GroupSoap;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.RoleSoap;
import com.liferay.portal.model.impl.GroupModelImpl;
import com.liferay.portal.service.RoleServiceUtil;
import com.liferay.portal.service.ServiceContext;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;

public class RoleServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(RoleServiceSoap.class);

    public static RoleSoap addRole(String className, long classPK, String name, String[] titleMapLanguageIds, String[] titleMapValues, String[] descriptionMapLanguageIds, String[] descriptionMapValues, int type, String subtype, ServiceContext serviceContext) throws RemoteException {
        try {
            Map titleMap = LocalizationUtil.getLocalizationMap((String[])titleMapLanguageIds, (String[])titleMapValues);
            Map descriptionMap = LocalizationUtil.getLocalizationMap((String[])descriptionMapLanguageIds, (String[])descriptionMapValues);
            Role returnValue = RoleServiceUtil.addRole((String)className, (long)classPK, (String)name, (Map)titleMap, (Map)descriptionMap, (int)type, (String)subtype, (ServiceContext)serviceContext);
            return RoleSoap.toSoapModel((Role)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static RoleSoap addRole(String name, String[] titleMapLanguageIds, String[] titleMapValues, String[] descriptionMapLanguageIds, String[] descriptionMapValues, int type) throws RemoteException {
        try {
            Map titleMap = LocalizationUtil.getLocalizationMap((String[])titleMapLanguageIds, (String[])titleMapValues);
            Map descriptionMap = LocalizationUtil.getLocalizationMap((String[])descriptionMapLanguageIds, (String[])descriptionMapValues);
            Role returnValue = RoleServiceUtil.addRole((String)name, (Map)titleMap, (Map)descriptionMap, (int)type);
            return RoleSoap.toSoapModel((Role)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static void addUserRoles(long userId, long[] roleIds) throws RemoteException {
        try {
            RoleServiceUtil.addUserRoles((long)userId, (long[])roleIds);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static void deleteRole(long roleId) throws RemoteException {
        try {
            RoleServiceUtil.deleteRole((long)roleId);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static RoleSoap[] getGroupRoles(long groupId) throws RemoteException {
        try {
            List returnValue = RoleServiceUtil.getGroupRoles((long)groupId);
            return RoleSoap.toSoapModels((List)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static RoleSoap getRole(long roleId) throws RemoteException {
        try {
            Role returnValue = RoleServiceUtil.getRole((long)roleId);
            return RoleSoap.toSoapModel((Role)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static RoleSoap getRole(long companyId, String name) throws RemoteException {
        try {
            Role returnValue = RoleServiceUtil.getRole((long)companyId, (String)name);
            return RoleSoap.toSoapModel((Role)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static RoleSoap[] getUserGroupGroupRoles(long userId, long groupId) throws RemoteException {
        try {
            List returnValue = RoleServiceUtil.getUserGroupGroupRoles((long)userId, (long)groupId);
            return RoleSoap.toSoapModels((List)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static RoleSoap[] getUserGroupRoles(long userId, long groupId) throws RemoteException {
        try {
            List returnValue = RoleServiceUtil.getUserGroupRoles((long)userId, (long)groupId);
            return RoleSoap.toSoapModels((List)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static RoleSoap[] getUserRelatedRoles(long userId, GroupSoap[] groups) throws RemoteException {
        try {
            List returnValue = RoleServiceUtil.getUserRelatedRoles((long)userId, GroupModelImpl.toModels(groups));
            return RoleSoap.toSoapModels((List)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static RoleSoap[] getUserRoles(long userId) throws RemoteException {
        try {
            List returnValue = RoleServiceUtil.getUserRoles((long)userId);
            return RoleSoap.toSoapModels((List)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static boolean hasUserRole(long userId, long companyId, String name, boolean inherited) throws RemoteException {
        try {
            boolean returnValue = RoleServiceUtil.hasUserRole((long)userId, (long)companyId, (String)name, (boolean)inherited);
            return returnValue;
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static boolean hasUserRoles(long userId, long companyId, String[] names, boolean inherited) throws RemoteException {
        try {
            boolean returnValue = RoleServiceUtil.hasUserRoles((long)userId, (long)companyId, (String[])names, (boolean)inherited);
            return returnValue;
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static void unsetUserRoles(long userId, long[] roleIds) throws RemoteException {
        try {
            RoleServiceUtil.unsetUserRoles((long)userId, (long[])roleIds);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }

    public static RoleSoap updateRole(long roleId, String name, String[] titleMapLanguageIds, String[] titleMapValues, String[] descriptionMapLanguageIds, String[] descriptionMapValues, String subtype, ServiceContext serviceContext) throws RemoteException {
        try {
            Map titleMap = LocalizationUtil.getLocalizationMap((String[])titleMapLanguageIds, (String[])titleMapValues);
            Map descriptionMap = LocalizationUtil.getLocalizationMap((String[])descriptionMapLanguageIds, (String[])descriptionMapValues);
            Role returnValue = RoleServiceUtil.updateRole((long)roleId, (String)name, (Map)titleMap, (Map)descriptionMap, (String)subtype, (ServiceContext)serviceContext);
            return RoleSoap.toSoapModel((Role)returnValue);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new RemoteException(e2.getMessage());
        }
    }
}

