/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.server.capabilities;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.server.capabilities.DefaultServerCapabilities;
import com.liferay.portal.server.capabilities.GlassfishServerCapabilities;
import com.liferay.portal.server.capabilities.JBossServerCapabilities;
import com.liferay.portal.server.capabilities.JettyServerCapabilities;
import com.liferay.portal.server.capabilities.ServerCapabilities;
import com.liferay.portal.server.capabilities.TomcatServerCapabilities;
import javax.servlet.ServletContext;

public class ServerCapabilitiesUtil {
    private static Log _log = LogFactoryUtil.getLog(ServerCapabilitiesUtil.class);

    public static void determineServerCapabilities(ServletContext servletContext) {
        ServerCapabilities serverCapabilities = null;
        if (ServerDetector.isGlassfish()) {
            serverCapabilities = new GlassfishServerCapabilities();
        } else if (ServerDetector.isJBoss()) {
            serverCapabilities = new JBossServerCapabilities();
        } else if (ServerDetector.isJetty()) {
            serverCapabilities = new JettyServerCapabilities();
        } else if (ServerDetector.isTomcat()) {
            serverCapabilities = new TomcatServerCapabilities();
        }
        if (serverCapabilities == null) {
            serverCapabilities = new DefaultServerCapabilities();
        }
        if (_log.isInfoEnabled()) {
            Class<?> clazz = serverCapabilities.getClass();
            _log.info((Object)("Using " + clazz.getName()));
        }
        try {
            serverCapabilities.determine(servletContext);
        }
        catch (Exception e2) {
            _log.error((Object)"Unable to determine server capabilities", (Throwable)e2);
        }
        ServerDetector.setSupportsHotDeploy((boolean)serverCapabilities.isSupportsHotDeploy());
    }
}

