/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.CookieKeys;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.AutoLoginException;
import com.liferay.portal.security.auth.BaseAutoLogin;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RememberMeAutoLogin
extends BaseAutoLogin {
    private static Log _log = LogFactoryUtil.getLog(RememberMeAutoLogin.class);

    protected String[] doHandleException(HttpServletRequest request, HttpServletResponse response, Exception e2) throws AutoLoginException {
        if (_log.isWarnEnabled()) {
            _log.warn((Object)e2, (Throwable)e2);
        }
        this.removeCookies(request, response);
        throw new AutoLoginException((Throwable)e2);
    }

    protected String[] doLogin(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Company company;
        String contextPath;
        String autoUserId = CookieKeys.getCookie((HttpServletRequest)request, (String)"ID", (boolean)false);
        String autoPassword = CookieKeys.getCookie((HttpServletRequest)request, (String)"PASSWORD", (boolean)false);
        String rememberMe = CookieKeys.getCookie((HttpServletRequest)request, (String)"REMEMBER_ME", (boolean)false);
        String proxyPath = PortalUtil.getPathProxy();
        if (proxyPath.equals(contextPath = PortalUtil.getPathContext())) {
            if (Validator.isNotNull((String)request.getContextPath())) {
                rememberMe = Boolean.TRUE.toString();
            }
        } else if (!contextPath.equals(request.getContextPath())) {
            rememberMe = Boolean.TRUE.toString();
        }
        String[] credentials = null;
        if (Validator.isNotNull((String)autoUserId) && Validator.isNotNull((String)autoPassword) && Validator.isNotNull((String)rememberMe)) {
            company = PortalUtil.getCompany((HttpServletRequest)request);
            KeyValuePair kvp = null;
            if (company.isAutoLogin()) {
                kvp = UserLocalServiceUtil.decryptUserId((long)company.getCompanyId(), (String)autoUserId, (String)autoPassword);
                credentials = new String[]{kvp.getKey(), kvp.getValue(), Boolean.FALSE.toString()};
            }
        }
        if (credentials != null) {
            company = PortalUtil.getCompany((HttpServletRequest)request);
            User defaultUser = UserLocalServiceUtil.getDefaultUser((long)company.getCompanyId());
            long userId = GetterUtil.getLong((String)credentials[0]);
            if (defaultUser.getUserId() == userId) {
                this.removeCookies(request, response);
                return null;
            }
        }
        return credentials;
    }

    protected void removeCookies(HttpServletRequest request, HttpServletResponse response) {
        Cookie cookie = new Cookie("ID", "");
        cookie.setMaxAge(0);
        cookie.setPath("/");
        CookieKeys.addCookie((HttpServletRequest)request, (HttpServletResponse)response, (Cookie)cookie);
        cookie = new Cookie("PASSWORD", "");
        cookie.setMaxAge(0);
        cookie.setPath("/");
        CookieKeys.addCookie((HttpServletRequest)request, (HttpServletResponse)response, (Cookie)cookie);
    }
}

