/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.security.auth.AccessControlContext;
import com.liferay.portal.security.auth.AuthVerifier;
import com.liferay.portal.security.auth.AuthVerifierConfiguration;
import com.liferay.portal.security.auth.AuthVerifierResult;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.ClassLoaderUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.http.HttpServletRequest;
import jodd.util.Wildcard;

public class AuthVerifierPipeline {
    public static final String AUTH_TYPE = "auth.type";
    private static Log _log = LogFactoryUtil.getLog(AuthVerifierPipeline.class);
    private static AuthVerifierPipeline _instance = new AuthVerifierPipeline();
    private List<AuthVerifierConfiguration> _authVerifierConfigurations;

    public static String getAuthVerifierPropertyName(String className) {
        String simpleClassName = StringUtil.extractLast((String)className, (String)".");
        return "auth.verifier.".concat(simpleClassName).concat(".");
    }

    public static void register(AuthVerifierConfiguration authVerifierConfiguration) {
        _instance._register(authVerifierConfiguration);
    }

    public static void unregister(AuthVerifierConfiguration authVerifierConfiguration) {
        _instance._unregister(authVerifierConfiguration);
    }

    public static AuthVerifierResult verifyRequest(AccessControlContext accessControlContext) throws PortalException, SystemException {
        return _instance._verifyRequest(accessControlContext);
    }

    private AuthVerifierPipeline() {
        this._initAuthVerifierConfigurations();
    }

    private AuthVerifierResult _createGuestVerificationResult(AccessControlContext accessControlContext) throws PortalException, SystemException {
        AuthVerifierResult authVerifierResult = new AuthVerifierResult();
        authVerifierResult.setState(AuthVerifierResult.State.SUCCESS);
        HttpServletRequest request = accessControlContext.getRequest();
        long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
        long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)companyId);
        authVerifierResult.setUserId(defaultUserId);
        return authVerifierResult;
    }

    private List<AuthVerifierConfiguration> _getAuthVerifierConfigurations(AccessControlContext accessControlContext) {
        HttpServletRequest request = accessControlContext.getRequest();
        ArrayList<AuthVerifierConfiguration> authVerifierConfigurations = new ArrayList<AuthVerifierConfiguration>();
        String requestURI = request.getRequestURI();
        String contextPath = request.getContextPath();
        requestURI = requestURI.substring(contextPath.length());
        for (AuthVerifierConfiguration authVerifierConfiguration : this._authVerifierConfigurations) {
            if (!this._isMatchingRequestURI(authVerifierConfiguration = this._mergeAuthVerifierConfiguration(authVerifierConfiguration, accessControlContext), requestURI)) continue;
            authVerifierConfigurations.add(authVerifierConfiguration);
        }
        return authVerifierConfigurations;
    }

    private void _initAuthVerifierConfigurations() {
        this._authVerifierConfigurations = new CopyOnWriteArrayList<AuthVerifierConfiguration>();
        String[] stringArray = PropsValues.AUTH_VERIFIER_PIPELINE;
        int n = PropsValues.AUTH_VERIFIER_PIPELINE.length;
        int n2 = 0;
        while (n2 < n) {
            String authVerifierClassName = stringArray[n2];
            try {
                AuthVerifierConfiguration authVerifierConfiguration = new AuthVerifierConfiguration();
                AuthVerifier authVerifier = (AuthVerifier)InstanceFactory.newInstance((ClassLoader)ClassLoaderUtil.getPortalClassLoader(), (String)authVerifierClassName);
                authVerifierConfiguration.setAuthVerifier(authVerifier);
                authVerifierConfiguration.setAuthVerifierClassName(authVerifierClassName);
                Properties properties = PropsUtil.getProperties((String)AuthVerifierPipeline.getAuthVerifierPropertyName(authVerifierClassName), (boolean)true);
                authVerifierConfiguration.setProperties(properties);
                this._authVerifierConfigurations.add(authVerifierConfiguration);
            }
            catch (Exception e2) {
                _log.error((Object)("Unable to initialize " + authVerifierClassName), (Throwable)e2);
            }
            ++n2;
        }
    }

    private boolean _isMatchingRequestURI(AuthVerifierConfiguration authVerifierConfiguration, String requestURI) {
        AuthVerifier authVerifier = authVerifierConfiguration.getAuthVerifier();
        Properties properties = authVerifierConfiguration.getProperties();
        String[] urlsExcludes = StringUtil.split((String)properties.getProperty("urls.excludes"));
        if (urlsExcludes.length > 0 && Wildcard.matchOne((String)requestURI, (String[])urlsExcludes) > -1) {
            return false;
        }
        String[] urlsIncludes = StringUtil.split((String)properties.getProperty("urls.includes"));
        if (urlsIncludes.length == 0) {
            Class<?> authVerifierClass = authVerifier.getClass();
            _log.error((Object)("Auth verifier " + authVerifierClass.getName() + " does not have any URLs configured"));
            return false;
        }
        return Wildcard.matchOne((String)requestURI, (String[])urlsIncludes) > -1;
    }

    private AuthVerifierConfiguration _mergeAuthVerifierConfiguration(AuthVerifierConfiguration authVerifierConfiguration, AccessControlContext accessControlContext) {
        Map settings = accessControlContext.getSettings();
        String authVerifierSettingsKey = AuthVerifierPipeline.getAuthVerifierPropertyName(authVerifierConfiguration.getAuthVerifierClassName());
        boolean merge = false;
        Set settingsKeys = settings.keySet();
        Iterator iterator = settingsKeys.iterator();
        while (iterator.hasNext() && !merge) {
            String settingsKey = (String)iterator.next();
            if (!settingsKey.startsWith(authVerifierSettingsKey) || !(settings.get(settingsKey) instanceof String)) continue;
            merge = true;
        }
        if (!merge) {
            return authVerifierConfiguration;
        }
        AuthVerifierConfiguration mergedAuthVerifierConfiguration = new AuthVerifierConfiguration();
        mergedAuthVerifierConfiguration.setAuthVerifier(authVerifierConfiguration.getAuthVerifier());
        Properties mergedProperties = new Properties(authVerifierConfiguration.getProperties());
        for (String settingsKey : settings.keySet()) {
            Object settingsValue;
            if (!settingsKey.startsWith(authVerifierSettingsKey) || !((settingsValue = settings.get(settingsKey)) instanceof String)) continue;
            String propertiesKey = settingsKey.substring(authVerifierSettingsKey.length());
            mergedProperties.setProperty(propertiesKey, (String)settingsValue);
        }
        mergedAuthVerifierConfiguration.setProperties(mergedProperties);
        return mergedAuthVerifierConfiguration;
    }

    private Map<String, Object> _mergeSettings(Properties properties, Map<String, Object> settings) {
        HashMap<String, Object> mergedSettings = new HashMap<String, Object>(settings);
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                mergedSettings.put((String)entry.getKey(), entry.getValue());
            }
        }
        return mergedSettings;
    }

    private void _register(AuthVerifierConfiguration authVerifierConfiguration) {
        if (authVerifierConfiguration == null) {
            throw new IllegalArgumentException("Auth verifier configuration is null");
        }
        if (authVerifierConfiguration.getAuthVerifier() == null) {
            throw new IllegalArgumentException("Auth verifier is null");
        }
        if (authVerifierConfiguration.getAuthVerifierClassName() == null) {
            throw new IllegalArgumentException("Class name is null");
        }
        if (authVerifierConfiguration.getProperties() == null) {
            throw new IllegalArgumentException("Properties is null");
        }
        this._authVerifierConfigurations.add(0, authVerifierConfiguration);
    }

    private void _unregister(AuthVerifierConfiguration authVerifierConfiguration) {
        if (authVerifierConfiguration == null) {
            throw new IllegalArgumentException("Auth verifier configuration is null");
        }
        this._authVerifierConfigurations.remove(authVerifierConfiguration);
    }

    private AuthVerifierResult _verifyRequest(AccessControlContext accessControlContext) throws PortalException, SystemException {
        if (accessControlContext == null) {
            throw new IllegalArgumentException("Access control context is null");
        }
        List<AuthVerifierConfiguration> authVerifierConfigurations = this._getAuthVerifierConfigurations(accessControlContext);
        for (AuthVerifierConfiguration authVerifierConfiguration : authVerifierConfigurations) {
            AuthVerifierResult authVerifierResult = null;
            AuthVerifier authVerifier = authVerifierConfiguration.getAuthVerifier();
            Properties properties = authVerifierConfiguration.getProperties();
            try {
                authVerifierResult = authVerifier.verify(accessControlContext, properties);
            }
            catch (Exception e2) {
                Class<?> authVerifierClass = authVerifier.getClass();
                _log.error((Object)("Skipping " + authVerifierClass.getName()), (Throwable)e2);
                continue;
            }
            if (authVerifierResult == null) {
                Class<?> authVerifierClass = authVerifier.getClass();
                _log.error((Object)("Auth verifier " + authVerifierClass.getName() + " did not return an auth verifier result"));
                continue;
            }
            if (authVerifierResult.getState() == AuthVerifierResult.State.NOT_APPLICABLE) continue;
            Map<String, Object> settings = this._mergeSettings(properties, authVerifierResult.getSettings());
            settings.put(AUTH_TYPE, authVerifier.getAuthType());
            authVerifierResult.setSettings(settings);
            return authVerifierResult;
        }
        return this._createGuestVerificationResult(accessControlContext);
    }
}

