/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.lucene;

import com.liferay.portal.kernel.search.BaseSpellCheckIndexWriter;
import com.liferay.portal.kernel.search.DictionaryEntry;
import com.liferay.portal.kernel.search.DictionaryReader;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.NGramHolder;
import com.liferay.portal.kernel.search.NGramHolderBuilderUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.search.lucene.IndexAccessor;
import com.liferay.portal.search.lucene.LuceneHelperUtil;
import com.liferay.portal.search.lucene.SpellCheckerUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.util.ReaderUtil;

public class LuceneSpellCheckIndexWriter
extends BaseSpellCheckIndexWriter {
    private static final int _MINIMUM_WORD_LENGTH = 3;

    public void clearQuerySuggestionDictionaryIndexes(SearchContext searchContext) throws SearchException {
        Term term = new Term("type", "querySuggestion");
        try {
            LuceneHelperUtil.deleteDocuments(searchContext.getCompanyId(), term);
        }
        catch (IOException e2) {
            throw new SearchException((Throwable)e2);
        }
    }

    public void clearSpellCheckerDictionaryIndexes(SearchContext searchContext) throws SearchException {
        Term term = new Term("type", "spellChecker");
        try {
            LuceneHelperUtil.deleteDocuments(searchContext.getCompanyId(), term);
        }
        catch (IOException e2) {
            throw new SearchException((Throwable)e2);
        }
    }

    protected void addField(Document document, String fieldName, String fieldValue, Field.Store fieldStore, FieldInfo.IndexOptions indexOptions, boolean omitNorms) {
        Field field = new Field(fieldName, fieldValue, fieldStore, Field.Index.NOT_ANALYZED);
        field.setIndexOptions(indexOptions);
        field.setOmitNorms(omitNorms);
        document.add((Fieldable)field);
    }

    protected void addNGramFields(Document document, Map<String, String> nGrams) {
        for (Map.Entry<String, String> entry : nGrams.entrySet()) {
            String fieldName = entry.getKey();
            String fieldValue = entry.getValue();
            this.addField(document, fieldName, fieldValue, Field.Store.NO, FieldInfo.IndexOptions.DOCS_ONLY, true);
        }
    }

    protected Document createDocument(long companyId, long groupId, String languageId, String localizedFieldName, String word, float weight, String typeFieldValue, int maxNGramLength) throws SearchException {
        Document document = new Document();
        this.addField(document, "groupId", String.valueOf(groupId), Field.Store.YES, FieldInfo.IndexOptions.DOCS_ONLY, true);
        this.addField(document, "languageId", languageId, Field.Store.YES, FieldInfo.IndexOptions.DOCS_ONLY, true);
        this.addField(document, "portletId", "3", Field.Store.YES, FieldInfo.IndexOptions.DOCS_ONLY, true);
        this.addField(document, "priority", String.valueOf(weight), Field.Store.YES, FieldInfo.IndexOptions.DOCS_ONLY, true);
        this.addField(document, "type", typeFieldValue, Field.Store.YES, FieldInfo.IndexOptions.DOCS_ONLY, true);
        this.addField(document, "uid", this.getUID(companyId, languageId, word, new String[0]), Field.Store.YES, FieldInfo.IndexOptions.DOCS_ONLY, true);
        this.addField(document, localizedFieldName, word, Field.Store.YES, FieldInfo.IndexOptions.DOCS_ONLY, true);
        NGramHolder nGramHolder = NGramHolderBuilderUtil.buildNGramHolder((String)word, (int)maxNGramLength);
        this.addNGramFields(document, nGramHolder.getNGramEnds());
        Map nGrams = nGramHolder.getNGrams();
        for (Map.Entry entry : nGrams.entrySet()) {
            String fieldName = (String)entry.getKey();
            for (String nGram : (List)entry.getValue()) {
                this.addField(document, fieldName, nGram, Field.Store.NO, FieldInfo.IndexOptions.DOCS_AND_FREQS, false);
            }
        }
        this.addNGramFields(document, nGramHolder.getNGramStarts());
        return document;
    }

    protected void indexKeywords(long companyId, long groupId, String languageId, InputStream inputStream, String keywordFieldName, String typeFieldValue, int maxNGramLength) throws Exception {
        IndexAccessor indexAccessor = LuceneHelperUtil.getIndexAccessor(companyId);
        IndexSearcher indexSearcher = null;
        try {
            String localizedFieldName = DocumentImpl.getLocalizedName((String)languageId, (String)keywordFieldName);
            indexSearcher = LuceneHelperUtil.getSearcher(indexAccessor.getCompanyId(), true);
            ArrayList<IndexReader> indexReaders = new ArrayList<IndexReader>();
            if (indexSearcher.maxDoc() > 0) {
                ReaderUtil.gatherSubReaders(indexReaders, (IndexReader)indexSearcher.getIndexReader());
            }
            ArrayList<Document> documents = new ArrayList<Document>();
            DictionaryReader dictionaryReader = new DictionaryReader(inputStream, "UTF-8");
            Iterator iterator = dictionaryReader.getDictionaryEntriesIterator();
            while (iterator.hasNext()) {
                DictionaryEntry dictionaryEntry = (DictionaryEntry)iterator.next();
                String word = dictionaryEntry.getWord();
                boolean validWord = this.isValidWord(localizedFieldName, word, indexReaders);
                if (!validWord) continue;
                Document document = this.createDocument(companyId, groupId, languageId, localizedFieldName, word, dictionaryEntry.getWeight(), typeFieldValue, maxNGramLength);
                documents.add(document);
            }
            indexAccessor.addDocuments(documents);
        }
        catch (Throwable throwable) {
            LuceneHelperUtil.cleanUp(indexSearcher);
            throw throwable;
        }
        LuceneHelperUtil.cleanUp(indexSearcher);
    }

    protected boolean isValidWord(String localizedFieldName, String word, List<IndexReader> indexReaders) throws IOException {
        if (word.length() < 3) {
            return false;
        }
        return !SpellCheckerUtil.isValidWord(localizedFieldName, word, indexReaders);
    }
}

